/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.ssl;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.ssl.SSLParameters;
import org.elasticsearch.common.ssl.SslConfigException;

public enum SslClientAuthenticationMode {
    NONE{

        @Override
        public boolean enabled() {
            return false;
        }

        @Override
        public void configure(SSLParameters sslParameters) {
            assert (!sslParameters.getWantClientAuth());
            assert (!sslParameters.getNeedClientAuth());
        }
    }
    ,
    OPTIONAL{

        @Override
        public boolean enabled() {
            return true;
        }

        @Override
        public void configure(SSLParameters sslParameters) {
            sslParameters.setWantClientAuth(true);
        }
    }
    ,
    REQUIRED{

        @Override
        public boolean enabled() {
            return true;
        }

        @Override
        public void configure(SSLParameters sslParameters) {
            sslParameters.setNeedClientAuth(true);
        }
    };

    private static final Map<String, SslClientAuthenticationMode> LOOKUP;

    public abstract boolean enabled();

    public abstract void configure(SSLParameters var1);

    static Map<String, SslClientAuthenticationMode> buildLookup() {
        LinkedHashMap<String, SslClientAuthenticationMode> map = new LinkedHashMap<String, SslClientAuthenticationMode>(3);
        map.put("none", NONE);
        map.put("optional", OPTIONAL);
        map.put("required", REQUIRED);
        return map;
    }

    public static SslClientAuthenticationMode parse(String value) {
        SslClientAuthenticationMode mode = LOOKUP.get(value.toLowerCase(Locale.ROOT));
        if (mode == null) {
            String allowedValues = LOOKUP.keySet().stream().collect(Collectors.joining(","));
            throw new SslConfigException("could not resolve ssl client authentication, unknown value [" + value + "], recognised values are [" + allowedValues + "]");
        }
        return mode;
    }

    static {
        LOOKUP = Collections.unmodifiableMap(SslClientAuthenticationMode.buildLookup());
    }
}

