/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.plain;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.fielddata.AbstractSortedDocValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexFieldDataCache;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.LeafOrdinalsFieldData;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.index.fielddata.plain.AbstractIndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.plain.AbstractLeafOrdinalsFieldData;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;

public class ConstantIndexFieldData
extends AbstractIndexOrdinalsFieldData {
    private final ConstantLeafFieldData atomicFieldData;

    private ConstantIndexFieldData(IndexSettings indexSettings, String name, String value) {
        super(indexSettings, name, null, null, 0.0, 2.147483647E9, 0);
        this.atomicFieldData = new ConstantLeafFieldData(value);
    }

    @Override
    public void clear() {
    }

    @Override
    public final LeafOrdinalsFieldData load(LeafReaderContext context) {
        return this.atomicFieldData;
    }

    @Override
    public LeafOrdinalsFieldData loadDirect(LeafReaderContext context) throws Exception {
        return this.atomicFieldData;
    }

    @Override
    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, boolean reverse) {
        BytesRefFieldComparatorSource source = new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
        return new SortField(this.getFieldName(), (FieldComparatorSource)source, reverse);
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("only supported on numeric fields");
    }

    @Override
    public IndexOrdinalsFieldData loadGlobal(DirectoryReader indexReader) {
        return this;
    }

    @Override
    public IndexOrdinalsFieldData localGlobalDirect(DirectoryReader indexReader) throws Exception {
        return this.loadGlobal(indexReader);
    }

    public String getValue() {
        return this.atomicFieldData.value;
    }

    private static class ConstantLeafFieldData
    extends AbstractLeafOrdinalsFieldData {
        private final String value;

        ConstantLeafFieldData(String value) {
            super(DEFAULT_SCRIPT_FUNCTION);
            this.value = value;
        }

        public long ramBytesUsed() {
            return 0L;
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }

        @Override
        public SortedSetDocValues getOrdinalsValues() {
            if (this.value == null) {
                return DocValues.emptySortedSet();
            }
            final BytesRef term = new BytesRef((CharSequence)this.value);
            AbstractSortedDocValues sortedValues = new AbstractSortedDocValues(){
                private int docID = -1;

                public BytesRef lookupOrd(int ord) {
                    return term;
                }

                public int getValueCount() {
                    return 1;
                }

                public int ordValue() {
                    return 0;
                }

                public boolean advanceExact(int target) throws IOException {
                    this.docID = target;
                    return true;
                }

                public int docID() {
                    return this.docID;
                }
            };
            return DocValues.singleton((SortedDocValues)sortedValues);
        }

        @Override
        public void close() {
        }
    }

    public static class Builder
    implements IndexFieldData.Builder {
        private final Function<MapperService, String> valueFunction;

        public Builder(Function<MapperService, String> valueFunction) {
            this.valueFunction = valueFunction;
        }

        @Override
        public IndexFieldData<?> build(IndexSettings indexSettings, MappedFieldType fieldType, IndexFieldDataCache cache, CircuitBreakerService breakerService, MapperService mapperService) {
            return new ConstantIndexFieldData(indexSettings, fieldType.name(), this.valueFunction.apply(mapperService));
        }
    }
}

