/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions.corrector;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.actions.corrector.TagCorrector;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.correction.RoleCorrection;
import org.openstreetmap.josm.data.correction.TagCorrection;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Tag;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Tagged;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.UserCancelException;

public class ReverseWayTagCorrector
extends TagCorrector<Way> {
    private static final String SEPARATOR = "[:_]";
    private static final Collection<Pattern> IGNORED_KEYS = new ArrayList<Pattern>();
    private static final StringSwitcher FORWARD_BACKWARD;
    private static final StringSwitcher UP_DOWN;
    private static final IStringSwitcher COMBINED_SWITCHERS;

    private static Pattern getPatternFor(String s) {
        return ReverseWayTagCorrector.getPatternFor(s, false);
    }

    private static Pattern getPatternFor(String s, boolean exactMatch) {
        if (exactMatch) {
            return Pattern.compile("(^)(" + s + ")($)");
        }
        return Pattern.compile("(^|.*[:_])(" + s + ")(" + SEPARATOR + ".*|$)", 2);
    }

    public static boolean isReversible(Way way) {
        for (Tag tag : TagCollection.from(way)) {
            if (tag.equals(TagSwitcher.apply(tag))) continue;
            return false;
        }
        return true;
    }

    public static List<Way> irreversibleWays(List<Way> ways) {
        ArrayList<Way> newWays = new ArrayList<Way>(ways);
        for (Way way : ways) {
            if (!ReverseWayTagCorrector.isReversible(way)) continue;
            newWays.remove(way);
        }
        return newWays;
    }

    public static String invertNumber(String value) {
        Pattern pattern = Pattern.compile("^([+-]?)(\\d.*)$", 2);
        Matcher matcher = pattern.matcher(value);
        if (!matcher.matches()) {
            return value;
        }
        String sign = matcher.group(1);
        String rest = matcher.group(2);
        sign = "-".equals(sign) ? "" : "-";
        return sign + rest;
    }

    static List<TagCorrection> getTagCorrections(Tagged way) {
        ArrayList<TagCorrection> tagCorrections = new ArrayList<TagCorrection>();
        for (Map.Entry<String, String> entry : way.getKeys().entrySet()) {
            boolean needsCorrection;
            String key = entry.getKey();
            String value = entry.getValue();
            Tag newTag = TagSwitcher.apply(key, value);
            String newKey = newTag.getKey();
            String newValue = newTag.getValue();
            boolean bl = needsCorrection = !key.equals(newKey);
            if (way.get(newKey) != null && way.get(newKey).equals(newValue)) {
                needsCorrection = false;
            }
            if (!value.equals(newValue)) {
                needsCorrection = true;
            }
            if (!needsCorrection) continue;
            tagCorrections.add(new TagCorrection(key, value, newKey, newValue));
        }
        return tagCorrections;
    }

    static List<RoleCorrection> getRoleCorrections(Way oldway) {
        ArrayList<RoleCorrection> roleCorrections = new ArrayList<RoleCorrection>();
        List<OsmPrimitive> referrers = oldway.getReferrers();
        for (OsmPrimitive referrer : referrers) {
            if (!(referrer instanceof Relation)) continue;
            Relation relation = (Relation)referrer;
            int position = 0;
            for (RelationMember member : relation.getMembers()) {
                if (!member.getMember().hasEqualSemanticAttributes(oldway) || !member.hasRole()) {
                    ++position;
                    continue;
                }
                String newRole = (String)COMBINED_SWITCHERS.apply(member.getRole());
                if (!member.getRole().equals(newRole)) {
                    roleCorrections.add(new RoleCorrection(relation, position, member, newRole));
                }
                ++position;
            }
        }
        return roleCorrections;
    }

    static Map<OsmPrimitive, List<TagCorrection>> getTagCorrectionsMap(Way way) {
        HashMap<OsmPrimitive, List<TagCorrection>> tagCorrectionsMap = new HashMap<OsmPrimitive, List<TagCorrection>>();
        List<TagCorrection> tagCorrections = ReverseWayTagCorrector.getTagCorrections(way);
        if (!tagCorrections.isEmpty()) {
            tagCorrectionsMap.put(way, tagCorrections);
        }
        for (Node node : way.getNodes()) {
            List<TagCorrection> corrections = ReverseWayTagCorrector.getTagCorrections(node);
            if (corrections.isEmpty()) continue;
            tagCorrectionsMap.put(node, corrections);
        }
        return tagCorrectionsMap;
    }

    @Override
    public Collection<Command> execute(Way oldway, Way way) throws UserCancelException {
        Map<OsmPrimitive, List<TagCorrection>> tagCorrectionsMap = ReverseWayTagCorrector.getTagCorrectionsMap(way);
        HashMap<OsmPrimitive, List<RoleCorrection>> roleCorrectionMap = new HashMap<OsmPrimitive, List<RoleCorrection>>();
        List<RoleCorrection> roleCorrections = ReverseWayTagCorrector.getRoleCorrections(oldway);
        if (!roleCorrections.isEmpty()) {
            roleCorrectionMap.put(way, roleCorrections);
        }
        return this.applyCorrections(oldway.getDataSet(), tagCorrectionsMap, roleCorrectionMap, I18n.tr("When reversing this way, the following changes are suggested in order to maintain data consistency.", new Object[0]));
    }

    private static boolean ignoreKeyForCorrection(String key) {
        return IGNORED_KEYS.stream().anyMatch(ignoredKey -> ignoredKey.matcher(key).matches());
    }

    static {
        for (String s : AbstractPrimitive.getUninterestingKeys()) {
            IGNORED_KEYS.add(ReverseWayTagCorrector.getPatternFor(s));
        }
        for (String s : new String[]{"name", "ref", "tiger:county"}) {
            IGNORED_KEYS.add(ReverseWayTagCorrector.getPatternFor(s, false));
        }
        for (String s : new String[]{"tiger:county", "turn:lanes", "change:lanes", "placement"}) {
            IGNORED_KEYS.add(ReverseWayTagCorrector.getPatternFor(s, true));
        }
        FORWARD_BACKWARD = new StringSwitcher("forward", "backward");
        UP_DOWN = new StringSwitcher("up", "down");
        COMBINED_SWITCHERS = IStringSwitcher.combined(new StringSwitcher("left", "right"), new StringSwitcher("forwards", "backwards"), FORWARD_BACKWARD, UP_DOWN);
    }

    public static final class TagSwitcher {
        private TagSwitcher() {
        }

        public static Tag apply(Tag tag) {
            return TagSwitcher.apply(tag.getKey(), tag.getValue());
        }

        public static Tag apply(String key, String value) {
            String newKey = key;
            String newValue = value;
            if (key.startsWith("oneway") || key.endsWith("oneway")) {
                if (OsmUtils.isReversed(value)) {
                    newValue = "yes";
                } else if (OsmUtils.isTrue(value)) {
                    newValue = "-1";
                }
                newKey = (String)COMBINED_SWITCHERS.apply(key);
            } else if (key.startsWith("incline") || key.endsWith("incline")) {
                newValue = UP_DOWN.apply(value);
                if (newValue.equals(value)) {
                    newValue = ReverseWayTagCorrector.invertNumber(value);
                }
            } else if (key.startsWith("direction") || key.endsWith("direction")) {
                newValue = (String)COMBINED_SWITCHERS.apply(value);
            } else if (key.endsWith(":forward") || key.endsWith(":backward")) {
                newKey = FORWARD_BACKWARD.apply(key);
            } else if (!ReverseWayTagCorrector.ignoreKeyForCorrection(key)) {
                newKey = (String)COMBINED_SWITCHERS.apply(key);
                newValue = (String)COMBINED_SWITCHERS.apply(value);
            }
            return new Tag(newKey, newValue);
        }
    }

    private static class StringSwitcher
    implements IStringSwitcher {
        private final String a;
        private final String b;
        private final Pattern pattern;

        StringSwitcher(String a, String b) {
            this.a = a;
            this.b = b;
            this.pattern = ReverseWayTagCorrector.getPatternFor(a + '|' + b);
        }

        @Override
        public String apply(String text) {
            Matcher m = this.pattern.matcher(text);
            if (m.lookingAt()) {
                String leftRight = m.group(2).toLowerCase(Locale.ENGLISH);
                StringBuilder result = new StringBuilder();
                result.append(text.substring(0, m.start(2))).append(leftRight.equals(this.a) ? this.b : this.a).append(text.substring(m.end(2)));
                return result.toString();
            }
            return text;
        }
    }

    private static interface IStringSwitcher
    extends Function<String, String> {
        public static IStringSwitcher combined(IStringSwitcher ... switchers) {
            return key -> Arrays.stream(switchers).map(switcher -> (String)switcher.apply(key)).filter(newKey -> !key.equals(newKey)).findFirst().orElse((String)key);
        }
    }
}

