/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import ch.poole.openinghoursparser.I18n;
import ch.poole.openinghoursparser.OpeningHoursParser;
import ch.poole.openinghoursparser.ParseException;
import ch.poole.openinghoursparser.Rule;
import ch.poole.openinghoursparser.Util;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;

public class OpeningHourTest
extends Test.TagTest {
    private static final Collection<String> KEYS_TO_CHECK = Arrays.asList("opening_hours", "collection_times", "service_times");

    public OpeningHourTest() {
        super(org.openstreetmap.josm.tools.I18n.tr("Opening hours syntax", new Object[0]), org.openstreetmap.josm.tools.I18n.tr("This test checks the correct usage of the opening hours syntax.", new Object[0]));
    }

    private TestError createTestError(Severity severity, String message, String key, String value, String prettifiedValue, OsmPrimitive p) {
        OsmPrimitive[] osmPrimitiveArray;
        TestError.Builder builder = TestError.builder(this, severity, 2901).message(org.openstreetmap.josm.tools.I18n.tr("Opening hours syntax", new Object[0]), message, new Object[0]);
        if (p != null) {
            OsmPrimitive[] osmPrimitiveArray2 = new OsmPrimitive[1];
            osmPrimitiveArray = osmPrimitiveArray2;
            osmPrimitiveArray2[0] = p;
        } else {
            osmPrimitiveArray = new OsmPrimitive[]{};
        }
        TestError.Builder error = builder.primitives(osmPrimitiveArray);
        if (p == null || prettifiedValue == null || prettifiedValue.equals(value)) {
            return error.build();
        }
        return error.fix(() -> new ChangePropertyCommand(p, key, prettifiedValue)).build();
    }

    public List<TestError> checkOpeningHourSyntax(String key, String value) {
        return this.checkOpeningHourSyntax(key, value, null, Locale.getDefault());
    }

    List<TestError> checkOpeningHourSyntax(String key, String value, OsmPrimitive p, Locale locale) {
        if (value == null || value.isEmpty()) {
            return Collections.emptyList();
        }
        I18n.setLocale(locale);
        String prettifiedValue = null;
        try {
            List<Rule> rules = new OpeningHoursParser(new StringReader(value)).rules(false);
            prettifiedValue = Util.rulesToOpeningHoursString(rules);
            if (!Objects.equals(value, prettifiedValue)) {
                new OpeningHoursParser(new StringReader(value)).rules(true);
            }
        }
        catch (ParseException e) {
            return Collections.singletonList(this.createTestError(Severity.WARNING, e.getMessage(), key, value, prettifiedValue, p));
        }
        if (!this.includeOtherSeverityChecks() || Objects.equals(value, prettifiedValue)) {
            return Collections.emptyList();
        }
        String message = org.openstreetmap.josm.tools.I18n.tr("{0} value can be prettified", key);
        return Collections.singletonList(this.createTestError(Severity.OTHER, message, key, value, prettifiedValue, p));
    }

    @Override
    public void check(OsmPrimitive p) {
        if (p.isTagged()) {
            for (String key : KEYS_TO_CHECK) {
                this.errors.addAll(this.checkOpeningHourSyntax(key, p.get(key), p, Locale.getDefault()));
            }
            String keyCovid19 = "opening_hours:covid19";
            if (p.hasTag("opening_hours:covid19") && !p.hasTag("opening_hours:covid19", "same", "restricted", "open", "off")) {
                this.errors.addAll(this.checkOpeningHourSyntax("opening_hours:covid19", p.get("opening_hours:covid19"), p, Locale.getDefault()));
            }
        }
    }
}

