/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.history;

import java.awt.Point;
import javax.swing.JTable;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.history.DiffTableModel;
import org.openstreetmap.josm.gui.history.HistoryBrowserModel;
import org.openstreetmap.josm.gui.history.HistoryViewerPanel;
import org.openstreetmap.josm.gui.history.NodeListTableColumnModel;
import org.openstreetmap.josm.gui.history.PointInTimeType;
import org.openstreetmap.josm.gui.history.ReversedChangeListener;
import org.openstreetmap.josm.gui.history.ShowHistoryAction;
import org.openstreetmap.josm.gui.history.TwoColumnDiff;
import org.openstreetmap.josm.gui.widgets.PopupMenuLauncher;
import org.openstreetmap.josm.tools.I18n;

public class NodeListViewer
extends HistoryViewerPanel {
    public NodeListViewer(HistoryBrowserModel model) {
        super(model);
    }

    @Override
    protected JTable buildTable(PointInTimeType pointInTimeType) {
        DiffTableModel tableModel = this.model.getNodeListTableModel(pointInTimeType);
        NodeListTableColumnModel columnModel = new NodeListTableColumnModel();
        JTable table = new JTable(tableModel, columnModel);
        tableModel.addTableModelListener(new ReversedChangeListener(table, columnModel, I18n.tr("The nodes of this way are in reverse order", new Object[0])));
        table.setSelectionMode(0);
        this.selectionSynchronizer.participateInSynchronizedSelection(table.getSelectionModel());
        table.getTableHeader().setReorderingAllowed(false);
        table.addMouseListener(new InternalPopupMenuLauncher());
        table.addMouseListener(new ShowHistoryAction.DoubleClickAdapter(e -> {
            int row = table.rowAtPoint(e.getPoint());
            return NodeListViewer.primitiveIdAtRow(tableModel, row);
        }));
        this.enableSemanticSelectionSynchronization(table.getSelectionModel(), tableModel, this.model.getNodeListTableModel(pointInTimeType.opposite()), this::isSemanticallyEquivalent);
        return table;
    }

    private boolean isSemanticallyEquivalent(TwoColumnDiff.Item o1, TwoColumnDiff.Item o2) {
        return o1.value != null && o1.value.equals(o2.value);
    }

    private static PrimitiveId primitiveIdAtRow(DiffTableModel model, int row) {
        if (row < 0) {
            return null;
        }
        Long id = (Long)model.getValueAt((int)row, (int)0).value;
        return id == null ? null : new SimplePrimitiveId(id, OsmPrimitiveType.NODE);
    }

    static class InternalPopupMenuLauncher
    extends PopupMenuLauncher {
        InternalPopupMenuLauncher() {
            super(new HistoryViewerPanel.ListPopupMenu(I18n.tr("Zoom to node", new Object[0]), I18n.tr("Zoom to this node in the current data layer", new Object[0])));
        }

        @Override
        protected int checkTableSelection(JTable table, Point p) {
            int row = super.checkTableSelection(table, p);
            ((HistoryViewerPanel.ListPopupMenu)this.menu).prepare(NodeListViewer.primitiveIdAtRow((DiffTableModel)table.getModel(), row));
            return row;
        }
    }
}

