/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.namefind;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;

public class NameSampleCountersStream
extends FilterObjectStream<NameSample, NameSample> {
    private int sentenceCount;
    private int tokenCount;
    private Map<String, Integer> nameCounters = new HashMap<String, Integer>();

    protected NameSampleCountersStream(ObjectStream<NameSample> samples) {
        super(samples);
    }

    @Override
    public NameSample read() throws IOException {
        NameSample sample = (NameSample)this.samples.read();
        if (sample != null) {
            ++this.sentenceCount;
            this.tokenCount += sample.getSentence().length;
            for (Span nameSpan : sample.getNames()) {
                Integer nameCounter = this.nameCounters.get(nameSpan.getType());
                if (nameCounter == null) {
                    nameCounter = 0;
                }
                this.nameCounters.put(nameSpan.getType(), nameCounter + 1);
            }
        }
        return sample;
    }

    @Override
    public void reset() throws IOException, UnsupportedOperationException {
        super.reset();
        this.sentenceCount = 0;
        this.tokenCount = 0;
        this.nameCounters = new HashMap<String, Integer>();
    }

    public int getSentenceCount() {
        return this.sentenceCount;
    }

    public int getTokenCount() {
        return this.tokenCount;
    }

    public Map<String, Integer> getNameCounters() {
        return Collections.unmodifiableMap(this.nameCounters);
    }

    public void printSummary() {
        System.out.println("Training data summary:");
        System.out.println("#Sentences: " + this.getSentenceCount());
        System.out.println("#Tokens: " + this.getTokenCount());
        int totalNames = 0;
        for (Map.Entry<String, Integer> counter : this.getNameCounters().entrySet()) {
            System.out.println("#" + counter.getKey() + " entities: " + counter.getValue());
            totalNames += counter.getValue().intValue();
        }
    }
}

