/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml.naivebayes;

import java.util.ArrayList;
import java.util.Map;
import opennlp.tools.ml.naivebayes.Probabilities;
import opennlp.tools.ml.naivebayes.Probability;

public class LogProbabilities<T>
extends Probabilities<T> {
    @Override
    public void set(T t, double probability) {
        this.isNormalised = false;
        this.map.put(t, this.log(probability));
    }

    @Override
    public void set(T t, Probability<T> probability) {
        this.isNormalised = false;
        this.map.put(t, probability.getLog());
    }

    @Override
    public void setIfLarger(T t, double probability) {
        double logProbability = this.log(probability);
        Double p = (Double)this.map.get(t);
        if (p == null || logProbability > p) {
            this.isNormalised = false;
            this.map.put(t, logProbability);
        }
    }

    @Override
    public void setLog(T t, double probability) {
        this.isNormalised = false;
        this.map.put(t, probability);
    }

    @Override
    public void addIn(T t, double probability, int count) {
        this.isNormalised = false;
        Double p = (Double)this.map.get(t);
        if (p == null) {
            p = 0.0;
        }
        probability = this.log(probability) * (double)count;
        this.map.put(t, p + probability);
    }

    private Map<T, Double> normalize() {
        Double p;
        Object t;
        if (this.isNormalised) {
            return this.normalised;
        }
        Map temp = this.createMapDataStructure();
        double highestLogProbability = Double.NEGATIVE_INFINITY;
        for (Map.Entry entry : this.map.entrySet()) {
            Double p2 = (Double)entry.getValue();
            if (p2 == null || !(p2 > highestLogProbability)) continue;
            highestLogProbability = p2;
        }
        double sum = 0.0;
        for (Map.Entry entry : this.map.entrySet()) {
            double temp_p;
            t = entry.getKey();
            p = (Double)entry.getValue();
            if (p == null || Double.isNaN(temp_p = Math.exp(p - highestLogProbability))) continue;
            sum += temp_p;
            temp.put(t, temp_p);
        }
        for (Map.Entry<Object, Object> entry : temp.entrySet()) {
            t = entry.getKey();
            p = (Double)entry.getValue();
            if (p == null || !(sum > Double.MIN_VALUE)) continue;
            temp.put(t, p / sum);
        }
        this.normalised = temp;
        this.isNormalised = true;
        return temp;
    }

    private double log(double prob) {
        return Math.log(prob);
    }

    @Override
    public Double get(T t) {
        Double d = this.normalize().get(t);
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    @Override
    public Double getLog(T t) {
        Double d = (Double)this.map.get(t);
        if (d == null) {
            return Double.NEGATIVE_INFINITY;
        }
        return d;
    }

    @Override
    public void discardCountsBelow(double i) {
        i = Math.log(i);
        ArrayList labelsToRemove = new ArrayList();
        for (Map.Entry entry : this.map.entrySet()) {
            Object label = entry.getKey();
            Double sum = (Double)entry.getValue();
            if (sum == null) {
                sum = Double.NEGATIVE_INFINITY;
            }
            if (!(sum < i)) continue;
            labelsToRemove.add(label);
        }
        for (Map.Entry label : labelsToRemove) {
            this.map.remove(label);
        }
    }

    @Override
    public Map<T, Double> getAll() {
        return this.normalize();
    }

    @Override
    public T getMax() {
        double max = Double.NEGATIVE_INFINITY;
        T maxT = null;
        for (Map.Entry entry : this.map.entrySet()) {
            Object t = entry.getKey();
            Double temp = (Double)entry.getValue();
            if (!(temp >= max)) continue;
            max = temp;
            maxT = (T)t;
        }
        return maxT;
    }
}

