/*
 * libedataserver.h
 *
 * This library is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef LIBEDATASERVER_H
#define LIBEDATASERVER_H

#define __LIBEDATASERVER_H_INSIDE__

#include <libedataserver/e-cancellable-locks.h>
#include <libedataserver/e-categories.h>
#include <libedataserver/e-client.h>
#include <libedataserver/e-collator.h>
#include <libedataserver/e-credentials.h>
#include <libedataserver/e-data-server-util.h>
#include <libedataserver/e-debug-log.h>
#include <libedataserver/e-extensible.h>
#include <libedataserver/e-extension.h>
#include <libedataserver/e-flag.h>
#include <libedataserver/e-free-form-exp.h>
#include <libedataserver/e-gdata-oauth2-authorizer.h>
#include <libedataserver/e-iterator.h>
#include <libedataserver/e-list-iterator.h>
#include <libedataserver/e-list.h>
#include <libedataserver/e-memory.h>
#include <libedataserver/e-module.h>
#include <libedataserver/e-network-monitor.h>
#include <libedataserver/e-oauth2-service.h>
#include <libedataserver/e-oauth2-service-base.h>
#include <libedataserver/e-oauth2-service-google.h>
#include <libedataserver/e-oauth2-service-outlook.h>
#include <libedataserver/e-oauth2-services.h>
#include <libedataserver/e-operation-pool.h>
#include <libedataserver/e-proxy.h>
#include <libedataserver/e-secret-store.h>
#include <libedataserver/e-sexp.h>
#include <libedataserver/e-soup-auth-bearer.h>
#include <libedataserver/e-soup-session.h>
#include <libedataserver/e-soup-ssl-trust.h>
#include <libedataserver/e-source-address-book.h>
#include <libedataserver/e-source-alarms.h>
#include <libedataserver/e-source-authentication.h>
#include <libedataserver/e-source-autocomplete.h>
#include <libedataserver/e-source-autoconfig.h>
#include <libedataserver/e-source-backend.h>
#include <libedataserver/e-source-calendar.h>
#include <libedataserver/e-source-camel.h>
#include <libedataserver/e-source-collection.h>
#include <libedataserver/e-source-contacts.h>
#include <libedataserver/e-source-credentials-provider.h>
#include <libedataserver/e-source-credentials-provider-impl.h>
#include <libedataserver/e-source-credentials-provider-impl-oauth2.h>
#include <libedataserver/e-source-credentials-provider-impl-password.h>
#include <libedataserver/e-source-enums.h>
#include <libedataserver/e-source-enumtypes.h>
#include <libedataserver/e-source-extension.h>
#include <libedataserver/e-source-goa.h>
#include <libedataserver/e-source-ldap.h>
#include <libedataserver/e-source-local.h>
#include <libedataserver/e-source-mail-account.h>
#include <libedataserver/e-source-mail-composition.h>
#include <libedataserver/e-source-mail-identity.h>
#include <libedataserver/e-source-mail-signature.h>
#include <libedataserver/e-source-mail-submission.h>
#include <libedataserver/e-source-mail-transport.h>
#include <libedataserver/e-source-mdn.h>
#include <libedataserver/e-source-memo-list.h>
#include <libedataserver/e-source-offline.h>
#include <libedataserver/e-source-openpgp.h>
#include <libedataserver/e-source-proxy.h>
#include <libedataserver/e-source-refresh.h>
#include <libedataserver/e-source-registry.h>
#include <libedataserver/e-source-registry-watcher.h>
#include <libedataserver/e-source-resource.h>
#include <libedataserver/e-source-revision-guards.h>
#include <libedataserver/e-source-security.h>
#include <libedataserver/e-source-selectable.h>
#include <libedataserver/e-source-smime.h>
#include <libedataserver/e-source-task-list.h>
#include <libedataserver/e-source-uoa.h>
#include <libedataserver/e-source-webdav.h>
#include <libedataserver/e-source-weather.h>
#include <libedataserver/e-source.h>
#include <libedataserver/e-time-utils.h>
#include <libedataserver/e-uid.h>
#include <libedataserver/e-url.h>
#include <libedataserver/e-webdav-discover.h>
#include <libedataserver/e-webdav-session.h>
#include <libedataserver/e-xml-document.h>
#include <libedataserver/e-xml-hash-utils.h>
#include <libedataserver/e-xml-utils.h>
#include <libedataserver/eds-version.h>

#include <libedataserver/e-dataserver-autocleanups.h>

#undef __LIBEDATASERVER_H_INSIDE__

#endif /* LIBEDATASERVER_H */

