/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.security.AccessController;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.rcache.AuthTimeWithHash;
import sun.security.krb5.internal.rcache.DflCache;
import sun.security.krb5.internal.rcache.MemoryCache;

public abstract class ReplayCache {
    public static ReplayCache getInstance(String type) {
        if (type == null) {
            return new MemoryCache();
        }
        if (type.equals("dfl") || type.startsWith("dfl:")) {
            return new DflCache(type);
        }
        if (type.equals("none")) {
            return new ReplayCache(){

                @Override
                public void checkAndStore(KerberosTime currTime, AuthTimeWithHash time) throws KrbApErrException {
                }
            };
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    public static ReplayCache getInstance() {
        String type = AccessController.doPrivileged(new GetPropertyAction("sun.security.krb5.rcache"));
        return ReplayCache.getInstance(type);
    }

    public abstract void checkAndStore(KerberosTime var1, AuthTimeWithHash var2) throws KrbApErrException;
}

