/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2;

import java.util.Properties;
import javax.swing.SwingUtilities;
import org.netbeans.modules.profiler.api.ProfilerStorage;
import org.netbeans.modules.profiler.v2.impl.WeakProcessor;
import org.openide.ErrorManager;
import org.openide.util.Lookup;

public final class SessionStorage {
    private static final String SETTINGS_FILENAME = "settings";
    private static final WeakProcessor PROCESSOR = new WeakProcessor("Profiler Storage Processor");
    private boolean dirty;
    private Properties properties;
    private final Lookup.Provider project;

    SessionStorage(Lookup.Provider provider) {
        this.project = provider;
    }

    public synchronized void storeFlag(String string, String string2) {
        if (this.properties == null) {
            this.loadProperties();
        }
        boolean bl = string2 != null ? !string2.equals(this.properties.put(string, string2)) : this.properties.remove(string) != null;
        this.dirty |= bl;
    }

    public synchronized String readFlag(String string, String string2) {
        if (this.properties == null) {
            this.loadProperties();
        }
        return this.properties.getProperty(string, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void persist(boolean bl) {
        if (this.dirty) {
            if (bl) {
                WeakProcessor weakProcessor = PROCESSOR;
                synchronized (weakProcessor) {
                    this.saveProperties(this.properties);
                }
            } else {
                final Properties properties = new Properties();
                for (String string : this.properties.stringPropertyNames()) {
                    properties.setProperty(string, this.properties.getProperty(string));
                }
                PROCESSOR.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        WeakProcessor weakProcessor = PROCESSOR;
                        synchronized (weakProcessor) {
                            SessionStorage.this.saveProperties(properties);
                        }
                    }
                });
            }
            this.dirty = false;
        }
    }

    private void loadProperties() {
        this.properties = new Properties();
        assert (!SwingUtilities.isEventDispatchThread());
        try {
            ProfilerStorage.loadProjectProperties((Properties)this.properties, (Lookup.Provider)this.project, (String)SETTINGS_FILENAME);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().log(65536, exception.getMessage());
            exception.printStackTrace();
        }
    }

    private void saveProperties(Properties properties) {
        assert (!SwingUtilities.isEventDispatchThread());
        try {
            ProfilerStorage.saveProjectProperties((Properties)properties, (Lookup.Provider)this.project, (String)SETTINGS_FILENAME);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().log(65536, exception.getMessage());
            exception.printStackTrace();
        }
    }
}

