/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.ketch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.internal.ketch.KetchLeader;
import org.eclipse.jgit.internal.ketch.KetchReplica;
import org.eclipse.jgit.internal.ketch.LogIndex;
import org.eclipse.jgit.internal.ketch.ReplicaSnapshot;
import org.eclipse.jgit.lib.ObjectId;

public class LeaderSnapshot {
    final List<ReplicaSnapshot> replicas = new ArrayList<ReplicaSnapshot>();
    KetchLeader.State state;
    long term;
    LogIndex headIndex;
    LogIndex committedIndex;
    boolean idle;

    LeaderSnapshot() {
    }

    public Collection<ReplicaSnapshot> getReplicas() {
        return Collections.unmodifiableList(this.replicas);
    }

    public KetchLeader.State getState() {
        return this.state;
    }

    public boolean isIdle() {
        return this.idle;
    }

    public long getTerm() {
        return this.term;
    }

    @Nullable
    public LogIndex getHead() {
        return this.headIndex;
    }

    @Nullable
    public LogIndex getCommitted() {
        return this.committedIndex;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        s2.append(this.isIdle() ? "IDLE" : "RUNNING");
        s2.append(" state ").append((Object)this.getState());
        if (this.getTerm() > 0L) {
            s2.append(" term ").append(this.getTerm());
        }
        s2.append('\n');
        s2.append(String.format("%-10s %12s %12s\n", "Replica", "Accepted", "Committed"));
        s2.append("------------------------------------\n");
        LeaderSnapshot.debug(s2, "(leader)", this.getHead(), this.getCommitted());
        s2.append('\n');
        for (ReplicaSnapshot r : this.getReplicas()) {
            LeaderSnapshot.debug(s2, r);
            s2.append('\n');
        }
        s2.append('\n');
        return s2.toString();
    }

    private static void debug(StringBuilder b, ReplicaSnapshot s2) {
        String err;
        KetchReplica replica = s2.getReplica();
        LeaderSnapshot.debug(b, replica.getName(), s2.getAccepted(), s2.getCommitted());
        b.append(String.format(" %-8s %s", new Object[]{replica.getParticipation(), s2.getState()}));
        if (s2.getState() == KetchReplica.State.OFFLINE && (err = s2.getErrorMessage()) != null) {
            b.append(" (").append(err).append(')');
        }
    }

    private static void debug(StringBuilder s2, String name2, ObjectId accepted, ObjectId committed) {
        s2.append(String.format("%-10s %-12s %-12s", name2, LeaderSnapshot.str(accepted), LeaderSnapshot.str(committed)));
    }

    static String str(ObjectId c) {
        if (c instanceof LogIndex) {
            return ((LogIndex)c).describeForLog();
        }
        if (c != null) {
            return c.abbreviate(8).name();
        }
        return "-";
    }
}

