/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data.sort;

import java.util.Comparator;
import tim.prune.data.DataPoint;
import tim.prune.data.sort.SortMode;

public class PhotoComparer
implements Comparator<DataPoint> {
    private SortMode _sortMode;

    public PhotoComparer(SortMode sortMode) {
        this._sortMode = sortMode;
    }

    @Override
    public int compare(DataPoint dataPoint, DataPoint dataPoint2) {
        if (dataPoint2 == null || dataPoint2.getPhoto() == null) {
            return -1;
        }
        if (dataPoint == null || dataPoint.getPhoto() == null) {
            return 1;
        }
        int n = 0;
        if (this._sortMode == SortMode.SORTBY_NAME) {
            n = this.compareNames(dataPoint, dataPoint2);
        }
        if (n == 0) {
            n = this.compareTimes(dataPoint, dataPoint2);
        }
        if (n == 0 && this._sortMode == SortMode.SORTBY_TIME) {
            n = this.compareNames(dataPoint, dataPoint2);
        }
        if (n == 0) {
            n = this.compareSizes(dataPoint, dataPoint2);
        }
        return n;
    }

    private int compareNames(DataPoint dataPoint, DataPoint dataPoint2) {
        if (dataPoint.getPhoto().getFile() == null || dataPoint2.getPhoto().getFile() == null) {
            return dataPoint.getPhoto().getName().compareTo(dataPoint2.getPhoto().getName());
        }
        return dataPoint.getPhoto().getFile().compareTo(dataPoint2.getPhoto().getFile());
    }

    private int compareTimes(DataPoint dataPoint, DataPoint dataPoint2) {
        if (!dataPoint2.hasTimestamp()) {
            return -1;
        }
        if (!dataPoint.hasTimestamp()) {
            return 1;
        }
        long l = dataPoint.getPhoto().getTimestamp().getMillisecondsSince(dataPoint2.getPhoto().getTimestamp());
        return l < 0L ? -1 : (l == 0L ? 0 : 1);
    }

    private int compareSizes(DataPoint dataPoint, DataPoint dataPoint2) {
        int n = dataPoint.getPhoto().getWidth();
        int n2 = dataPoint2.getPhoto().getWidth();
        if (n2 <= 0) {
            return -1;
        }
        if (n <= 0) {
            return 1;
        }
        if (n != n2) {
            return n2 > n ? 1 : -1;
        }
        int n3 = dataPoint.getPhoto().getHeight();
        int n4 = dataPoint2.getPhoto().getHeight();
        if (n4 <= 0) {
            return -1;
        }
        if (n3 <= 0) {
            return 1;
        }
        if (n3 != n4) {
            return n4 > n3 ? 1 : -1;
        }
        return 0;
    }
}

