/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.validation.tests;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.validation.Severity;
import org.openstreetmap.josm.data.validation.Test;
import org.openstreetmap.josm.data.validation.TestError;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class Lanes
extends Test.TagTest {
    private static final String[] BLACKLIST = new String[]{"source:lanes", "note:lanes", "proposed:lanes", "source:proposed:lanes", "piste:lanes"};

    public Lanes() {
        super(I18n.tr("Lane tags", new Object[0]), I18n.tr("Test that validates ''lane:'' tags.", new Object[0]));
    }

    static int getLanesCount(String value) {
        return value.isEmpty() ? 0 : value.replaceAll("[^|]", "").length() + 1;
    }

    protected void checkNumberOfLanesByKey(OsmPrimitive p, String lanesKey, String message) {
        Set lanesCount = p.keySet().stream().filter(x -> x.endsWith(":" + lanesKey)).filter(x -> !Arrays.asList(BLACKLIST).contains(x)).map(key -> Lanes.getLanesCount(p.get((String)key))).collect(Collectors.toSet());
        if (lanesCount.size() > 1) {
            this.errors.add(TestError.builder(this, Severity.WARNING, 3100).message(message).primitives(p).build());
        } else if (lanesCount.size() == 1 && p.hasKey(lanesKey)) {
            try {
                if (Integer.parseInt(p.get(lanesKey)) > (Integer)lanesCount.iterator().next()) {
                    this.errors.add(TestError.builder(this, Severity.WARNING, 3100).message(I18n.tr("Number of {0} greater than {1}", lanesKey, "*:" + lanesKey)).primitives(p).build());
                }
            }
            catch (NumberFormatException ignore) {
                Logging.debug(ignore.getMessage());
            }
        }
    }

    protected void checkNumberOfLanes(OsmPrimitive p) {
        String lanes = p.get("lanes");
        if (lanes == null) {
            return;
        }
        String forward = Utils.firstNonNull(p.get("lanes:forward"), "0");
        String backward = Utils.firstNonNull(p.get("lanes:backward"), "0");
        try {
            if (Integer.parseInt(lanes) < Integer.parseInt(forward) + Integer.parseInt(backward)) {
                this.errors.add(TestError.builder(this, Severity.WARNING, 3101).message(I18n.tr("Number of {0} greater than {1}", I18n.tr("{0}+{1}", "lanes:forward", "lanes:backward"), "lanes")).primitives(p).build());
            }
        }
        catch (NumberFormatException ignore) {
            Logging.debug(ignore.getMessage());
        }
    }

    @Override
    public void check(OsmPrimitive p) {
        this.checkNumberOfLanesByKey(p, "lanes", I18n.tr("Number of lane dependent values inconsistent", new Object[0]));
        this.checkNumberOfLanesByKey(p, "lanes:forward", I18n.tr("Number of lane dependent values inconsistent in forward direction", new Object[0]));
        this.checkNumberOfLanesByKey(p, "lanes:backward", I18n.tr("Number of lane dependent values inconsistent in backward direction", new Object[0]));
        this.checkNumberOfLanes(p);
    }

    @Override
    public boolean isPrimitiveUsable(OsmPrimitive p) {
        return p.isTagged() && super.isPrimitiveUsable(p);
    }
}

