/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging.ac;

import java.awt.Component;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.im.InputContext;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Locale;
import java.util.stream.IntStream;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.PlainDocument;
import javax.swing.text.StyleConstants;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionItem;
import org.openstreetmap.josm.data.tagging.ac.AutoCompletionPriority;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.datatransfer.ClipboardUtils;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class AutoCompletingComboBox
extends JosmComboBox<AutoCompletionItem> {
    private boolean autocompleteEnabled = true;
    private int maxTextLength = -1;
    private boolean useFixedLocale;
    private final transient InputContext privateInputContext = InputContext.getInstance();

    public AutoCompletingComboBox() {
        this("Foo");
    }

    public AutoCompletingComboBox(String prototype) {
        super(new AutoCompletionItem(prototype));
        this.setRenderer(new AutoCompleteListCellRenderer());
        JTextField editorComponent = this.getEditorComponent();
        ((JTextComponent)editorComponent).setDocument(new AutoCompletingComboBoxDocument());
        editorComponent.addFocusListener(new InnerFocusListener(editorComponent));
    }

    public void setMaxTextLength(int length) {
        this.maxTextLength = length;
    }

    @Override
    public void configureEditor(ComboBoxEditor cbEditor, Object item) {
        if (item == null) {
            cbEditor.setItem(null);
        } else if (item instanceof String) {
            cbEditor.setItem(item);
        } else if (item instanceof AutoCompletionItem) {
            cbEditor.setItem(((AutoCompletionItem)item).getValue());
        } else {
            throw new IllegalArgumentException("Unsupported item: " + item);
        }
    }

    @Override
    public void setSelectedItem(Object item) {
        this.setSelectedItem(item, false);
    }

    public void setSelectedItem(Object item, boolean disableAutoComplete) {
        boolean previousState = this.isAutocompleteEnabled();
        if (disableAutoComplete) {
            this.setAutocompleteEnabled(false);
        }
        if (item == null) {
            super.setSelectedItem(null);
        } else if (item instanceof AutoCompletionItem) {
            super.setSelectedItem(item);
        } else if (item instanceof String) {
            String s = (String)item;
            AutoCompletionItem acItem = IntStream.range(0, this.getModel().getSize()).mapToObj(i -> (AutoCompletionItem)this.getModel().getElementAt(i)).filter(i -> s.equals(i.getValue())).findFirst().orElseGet(() -> new AutoCompletionItem(s, AutoCompletionPriority.UNKNOWN));
            super.setSelectedItem(acItem);
        } else {
            this.setAutocompleteEnabled(previousState);
            throw new IllegalArgumentException("Unsupported item: " + item);
        }
        this.setAutocompleteEnabled(previousState);
    }

    public void setPossibleItems(Collection<String> elems) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        Object oldValue = this.getEditor().getItem();
        model.removeAllElements();
        for (String elem : elems) {
            model.addElement(new AutoCompletionItem(elem, AutoCompletionPriority.UNKNOWN));
        }
        this.setSelectedItem(null);
        this.setSelectedItem(oldValue, true);
    }

    public void setPossibleItemsTopDown(Collection<String> elems) {
        LinkedList<String> reversed = new LinkedList<String>(elems);
        Collections.reverse(reversed);
        this.setPossibleItems(reversed);
    }

    public void setPossibleAcItems(Collection<AutoCompletionItem> elems) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        Object oldValue = this.getSelectedItem();
        Object editorOldValue = this.getEditor().getItem();
        model.removeAllElements();
        for (AutoCompletionItem elem : elems) {
            model.addElement(elem);
        }
        this.setSelectedItem(oldValue);
        this.getEditor().setItem(editorOldValue);
    }

    public final boolean isAutocompleteEnabled() {
        return this.autocompleteEnabled;
    }

    public void setAutocompleteEnabled(boolean autocompleteEnabled) {
        this.autocompleteEnabled = autocompleteEnabled;
    }

    public void setFixedLocale(boolean f) {
        this.useFixedLocale = f;
        if (this.useFixedLocale) {
            Locale oldLocale = this.privateInputContext.getLocale();
            Logging.info("Using English input method");
            if (!this.privateInputContext.selectInputMethod(new Locale("en", "US"))) {
                Logging.warn("Unable to use English input method");
                this.useFixedLocale = false;
                if (oldLocale != null) {
                    Logging.info("Restoring input method to " + oldLocale);
                    if (!this.privateInputContext.selectInputMethod(oldLocale)) {
                        Logging.warn("Unable to restore input method to " + oldLocale);
                    }
                }
            }
        }
    }

    @Override
    public InputContext getInputContext() {
        if (this.useFixedLocale) {
            return this.privateInputContext;
        }
        return super.getInputContext();
    }

    public String getEditItem() {
        return Utils.removeWhiteSpaces(this.getEditor().getItem().toString());
    }

    public String getSelectedOrEditItem() {
        Object selectedItem = this.getSelectedItem();
        if (selectedItem instanceof AutoCompletionItem) {
            return ((AutoCompletionItem)selectedItem).getValue();
        }
        if (selectedItem instanceof String) {
            return (String)selectedItem;
        }
        return this.getEditItem();
    }

    public static class AutoCompleteListCellRenderer
    extends JLabel
    implements ListCellRenderer<AutoCompletionItem> {
        public AutoCompleteListCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends AutoCompletionItem> list, AutoCompletionItem item, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setText(item.getValue());
            return this;
        }
    }

    class AutoCompletingComboBoxDocument
    extends PlainDocument {
        private boolean selecting;

        AutoCompletingComboBoxDocument() {
        }

        @Override
        public void remove(int offs, int len) throws BadLocationException {
            if (this.selecting) {
                return;
            }
            try {
                super.remove(offs, len);
            }
            catch (IllegalArgumentException e) {
                Logging.error(e);
            }
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            String newText;
            Object item;
            int start;
            if (this.selecting || offs == 0 && str.equals(this.getText(0, this.getLength()))) {
                return;
            }
            if (AutoCompletingComboBox.this.maxTextLength > -1 && str.length() + this.getLength() > AutoCompletingComboBox.this.maxTextLength) {
                return;
            }
            boolean initial = offs == 0 && this.getLength() == 0 && str.length() > 1;
            super.insertString(offs, str, a);
            if (this.selecting) {
                return;
            }
            if (!AutoCompletingComboBox.this.autocompleteEnabled) {
                return;
            }
            if (a != null && a.isDefined(StyleConstants.ComposedTextAttribute)) {
                return;
            }
            if (offs + str.length() < this.getLength()) {
                return;
            }
            int size = this.getLength();
            int end = start = offs + str.length();
            String curText = this.getText(0, size);
            if (Config.getPref().getBoolean("autocomplete.dont_complete_numbers", true)) {
                try {
                    Long.parseLong(str);
                    if (!curText.isEmpty()) {
                        Long.parseLong(curText);
                    }
                    item = this.lookupItem(curText, true);
                }
                catch (NumberFormatException e) {
                    item = this.lookupItem(curText, false);
                }
            } else {
                item = this.lookupItem(curText, false);
            }
            this.setSelectedItem(item);
            if (initial) {
                start = 0;
            }
            if (item != null && !(newText = ((AutoCompletionItem)item).getValue()).equals(curText)) {
                this.selecting = true;
                super.remove(0, size);
                super.insertString(0, newText, a);
                this.selecting = false;
                start = size;
                end = this.getLength();
            }
            JTextField editorComponent = AutoCompletingComboBox.this.getEditorComponent();
            Clipboard sysSel = ClipboardUtils.getSystemSelection();
            if (sysSel != null) {
                Transferable old = ClipboardUtils.getClipboardContent(sysSel);
                editorComponent.select(start, end);
                if (old != null) {
                    sysSel.setContents(old, null);
                }
            } else {
                editorComponent.select(start, end);
            }
        }

        private void setSelectedItem(Object item) {
            this.selecting = true;
            AutoCompletingComboBox.this.setSelectedItem(item);
            this.selecting = false;
        }

        private Object lookupItem(String pattern, boolean match) {
            ComboBoxModel model = AutoCompletingComboBox.this.getModel();
            AutoCompletionItem bestItem = null;
            int n = model.getSize();
            for (int i = 0; i < n; ++i) {
                AutoCompletionItem currentItem = (AutoCompletionItem)model.getElementAt(i);
                if (currentItem.getValue().equals(pattern)) {
                    return currentItem;
                }
                if (match || !currentItem.getValue().startsWith(pattern) || bestItem != null && currentItem.getPriority().compareTo(bestItem.getPriority()) <= 0) continue;
                bestItem = currentItem;
            }
            return bestItem;
        }
    }

    static final class InnerFocusListener
    implements FocusListener {
        private final JTextComponent editorComponent;

        InnerFocusListener(JTextComponent editorComponent) {
            this.editorComponent = editorComponent;
        }

        @Override
        public void focusLost(FocusEvent e) {
            MapFrame map = MainApplication.getMap();
            if (map != null) {
                map.keyDetector.setEnabled(true);
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            Clipboard sysSel;
            MapFrame map = MainApplication.getMap();
            if (map != null) {
                map.keyDetector.setEnabled(false);
            }
            if ((sysSel = ClipboardUtils.getSystemSelection()) != null) {
                Transferable old = ClipboardUtils.getClipboardContent(sysSel);
                this.editorComponent.selectAll();
                if (old != null) {
                    sysSel.setContents(old, null);
                }
            } else if (e != null && e.getOppositeComponent() != null) {
                this.editorComponent.selectAll();
            }
        }
    }
}

