/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.openssl.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.jruby.ext.openssl.SecurityHelper;

public class NetscapeCertRequest {
    private AlgorithmIdentifier sigAlg;
    private AlgorithmIdentifier keyAlg;
    private byte[] signatureBits;
    private final String challenge;
    private final DERBitString content;
    private PublicKey publicKey;

    public NetscapeCertRequest(byte[] request) throws NoSuchAlgorithmException, InvalidKeySpecException, IllegalArgumentException {
        String keyAlgorithm;
        X509EncodedKeySpec encodedKeySpec;
        ASN1Sequence spkac;
        ASN1InputStream input = new ASN1InputStream((InputStream)new ByteArrayInputStream(request));
        try {
            spkac = ASN1Sequence.getInstance((Object)input.readObject());
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        if (spkac.size() != 3) {
            throw new IllegalArgumentException("invalid SPKAC (size):" + spkac.size());
        }
        ASN1Sequence signatureId = (ASN1Sequence)spkac.getObjectAt(1);
        this.sigAlg = AlgorithmIdentifier.getInstance((Object)signatureId);
        this.signatureBits = ((DERBitString)spkac.getObjectAt(2)).getBytes();
        ASN1Sequence pkac = (ASN1Sequence)spkac.getObjectAt(0);
        if (pkac.size() != 2) {
            throw new IllegalArgumentException("invalid PKAC (len): " + pkac.size());
        }
        this.challenge = ((DERIA5String)pkac.getObjectAt(1)).getString();
        try {
            this.content = new DERBitString((ASN1Encodable)pkac);
            SubjectPublicKeyInfo pubKeyInfo = new SubjectPublicKeyInfo((ASN1Sequence)pkac.getObjectAt(0));
            encodedKeySpec = new X509EncodedKeySpec(new DERBitString((ASN1Encodable)pubKeyInfo).getBytes());
            this.keyAlg = pubKeyInfo.getAlgorithm();
            keyAlgorithm = this.keyAlg.getAlgorithm().getId();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalArgumentException(e);
        }
        KeyFactory keyFactory = SecurityHelper.getKeyFactory(keyAlgorithm);
        this.publicKey = keyFactory.generatePublic(encodedKeySpec);
    }

    public NetscapeCertRequest(String challenge2, AlgorithmIdentifier signingAlg, PublicKey publicKey) throws InvalidKeySpecException {
        this.challenge = challenge2;
        this.sigAlg = signingAlg;
        this.publicKey = publicKey;
        ASN1EncodableVector contentDER = new ASN1EncodableVector();
        try {
            contentDER.add((ASN1Encodable)this.getKeySpec());
        }
        catch (IOException e) {
            throw new InvalidKeySpecException(e);
        }
        contentDER.add((ASN1Encodable)new DERIA5String(challenge2));
        try {
            this.content = new DERBitString((ASN1Encodable)new DERSequence(contentDER));
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new InvalidKeySpecException("exception encoding key: " + e.toString());
        }
    }

    public String getChallenge() {
        return this.challenge;
    }

    public AlgorithmIdentifier getSigningAlgorithm() {
        return this.sigAlg;
    }

    public AlgorithmIdentifier getKeyAlgorithm() {
        return this.keyAlg;
    }

    public void setKeyAlgorithm(AlgorithmIdentifier value2) {
        this.keyAlg = value2;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey value2) {
        this.publicKey = value2;
    }

    public boolean verify(String challenge2) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (!challenge2.equals(this.challenge)) {
            return false;
        }
        Signature signature = this.getSignature();
        signature.initVerify(this.publicKey);
        signature.update(this.content.getBytes());
        return signature.verify(this.signatureBits);
    }

    public void sign(PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, InvalidKeySpecException {
        this.sign(privateKey, null);
    }

    public void sign(PrivateKey privateKey, SecureRandom random) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException, InvalidKeySpecException {
        Signature signature = this.getSignature();
        if (random != null) {
            signature.initSign(privateKey, random);
        } else {
            signature.initSign(privateKey);
        }
        ASN1EncodableVector pkac = new ASN1EncodableVector();
        try {
            pkac.add((ASN1Encodable)this.getKeySpec());
        }
        catch (IOException e) {
            throw new InvalidKeySpecException(e);
        }
        pkac.add((ASN1Encodable)new DERIA5String(this.challenge));
        try {
            signature.update(new DERSequence(pkac).getEncoded("DER"));
        }
        catch (IOException e) {
            throw new SignatureException(e);
        }
        this.signatureBits = signature.sign();
    }

    private Signature getSignature() throws NoSuchAlgorithmException {
        String algorithm = this.sigAlg.getAlgorithm().getId();
        return SecurityHelper.getSignature(algorithm);
    }

    private ASN1Primitive getKeySpec() throws IOException {
        ASN1InputStream input = new ASN1InputStream((InputStream)new ByteArrayInputStream(this.publicKey.getEncoded()));
        return input.readObject();
    }

    public ASN1Primitive toASN1Primitive() throws IOException {
        ASN1EncodableVector spkac = new ASN1EncodableVector();
        ASN1EncodableVector pkac = new ASN1EncodableVector();
        try {
            pkac.add((ASN1Encodable)this.getKeySpec());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        pkac.add((ASN1Encodable)new DERIA5String(this.challenge));
        spkac.add((ASN1Encodable)new DERSequence(pkac));
        spkac.add((ASN1Encodable)this.sigAlg);
        spkac.add((ASN1Encodable)new DERBitString(this.signatureBits));
        return new DERSequence(spkac);
    }
}

