#
#  Strings_SBCS.pm
#
#  Language support. Single Byte Character Set strings translations.
#
# The module, in its source file, contains a data structure, indexed
# by the English strings, that has all available single byte
# translations.
#
# Be careful, this file mixes different single byte encodings, latin1,
# euc-jp and euc-kr.
#
# For UTF-8 translations of strings look at Data::Strings_UTF8.pm
#
# By the time this grows big, we'll make up something else.
#
#  (C) Copyright 1997, Cees de Groot
#  (C) Copyright 2020, Agustin Martin
# -------------------------------------------------------------------------

package LinuxDocTools::Data::Strings_SBCS;

use strict;

our $translations
  = {
     "Previous"
     => {
	 "nl" => "Terug",
	 "de" => "Zurck",
	 "es" => "Pgina anterior",
	 "fr" => "Page prcdente",
	 "da" => "Forrige",
	 "no" => "Forrige",
	 "se" => "Fregende",
	 "pt" => "Pgina anterior",
	 "ca" => "Pgina anterior",
	 "it" => "Indietro",
	 "ro" => "napoi",
	 "ja" => "Υڡ",
	 "pl" => "Poprzedni",
	 "ko" => "",
	 "fi" => "Edellinen"
	},
     "Next"
     => {
	 "nl" => "Verder",
	 "de" => "Weiter",
	 "es" => "Pgina siguiente",
	 "fr" => "Page suivante",
	 "da" => "Nste",
	 "no" => "Neste",
	 "se" => "Nsta",
	 "pt" => "Pgina seguinte",
	 "ca" => "Pgina segent",
	 "it" => "Avanti",
	 "ro" => "nainte",
	 "ja" => "Υڡ",
	 "pl" => "Nastny",
	 "ko" => "",
	 "fi" => "Seuraava"
	},
     "Contents"
     => {
	 "nl" => "Inhoud",
	 "de" => "Inhalt",
	 "es" => "ndice general",
	 "fr" => "Table des matires",
	 "da" => "Indhold",
	 "no" => "Innhold",
	 "se" => "Innehllsfrteckning",
	 "pt" => "ndice",
	 "ca" => "ndex",
	 "it" => "Indice",
	 "ro" => "Cuprins",
	 "ja" => "ܼ",
	 "pl" => "Spis Trei",
	 "ko" => "",
	 "fi" => "Sisllys"
	},
     "Table of Contents"
     => {
	 "nl" => "Inhoudsopgave",
	 "de" => "Inhaltsverzeichnis",
	 "es" => "ndice general",
	 "fr" => "Table des matires",
	 "da" => "Indholdsfortegnelse",
	 "no" => "Innholdsfortegnelse",
	 "se" => "Innehllsfrteckning",
	 "pt" => "ndice geral",
	 "ca" => "ndex general",
	 "it" => "Indice Generale",
	 "ro" => "Cuprins",
	 "ja" => "ܼ",
	 "pl" => "Spis Trei",
	 "ko" => "",
	 "fi" => "Sisllysluettelo"
	}
    };

=back

=head1 AUTHOR

Cees de Groot, C<E<lt>cg@pobox.comE<gt>>

=cut

1;
