/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.UIResource;

public class JToolBar
extends JComponent
implements SwingConstants,
Accessible {
    private static final String uiClassID = "ToolBarUI";
    private boolean paintBorder = true;
    private Insets margin = null;
    private boolean floatable = true;
    private int orientation = 0;

    public JToolBar() {
        this(0);
    }

    public JToolBar(int n) {
        this(null, n);
    }

    public JToolBar(String string) {
        this(string, 0);
    }

    public JToolBar(String string, int n) {
        this.setName(string);
        this.checkOrientation(n);
        this.orientation = n;
        DefaultToolBarLayout defaultToolBarLayout = new DefaultToolBarLayout(n);
        this.setLayout(defaultToolBarLayout);
        this.addPropertyChangeListener(defaultToolBarLayout);
        this.updateUI();
    }

    public ToolBarUI getUI() {
        return (ToolBarUI)this.ui;
    }

    public void setUI(ToolBarUI toolBarUI) {
        super.setUI(toolBarUI);
    }

    @Override
    public void updateUI() {
        this.setUI((ToolBarUI)UIManager.getUI(this));
        if (this.getLayout() == null) {
            this.setLayout(new DefaultToolBarLayout(this.getOrientation()));
        }
        this.invalidate();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public int getComponentIndex(Component component) {
        int n = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < n; ++i) {
            Component component2 = componentArray[i];
            if (component2 != component) continue;
            return i;
        }
        return -1;
    }

    public Component getComponentAtIndex(int n) {
        int n2 = this.getComponentCount();
        if (n >= 0 && n < n2) {
            Component[] componentArray = this.getComponents();
            return componentArray[n];
        }
        return null;
    }

    public void setMargin(Insets insets) {
        Insets insets2 = this.margin;
        this.margin = insets;
        this.firePropertyChange("margin", insets2, insets);
        this.revalidate();
        this.repaint();
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.margin;
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean bl) {
        if (this.paintBorder != bl) {
            boolean bl2 = this.paintBorder;
            this.paintBorder = bl;
            this.firePropertyChange("borderPainted", bl2, bl);
            this.revalidate();
            this.repaint();
        }
    }

    @Override
    protected void paintBorder(Graphics graphics) {
        if (this.isBorderPainted()) {
            super.paintBorder(graphics);
        }
    }

    public boolean isFloatable() {
        return this.floatable;
    }

    public void setFloatable(boolean bl) {
        if (this.floatable != bl) {
            boolean bl2 = this.floatable;
            this.floatable = bl;
            this.firePropertyChange("floatable", bl2, bl);
            this.revalidate();
            this.repaint();
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int n) {
        this.checkOrientation(n);
        if (this.orientation != n) {
            int n2 = this.orientation;
            this.orientation = n;
            this.firePropertyChange("orientation", n2, n);
            this.revalidate();
            this.repaint();
        }
    }

    public void setRollover(boolean bl) {
        this.putClientProperty("JToolBar.isRollover", bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isRollover() {
        Boolean bl = (Boolean)this.getClientProperty("JToolBar.isRollover");
        if (bl != null) {
            return bl;
        }
        return false;
    }

    private void checkOrientation(int n) {
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
        }
    }

    public void addSeparator() {
        this.addSeparator(null);
    }

    public void addSeparator(Dimension dimension) {
        Separator separator = new Separator(dimension);
        this.add(separator);
    }

    public JButton add(Action action) {
        JButton jButton = this.createActionComponent(action);
        jButton.setAction(action);
        this.add(jButton);
        return jButton;
    }

    protected JButton createActionComponent(Action action) {
        JButton jButton = new JButton(){

            @Override
            protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
                PropertyChangeListener propertyChangeListener = JToolBar.this.createActionChangeListener(this);
                if (propertyChangeListener == null) {
                    propertyChangeListener = super.createActionPropertyChangeListener(action);
                }
                return propertyChangeListener;
            }
        };
        if (action != null && (action.getValue("SmallIcon") != null || action.getValue("SwingLargeIconKey") != null)) {
            jButton.setHideActionText(true);
        }
        jButton.setHorizontalTextPosition(0);
        jButton.setVerticalTextPosition(3);
        return jButton;
    }

    protected PropertyChangeListener createActionChangeListener(JButton jButton) {
        return null;
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (component instanceof Separator) {
            if (this.getOrientation() == 1) {
                ((Separator)component).setOrientation(0);
            } else {
                ((Separator)component).setOrientation(1);
            }
        }
        super.addImpl(component, object, n);
        if (component instanceof JButton) {
            ((JButton)component).setDefaultCapable(false);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    @Override
    protected String paramString() {
        String string = this.paintBorder ? "true" : "false";
        String string2 = this.margin != null ? this.margin.toString() : "";
        String string3 = this.floatable ? "true" : "false";
        String string4 = this.orientation == 0 ? "HORIZONTAL" : "VERTICAL";
        return super.paramString() + ",floatable=" + string3 + ",margin=" + string2 + ",orientation=" + string4 + ",paintBorder=" + string;
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        LayoutManager layoutManager2 = this.getLayout();
        if (layoutManager2 instanceof PropertyChangeListener) {
            this.removePropertyChangeListener((PropertyChangeListener)((Object)layoutManager2));
        }
        super.setLayout(layoutManager);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJToolBar();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJToolBar
    extends JComponent.AccessibleJComponent {
        protected AccessibleJToolBar() {
            super(JToolBar.this);
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            return accessibleStateSet;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.TOOL_BAR;
        }
    }

    private class DefaultToolBarLayout
    implements LayoutManager2,
    Serializable,
    PropertyChangeListener,
    UIResource {
        BoxLayout lm;

        DefaultToolBarLayout(int n) {
            this.lm = n == 1 ? new BoxLayout(JToolBar.this, 3) : new BoxLayout(JToolBar.this, 2);
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            this.lm.addLayoutComponent(string, component);
        }

        @Override
        public void addLayoutComponent(Component component, Object object) {
            this.lm.addLayoutComponent(component, object);
        }

        @Override
        public void removeLayoutComponent(Component component) {
            this.lm.removeLayoutComponent(component);
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.lm.preferredLayoutSize(container);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.lm.minimumLayoutSize(container);
        }

        @Override
        public Dimension maximumLayoutSize(Container container) {
            return this.lm.maximumLayoutSize(container);
        }

        @Override
        public void layoutContainer(Container container) {
            this.lm.layoutContainer(container);
        }

        @Override
        public float getLayoutAlignmentX(Container container) {
            return this.lm.getLayoutAlignmentX(container);
        }

        @Override
        public float getLayoutAlignmentY(Container container) {
            return this.lm.getLayoutAlignmentY(container);
        }

        @Override
        public void invalidateLayout(Container container) {
            this.lm.invalidateLayout(container);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("orientation")) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                this.lm = n == 1 ? new BoxLayout(JToolBar.this, 3) : new BoxLayout(JToolBar.this, 2);
            }
        }
    }

    public static class Separator
    extends JSeparator {
        private Dimension separatorSize;

        public Separator() {
            this(null);
        }

        public Separator(Dimension dimension) {
            super(0);
            this.setSeparatorSize(dimension);
        }

        @Override
        public String getUIClassID() {
            return "ToolBarSeparatorUI";
        }

        public void setSeparatorSize(Dimension dimension) {
            if (dimension != null) {
                this.separatorSize = dimension;
            } else {
                super.updateUI();
            }
            this.invalidate();
        }

        public Dimension getSeparatorSize() {
            return this.separatorSize;
        }

        @Override
        public Dimension getMinimumSize() {
            if (this.separatorSize != null) {
                return this.separatorSize.getSize();
            }
            return super.getMinimumSize();
        }

        @Override
        public Dimension getMaximumSize() {
            if (this.separatorSize != null) {
                return this.separatorSize.getSize();
            }
            return super.getMaximumSize();
        }

        @Override
        public Dimension getPreferredSize() {
            if (this.separatorSize != null) {
                return this.separatorSize.getSize();
            }
            return super.getPreferredSize();
        }
    }
}

