/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.heapviewer.java;

import com.sun.tools.visualvm.heapviewer.java.Bundle;
import com.sun.tools.visualvm.heapviewer.java.InstanceNode;
import com.sun.tools.visualvm.heapviewer.model.DataType;
import com.sun.tools.visualvm.heapviewer.model.HeapViewerNode;
import com.sun.tools.visualvm.heapviewer.ui.HeapViewerRenderer;
import java.awt.Image;
import javax.swing.ImageIcon;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.swing.renderer.JavaNameRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.ImageUtilities;

public class InstanceNodeRenderer
extends JavaNameRenderer
implements HeapViewerRenderer {
    private static final ImageIcon ICON_INSTANCE = Icons.getImageIcon((String)"LanguageIcons.Instance");
    private static final ImageIcon ICON_ARRAY = Icons.getImageIcon((String)"LanguageIcons.Array");
    private static final Image IMAGE_LOOP = Icons.getImage((String)"HeapWalkerIcons.Loop");
    private final Heap heap;

    public InstanceNodeRenderer(Heap heap) {
        this.heap = heap;
    }

    public void setValue(Object value, int row) {
        JavaClass jclass;
        String log;
        HeapViewerNode loop = HeapViewerNode.getValue((HeapViewerNode)((Object)value), DataType.LOOP, this.heap);
        boolean isLoop = loop != null;
        InstanceNode node = isLoop ? (InstanceNode)loop : (InstanceNode)((Object)value);
        String name = node.getName(this.heap);
        if (name != null && !"null".equals(name)) {
            super.setValue((Object)name, row);
            if (isLoop) {
                super.setNormalValue(Bundle.InstanceNodeRenderer_LoopTo(super.getNormalValue()));
            }
        } else {
            super.setValue(null, row);
            super.setNormalValue("null");
        }
        if ((log = node.getLogicalValue(this.heap)) != null && !log.isEmpty()) {
            this.setGrayValue(" : " + log);
        }
        ImageIcon icon = (jclass = HeapViewerNode.getValue(node, DataType.CLASS, this.heap)) != null && jclass.isArray() ? ICON_ARRAY : ICON_INSTANCE;
        this.setIcon(isLoop ? new ImageIcon(ImageUtilities.mergeImages((Image)icon.getImage(), (Image)IMAGE_LOOP, (int)0, (int)0)) : icon);
        this.setIconTextGap(isLoop ? 4 : 1);
        ((LabelRenderer)this.valueRenderers()[0]).setMargin(3, isLoop ? 3 : 0, 3, 0);
    }

    @Override
    public String getShortName() {
        return this.getBoldValue();
    }
}

