/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import org.netbeans.lib.profiler.ui.swing.ProfilerRowSorter;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;

class ProfilerColumnModel
extends DefaultTableColumnModel {
    private static final String PROP_COLUMN_WIDTH = "width";
    private int fitWidthColumn = 0;
    private int refWidth = -1;
    private Map<Integer, Integer> columnOffsets;
    private Map<Integer, Integer> columnPreferredWidths;
    private int minColumnWidth = 20;
    private int defaultColumnWidth = 60;
    private Map<Integer, Integer> defaultColumnWidths;
    private Map<Integer, Integer> hiddenColumnWidths = new HashMap<Integer, Integer>();
    private String[] toolTips;
    private Set<Listener> columnListeners;
    private static final String COLUMN_INDEX_KEY = "ProfilerColumnModel.ColumnIndex";
    private static final String COLUMN_WIDTH_KEY = "ProfilerColumnModel.ColumnWidth";

    ProfilerColumnModel() {
    }

    void setFitWidthColumn(int n) {
        this.fitWidthColumn = n;
    }

    int getFitWidthColumn() {
        return this.fitWidthColumn;
    }

    boolean hasFitWidthColumn() {
        return this.fitWidthColumn != -1;
    }

    void setResizingColumn(TableColumn tableColumn) {
        this.refWidth = -1;
    }

    TableColumn createTableColumn(int n) {
        return new TableColumn(n){

            @Override
            public void setWidth(int n) {
                if (this.getMaxWidth() == 0 && this.getWidth() == 0) {
                    TableColumn tableColumn = ProfilerColumnModel.this.getPreviousVisibleColumn(this);
                    if (ProfilerColumnModel.this.refWidth == -1) {
                        ProfilerColumnModel.this.refWidth = tableColumn.getWidth();
                    }
                    tableColumn.setWidth(ProfilerColumnModel.this.refWidth + n);
                } else {
                    super.setWidth(n);
                }
            }
        };
    }

    @Override
    public void addColumn(TableColumn tableColumn) {
        super.addColumn(tableColumn);
        final int n = tableColumn.getModelIndex();
        tableColumn.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (ProfilerColumnModel.PROP_COLUMN_WIDTH.equals(propertyChangeEvent.getPropertyName())) {
                    int n3 = (Integer)propertyChangeEvent.getOldValue();
                    int n2 = (Integer)propertyChangeEvent.getNewValue();
                    ProfilerColumnModel.this.fireColumnWidthChanged(n, n3, n2);
                }
            }
        });
    }

    boolean setColumnOffset(int n, int n2) {
        boolean bl;
        Integer n3;
        if (this.columnOffsets == null) {
            this.columnOffsets = new HashMap<Integer, Integer>();
        }
        int n4 = (n3 = this.columnOffsets.put(n, n2)) == null ? 0 : n3;
        boolean bl2 = bl = n4 != n2;
        if (bl) {
            this.fireColumnOffsetChanged(n, n4, n2);
        }
        return bl;
    }

    int getColumnOffset(int n) {
        if (this.columnOffsets == null) {
            return 0;
        }
        Integer n2 = this.columnOffsets.get(n);
        return n2 == null ? 0 : n2;
    }

    void clearColumnsPrefferedWidth() {
        if (this.columnPreferredWidths != null) {
            this.columnPreferredWidths.clear();
        }
    }

    boolean setColumnPreferredWidth(int n, int n2) {
        boolean bl;
        Integer n3;
        if (this.columnPreferredWidths == null) {
            this.columnPreferredWidths = new HashMap<Integer, Integer>();
        }
        int n4 = (n3 = this.columnPreferredWidths.put(n, n2)) == null ? 0 : n3;
        boolean bl2 = bl = n4 != n2;
        if (bl) {
            this.fireColumnPreferredWidthChanged(n, n4, n2);
        }
        return bl;
    }

    int getColumnPreferredWidth(int n) {
        if (this.columnPreferredWidths == null) {
            return 0;
        }
        Integer n2 = this.columnPreferredWidths.get(n);
        return n2 == null ? 0 : n2;
    }

    void setDefaultColumnWidth(int n) {
        this.defaultColumnWidth = n;
        Enumeration<TableColumn> enumeration = this.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            int n2 = tableColumn.getModelIndex();
            if (this.defaultColumnWidths != null && this.defaultColumnWidths.get(n2) != null || n2 == this.fitWidthColumn) continue;
            tableColumn.setWidth(n);
        }
    }

    void setDefaultColumnWidth(int n, int n2) {
        if (this.defaultColumnWidths == null) {
            this.defaultColumnWidths = new HashMap<Integer, Integer>();
        }
        this.defaultColumnWidths.put(n, n2);
        if (this.isColumnVisible(n)) {
            TableColumn tableColumn = this.getModelColumn(n);
            if (tableColumn != null) {
                tableColumn.setWidth(n2);
            }
        } else {
            this.hiddenColumnWidths.put(n, n2);
        }
    }

    int getDefaultColumnWidth(int n) {
        Integer n2 = this.defaultColumnWidths == null ? null : this.defaultColumnWidths.get(n);
        return n2 == null ? this.defaultColumnWidth : n2;
    }

    void setColumnVisibility(TableColumn tableColumn, boolean bl, ProfilerTable profilerTable) {
        if (bl) {
            this.showColumn(tableColumn, profilerTable);
        } else {
            this.hideColumn(tableColumn, profilerTable);
        }
    }

    boolean isColumnVisible(int n) {
        return this.isColumnVisible(this.getModelColumn(n));
    }

    boolean isColumnVisible(TableColumn tableColumn) {
        return tableColumn.getMaxWidth() > 0;
    }

    int getVisibleColumnCount() {
        return this.getColumnCount() - this.hiddenColumnWidths.size();
    }

    void showColumn(TableColumn tableColumn, ProfilerTable profilerTable) {
        tableColumn.setMaxWidth(Integer.MAX_VALUE);
        Integer n = this.hiddenColumnWidths.remove(tableColumn.getModelIndex());
        tableColumn.setWidth(n != null ? n.intValue() : this.getDefaultColumnWidth(tableColumn.getModelIndex()));
        tableColumn.setMinWidth(this.minColumnWidth);
        int n2 = this.getFitWidthColumn();
        if (tableColumn.getModelIndex() == n2) {
            Enumeration<TableColumn> enumeration = this.getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn tableColumn2 = enumeration.nextElement();
                int n3 = tableColumn2.getModelIndex();
                if (tableColumn2.getModelIndex() == n2 || !this.isColumnVisible(tableColumn2)) continue;
                tableColumn2.setWidth(this.getDefaultColumnWidth(n3));
            }
            profilerTable.doLayout();
        }
    }

    void hideColumn(TableColumn tableColumn, ProfilerTable profilerTable) {
        ProfilerRowSorter profilerRowSorter;
        int n;
        this.hiddenColumnWidths.put(tableColumn.getModelIndex(), tableColumn.getWidth());
        tableColumn.setMinWidth(0);
        tableColumn.setMaxWidth(0);
        int n2 = profilerTable.getSelectedColumn();
        if (n2 != -1 && this.getColumn(n2).equals(tableColumn)) {
            int n3 = this.getPreviousVisibleColumn(n2);
            this.getSelectionModel().setSelectionInterval(n3, n3);
        }
        if (profilerTable.isSortable() && (n = (profilerRowSorter = profilerTable._getRowSorter()).getSortColumn()) == tableColumn.getModelIndex()) {
            int n4 = profilerTable.convertColumnIndexToView(n);
            n4 = this.getPreviousVisibleColumn(n4);
            profilerRowSorter.setSortColumn(this.getColumn(n4).getModelIndex());
        }
    }

    int getFirstVisibleColumn() {
        int n = 0;
        return this.isColumnVisible(this.getColumn(n)) ? n : this.getNextVisibleColumn(n);
    }

    int getLastVisibleColumn() {
        int n = this.getColumnCount() - 1;
        return this.isColumnVisible(this.getColumn(n)) ? n : this.getPreviousVisibleColumn(n);
    }

    TableColumn getNextVisibleColumn(TableColumn tableColumn) {
        int n = this.tableColumns.indexOf(tableColumn);
        int n2 = this.getNextVisibleColumn(n);
        return this.getColumn(n2);
    }

    int getNextVisibleColumn(int n) {
        while (!this.isColumnVisible(this.getColumn(n = this.getNextColumn(n)))) {
        }
        return n;
    }

    TableColumn getPreviousVisibleColumn(TableColumn tableColumn) {
        int n = this.tableColumns.indexOf(tableColumn);
        int n2 = this.getPreviousVisibleColumn(n);
        return this.getColumn(n2);
    }

    int getPreviousVisibleColumn(int n) {
        while (!this.isColumnVisible(this.getColumn(n = this.getPreviousColumn(n)))) {
        }
        return n;
    }

    private int getNextColumn(int n) {
        return ++n == this.getColumnCount() ? 0 : n;
    }

    private int getPreviousColumn(int n) {
        return --n == -1 ? this.getColumnCount() - 1 : n;
    }

    private TableColumn getModelColumn(int n) {
        Enumeration<TableColumn> enumeration = this.getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = enumeration.nextElement();
            if (tableColumn.getModelIndex() != n) continue;
            return tableColumn;
        }
        return null;
    }

    void setColumnToolTips(String[] stringArray) {
        this.toolTips = Arrays.copyOf(stringArray, stringArray.length);
    }

    String getColumnToolTip(int n) {
        if (this.toolTips == null) {
            return null;
        }
        return n < 0 || n >= this.toolTips.length ? null : this.toolTips[n];
    }

    void addColumnChangeListener(Listener listener) {
        if (this.columnListeners == null) {
            this.columnListeners = new HashSet<Listener>();
        }
        this.columnListeners.add(listener);
    }

    void removeColumnChangeListener(Listener listener) {
        if (this.columnListeners == null) {
            return;
        }
        this.columnListeners.remove(listener);
        if (this.columnListeners.isEmpty()) {
            this.columnListeners = null;
        }
    }

    private void fireColumnOffsetChanged(int n, int n2, int n3) {
        if (this.columnListeners == null) {
            return;
        }
        for (Listener listener : this.columnListeners) {
            listener.columnOffsetChanged(n, n2, n3);
        }
    }

    private void fireColumnWidthChanged(int n, int n2, int n3) {
        if (this.columnListeners == null) {
            return;
        }
        for (Listener listener : this.columnListeners) {
            listener.columnWidthChanged(n, n2, n3);
        }
    }

    private void fireColumnPreferredWidthChanged(int n, int n2, int n3) {
        if (this.columnListeners == null) {
            return;
        }
        for (Listener listener : this.columnListeners) {
            listener.columnPreferredWidthChanged(n, n2, n3);
        }
    }

    void loadFromStorage(Properties properties, ProfilerTable profilerTable) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            String string = properties.getProperty("ProfilerColumnModel.ColumnIndex." + i);
            if (string == null) continue;
            try {
                int n = Integer.parseInt(string);
                int n2 = this.getDefaultColumnWidth(n);
                String string2 = properties.getProperty("ProfilerColumnModel.ColumnWidth." + i);
                if (string2 != null) {
                    try {
                        n2 = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                TableColumn tableColumn = this.getModelColumn(n);
                tableColumn.setIdentifier(i);
                if (n == this.getFitWidthColumn()) continue;
                if (n2 == 0) {
                    this.hideColumn(tableColumn, profilerTable);
                    continue;
                }
                tableColumn.setWidth(n2);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Collections.sort(this.tableColumns, new Comparator<TableColumn>(){

            @Override
            public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
                Integer n = (Integer)tableColumn.getIdentifier();
                Integer n2 = (Integer)tableColumn2.getIdentifier();
                return n.compareTo(n2);
            }
        });
    }

    void saveToStorage(Properties properties, ProfilerTable profilerTable) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            TableColumn tableColumn = this.getColumn(i);
            properties.setProperty("ProfilerColumnModel.ColumnIndex." + i, Integer.toString(tableColumn.getModelIndex()));
            properties.setProperty("ProfilerColumnModel.ColumnWidth." + i, Integer.toString(tableColumn.getWidth()));
        }
    }

    static interface Listener {
        public void columnOffsetChanged(int var1, int var2, int var3);

        public void columnWidthChanged(int var1, int var2, int var3);

        public void columnPreferredWidthChanged(int var1, int var2, int var3);
    }
}

