/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.attributes;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.attributes.Attributes;
import org.eclipse.jgit.attributes.AttributesNode;
import org.eclipse.jgit.attributes.AttributesNodeProvider;
import org.eclipse.jgit.attributes.AttributesRule;
import org.eclipse.jgit.dircache.DirCacheIterator;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;

public class AttributesHandler {
    private static final String MACRO_PREFIX = "[attr]";
    private static final String BINARY_RULE_KEY = "binary";
    private static final List<Attribute> BINARY_RULE_ATTRIBUTES = new AttributesRule("[attr]binary", "-diff -merge -text").getAttributes();
    private final TreeWalk treeWalk;
    private final AttributesNode globalNode;
    private final AttributesNode infoNode;
    private final Map<String, List<Attribute>> expansions = new HashMap<String, List<Attribute>>();

    public AttributesHandler(TreeWalk treeWalk) throws IOException {
        this.treeWalk = treeWalk;
        AttributesNodeProvider attributesNodeProvider = treeWalk.getAttributesNodeProvider();
        this.globalNode = attributesNodeProvider != null ? attributesNodeProvider.getGlobalAttributesNode() : null;
        this.infoNode = attributesNodeProvider != null ? attributesNodeProvider.getInfoAttributesNode() : null;
        AttributesNode rootNode = AttributesHandler.attributesNode(treeWalk, AttributesHandler.rootOf(treeWalk.getTree(WorkingTreeIterator.class)), AttributesHandler.rootOf(treeWalk.getTree(DirCacheIterator.class)), AttributesHandler.rootOf(treeWalk.getTree(CanonicalTreeParser.class)));
        this.expansions.put(BINARY_RULE_KEY, BINARY_RULE_ATTRIBUTES);
        for (AttributesNode node2 : new AttributesNode[]{this.globalNode, rootNode, this.infoNode}) {
            if (node2 == null) continue;
            for (AttributesRule rule : node2.getRules()) {
                if (!rule.getPattern().startsWith(MACRO_PREFIX)) continue;
                this.expansions.put(rule.getPattern().substring(MACRO_PREFIX.length()).trim(), rule.getAttributes());
            }
        }
    }

    public Attributes getAttributes() throws IOException {
        String entryPath = this.treeWalk.getPathString();
        boolean isDirectory = this.treeWalk.getFileMode() == FileMode.TREE;
        Attributes attributes = new Attributes(new Attribute[0]);
        this.mergeInfoAttributes(entryPath, isDirectory, attributes);
        this.mergePerDirectoryEntryAttributes(entryPath, entryPath.lastIndexOf(47), isDirectory, this.treeWalk.getTree(WorkingTreeIterator.class), this.treeWalk.getTree(DirCacheIterator.class), this.treeWalk.getTree(CanonicalTreeParser.class), attributes);
        this.mergeGlobalAttributes(entryPath, isDirectory, attributes);
        for (Attribute a : attributes.getAll()) {
            if (a.getState() != Attribute.State.UNSPECIFIED) continue;
            attributes.remove(a.getKey());
        }
        return attributes;
    }

    private void mergeGlobalAttributes(String entryPath, boolean isDirectory, Attributes result) {
        this.mergeAttributes(this.globalNode, entryPath, isDirectory, result);
    }

    private void mergeInfoAttributes(String entryPath, boolean isDirectory, Attributes result) {
        this.mergeAttributes(this.infoNode, entryPath, isDirectory, result);
    }

    private void mergePerDirectoryEntryAttributes(String entryPath, int nameRoot, boolean isDirectory, @Nullable WorkingTreeIterator workingTreeIterator, @Nullable DirCacheIterator dirCacheIterator, @Nullable CanonicalTreeParser otherTree, Attributes result) throws IOException {
        if (workingTreeIterator != null || dirCacheIterator != null || otherTree != null) {
            AttributesNode attributesNode = AttributesHandler.attributesNode(this.treeWalk, workingTreeIterator, dirCacheIterator, otherTree);
            if (attributesNode != null) {
                this.mergeAttributes(attributesNode, entryPath.substring(nameRoot + 1), isDirectory, result);
            }
            this.mergePerDirectoryEntryAttributes(entryPath, entryPath.lastIndexOf(47, nameRoot - 1), isDirectory, AttributesHandler.parentOf(workingTreeIterator), AttributesHandler.parentOf(dirCacheIterator), AttributesHandler.parentOf(otherTree), result);
        }
    }

    protected void mergeAttributes(@Nullable AttributesNode node2, String entryPath, boolean isDirectory, Attributes result) {
        if (node2 == null) {
            return;
        }
        List<AttributesRule> rules = node2.getRules();
        ListIterator<AttributesRule> ruleIterator = rules.listIterator(rules.size());
        while (ruleIterator.hasPrevious()) {
            AttributesRule rule = ruleIterator.previous();
            if (!rule.isMatch(entryPath, isDirectory)) continue;
            ListIterator<Attribute> attributeIte = rule.getAttributes().listIterator(rule.getAttributes().size());
            while (attributeIte.hasPrevious()) {
                this.expandMacro(attributeIte.previous(), result);
            }
        }
    }

    protected void expandMacro(Attribute attr, Attributes result) {
        if (result.containsKey(attr.getKey())) {
            return;
        }
        result.put(attr);
        List<Attribute> expansion = this.expansions.get(attr.getKey());
        if (expansion == null) {
            return;
        }
        switch (attr.getState()) {
            case UNSET: {
                block13: for (Attribute e2 : expansion) {
                    switch (e2.getState()) {
                        case SET: {
                            this.expandMacro(new Attribute(e2.getKey(), Attribute.State.UNSET), result);
                            continue block13;
                        }
                        case UNSET: {
                            this.expandMacro(new Attribute(e2.getKey(), Attribute.State.SET), result);
                            continue block13;
                        }
                        case UNSPECIFIED: {
                            this.expandMacro(new Attribute(e2.getKey(), Attribute.State.UNSPECIFIED), result);
                            continue block13;
                        }
                    }
                    this.expandMacro(e2, result);
                }
                break;
            }
            case CUSTOM: {
                block14: for (Attribute e3 : expansion) {
                    switch (e3.getState()) {
                        case SET: 
                        case UNSET: 
                        case UNSPECIFIED: {
                            this.expandMacro(e3, result);
                            continue block14;
                        }
                    }
                    this.expandMacro(new Attribute(e3.getKey(), attr.getValue()), result);
                }
                break;
            }
            case UNSPECIFIED: {
                for (Attribute e4 : expansion) {
                    this.expandMacro(new Attribute(e4.getKey(), Attribute.State.UNSPECIFIED), result);
                }
                break;
            }
            default: {
                for (Attribute e5 : expansion) {
                    this.expandMacro(e5, result);
                }
            }
        }
    }

    private static AttributesNode attributesNode(TreeWalk treeWalk, @Nullable WorkingTreeIterator workingTreeIterator, @Nullable DirCacheIterator dirCacheIterator, @Nullable CanonicalTreeParser otherTree) throws IOException {
        AttributesNode attributesNode = null;
        switch (treeWalk.getOperationType()) {
            case CHECKIN_OP: {
                if (workingTreeIterator != null) {
                    attributesNode = workingTreeIterator.getEntryAttributesNode();
                }
                if (attributesNode == null && dirCacheIterator != null) {
                    attributesNode = dirCacheIterator.getEntryAttributesNode(treeWalk.getObjectReader());
                }
                if (attributesNode != null || otherTree == null) break;
                attributesNode = otherTree.getEntryAttributesNode(treeWalk.getObjectReader());
                break;
            }
            case CHECKOUT_OP: {
                if (otherTree != null) {
                    attributesNode = otherTree.getEntryAttributesNode(treeWalk.getObjectReader());
                }
                if (attributesNode == null && dirCacheIterator != null) {
                    attributesNode = dirCacheIterator.getEntryAttributesNode(treeWalk.getObjectReader());
                }
                if (attributesNode != null || workingTreeIterator == null) break;
                attributesNode = workingTreeIterator.getEntryAttributesNode();
                break;
            }
            default: {
                throw new IllegalStateException("The only supported operation types are:" + (Object)((Object)TreeWalk.OperationType.CHECKIN_OP) + "," + (Object)((Object)TreeWalk.OperationType.CHECKOUT_OP));
            }
        }
        return attributesNode;
    }

    private static <T extends AbstractTreeIterator> T parentOf(@Nullable T node2) {
        AbstractTreeIterator parent;
        if (node2 == null) {
            return null;
        }
        Class<?> type2 = node2.getClass();
        if (type2.isInstance(parent = node2.parent)) {
            return (T)((AbstractTreeIterator)type2.cast(parent));
        }
        return null;
    }

    private static <T extends AbstractTreeIterator> T rootOf(@Nullable T node2) {
        if (node2 == null) {
            return null;
        }
        Object t = node2;
        while (t != null && t.parent != null) {
            t = t.parent;
        }
        Class<?> type2 = node2.getClass();
        if (type2.isInstance(t)) {
            return (T)((AbstractTreeIterator)type2.cast(t));
        }
        return null;
    }
}

