/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RateLimiter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.RepositoryCleanupInProgress;
import org.elasticsearch.cluster.SnapshotDeletionsInProgress;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.RepositoriesMetaData;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.DeleteResult;
import org.elasticsearch.common.blobstore.fs.FsBlobContainer;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.compress.NotXContentException;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.store.InputStreamIndexInput;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardRestoreFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshots;
import org.elasticsearch.index.snapshots.blobstore.RateLimitingInputStream;
import org.elasticsearch.index.snapshots.blobstore.SlicedInputStream;
import org.elasticsearch.index.snapshots.blobstore.SnapshotFiles;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryCleanupResult;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryOperation;
import org.elasticsearch.repositories.RepositoryVerificationException;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.repositories.blobstore.ChecksumBlobStoreFormat;
import org.elasticsearch.repositories.blobstore.FileRestoreContext;
import org.elasticsearch.snapshots.ConcurrentSnapshotExecutionException;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotCreationException;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotShardFailure;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class BlobStoreRepository
extends AbstractLifecycleComponent
implements Repository {
    private static final Logger logger = LogManager.getLogger(BlobStoreRepository.class);
    protected volatile RepositoryMetaData metadata;
    protected final NamedXContentRegistry namedXContentRegistry;
    protected final ThreadPool threadPool;
    private static final int BUFFER_SIZE = 4096;
    public static final String SNAPSHOT_PREFIX = "snap-";
    public static final String SNAPSHOT_CODEC = "snapshot";
    public static final String INDEX_FILE_PREFIX = "index-";
    public static final String INDEX_LATEST_BLOB = "index.latest";
    private static final String TESTS_FILE = "tests-";
    public static final String METADATA_PREFIX = "meta-";
    public static final String METADATA_NAME_FORMAT = "meta-%s.dat";
    private static final String METADATA_CODEC = "metadata";
    private static final String INDEX_METADATA_CODEC = "index-metadata";
    public static final String SNAPSHOT_NAME_FORMAT = "snap-%s.dat";
    private static final String SNAPSHOT_INDEX_PREFIX = "index-";
    private static final String SNAPSHOT_INDEX_NAME_FORMAT = "index-%s";
    private static final String SNAPSHOT_INDEX_CODEC = "snapshots";
    private static final String UPLOADED_DATA_BLOB_PREFIX = "__";
    private static final String VIRTUAL_DATA_BLOB_PREFIX = "v__";
    public static final Setting<Boolean> COMPRESS_SETTING = Setting.boolSetting("compress", true, Setting.Property.NodeScope);
    public static final Setting<Boolean> ALLOW_CONCURRENT_MODIFICATION = Setting.boolSetting("allow_concurrent_modifications", false, Setting.Property.Deprecated);
    public static final Setting<Boolean> CACHE_REPOSITORY_DATA = Setting.boolSetting("cache_repository_data", true, Setting.Property.Deprecated);
    private final boolean compress;
    private final boolean cacheRepositoryData;
    private final RateLimiter snapshotRateLimiter;
    private final RateLimiter restoreRateLimiter;
    private final CounterMetric snapshotRateLimitingTimeInNanos = new CounterMetric();
    private final CounterMetric restoreRateLimitingTimeInNanos = new CounterMetric();
    private ChecksumBlobStoreFormat<MetaData> globalMetaDataFormat;
    private ChecksumBlobStoreFormat<IndexMetaData> indexMetaDataFormat;
    protected ChecksumBlobStoreFormat<SnapshotInfo> snapshotFormat;
    private final boolean readOnly;
    private final ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshot> indexShardSnapshotFormat;
    private final ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshots> indexShardSnapshotsFormat;
    private final Object lock = new Object();
    private final SetOnce<BlobContainer> blobContainer = new SetOnce();
    private final SetOnce<BlobStore> blobStore = new SetOnce();
    private final ClusterService clusterService;
    private boolean uncleanStart;
    private volatile boolean bestEffortConsistency;
    private final AtomicLong latestKnownRepoGen = new AtomicLong(-2L);
    private final AtomicReference<Tuple<Long, BytesReference>> latestKnownRepositoryData = new AtomicReference();

    protected BlobStoreRepository(RepositoryMetaData metadata, boolean compress, NamedXContentRegistry namedXContentRegistry, ClusterService clusterService) {
        this.compress = compress;
        this.metadata = metadata;
        this.namedXContentRegistry = namedXContentRegistry;
        this.threadPool = clusterService.getClusterApplierService().threadPool();
        this.clusterService = clusterService;
        this.snapshotRateLimiter = this.getRateLimiter(metadata.settings(), "max_snapshot_bytes_per_sec", new ByteSizeValue(40L, ByteSizeUnit.MB));
        this.restoreRateLimiter = this.getRateLimiter(metadata.settings(), "max_restore_bytes_per_sec", new ByteSizeValue(40L, ByteSizeUnit.MB));
        this.readOnly = metadata.settings().getAsBoolean("readonly", false);
        this.cacheRepositoryData = CACHE_REPOSITORY_DATA.get(metadata.settings());
        this.indexShardSnapshotFormat = new ChecksumBlobStoreFormat(SNAPSHOT_CODEC, SNAPSHOT_NAME_FORMAT, BlobStoreIndexShardSnapshot::fromXContent, namedXContentRegistry, compress);
        this.indexShardSnapshotsFormat = new ChecksumBlobStoreFormat(SNAPSHOT_INDEX_CODEC, SNAPSHOT_INDEX_NAME_FORMAT, BlobStoreIndexShardSnapshots::fromXContent, namedXContentRegistry, compress);
    }

    @Override
    protected void doStart() {
        this.uncleanStart = this.metadata.pendingGeneration() > -1L && this.metadata.generation() != this.metadata.pendingGeneration();
        ByteSizeValue chunkSize = this.chunkSize();
        if (chunkSize != null && chunkSize.getBytes() <= 0L) {
            throw new IllegalArgumentException("the chunk size cannot be negative: [" + chunkSize + "]");
        }
        this.globalMetaDataFormat = new ChecksumBlobStoreFormat(METADATA_CODEC, METADATA_NAME_FORMAT, MetaData::fromXContent, this.namedXContentRegistry, this.compress);
        this.indexMetaDataFormat = new ChecksumBlobStoreFormat(INDEX_METADATA_CODEC, METADATA_NAME_FORMAT, IndexMetaData::fromXContent, this.namedXContentRegistry, this.compress);
        this.snapshotFormat = new ChecksumBlobStoreFormat(SNAPSHOT_CODEC, SNAPSHOT_NAME_FORMAT, SnapshotInfo::fromXContentInternal, this.namedXContentRegistry, this.compress);
    }

    @Override
    protected void doStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() {
        BlobStore store;
        Object object = this.lock;
        synchronized (object) {
            store = (BlobStore)this.blobStore.get();
        }
        if (store != null) {
            try {
                store.close();
            }
            catch (Exception t) {
                logger.warn("cannot close blob store", (Throwable)t);
            }
        }
    }

    @Override
    public void updateState(ClusterState state) {
        this.metadata = this.getRepoMetaData(state);
        this.uncleanStart = this.uncleanStart && this.metadata.generation() != this.metadata.pendingGeneration();
        boolean bl = this.bestEffortConsistency = this.uncleanStart || this.isReadOnly() || state.nodes().getMinNodeVersion().before(RepositoryMetaData.REPO_GEN_IN_CS_VERSION) || this.metadata.generation() == -2L || ALLOW_CONCURRENT_MODIFICATION.get(this.metadata.settings()) != false;
        if (this.isReadOnly()) {
            return;
        }
        if (this.bestEffortConsistency) {
            long bestGenerationFromCS = -1L;
            SnapshotsInProgress snapshotsInProgress = (SnapshotsInProgress)state.custom(SNAPSHOT_INDEX_CODEC);
            if (snapshotsInProgress != null) {
                bestGenerationFromCS = this.bestGeneration(snapshotsInProgress.entries());
            }
            SnapshotDeletionsInProgress deletionsInProgress = (SnapshotDeletionsInProgress)state.custom("snapshot_deletions");
            if (bestGenerationFromCS == -1L && deletionsInProgress != null) {
                bestGenerationFromCS = this.bestGeneration(deletionsInProgress.getEntries());
            }
            RepositoryCleanupInProgress cleanupInProgress = (RepositoryCleanupInProgress)state.custom("repository_cleanup");
            if (bestGenerationFromCS == -1L && cleanupInProgress != null) {
                bestGenerationFromCS = this.bestGeneration(cleanupInProgress.entries());
            }
            long finalBestGen = Math.max(bestGenerationFromCS, this.metadata.generation());
            this.latestKnownRepoGen.updateAndGet(known -> Math.max(known, finalBestGen));
        } else {
            long previousBest = this.latestKnownRepoGen.getAndSet(this.metadata.generation());
            if (previousBest != this.metadata.generation()) {
                assert (this.metadata.generation() == -3L || previousBest < this.metadata.generation()) : "Illegal move from repository generation [" + previousBest + "] to generation [" + this.metadata.generation() + "]";
                logger.debug("Updated repository generation from [{}] to [{}]", (Object)previousBest, (Object)this.metadata.generation());
            }
        }
    }

    private long bestGeneration(Collection<? extends RepositoryOperation> operations) {
        String repoName = this.metadata.name();
        assert (operations.size() <= 1) : "Assumed one or no operations but received " + operations;
        return operations.stream().filter(e -> e.repository().equals(repoName)).mapToLong(RepositoryOperation::repositoryStateId).max().orElse(-1L);
    }

    public ThreadPool threadPool() {
        return this.threadPool;
    }

    BlobContainer getBlobContainer() {
        return (BlobContainer)this.blobContainer.get();
    }

    protected BlobStore getBlobStore() {
        return (BlobStore)this.blobStore.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlobContainer blobContainer() {
        this.assertSnapshotOrGenericThread();
        BlobContainer blobContainer = (BlobContainer)this.blobContainer.get();
        if (blobContainer == null) {
            Object object = this.lock;
            synchronized (object) {
                blobContainer = (BlobContainer)this.blobContainer.get();
                if (blobContainer == null) {
                    blobContainer = this.blobStore().blobContainer(this.basePath());
                    this.blobContainer.set((Object)blobContainer);
                }
            }
        }
        return blobContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BlobStore blobStore() {
        this.assertSnapshotOrGenericThread();
        BlobStore store = (BlobStore)this.blobStore.get();
        if (store == null) {
            Object object = this.lock;
            synchronized (object) {
                store = (BlobStore)this.blobStore.get();
                if (store == null) {
                    if (!this.lifecycle.started()) {
                        throw new RepositoryException(this.metadata.name(), "repository is not in started state");
                    }
                    try {
                        store = this.createBlobStore();
                    }
                    catch (RepositoryException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RepositoryException(this.metadata.name(), "cannot create blob store", e);
                    }
                    this.blobStore.set((Object)store);
                }
            }
        }
        return store;
    }

    protected abstract BlobStore createBlobStore() throws Exception;

    public abstract BlobPath basePath();

    protected final boolean isCompress() {
        return this.compress;
    }

    protected ByteSizeValue chunkSize() {
        return null;
    }

    @Override
    public RepositoryMetaData getMetadata() {
        return this.metadata;
    }

    @Override
    public void initializeSnapshot(SnapshotId snapshotId, List<IndexId> indices, MetaData clusterMetaData) {
        try {
            this.globalMetaDataFormat.write(clusterMetaData, this.blobContainer(), snapshotId.getUUID(), true);
            for (IndexId index : indices) {
                this.indexMetaDataFormat.write(clusterMetaData.index(index.getName()), this.indexContainer(index), snapshotId.getUUID(), true);
            }
        }
        catch (IOException ex) {
            throw new SnapshotCreationException(this.metadata.name(), snapshotId, (Throwable)ex);
        }
    }

    @Override
    public void deleteSnapshot(SnapshotId snapshotId, long repositoryStateId, Version repositoryMetaVersion, ActionListener<Void> listener) {
        if (this.isReadOnly()) {
            listener.onFailure(new RepositoryException(this.metadata.name(), "cannot delete snapshot from a readonly repository"));
        } else {
            long latestKnownGen = this.latestKnownRepoGen.get();
            if (latestKnownGen > repositoryStateId) {
                listener.onFailure(new ConcurrentSnapshotExecutionException(new Snapshot(this.metadata.name(), snapshotId), "Another concurrent operation moved repo generation to [ " + latestKnownGen + "] but this delete assumed generation [" + repositoryStateId + "]"));
                return;
            }
            try {
                Map<String, BlobMetaData> rootBlobs = this.blobContainer().listBlobs();
                RepositoryData repositoryData = this.safeRepositoryData(repositoryStateId, rootBlobs);
                Map<String, BlobContainer> foundIndices = this.blobStore().blobContainer(this.indicesPath()).children();
                this.doDeleteShardSnapshots(snapshotId, repositoryStateId, foundIndices, rootBlobs, repositoryData, SnapshotsService.useShardGenerations(repositoryMetaVersion), listener);
            }
            catch (Exception ex) {
                listener.onFailure(new RepositoryException(this.metadata.name(), "failed to delete snapshot [" + snapshotId + "]", ex));
            }
        }
    }

    private RepositoryData safeRepositoryData(long repositoryStateId, Map<String, BlobMetaData> rootBlobs) throws IOException {
        Tuple<Long, BytesReference> cached;
        long genToLoad;
        long generation = this.latestGeneration(rootBlobs.keySet());
        if (this.bestEffortConsistency) {
            genToLoad = this.latestKnownRepoGen.updateAndGet(known -> Math.max(known, repositoryStateId));
            cached = null;
        } else {
            genToLoad = this.latestKnownRepoGen.get();
            cached = this.latestKnownRepositoryData.get();
        }
        if (genToLoad > generation) {
            logger.debug("Determined repository's generation from its contents to [" + generation + "] but current generation is at least [" + genToLoad + "]");
        }
        if (genToLoad != repositoryStateId) {
            throw new RepositoryException(this.metadata.name(), "concurrent modification of the index-N file, expected current generation [" + repositoryStateId + "], actual current generation [" + genToLoad + "]");
        }
        if (cached != null && (Long)cached.v1() == genToLoad) {
            return this.repositoryDataFromCachedEntry(cached);
        }
        return this.getRepositoryData(genToLoad);
    }

    private void doDeleteShardSnapshots(SnapshotId snapshotId, long repositoryStateId, Map<String, BlobContainer> foundIndices, Map<String, BlobMetaData> rootBlobs, RepositoryData repositoryData, boolean writeShardGens, ActionListener<Void> listener) {
        if (writeShardGens) {
            StepListener<Collection<ShardSnapshotMetaDeleteResult>> writeShardMetaDataAndComputeDeletesStep = new StepListener<Collection<ShardSnapshotMetaDeleteResult>>();
            this.writeUpdatedShardMetaDataAndComputeDeletes(snapshotId, repositoryData, true, writeShardMetaDataAndComputeDeletesStep);
            StepListener<RepositoryData> writeUpdatedRepoDataStep = new StepListener<RepositoryData>();
            writeShardMetaDataAndComputeDeletesStep.whenComplete(deleteResults -> {
                ShardGenerations.Builder builder = ShardGenerations.builder();
                for (ShardSnapshotMetaDeleteResult newGen : deleteResults) {
                    builder.put(newGen.indexId, newGen.shardId, newGen.newGeneration);
                }
                RepositoryData updatedRepoData = repositoryData.removeSnapshot(snapshotId, builder.build());
                this.writeIndexGen(updatedRepoData, repositoryStateId, true, ActionListener.wrap(v -> writeUpdatedRepoDataStep.onResponse(updatedRepoData), listener::onFailure));
            }, listener::onFailure);
            writeUpdatedRepoDataStep.whenComplete(updatedRepoData -> {
                GroupedActionListener<Void> afterCleanupsListener = new GroupedActionListener<Void>(ActionListener.wrap(() -> listener.onResponse(null)), 2);
                this.asyncCleanupUnlinkedRootAndIndicesBlobs(foundIndices, rootBlobs, (RepositoryData)updatedRepoData, (ActionListener<Void>)afterCleanupsListener);
                this.asyncCleanupUnlinkedShardLevelBlobs(snapshotId, (Collection)writeShardMetaDataAndComputeDeletesStep.result(), afterCleanupsListener);
            }, listener::onFailure);
        } else {
            RepositoryData updatedRepoData2 = repositoryData.removeSnapshot(snapshotId, ShardGenerations.EMPTY);
            this.writeIndexGen(updatedRepoData2, repositoryStateId, false, ActionListener.wrap(v -> {
                GroupedActionListener<Void> afterCleanupsListener = new GroupedActionListener<Void>(ActionListener.wrap(() -> listener.onResponse(null)), 2);
                this.asyncCleanupUnlinkedRootAndIndicesBlobs(foundIndices, rootBlobs, updatedRepoData2, afterCleanupsListener);
                StepListener<Collection<ShardSnapshotMetaDeleteResult>> writeMetaAndComputeDeletesStep = new StepListener<Collection<ShardSnapshotMetaDeleteResult>>();
                this.writeUpdatedShardMetaDataAndComputeDeletes(snapshotId, repositoryData, false, writeMetaAndComputeDeletesStep);
                writeMetaAndComputeDeletesStep.whenComplete(deleteResults -> this.asyncCleanupUnlinkedShardLevelBlobs(snapshotId, (Collection<ShardSnapshotMetaDeleteResult>)deleteResults, (ActionListener<Void>)afterCleanupsListener), afterCleanupsListener::onFailure);
            }, listener::onFailure));
        }
    }

    private void asyncCleanupUnlinkedRootAndIndicesBlobs(Map<String, BlobContainer> foundIndices, Map<String, BlobMetaData> rootBlobs, RepositoryData updatedRepoData, ActionListener<Void> listener) {
        this.threadPool.executor(SNAPSHOT_CODEC).execute(ActionRunnable.wrap(listener, l -> this.cleanupStaleBlobs(foundIndices, rootBlobs, updatedRepoData, ActionListener.map(l, ignored -> null))));
    }

    private void asyncCleanupUnlinkedShardLevelBlobs(SnapshotId snapshotId, Collection<ShardSnapshotMetaDeleteResult> deleteResults, ActionListener<Void> listener) {
        this.threadPool.executor(SNAPSHOT_CODEC).execute(ActionRunnable.wrap(listener, l -> {
            try {
                this.blobContainer().deleteBlobsIgnoringIfNotExists(this.resolveFilesToDelete(snapshotId, deleteResults));
                l.onResponse(null);
            }
            catch (Exception e) {
                logger.warn(() -> new ParameterizedMessage("[{}] Failed to delete some blobs during snapshot delete", (Object)snapshotId), (Throwable)e);
                throw e;
            }
        }));
    }

    private void writeUpdatedShardMetaDataAndComputeDeletes(final SnapshotId snapshotId, final RepositoryData oldRepositoryData, final boolean useUUIDs, ActionListener<Collection<ShardSnapshotMetaDeleteResult>> onAllShardsCompleted) {
        ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        List<IndexId> indices = oldRepositoryData.indicesToUpdateAfterRemovingSnapshot(snapshotId);
        if (indices.isEmpty()) {
            onAllShardsCompleted.onResponse(Collections.emptyList());
            return;
        }
        GroupedActionListener deleteIndexMetaDataListener = new GroupedActionListener(ActionListener.map(onAllShardsCompleted, res -> res.stream().flatMap(Collection::stream).collect(Collectors.toList())), indices.size());
        for (final IndexId indexId : indices) {
            final Set survivingSnapshots = oldRepositoryData.getSnapshots(indexId).stream().filter(id -> !id.equals(snapshotId)).collect(Collectors.toSet());
            executor.execute(ActionRunnable.wrap(deleteIndexMetaDataListener, deleteIdxMetaListener -> {
                IndexMetaData indexMetaData;
                try {
                    indexMetaData = this.getSnapshotIndexMetaData(snapshotId, indexId);
                }
                catch (Exception ex) {
                    logger.warn(() -> new ParameterizedMessage("[{}] [{}] failed to read metadata for index", (Object)snapshotId, (Object)indexId.getName()), (Throwable)ex);
                    deleteIdxMetaListener.onResponse(null);
                    return;
                }
                int shardCount = indexMetaData.getNumberOfShards();
                assert (shardCount > 0) : "index did not have positive shard count, get [" + shardCount + "]";
                final GroupedActionListener allShardsListener = new GroupedActionListener(deleteIdxMetaListener, shardCount);
                Index index = indexMetaData.getIndex();
                for (int shardId = 0; shardId < indexMetaData.getNumberOfShards(); ++shardId) {
                    final ShardId shard = new ShardId(index, shardId);
                    executor.execute(new AbstractRunnable(){

                        @Override
                        protected void doRun() throws Exception {
                            BlobStoreIndexShardSnapshots blobStoreIndexShardSnapshots;
                            String newGen;
                            BlobContainer shardContainer = BlobStoreRepository.this.shardContainer(indexId, shard);
                            Set blobs = BlobStoreRepository.getShardBlobs(shard, shardContainer);
                            if (useUUIDs) {
                                newGen = UUIDs.randomBase64UUID();
                                blobStoreIndexShardSnapshots = (BlobStoreIndexShardSnapshots)BlobStoreRepository.this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer, oldRepositoryData.shardGenerations().getShardGen(indexId, shard.getId())).v1();
                            } else {
                                Tuple tuple = BlobStoreRepository.this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer);
                                newGen = Long.toString((Long)tuple.v2() + 1L);
                                blobStoreIndexShardSnapshots = (BlobStoreIndexShardSnapshots)tuple.v1();
                            }
                            allShardsListener.onResponse(BlobStoreRepository.this.deleteFromShardSnapshotMeta(survivingSnapshots, indexId, shard, snapshotId, shardContainer, blobs, blobStoreIndexShardSnapshots, newGen));
                        }

                        @Override
                        public void onFailure(Exception ex) {
                            logger.warn(() -> new ParameterizedMessage("[{}] failed to delete shard data for shard [{}][{}]", new Object[]{snapshotId, indexId.getName(), shard.id()}), (Throwable)ex);
                            allShardsListener.onResponse(null);
                        }
                    });
                }
            }));
        }
    }

    private List<String> resolveFilesToDelete(SnapshotId snapshotId, Collection<ShardSnapshotMetaDeleteResult> deleteResults) {
        String basePath = this.basePath().buildAsString();
        int basePathLen = basePath.length();
        return Stream.concat(deleteResults.stream().flatMap(shardResult -> {
            String shardPath = this.shardContainer(((ShardSnapshotMetaDeleteResult)shardResult).indexId, ((ShardSnapshotMetaDeleteResult)shardResult).shardId).path().buildAsString();
            return ((ShardSnapshotMetaDeleteResult)shardResult).blobsToDelete.stream().map(blob -> shardPath + blob);
        }), deleteResults.stream().map(shardResult -> ((ShardSnapshotMetaDeleteResult)shardResult).indexId).distinct().map(indexId -> this.indexContainer((IndexId)indexId).path().buildAsString() + this.globalMetaDataFormat.blobName(snapshotId.getUUID()))).map(absolutePath -> {
            assert (absolutePath.startsWith(basePath));
            return absolutePath.substring(basePathLen);
        }).collect(Collectors.toList());
    }

    private void cleanupStaleBlobs(Map<String, BlobContainer> foundIndices, Map<String, BlobMetaData> rootBlobs, RepositoryData newRepoData, ActionListener<DeleteResult> listener) {
        GroupedActionListener groupedListener = new GroupedActionListener(ActionListener.wrap(deleteResults -> {
            DeleteResult deleteResult = DeleteResult.ZERO;
            for (DeleteResult result : deleteResults) {
                deleteResult = deleteResult.add(result);
            }
            listener.onResponse(deleteResult);
        }, listener::onFailure), 2);
        ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        executor.execute(ActionRunnable.supply(groupedListener, () -> {
            List<String> deletedBlobs = this.cleanupStaleRootFiles(this.staleRootBlobs(newRepoData, rootBlobs.keySet()));
            return new DeleteResult(deletedBlobs.size(), deletedBlobs.stream().mapToLong(name -> ((BlobMetaData)rootBlobs.get(name)).length()).sum());
        }));
        Set survivingIndexIds = newRepoData.getIndices().values().stream().map(IndexId::getId).collect(Collectors.toSet());
        executor.execute(ActionRunnable.supply(groupedListener, () -> this.cleanupStaleIndices(foundIndices, survivingIndexIds)));
    }

    public void cleanup(long repositoryStateId, Version repositoryMetaVersion, ActionListener<RepositoryCleanupResult> listener) {
        try {
            if (this.isReadOnly()) {
                throw new RepositoryException(this.metadata.name(), "cannot run cleanup on readonly repository");
            }
            Map<String, BlobMetaData> rootBlobs = this.blobContainer().listBlobs();
            RepositoryData repositoryData = this.safeRepositoryData(repositoryStateId, rootBlobs);
            Map<String, BlobContainer> foundIndices = this.blobStore().blobContainer(this.indicesPath()).children();
            Set survivingIndexIds = repositoryData.getIndices().values().stream().map(IndexId::getId).collect(Collectors.toSet());
            List<String> staleRootBlobs = this.staleRootBlobs(repositoryData, rootBlobs.keySet());
            if (survivingIndexIds.equals(foundIndices.keySet()) && staleRootBlobs.isEmpty()) {
                listener.onResponse(new RepositoryCleanupResult(DeleteResult.ZERO));
            } else {
                this.writeIndexGen(repositoryData, repositoryStateId, SnapshotsService.useShardGenerations(repositoryMetaVersion), ActionListener.wrap(v -> this.cleanupStaleBlobs(foundIndices, rootBlobs, repositoryData, ActionListener.map(listener, RepositoryCleanupResult::new)), listener::onFailure));
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private List<String> staleRootBlobs(RepositoryData repositoryData, Set<String> rootBlobNames) {
        Set allSnapshotIds = repositoryData.getSnapshotIds().stream().map(SnapshotId::getUUID).collect(Collectors.toSet());
        return rootBlobNames.stream().filter(blob -> {
            if (FsBlobContainer.isTempBlobName(blob)) {
                return true;
            }
            if (blob.endsWith(".dat")) {
                String foundUUID;
                if (blob.startsWith(SNAPSHOT_PREFIX)) {
                    foundUUID = blob.substring(SNAPSHOT_PREFIX.length(), blob.length() - ".dat".length());
                    assert (this.snapshotFormat.blobName(foundUUID).equals(blob));
                } else if (blob.startsWith(METADATA_PREFIX)) {
                    foundUUID = blob.substring(METADATA_PREFIX.length(), blob.length() - ".dat".length());
                    assert (this.globalMetaDataFormat.blobName(foundUUID).equals(blob));
                } else {
                    return false;
                }
                return !allSnapshotIds.contains(foundUUID);
            }
            if (blob.startsWith("index-")) {
                return repositoryData.getGenId() > Long.parseLong(blob.substring("index-".length()));
            }
            return false;
        }).collect(Collectors.toList());
    }

    private List<String> cleanupStaleRootFiles(List<String> blobsToDelete) {
        if (blobsToDelete.isEmpty()) {
            return blobsToDelete;
        }
        try {
            logger.info("[{}] Found stale root level blobs {}. Cleaning them up", (Object)this.metadata.name(), blobsToDelete);
            this.blobContainer().deleteBlobsIgnoringIfNotExists(blobsToDelete);
            return blobsToDelete;
        }
        catch (IOException e) {
            logger.warn(() -> new ParameterizedMessage("[{}] The following blobs are no longer part of any snapshot [{}] but failed to remove them", (Object)this.metadata.name(), (Object)blobsToDelete), (Throwable)e);
        }
        catch (Exception e) {
            assert (false) : e;
            logger.warn((Message)new ParameterizedMessage("[{}] Exception during cleanup of root level blobs", (Object)this.metadata.name()), (Throwable)e);
        }
        return Collections.emptyList();
    }

    private DeleteResult cleanupStaleIndices(Map<String, BlobContainer> foundIndices, Set<String> survivingIndexIds) {
        DeleteResult deleteResult = DeleteResult.ZERO;
        try {
            for (Map.Entry<String, BlobContainer> indexEntry : foundIndices.entrySet()) {
                String indexSnId = indexEntry.getKey();
                try {
                    if (survivingIndexIds.contains(indexSnId)) continue;
                    logger.debug("[{}] Found stale index [{}]. Cleaning it up", (Object)this.metadata.name(), (Object)indexSnId);
                    deleteResult = deleteResult.add(indexEntry.getValue().delete());
                    logger.debug("[{}] Cleaned up stale index [{}]", (Object)this.metadata.name(), (Object)indexSnId);
                }
                catch (IOException e) {
                    logger.warn(() -> new ParameterizedMessage("[{}] index {} is no longer part of any snapshots in the repository, but failed to clean up their index folders", (Object)this.metadata.name(), (Object)indexSnId), (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            assert (false) : e;
            logger.warn((Message)new ParameterizedMessage("[{}] Exception during cleanup of stale indices", (Object)this.metadata.name()), (Throwable)e);
        }
        return deleteResult;
    }

    @Override
    public void finalizeSnapshot(SnapshotId snapshotId, ShardGenerations shardGenerations, long startTime, String failure, int totalShards, List<SnapshotShardFailure> shardFailures, long repositoryStateId, boolean includeGlobalState, MetaData clusterMetaData, Map<String, Object> userMetadata, Version repositoryMetaVersion, ActionListener<SnapshotInfo> listener) {
        Collection<IndexId> indices = shardGenerations.indices();
        boolean writeShardGens = SnapshotsService.useShardGenerations(repositoryMetaVersion);
        Consumer<Exception> onUpdateFailure = e -> listener.onFailure(new SnapshotException(this.metadata.name(), snapshotId, "failed to update snapshot in repository", (Throwable)e));
        GroupedActionListener allMetaListener = new GroupedActionListener(ActionListener.wrap(snapshotInfos -> {
            assert (snapshotInfos.size() == 1) : "Should have only received a single SnapshotInfo but received " + snapshotInfos;
            SnapshotInfo snapshotInfo = (SnapshotInfo)snapshotInfos.iterator().next();
            this.getRepositoryData(ActionListener.wrap(existingRepositoryData -> {
                RepositoryData updatedRepositoryData = existingRepositoryData.addSnapshot(snapshotId, snapshotInfo.state(), Version.CURRENT, shardGenerations);
                this.writeIndexGen(updatedRepositoryData, repositoryStateId, writeShardGens, ActionListener.wrap(v -> {
                    if (writeShardGens) {
                        this.cleanupOldShardGens((RepositoryData)existingRepositoryData, updatedRepositoryData);
                    }
                    listener.onResponse(snapshotInfo);
                }, onUpdateFailure));
            }, onUpdateFailure));
        }, onUpdateFailure), 2 + indices.size());
        ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        executor.execute(ActionRunnable.run(allMetaListener, (CheckedRunnable<Exception>)((CheckedRunnable)() -> this.globalMetaDataFormat.write(clusterMetaData, this.blobContainer(), snapshotId.getUUID(), false))));
        for (IndexId index : indices) {
            executor.execute(ActionRunnable.run(allMetaListener, (CheckedRunnable<Exception>)((CheckedRunnable)() -> this.indexMetaDataFormat.write(clusterMetaData.index(index.getName()), this.indexContainer(index), snapshotId.getUUID(), false))));
        }
        executor.execute(ActionRunnable.supply(allMetaListener, () -> {
            SnapshotInfo snapshotInfo = new SnapshotInfo(snapshotId, indices.stream().map(IndexId::getName).collect(Collectors.toList()), startTime, failure, this.threadPool.absoluteTimeInMillis(), totalShards, shardFailures, includeGlobalState, userMetadata);
            this.snapshotFormat.write(snapshotInfo, this.blobContainer(), snapshotId.getUUID(), false);
            return snapshotInfo;
        }));
    }

    private void cleanupOldShardGens(RepositoryData existingRepositoryData, RepositoryData updatedRepositoryData) {
        ArrayList<String> toDelete = new ArrayList<String>();
        int prefixPathLen = this.basePath().buildAsString().length();
        updatedRepositoryData.shardGenerations().obsoleteShardGenerations(existingRepositoryData.shardGenerations()).forEach((indexId, gens) -> gens.forEach((shardId, oldGen) -> toDelete.add(this.shardContainer((IndexId)indexId, (int)shardId).path().buildAsString().substring(prefixPathLen) + "index-" + oldGen)));
        try {
            this.blobContainer().deleteBlobsIgnoringIfNotExists(toDelete);
        }
        catch (Exception e) {
            logger.warn("Failed to clean up old shard generation blobs", (Throwable)e);
        }
    }

    @Override
    public SnapshotInfo getSnapshotInfo(SnapshotId snapshotId) {
        try {
            return this.snapshotFormat.read(this.blobContainer(), snapshotId.getUUID());
        }
        catch (NoSuchFileException ex) {
            throw new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)ex);
        }
        catch (IOException | NotXContentException ex) {
            throw new SnapshotException(this.metadata.name(), snapshotId, "failed to get snapshots", (Throwable)ex);
        }
    }

    @Override
    public MetaData getSnapshotGlobalMetaData(SnapshotId snapshotId) {
        try {
            return this.globalMetaDataFormat.read(this.blobContainer(), snapshotId.getUUID());
        }
        catch (NoSuchFileException ex) {
            throw new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new SnapshotException(this.metadata.name(), snapshotId, "failed to read global metadata", (Throwable)ex);
        }
    }

    @Override
    public IndexMetaData getSnapshotIndexMetaData(SnapshotId snapshotId, IndexId index) throws IOException {
        try {
            return this.indexMetaDataFormat.read(this.indexContainer(index), snapshotId.getUUID());
        }
        catch (NoSuchFileException e) {
            throw new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)e);
        }
    }

    private BlobPath indicesPath() {
        return this.basePath().add("indices");
    }

    private BlobContainer indexContainer(IndexId indexId) {
        return this.blobStore().blobContainer(this.indicesPath().add(indexId.getId()));
    }

    private BlobContainer shardContainer(IndexId indexId, ShardId shardId) {
        return this.shardContainer(indexId, shardId.getId());
    }

    private BlobContainer shardContainer(IndexId indexId, int shardId) {
        return this.blobStore().blobContainer(this.indicesPath().add(indexId.getId()).add(Integer.toString(shardId)));
    }

    private RateLimiter getRateLimiter(Settings repositorySettings, String setting, ByteSizeValue defaultRate) {
        ByteSizeValue maxSnapshotBytesPerSec = repositorySettings.getAsBytesSize(setting, defaultRate);
        if (maxSnapshotBytesPerSec.getBytes() <= 0L) {
            return null;
        }
        return new RateLimiter.SimpleRateLimiter(maxSnapshotBytesPerSec.getMbFrac());
    }

    @Override
    public long getSnapshotThrottleTimeInNanos() {
        return this.snapshotRateLimitingTimeInNanos.count();
    }

    @Override
    public long getRestoreThrottleTimeInNanos() {
        return this.restoreRateLimitingTimeInNanos.count();
    }

    protected void assertSnapshotOrGenericThread() {
        assert (Thread.currentThread().getName().contains(SNAPSHOT_CODEC) || Thread.currentThread().getName().contains("generic")) : "Expected current thread [" + Thread.currentThread() + "] to be the snapshot or generic thread.";
    }

    @Override
    public String startVerification() {
        try {
            if (this.isReadOnly()) {
                this.latestIndexBlobId();
                return "read-only";
            }
            String seed = UUIDs.randomBase64UUID();
            byte[] testBytes = Strings.toUTF8Bytes(seed);
            BlobContainer testContainer = this.blobStore().blobContainer(this.basePath().add(BlobStoreRepository.testBlobPrefix(seed)));
            BytesArray bytes = new BytesArray(testBytes);
            try (StreamInput stream = bytes.streamInput();){
                testContainer.writeBlobAtomic("master.dat", stream, bytes.length(), true);
            }
            return seed;
        }
        catch (IOException exp) {
            throw new RepositoryVerificationException(this.metadata.name(), "path " + this.basePath() + " is not accessible on master node", exp);
        }
    }

    @Override
    public void endVerification(String seed) {
        if (!this.isReadOnly()) {
            try {
                String testPrefix = BlobStoreRepository.testBlobPrefix(seed);
                this.blobStore().blobContainer(this.basePath().add(testPrefix)).delete();
            }
            catch (IOException exp) {
                throw new RepositoryVerificationException(this.metadata.name(), "cannot delete test data at " + this.basePath(), exp);
            }
        }
    }

    @Override
    public void getRepositoryData(ActionListener<RepositoryData> listener) {
        if (this.latestKnownRepoGen.get() == -3L) {
            listener.onFailure(this.corruptedStateException(null));
            return;
        }
        long lastFailedGeneration = -2L;
        while (true) {
            long genToLoad;
            if (this.bestEffortConsistency) {
                long generation;
                try {
                    generation = this.latestIndexBlobId();
                }
                catch (IOException ioe) {
                    listener.onFailure(new RepositoryException(this.metadata.name(), "Could not determine repository generation from root blobs", ioe));
                    return;
                }
                genToLoad = this.latestKnownRepoGen.updateAndGet(known -> Math.max(known, generation));
                if (genToLoad > generation) {
                    logger.info("Determined repository generation [" + generation + "] from repository contents but correct generation must be at least [" + genToLoad + "]");
                }
            } else {
                genToLoad = this.latestKnownRepoGen.get();
            }
            try {
                RepositoryData loaded;
                Tuple<Long, BytesReference> cached = this.latestKnownRepositoryData.get();
                if (!this.bestEffortConsistency && cached != null && (Long)cached.v1() == genToLoad) {
                    loaded = this.repositoryDataFromCachedEntry(cached);
                } else {
                    loaded = this.getRepositoryData(genToLoad);
                    this.cacheRepositoryData(loaded);
                }
                listener.onResponse(loaded);
                return;
            }
            catch (RepositoryException e) {
                if (genToLoad != this.latestKnownRepoGen.get() && genToLoad != lastFailedGeneration) {
                    lastFailedGeneration = genToLoad;
                    logger.warn("Failed to load repository data generation [" + genToLoad + "] because a concurrent operation moved the current generation to [" + this.latestKnownRepoGen.get() + "]", (Throwable)e);
                    continue;
                }
                if (!this.bestEffortConsistency && ExceptionsHelper.unwrap(e, NoSuchFileException.class) != null) {
                    this.markRepoCorrupted(genToLoad, e, ActionListener.wrap(v -> listener.onFailure(this.corruptedStateException(e)), listener::onFailure));
                } else {
                    listener.onFailure(e);
                }
                return;
            }
            catch (Exception e) {
                listener.onFailure(new RepositoryException(this.metadata.name(), "Unexpected exception when loading repository data", e));
                return;
            }
            break;
        }
    }

    private void cacheRepositoryData(RepositoryData updated) {
        if (this.cacheRepositoryData && !this.bestEffortConsistency) {
            BytesReference serialized;
            BytesStreamOutput out = new BytesStreamOutput();
            try {
                try (StreamOutput tmp = CompressorFactory.COMPRESSOR.streamOutput(out);
                     XContentBuilder builder = XContentFactory.jsonBuilder((OutputStream)tmp);){
                    updated.snapshotsToXContent(builder, true);
                }
                serialized = out.bytes();
                int len = serialized.length();
                if ((long)len > ByteSizeUnit.KB.toBytes(500L)) {
                    logger.debug("Not caching repository data of size [{}] for repository [{}] because it is larger than 500KB in serialized size", (Object)len, (Object)this.metadata.name());
                    if ((long)len > ByteSizeUnit.MB.toBytes(5L)) {
                        logger.warn("Your repository metadata blob for repository [{}] is larger than 5MB. Consider moving to a fresh repository for new snapshots or deleting unneeded snapshots from your repository to ensure stable repository behavior going forward.", (Object)this.metadata.name());
                    }
                    this.latestKnownRepositoryData.set(null);
                    return;
                }
            }
            catch (IOException e) {
                assert (false) : new AssertionError("Impossible, no IO happens here", e);
                logger.warn("Failed to serialize repository data", (Throwable)e);
                return;
            }
            this.latestKnownRepositoryData.updateAndGet(known -> {
                if (known != null && (Long)known.v1() > updated.getGenId()) {
                    return known;
                }
                return new Tuple((Object)updated.getGenId(), (Object)serialized);
            });
        }
    }

    private RepositoryData repositoryDataFromCachedEntry(Tuple<Long, BytesReference> cacheEntry) throws IOException {
        return RepositoryData.snapshotsFromXContent(XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)CompressorFactory.COMPRESSOR.streamInput(((BytesReference)cacheEntry.v2()).streamInput())), (Long)cacheEntry.v1());
    }

    private RepositoryException corruptedStateException(@Nullable Exception cause) {
        return new RepositoryException(this.metadata.name(), "Could not read repository data because the contents of the repository do not match its expected state. This is likely the result of either concurrently modifying the contents of the repository by a process other than this cluster or an issue with the repository's underlyingstorage. The repository has been disabled to prevent corrupting its contents. To re-enable it and continue using it please remove the repository from the cluster and add it again to make the cluster recover the known state of the repository from its physical contents.", cause);
    }

    private void markRepoCorrupted(final long corruptedGeneration, final Exception originalException, final ActionListener<Void> listener) {
        assert (corruptedGeneration != -2L);
        assert (!this.bestEffortConsistency);
        this.clusterService.submitStateUpdateTask("mark repository corrupted [" + this.metadata.name() + "][" + corruptedGeneration + "]", new ClusterStateUpdateTask(){

            @Override
            public ClusterState execute(ClusterState currentState) {
                RepositoriesMetaData state = (RepositoriesMetaData)currentState.metaData().custom("repositories");
                RepositoryMetaData repoState = state.repository(BlobStoreRepository.this.metadata.name());
                if (repoState.generation() != corruptedGeneration) {
                    throw new IllegalStateException("Tried to mark repo generation [" + corruptedGeneration + "] as corrupted but its state concurrently changed to [" + repoState + "]");
                }
                return ClusterState.builder(currentState).metaData(MetaData.builder(currentState.metaData()).putCustom("repositories", state.withUpdatedGeneration(BlobStoreRepository.this.metadata.name(), -3L, repoState.pendingGeneration())).build()).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(new RepositoryException(BlobStoreRepository.this.metadata.name(), "Failed marking repository state as corrupted", ExceptionsHelper.useOrSuppress(e, originalException)));
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(null);
            }
        });
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private RepositoryData getRepositoryData(long indexGen) {
        if (indexGen == -1L) {
            return RepositoryData.EMPTY;
        }
        try {
            String snapshotsIndexBlobName = "index-" + Long.toString(indexGen);
            try (InputStream blob = this.blobContainer().readBlob(snapshotsIndexBlobName);){
                RepositoryData repositoryData;
                block16: {
                    XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, blob);
                    try {
                        repositoryData = RepositoryData.snapshotsFromXContent(parser, indexGen);
                        if (parser == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    parser.close();
                }
                return repositoryData;
            }
        }
        catch (IOException ioe) {
            if (this.bestEffortConsistency && this.latestKnownRepoGen.compareAndSet(indexGen, -1L)) {
                logger.warn("Resetting repository generation tracker because we failed to read generation [" + indexGen + "]", (Throwable)ioe);
            }
            throw new RepositoryException(this.metadata.name(), "could not read repository data from index blob", ioe);
        }
    }

    private static String testBlobPrefix(String seed) {
        return TESTS_FILE + seed;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void writeIndexGen(RepositoryData repositoryData, final long expectedGen, boolean writeShardGens, final ActionListener<Void> listener) {
        assert (!this.isReadOnly());
        long currentGen = repositoryData.getGenId();
        if (currentGen != expectedGen) {
            listener.onFailure(new RepositoryException(this.metadata.name(), "concurrent modification of the index-N file, expected current generation [" + expectedGen + "], actual current generation [" + currentGen + "]"));
            return;
        }
        final StepListener<Long> setPendingStep = new StepListener<Long>();
        this.clusterService.submitStateUpdateTask("set pending repository generation [" + this.metadata.name() + "][" + expectedGen + "]", new ClusterStateUpdateTask(){
            private long newGen;

            @Override
            public ClusterState execute(ClusterState currentState) {
                boolean uninitializedMeta;
                RepositoryMetaData meta = BlobStoreRepository.this.getRepoMetaData(currentState);
                String repoName = BlobStoreRepository.this.metadata.name();
                long genInState = meta.generation();
                boolean bl = uninitializedMeta = meta.generation() == -2L || BlobStoreRepository.this.bestEffortConsistency;
                if (!uninitializedMeta && meta.pendingGeneration() != genInState) {
                    logger.info("Trying to write new repository data over unfinished write, repo [{}] is at safe generation [{}] and pending generation [{}]", (Object)meta.name(), (Object)genInState, (Object)meta.pendingGeneration());
                }
                assert (expectedGen == -1L || uninitializedMeta || expectedGen == meta.generation()) : "Expected non-empty generation [" + expectedGen + "] does not match generation tracked in [" + meta + "]";
                long safeGeneration = expectedGen == -1L ? -1L : (uninitializedMeta ? expectedGen : genInState);
                long nextPendingGen = BlobStoreRepository.this.metadata.pendingGeneration() + 1L;
                long l = this.newGen = uninitializedMeta ? Math.max(expectedGen + 1L, nextPendingGen) : nextPendingGen;
                assert (this.newGen > BlobStoreRepository.this.latestKnownRepoGen.get()) : "Attempted new generation [" + this.newGen + "] must be larger than latest known generation [" + BlobStoreRepository.access$300(BlobStoreRepository.this).get() + "]";
                return ClusterState.builder(currentState).metaData(MetaData.builder(currentState.getMetaData()).putCustom("repositories", ((RepositoriesMetaData)currentState.metaData().custom("repositories")).withUpdatedGeneration(repoName, safeGeneration, this.newGen)).build()).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(new RepositoryException(BlobStoreRepository.this.metadata.name(), "Failed to execute cluster state update [" + source + "]", e));
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                setPendingStep.onResponse(this.newGen);
            }
        });
        StepListener<RepositoryData> filterRepositoryDataStep = new StepListener<RepositoryData>();
        setPendingStep.whenComplete(newGen -> this.threadPool().executor(SNAPSHOT_CODEC).execute(ActionRunnable.wrap(listener, l -> {
            final List snapshotIdsWithoutVersion = repositoryData.getSnapshotIds().stream().filter(snapshotId -> repositoryData.getVersion((SnapshotId)snapshotId) == null).collect(Collectors.toList());
            if (!snapshotIdsWithoutVersion.isEmpty()) {
                ConcurrentHashMap updatedVersionMap = new ConcurrentHashMap();
                GroupedActionListener loadAllVersionsListener = new GroupedActionListener(ActionListener.runAfter(new ActionListener<Collection<Void>>(){

                    @Override
                    public void onResponse(Collection<Void> voids) {
                        logger.info("Successfully loaded all snapshot's version information for {} from snapshot metadata", (Object)AllocationService.firstListElementsToCommaDelimitedString(snapshotIdsWithoutVersion, SnapshotId::toString, logger.isDebugEnabled()));
                    }

                    @Override
                    public void onFailure(Exception e) {
                        logger.warn("Failure when trying to load missing version information from snapshot metadata", (Throwable)e);
                    }
                }, () -> filterRepositoryDataStep.onResponse(repositoryData.withVersions(updatedVersionMap))), snapshotIdsWithoutVersion.size());
                for (SnapshotId snapshotId2 : snapshotIdsWithoutVersion) {
                    this.threadPool().executor(SNAPSHOT_CODEC).execute(ActionRunnable.run(loadAllVersionsListener, (CheckedRunnable<Exception>)((CheckedRunnable)() -> updatedVersionMap.put(snapshotId2, this.getSnapshotInfo(snapshotId2).version()))));
                }
            } else {
                filterRepositoryDataStep.onResponse(repositoryData);
            }
        })), listener::onFailure);
        filterRepositoryDataStep.whenComplete(filteredRepositoryData -> {
            BytesReference genBytes;
            final long newGen = (Long)setPendingStep.result();
            if (this.latestKnownRepoGen.get() >= newGen) {
                throw new IllegalArgumentException("Tried writing generation [" + newGen + "] but repository is at least at generation [" + this.latestKnownRepoGen.get() + "] already");
            }
            String indexBlob = "index-" + Long.toString(newGen);
            logger.debug("Repository [{}] writing new index generational blob [{}]", (Object)this.metadata.name(), (Object)indexBlob);
            this.writeAtomic(indexBlob, BytesReference.bytes(filteredRepositoryData.snapshotsToXContent(XContentFactory.jsonBuilder(), writeShardGens)), true);
            try (BytesStreamOutput bStream = new BytesStreamOutput();){
                bStream.writeLong(newGen);
                genBytes = bStream.bytes();
            }
            logger.debug("Repository [{}] updating index.latest with generation [{}]", (Object)this.metadata.name(), (Object)newGen);
            this.writeAtomic(INDEX_LATEST_BLOB, genBytes, false);
            this.clusterService.submitStateUpdateTask("set safe repository generation [" + this.metadata.name() + "][" + newGen + "]", new ClusterStateUpdateTask((RepositoryData)filteredRepositoryData){
                final /* synthetic */ RepositoryData val$filteredRepositoryData;
                {
                    this.val$filteredRepositoryData = repositoryData;
                }

                @Override
                public ClusterState execute(ClusterState currentState) {
                    RepositoryMetaData meta = BlobStoreRepository.this.getRepoMetaData(currentState);
                    if (meta.generation() != expectedGen) {
                        throw new IllegalStateException("Tried to update repo generation to [" + newGen + "] but saw unexpected generation in state [" + meta + "]");
                    }
                    if (meta.pendingGeneration() != newGen) {
                        throw new IllegalStateException("Tried to update from unexpected pending repo generation [" + meta.pendingGeneration() + "] after write to generation [" + newGen + "]");
                    }
                    return ClusterState.builder(currentState).metaData(MetaData.builder(currentState.getMetaData()).putCustom("repositories", ((RepositoriesMetaData)currentState.metaData().custom("repositories")).withUpdatedGeneration(BlobStoreRepository.this.metadata.name(), newGen, newGen)).build()).build();
                }

                @Override
                public void onFailure(String source, Exception e) {
                    listener.onFailure(new RepositoryException(BlobStoreRepository.this.metadata.name(), "Failed to execute cluster state update [" + source + "]", e));
                }

                @Override
                public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                    BlobStoreRepository.this.cacheRepositoryData(this.val$filteredRepositoryData.withGenId(newGen));
                    BlobStoreRepository.this.threadPool.executor(BlobStoreRepository.SNAPSHOT_CODEC).execute(ActionRunnable.run(listener, (CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                        List<String> oldIndexN = LongStream.range(Math.max(Math.max(expectedGen - 1L, 0L), newGen - 1000L), newGen).mapToObj(gen -> "index-" + gen).collect(Collectors.toList());
                        try {
                            BlobStoreRepository.this.blobContainer().deleteBlobsIgnoringIfNotExists(oldIndexN);
                        }
                        catch (IOException e) {
                            logger.warn(() -> new ParameterizedMessage("Failed to clean up old index blobs {}", (Object)oldIndexN), (Throwable)e);
                        }
                    })));
                }
            });
        }, listener::onFailure);
    }

    private RepositoryMetaData getRepoMetaData(ClusterState state) {
        RepositoryMetaData metaData = ((RepositoriesMetaData)state.getMetaData().custom("repositories")).repository(this.metadata.name());
        assert (metaData != null);
        return metaData;
    }

    long latestIndexBlobId() throws IOException {
        try {
            return this.listBlobsToGetLatestIndexId();
        }
        catch (UnsupportedOperationException e) {
            try {
                return this.readSnapshotIndexLatestBlob();
            }
            catch (NoSuchFileException nsfe) {
                return -1L;
            }
        }
    }

    long readSnapshotIndexLatestBlob() throws IOException {
        return Numbers.bytesToLong(Streams.readFully(this.blobContainer().readBlob(INDEX_LATEST_BLOB)).toBytesRef());
    }

    private long listBlobsToGetLatestIndexId() throws IOException {
        return this.latestGeneration(this.blobContainer().listBlobsByPrefix("index-").keySet());
    }

    private long latestGeneration(Collection<String> rootBlobs) {
        long latest = -1L;
        for (String blobName : rootBlobs) {
            if (!blobName.startsWith("index-")) continue;
            try {
                long curr = Long.parseLong(blobName.substring("index-".length()));
                latest = Math.max(latest, curr);
            }
            catch (NumberFormatException nfe) {
                logger.warn("[{}] Unknown blob in the repository: {}", (Object)this.metadata.name(), (Object)blobName);
            }
        }
        return latest;
    }

    private void writeAtomic(String blobName, BytesReference bytesRef, boolean failIfAlreadyExists) throws IOException {
        try (StreamInput stream = bytesRef.streamInput();){
            this.blobContainer().writeBlobAtomic(blobName, stream, bytesRef.length(), failIfAlreadyExists);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void snapshotShard(Store store, MapperService mapperService, SnapshotId snapshotId, IndexId indexId, IndexCommit snapshotIndexCommit, String shardStateIdentifier, IndexShardSnapshotStatus snapshotStatus, Version repositoryMetaVersion, Map<String, Object> userMetadata, ActionListener<String> listener) {
        ShardId shardId = store.shardId();
        long startTime = this.threadPool.absoluteTimeInMillis();
        try {
            ArrayList<BlobStoreIndexShardSnapshot.FileInfo> indexCommitPointFiles;
            Set<String> blobs;
            String generation = snapshotStatus.generation();
            logger.debug("[{}] [{}] snapshot to [{}] [{}] ...", (Object)shardId, (Object)snapshotId, (Object)this.metadata.name(), (Object)generation);
            BlobContainer shardContainer = this.shardContainer(indexId, shardId);
            if (generation == null) {
                try {
                    blobs = shardContainer.listBlobsByPrefix("index-").keySet();
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(shardId, "failed to list blobs", e);
                }
            } else {
                blobs = Collections.singleton("index-" + generation);
            }
            Tuple<BlobStoreIndexShardSnapshots, String> tuple = this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer, generation);
            BlobStoreIndexShardSnapshots snapshots = (BlobStoreIndexShardSnapshots)tuple.v1();
            String fileListGeneration = (String)tuple.v2();
            if (snapshots.snapshots().stream().anyMatch(sf -> sf.snapshot().equals(snapshotId.getName()))) {
                throw new IndexShardSnapshotFailedException(shardId, "Duplicate snapshot name [" + snapshotId.getName() + "] detected, aborting");
            }
            ArrayList<BlobStoreIndexShardSnapshot.FileInfo> filesFromSegmentInfos = Optional.ofNullable(shardStateIdentifier).map(id -> {
                for (SnapshotFiles snapshotFileSet : snapshots.snapshots()) {
                    if (!id.equals(snapshotFileSet.shardStateIdentifier())) continue;
                    return snapshotFileSet.indexFiles();
                }
                return null;
            }).orElse(null);
            int indexIncrementalFileCount = 0;
            int indexTotalNumberOfFiles = 0;
            long indexIncrementalSize = 0L;
            long indexTotalFileSize = 0L;
            LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> filesToSnapshot = new LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo>();
            if (filesFromSegmentInfos == null) {
                Collection fileNames;
                Store.MetadataSnapshot metadataFromStore;
                indexCommitPointFiles = new ArrayList<BlobStoreIndexShardSnapshot.FileInfo>();
                store.incRef();
                try {
                    try {
                        logger.trace("[{}] [{}] Loading store metadata using index commit [{}]", (Object)shardId, (Object)snapshotId, (Object)snapshotIndexCommit);
                        metadataFromStore = store.getMetadata(snapshotIndexCommit);
                        fileNames = snapshotIndexCommit.getFileNames();
                    }
                    catch (IOException e) {
                        throw new IndexShardSnapshotFailedException(shardId, "Failed to get store file metadata", e);
                    }
                }
                finally {
                    store.decRef();
                }
                for (String fileName : fileNames) {
                    if (snapshotStatus.isAborted()) {
                        logger.debug("[{}] [{}] Aborted on the file [{}], exiting", (Object)shardId, (Object)snapshotId, (Object)fileName);
                        throw new IndexShardSnapshotFailedException(shardId, "Aborted");
                    }
                    logger.trace("[{}] [{}] Processing [{}]", (Object)shardId, (Object)snapshotId, (Object)fileName);
                    StoreFileMetaData md = metadataFromStore.get(fileName);
                    BlobStoreIndexShardSnapshot.FileInfo existingFileInfo = null;
                    List<BlobStoreIndexShardSnapshot.FileInfo> filesInfo = snapshots.findPhysicalIndexFiles(fileName);
                    if (filesInfo != null) {
                        for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : filesInfo) {
                            if (!fileInfo.isSame(md)) continue;
                            existingFileInfo = fileInfo;
                            break;
                        }
                    }
                    boolean needsWrite = !md.hashEqualsContents();
                    indexTotalFileSize += md.length();
                    ++indexTotalNumberOfFiles;
                    if (existingFileInfo == null) {
                        ++indexIncrementalFileCount;
                        indexIncrementalSize += md.length();
                        BlobStoreIndexShardSnapshot.FileInfo snapshotFileInfo = new BlobStoreIndexShardSnapshot.FileInfo((needsWrite ? UPLOADED_DATA_BLOB_PREFIX : VIRTUAL_DATA_BLOB_PREFIX) + UUIDs.randomBase64UUID(), md, this.chunkSize());
                        indexCommitPointFiles.add(snapshotFileInfo);
                        if (needsWrite) {
                            filesToSnapshot.add(snapshotFileInfo);
                        }
                        assert (needsWrite || BlobStoreRepository.assertFileContentsMatchHash(snapshotFileInfo, store));
                        continue;
                    }
                    indexCommitPointFiles.add(existingFileInfo);
                }
            } else {
                indexCommitPointFiles = filesFromSegmentInfos;
            }
            snapshotStatus.moveToStarted(startTime, indexIncrementalFileCount, indexTotalNumberOfFiles, indexIncrementalSize, indexTotalFileSize);
            StepListener<Collection<Void>> allFilesUploadedListener = new StepListener<Collection<Void>>();
            allFilesUploadedListener.whenComplete(v -> {
                List<String> blobsToDelete;
                String indexGeneration;
                IndexShardSnapshotStatus.Copy lastSnapshotStatus = snapshotStatus.moveToFinalize(snapshotIndexCommit.getGeneration());
                BlobStoreIndexShardSnapshot snapshot = new BlobStoreIndexShardSnapshot(snapshotId.getName(), lastSnapshotStatus.getIndexVersion(), indexCommitPointFiles, lastSnapshotStatus.getStartTime(), this.threadPool.absoluteTimeInMillis() - lastSnapshotStatus.getStartTime(), lastSnapshotStatus.getIncrementalFileCount(), lastSnapshotStatus.getIncrementalSize());
                logger.trace("[{}] [{}] writing shard snapshot file", (Object)shardId, (Object)snapshotId);
                try {
                    this.indexShardSnapshotFormat.write(snapshot, shardContainer, snapshotId.getUUID(), false);
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(shardId, "Failed to write commit point", e);
                }
                ArrayList<SnapshotFiles> newSnapshotsList = new ArrayList<SnapshotFiles>();
                newSnapshotsList.add(new SnapshotFiles(snapshot.snapshot(), snapshot.indexFiles(), shardStateIdentifier));
                for (SnapshotFiles point : snapshots) {
                    newSnapshotsList.add(point);
                }
                boolean writeShardGens = SnapshotsService.useShardGenerations(repositoryMetaVersion);
                if (writeShardGens) {
                    indexGeneration = UUIDs.randomBase64UUID();
                    blobsToDelete = Collections.emptyList();
                } else {
                    indexGeneration = Long.toString(Long.parseLong(fileListGeneration) + 1L);
                    blobsToDelete = blobs.stream().filter(blob -> blob.startsWith("index-")).collect(Collectors.toList());
                    assert (blobsToDelete.stream().mapToLong(b -> Long.parseLong(b.replaceFirst("index-", ""))).max().orElse(-1L) < Long.parseLong(indexGeneration)) : "Tried to delete an index-N blob newer than the current generation [" + indexGeneration + "] when deleting index-N blobs " + blobsToDelete;
                }
                try {
                    this.writeShardIndexBlob(shardContainer, indexGeneration, new BlobStoreIndexShardSnapshots(newSnapshotsList));
                }
                catch (IOException e) {
                    throw new IndexShardSnapshotFailedException(shardId, "Failed to finalize snapshot creation [" + snapshotId + "] with shard index [" + this.indexShardSnapshotsFormat.blobName(indexGeneration) + "]", e);
                }
                if (!writeShardGens) {
                    try {
                        shardContainer.deleteBlobsIgnoringIfNotExists(blobsToDelete);
                    }
                    catch (IOException e) {
                        logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to delete old index-N blobs during finalization", (Object)snapshotId, (Object)shardId), (Throwable)e);
                    }
                }
                snapshotStatus.moveToDone(this.threadPool.absoluteTimeInMillis(), indexGeneration);
                listener.onResponse(indexGeneration);
            }, listener::onFailure);
            if (indexIncrementalFileCount == 0) {
                allFilesUploadedListener.onResponse(Collections.emptyList());
                return;
            }
            ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
            int workers = Math.min(this.threadPool.info(SNAPSHOT_CODEC).getMax(), indexIncrementalFileCount);
            ActionListener<Void> filesListener = BlobStoreRepository.fileQueueListener(filesToSnapshot, workers, allFilesUploadedListener);
            for (int i = 0; i < workers; ++i) {
                executor.execute(ActionRunnable.run(filesListener, (CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                    BlobStoreIndexShardSnapshot.FileInfo snapshotFileInfo = (BlobStoreIndexShardSnapshot.FileInfo)filesToSnapshot.poll(0L, TimeUnit.MILLISECONDS);
                    if (snapshotFileInfo != null) {
                        store.incRef();
                        try {
                            do {
                                this.snapshotFile(snapshotFileInfo, indexId, shardId, snapshotId, snapshotStatus, store);
                            } while ((snapshotFileInfo = (BlobStoreIndexShardSnapshot.FileInfo)filesToSnapshot.poll(0L, TimeUnit.MILLISECONDS)) != null);
                        }
                        finally {
                            store.decRef();
                        }
                    }
                })));
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private static boolean assertFileContentsMatchHash(BlobStoreIndexShardSnapshot.FileInfo fileInfo, Store store) {
        try (IndexInput indexInput = store.openVerifyingInput(fileInfo.physicalName(), IOContext.READONCE, fileInfo.metadata());){
            byte[] tmp = new byte[Math.toIntExact(fileInfo.metadata().length())];
            indexInput.readBytes(tmp, 0, tmp.length);
            assert (fileInfo.metadata().hash().bytesEquals(new BytesRef(tmp)));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return true;
    }

    @Override
    public void restoreShard(Store store, SnapshotId snapshotId, IndexId indexId, ShardId snapshotShardId, RecoveryState recoveryState, ActionListener<Void> listener) {
        ShardId shardId = store.shardId();
        ActionListener<Void> restoreListener = ActionListener.delegateResponse(listener, (l, e) -> l.onFailure(new IndexShardRestoreFailedException(shardId, "failed to restore snapshot [" + snapshotId + "]", (Throwable)e)));
        final ExecutorService executor = this.threadPool.executor(SNAPSHOT_CODEC);
        final BlobContainer container = this.shardContainer(indexId, snapshotShardId);
        executor.execute(ActionRunnable.wrap(restoreListener, l -> {
            BlobStoreIndexShardSnapshot snapshot = this.loadShardSnapshot(container, snapshotId);
            final SnapshotFiles snapshotFiles = new SnapshotFiles(snapshot.snapshot(), snapshot.indexFiles(), null);
            new FileRestoreContext(this.metadata.name(), shardId, snapshotId, recoveryState){

                @Override
                protected void restoreFiles(List<BlobStoreIndexShardSnapshot.FileInfo> filesToRecover, Store store, ActionListener<Void> listener) {
                    if (filesToRecover.isEmpty()) {
                        listener.onResponse(null);
                    } else {
                        int workers = Math.min(BlobStoreRepository.this.threadPool.info(BlobStoreRepository.SNAPSHOT_CODEC).getMax(), snapshotFiles.indexFiles().size());
                        LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> files = new LinkedBlockingQueue<BlobStoreIndexShardSnapshot.FileInfo>(filesToRecover);
                        ActionListener allFilesListener = BlobStoreRepository.fileQueueListener(files, workers, ActionListener.map(listener, v -> null));
                        for (int i = 0; i < workers; ++i) {
                            executor.execute(ActionRunnable.run(allFilesListener, (CheckedRunnable<Exception>)((CheckedRunnable)() -> {
                                store.incRef();
                                try {
                                    BlobStoreIndexShardSnapshot.FileInfo fileToRecover;
                                    while ((fileToRecover = (BlobStoreIndexShardSnapshot.FileInfo)files.poll(0L, TimeUnit.MILLISECONDS)) != null) {
                                        this.restoreFile(fileToRecover, store);
                                    }
                                }
                                finally {
                                    store.decRef();
                                }
                            })));
                        }
                    }
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                private void restoreFile(final BlobStoreIndexShardSnapshot.FileInfo fileInfo, Store store) throws IOException {
                    boolean success = false;
                    try {
                        try (IndexOutput indexOutput = store.createVerifyingOutput(fileInfo.physicalName(), fileInfo.metadata(), IOContext.DEFAULT);){
                            if (fileInfo.name().startsWith(BlobStoreRepository.VIRTUAL_DATA_BLOB_PREFIX)) {
                                BytesRef hash = fileInfo.metadata().hash();
                                indexOutput.writeBytes(hash.bytes, hash.offset, hash.length);
                                this.recoveryState.getIndex().addRecoveredBytesToFile(fileInfo.physicalName(), hash.length);
                            } else {
                                try (InputStream stream = BlobStoreRepository.maybeRateLimit(new SlicedInputStream(fileInfo.numberOfParts()){

                                    @Override
                                    protected InputStream openSlice(long slice) throws IOException {
                                        return container.readBlob(fileInfo.partName(slice));
                                    }
                                }, BlobStoreRepository.this.restoreRateLimiter, BlobStoreRepository.this.restoreRateLimitingTimeInNanos);){
                                    int length;
                                    byte[] buffer = new byte[4096];
                                    while ((length = stream.read(buffer)) > 0) {
                                        indexOutput.writeBytes(buffer, 0, length);
                                        this.recoveryState.getIndex().addRecoveredBytesToFile(fileInfo.physicalName(), length);
                                    }
                                }
                            }
                            Store.verify(indexOutput);
                            indexOutput.close();
                            store.directory().sync(Collections.singleton(fileInfo.physicalName()));
                            success = true;
                        }
                        if (success) return;
                    }
                    catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                        try {
                            try {
                                store.markStoreCorrupted((IOException)ex);
                                throw ex;
                            }
                            catch (IOException e) {
                                logger.warn("store cannot be marked as corrupted", (Throwable)e);
                            }
                            throw ex;
                        }
                        catch (Throwable throwable) {
                            if (success) throw throwable;
                            store.deleteQuiet(fileInfo.physicalName());
                            throw throwable;
                        }
                    }
                    store.deleteQuiet(fileInfo.physicalName());
                    return;
                }
            }.restore(snapshotFiles, store, (ActionListener<Void>)l);
        }));
    }

    private static ActionListener<Void> fileQueueListener(BlockingQueue<BlobStoreIndexShardSnapshot.FileInfo> files, int workers, ActionListener<Collection<Void>> listener) {
        return ActionListener.delegateResponse(new GroupedActionListener(listener, workers), (l, e) -> {
            files.clear();
            l.onFailure((Exception)e);
        });
    }

    private static InputStream maybeRateLimit(InputStream stream, @Nullable RateLimiter rateLimiter, CounterMetric metric) {
        return rateLimiter == null ? stream : new RateLimitingInputStream(stream, rateLimiter, metric::inc);
    }

    @Override
    public IndexShardSnapshotStatus getShardSnapshotStatus(SnapshotId snapshotId, IndexId indexId, ShardId shardId) {
        BlobStoreIndexShardSnapshot snapshot = this.loadShardSnapshot(this.shardContainer(indexId, shardId), snapshotId);
        return IndexShardSnapshotStatus.newDone(snapshot.startTime(), snapshot.time(), snapshot.incrementalFileCount(), snapshot.totalFileCount(), snapshot.incrementalSize(), snapshot.totalSize(), null);
    }

    @Override
    public void verify(String seed, DiscoveryNode localNode) {
        this.assertSnapshotOrGenericThread();
        if (this.isReadOnly()) {
            try {
                this.latestIndexBlobId();
            }
            catch (IOException e) {
                throw new RepositoryVerificationException(this.metadata.name(), "path " + this.basePath() + " is not accessible on node " + localNode, e);
            }
        }
        BlobContainer testBlobContainer = this.blobStore().blobContainer(this.basePath().add(BlobStoreRepository.testBlobPrefix(seed)));
        try {
            BytesArray bytes = new BytesArray(seed);
            try (StreamInput stream = bytes.streamInput();){
                testBlobContainer.writeBlob("data-" + localNode.getId() + ".dat", stream, bytes.length(), true);
            }
        }
        catch (IOException exp) {
            throw new RepositoryVerificationException(this.metadata.name(), "store location [" + this.blobStore() + "] is not accessible on the node [" + localNode + "]", exp);
        }
        try (InputStream masterDat = testBlobContainer.readBlob("master.dat");){
            String seedRead = Streams.readFully(masterDat).utf8ToString();
            if (!seedRead.equals(seed)) {
                throw new RepositoryVerificationException(this.metadata.name(), "Seed read from master.dat was [" + seedRead + "] but expected seed [" + seed + "]");
            }
        }
        catch (NoSuchFileException e) {
            throw new RepositoryVerificationException(this.metadata.name(), "a file written by master to the store [" + this.blobStore() + "] cannot be accessed on the node [" + localNode + "]. This might indicate that the store [" + this.blobStore() + "] is not shared between this node and the master node or that permissions on the store don't allow reading files written by the master node", e);
        }
        catch (IOException e) {
            throw new RepositoryVerificationException(this.metadata.name(), "Failed to verify repository", e);
        }
    }

    public String toString() {
        return "BlobStoreRepository[[" + this.metadata.name() + "], [" + this.blobStore.get() + ']' + ']';
    }

    private ShardSnapshotMetaDeleteResult deleteFromShardSnapshotMeta(Set<SnapshotId> survivingSnapshots, IndexId indexId, ShardId snapshotShardId, SnapshotId snapshotId, BlobContainer shardContainer, Set<String> blobs, BlobStoreIndexShardSnapshots snapshots, String indexGeneration) {
        ArrayList<SnapshotFiles> newSnapshotsList = new ArrayList<SnapshotFiles>();
        Set survivingSnapshotNames = survivingSnapshots.stream().map(SnapshotId::getName).collect(Collectors.toSet());
        for (SnapshotFiles point : snapshots) {
            if (!survivingSnapshotNames.contains(point.snapshot())) continue;
            newSnapshotsList.add(point);
        }
        try {
            if (newSnapshotsList.isEmpty()) {
                return new ShardSnapshotMetaDeleteResult(indexId, snapshotShardId.id(), "_deleted", blobs);
            }
            BlobStoreIndexShardSnapshots updatedSnapshots = new BlobStoreIndexShardSnapshots(newSnapshotsList);
            this.writeShardIndexBlob(shardContainer, indexGeneration, updatedSnapshots);
            Set<String> survivingSnapshotUUIDs = survivingSnapshots.stream().map(SnapshotId::getUUID).collect(Collectors.toSet());
            return new ShardSnapshotMetaDeleteResult(indexId, snapshotShardId.id(), indexGeneration, BlobStoreRepository.unusedBlobs(blobs, survivingSnapshotUUIDs, updatedSnapshots));
        }
        catch (IOException e) {
            throw new IndexShardSnapshotFailedException(snapshotShardId, "Failed to finalize snapshot deletion [" + snapshotId + "] with shard index [" + this.indexShardSnapshotsFormat.blobName(indexGeneration) + "]", e);
        }
    }

    private void writeShardIndexBlob(BlobContainer shardContainer, String indexGeneration, BlobStoreIndexShardSnapshots updatedSnapshots) throws IOException {
        assert (!"_new".equals(indexGeneration));
        assert (!"_deleted".equals(indexGeneration));
        this.indexShardSnapshotsFormat.writeAtomic(updatedSnapshots, shardContainer, indexGeneration);
    }

    private static Set<String> getShardBlobs(ShardId snapshotShardId, BlobContainer shardContainer) {
        Set<String> blobs;
        try {
            blobs = shardContainer.listBlobs().keySet();
        }
        catch (IOException e) {
            throw new IndexShardSnapshotException(snapshotShardId, "Failed to list content of shard directory", e);
        }
        return blobs;
    }

    private static List<String> unusedBlobs(Set<String> blobs, Set<String> survivingSnapshotUUIDs, BlobStoreIndexShardSnapshots updatedSnapshots) {
        return blobs.stream().filter(blob -> blob.startsWith("index-") || blob.startsWith(SNAPSHOT_PREFIX) && blob.endsWith(".dat") && !survivingSnapshotUUIDs.contains(blob.substring(SNAPSHOT_PREFIX.length(), blob.length() - ".dat".length())) || blob.startsWith(UPLOADED_DATA_BLOB_PREFIX) && updatedSnapshots.findNameFile(BlobStoreIndexShardSnapshot.FileInfo.canonicalName(blob)) == null || FsBlobContainer.isTempBlobName(blob)).collect(Collectors.toList());
    }

    private BlobStoreIndexShardSnapshot loadShardSnapshot(BlobContainer shardContainer, SnapshotId snapshotId) {
        try {
            return this.indexShardSnapshotFormat.read(shardContainer, snapshotId.getUUID());
        }
        catch (NoSuchFileException ex) {
            throw new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new SnapshotException(this.metadata.name(), snapshotId, "failed to read shard snapshot file for [" + shardContainer.path() + ']', (Throwable)ex);
        }
    }

    private Tuple<BlobStoreIndexShardSnapshots, String> buildBlobStoreIndexShardSnapshots(Set<String> blobs, BlobContainer shardContainer, @Nullable String generation) throws IOException {
        if (generation != null) {
            if (generation.equals("_new")) {
                return new Tuple((Object)BlobStoreIndexShardSnapshots.EMPTY, (Object)"_new");
            }
            return new Tuple((Object)this.indexShardSnapshotsFormat.read(shardContainer, generation), (Object)generation);
        }
        Tuple<BlobStoreIndexShardSnapshots, Long> legacyIndex = this.buildBlobStoreIndexShardSnapshots(blobs, shardContainer);
        return new Tuple((Object)((BlobStoreIndexShardSnapshots)legacyIndex.v1()), (Object)String.valueOf(legacyIndex.v2()));
    }

    private Tuple<BlobStoreIndexShardSnapshots, Long> buildBlobStoreIndexShardSnapshots(Set<String> blobs, BlobContainer shardContainer) throws IOException {
        long latest = this.latestGeneration(blobs);
        if (latest >= 0L) {
            BlobStoreIndexShardSnapshots shardSnapshots = this.indexShardSnapshotsFormat.read(shardContainer, Long.toString(latest));
            return new Tuple((Object)shardSnapshots, (Object)latest);
        }
        if (blobs.stream().anyMatch(b -> b.startsWith(SNAPSHOT_PREFIX) || b.startsWith("index-") || b.startsWith(UPLOADED_DATA_BLOB_PREFIX))) {
            throw new IllegalStateException("Could not find a readable index-N file in a non-empty shard snapshot directory [" + shardContainer.path() + "]");
        }
        return new Tuple((Object)BlobStoreIndexShardSnapshots.EMPTY, (Object)latest);
    }

    private void snapshotFile(final BlobStoreIndexShardSnapshot.FileInfo fileInfo, IndexId indexId, final ShardId shardId, final SnapshotId snapshotId, final IndexShardSnapshotStatus snapshotStatus, Store store) throws IOException {
        BlobContainer shardContainer = this.shardContainer(indexId, shardId);
        String file = fileInfo.physicalName();
        try (IndexInput indexInput = store.openVerifyingInput(file, IOContext.READONCE, fileInfo.metadata());){
            int i = 0;
            while ((long)i < fileInfo.numberOfParts()) {
                long partBytes = fileInfo.partBytes(i);
                FilterInputStream inputStream = new FilterInputStream(BlobStoreRepository.maybeRateLimit(new InputStreamIndexInput(indexInput, partBytes), this.snapshotRateLimiter, this.snapshotRateLimitingTimeInNanos)){

                    @Override
                    public int read() throws IOException {
                        this.checkAborted();
                        return super.read();
                    }

                    @Override
                    public int read(byte[] b, int off, int len) throws IOException {
                        this.checkAborted();
                        return super.read(b, off, len);
                    }

                    private void checkAborted() {
                        if (snapshotStatus.isAborted()) {
                            logger.debug("[{}] [{}] Aborted on the file [{}], exiting", (Object)shardId, (Object)snapshotId, (Object)fileInfo.physicalName());
                            throw new IndexShardSnapshotFailedException(shardId, "Aborted");
                        }
                    }
                };
                shardContainer.writeBlob(fileInfo.partName(i), inputStream, partBytes, true);
                ++i;
            }
            Store.verify(indexInput);
            snapshotStatus.addProcessedFile(fileInfo.length());
        }
        catch (Exception t) {
            BlobStoreRepository.failStoreIfCorrupted(store, t);
            snapshotStatus.addProcessedFile(0L);
            throw t;
        }
    }

    private static void failStoreIfCorrupted(Store store, Exception e) {
        if (Lucene.isCorruptionException(e)) {
            try {
                store.markStoreCorrupted((IOException)e);
            }
            catch (IOException inner) {
                inner.addSuppressed(e);
                logger.warn("store cannot be marked as corrupted", (Throwable)inner);
            }
        }
    }

    private static final class ShardSnapshotMetaDeleteResult {
        private final IndexId indexId;
        private final int shardId;
        private final String newGeneration;
        private final Collection<String> blobsToDelete;

        ShardSnapshotMetaDeleteResult(IndexId indexId, int shardId, String newGeneration, Collection<String> blobsToDelete) {
            this.indexId = indexId;
            this.shardId = shardId;
            this.newGeneration = newGeneration;
            this.blobsToDelete = blobsToDelete;
        }
    }
}

