/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator;

import java.security.SecureRandom;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPUtil;

public abstract class PBEKeyEncryptionMethodGenerator
extends PGPKeyEncryptionMethodGenerator {
    private char[] passPhrase;
    private PGPDigestCalculator s2kDigestCalculator;
    private S2K s2k;
    private SecureRandom random;
    private int s2kCount;

    protected PBEKeyEncryptionMethodGenerator(char[] passPhrase, PGPDigestCalculator s2kDigestCalculator) {
        this(passPhrase, s2kDigestCalculator, 96);
    }

    protected PBEKeyEncryptionMethodGenerator(char[] passPhrase, PGPDigestCalculator s2kDigestCalculator, int s2kCount) {
        this.passPhrase = passPhrase;
        this.s2kDigestCalculator = s2kDigestCalculator;
        if (s2kCount < 0 || s2kCount > 255) {
            throw new IllegalArgumentException("s2kCount value outside of range 0 to 255.");
        }
        this.s2kCount = s2kCount;
    }

    public PBEKeyEncryptionMethodGenerator setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public byte[] getKey(int encAlgorithm) throws PGPException {
        if (this.s2k == null) {
            byte[] iv = new byte[8];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(iv);
            this.s2k = new S2K(this.s2kDigestCalculator.getAlgorithm(), iv, this.s2kCount);
        }
        return PGPUtil.makeKeyFromPassPhrase(this.s2kDigestCalculator, encAlgorithm, this.s2k, this.passPhrase);
    }

    public ContainedPacket generate(int encAlgorithm, byte[] sessionInfo) throws PGPException {
        byte[] key = this.getKey(encAlgorithm);
        if (sessionInfo == null) {
            return new SymmetricKeyEncSessionPacket(encAlgorithm, this.s2k, null);
        }
        byte[] nSessionInfo = new byte[sessionInfo.length - 2];
        System.arraycopy(sessionInfo, 0, nSessionInfo, 0, nSessionInfo.length);
        return new SymmetricKeyEncSessionPacket(encAlgorithm, this.s2k, this.encryptSessionInfo(encAlgorithm, key, nSessionInfo));
    }

    protected abstract byte[] encryptSessionInfo(int var1, byte[] var2, byte[] var3) throws PGPException;
}

