/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.ToIntFunction;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ColonyTile;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.EquipmentType;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsLocation;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Movable;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Scope;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TradeLocation;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TradeRouteStop;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.StringUtils;
import org.w3c.dom.Element;

public class Unit
extends GoodsLocation
implements Consumer,
Locatable,
Movable,
Nameable,
Ownable {
    private static final Logger logger = Logger.getLogger(Unit.class.getName());
    public static final int MANY_TURNS = 10000;
    public static final String CARGO_CHANGE = "CARGO_CHANGE";
    public static final String MOVE_CHANGE = "MOVE_CHANGE";
    public static final String ROLE_CHANGE = "ROLE_CHANGE";
    public static final Comparator<Unit> locComparator = Comparator.comparingInt(u -> Location.getRank(u));
    public static final Comparator<Unit> typeRoleComparator = Comparator.comparing(Unit::getType).thenComparing(Comparator.comparing(Unit::getRole));
    protected String name = null;
    protected Player owner;
    protected UnitType unitType;
    protected UnitState state = UnitState.ACTIVE;
    protected Role role;
    protected int roleCount;
    protected Location location;
    protected Location entryLocation;
    protected int movesLeft;
    protected GoodsType workType;
    protected GoodsType experienceType;
    protected int experience = 0;
    protected int workLeft;
    protected TileImprovement workImprovement;
    protected Unit student;
    protected Unit teacher;
    protected int turnsOfTraining = 0;
    protected String nationality = null;
    protected String ethnicity = null;
    protected IndianSettlement indianSettlement = null;
    protected int hitPoints;
    protected Location destination = null;
    protected TradeRoute tradeRoute = null;
    protected int currentStop = -1;
    protected int treasureAmount;
    protected int attrition = 0;
    protected int visibleGoodsCount;
    private static final String ATTRITION_TAG = "attrition";
    private static final String COUNT_TAG = "count";
    private static final String CURRENT_STOP_TAG = "currentStop";
    private static final String DESTINATION_TAG = "destination";
    private static final String ENTRY_LOCATION_TAG = "entryLocation";
    private static final String ETHNICITY_TAG = "ethnicity";
    private static final String EXPERIENCE_TAG = "experience";
    private static final String EXPERIENCE_TYPE_TAG = "experienceType";
    private static final String HIT_POINTS_TAG = "hitPoints";
    private static final String INDIAN_SETTLEMENT_TAG = "indianSettlement";
    private static final String LOCATION_TAG = "location";
    private static final String MOVES_LEFT_TAG = "movesLeft";
    private static final String NAME_TAG = "name";
    private static final String NATIONALITY_TAG = "nationality";
    private static final String OWNER_TAG = "owner";
    private static final String ROLE_TAG = "role";
    private static final String ROLE_COUNT_TAG = "roleCount";
    private static final String STATE_TAG = "state";
    private static final String STUDENT_TAG = "student";
    private static final String TRADE_ROUTE_TAG = "tradeRoute";
    private static final String TEACHER_TAG = "teacher";
    private static final String TREASURE_AMOUNT_TAG = "treasureAmount";
    private static final String TURNS_OF_TRAINING_TAG = "turnsOfTraining";
    private static final String UNIT_TYPE_TAG = "unitType";
    private static final String VISIBLE_GOODS_COUNT_TAG = "visibleGoodsCount";
    private static final String WORK_LEFT_TAG = "workLeft";
    private static final String WORK_TYPE_TAG = "workType";
    private static final String OLD_UNITS_TAG = "units";
    private static final String OLD_HIT_POINTS_TAG = "hitpoints";
    private static final String EQUIPMENT_TAG = "equipment";
    private final TypeCountMap<EquipmentType> equipment = new TypeCountMap();
    private static final String OLD_TILE_IMPROVEMENT_TAG = "tileimprovement";

    protected Unit(Game game) {
        super(game);
    }

    public Unit(Game game, Element e) {
        super(game, e);
        this.readFromXMLElement(e);
    }

    public Unit(Game game, String id) {
        super(game, id);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    public StringTemplate getApparentOwnerName() {
        Player own = this.hasAbility("model.ability.piracy") ? this.getGame().getUnknownEnemy() : this.owner;
        return own.getNationLabel();
    }

    public StringTemplate getLabel() {
        return this.getLabel(UnitLabelType.PLAIN);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StringTemplate getLabel(UnitLabelType ult) {
        UnitType type = this.getType();
        Role role = this.getRole();
        Player owner = this.getOwner();
        if (type == null || role == null || owner == null) {
            return null;
        }
        switch (ult) {
            case PLAIN: {
                return Messages.getUnitLabel(this.getName(), type.getId(), 1, null, role.getId(), null);
            }
            case NATIONAL: {
                if (role.getMaximumCount() <= 1) {
                    return Messages.getUnitLabel(this.getName(), type.getId(), 1, owner.getNationId(), role.getId(), null);
                }
            }
            case FULL: {
                StringTemplate extra = null;
                if (role.isDefaultRole()) {
                    if (this.canCarryTreasure()) {
                        extra = StringTemplate.template("goldAmount").addAmount("%amount%", this.getTreasureAmount());
                        return Messages.getUnitLabel(this.getName(), type.getId(), 1, owner.getNationId(), role.getId(), extra);
                    }
                    boolean noEquipment = false;
                    List<Role> expertRoles = type.getExpertRoles();
                    for (Role someRole : expertRoles) {
                        String key = someRole.getId() + ".noequipment";
                        if (!Messages.containsKey(key)) continue;
                        extra = StringTemplate.key(key);
                        return Messages.getUnitLabel(this.getName(), type.getId(), 1, owner.getNationId(), role.getId(), extra);
                    }
                    return Messages.getUnitLabel(this.getName(), type.getId(), 1, owner.getNationId(), role.getId(), extra);
                }
                String equipmentKey = role.getId() + ".equipment";
                if (Messages.containsKey(equipmentKey)) {
                    extra = AbstractGoods.getLabel(equipmentKey, 1);
                    return Messages.getUnitLabel(this.getName(), type.getId(), 1, owner.getNationId(), role.getId(), extra);
                } else {
                    List<AbstractGoods> requiredGoods = role.getRequiredGoods(this.getRoleCount());
                    boolean first = true;
                    extra = StringTemplate.label("");
                    for (AbstractGoods ag : requiredGoods) {
                        if (first) {
                            first = false;
                        } else {
                            extra.addName(" ");
                        }
                        extra.addStringTemplate(ag.getLabel());
                    }
                }
                return Messages.getUnitLabel(this.getName(), type.getId(), 1, owner.getNationId(), role.getId(), extra);
            }
        }
        return null;
    }

    public String getDescription() {
        return Messages.message(this.getLabel());
    }

    public String getDescription(UnitLabelType ult) {
        return Messages.message(this.getLabel(ult));
    }

    public StringTemplate getCombatLabel(Tile tile) {
        CombatModel.CombatOdds combatOdds = this.getGame().getCombatModel().calculateCombatOdds(this, tile.getDefendingUnit(this));
        boolean unknown = combatOdds.win == -1.0 || tile.hasSettlement();
        return StringTemplate.template("model.unit.attackTileOdds").addName("%chance%", unknown ? "??" : String.valueOf((int)(combatOdds.win * 100.0)));
    }

    public StringTemplate getDestinationLabel() {
        String type = this.isPerson() ? "person" : (this.isNaval() ? "ship" : "other");
        return Unit.getDestinationLabel(type, this.getDestination(), this.getOwner());
    }

    public static StringTemplate getDestinationLabel(String tag, Location destination, Player player) {
        return StringTemplate.template("model.unit.goingTo").add("%type%", tag).addStringTemplate("%location%", destination.getLocationLabelFor(player));
    }

    public StringTemplate getRepairLabel() {
        return StringTemplate.template("model.unit.underRepair").addAmount("%turns%", this.getTurnsForRepair());
    }

    public final UnitType getType() {
        return this.unitType;
    }

    public void setType(UnitType unitType) {
        this.unitType = unitType;
    }

    public boolean changeType(UnitType unitType) {
        if (!unitType.isAvailableTo(this.owner)) {
            return false;
        }
        this.setType(unitType);
        if (this.getMovesLeft() > this.getInitialMovesLeft()) {
            this.setMovesLeft(this.getInitialMovesLeft());
        }
        this.hitPoints = unitType.getHitPoints();
        if (this.getTeacher() != null && !this.canBeStudent(this.getTeacher())) {
            this.getTeacher().setStudent(null);
            this.setTeacher(null);
        }
        return true;
    }

    public boolean isNaval() {
        return this.unitType == null ? false : this.unitType.isNaval();
    }

    public boolean isUndead() {
        return this.hasAbility("model.ability.undead");
    }

    public boolean canCarryTreasure() {
        return this.hasAbility("model.ability.carryTreasure");
    }

    public boolean canCaptureGoods() {
        return this.hasAbility("model.ability.captureGoods");
    }

    public boolean isTradingUnit() {
        return this.canCarryGoods() && this.owner.isEuropean();
    }

    public boolean isColonist() {
        return this.unitType.hasAbility("model.ability.foundColony") && this.owner.hasAbility("model.ability.foundsColonies");
    }

    public boolean isCarrier() {
        return this.unitType.canCarryGoods() || this.unitType.canCarryUnits();
    }

    public boolean isPerson() {
        return this.hasAbility("model.ability.person") || this.unitType.hasAbility("model.ability.bornInColony") || this.unitType.hasAbility("model.ability.bornInIndianSettlement") || this.unitType.hasAbility("model.ability.foundColony");
    }

    public UnitState getState() {
        return this.state;
    }

    public boolean checkSetState(UnitState s) {
        if (this.getState() == s) {
            return false;
        }
        switch (s) {
            case ACTIVE: {
                return true;
            }
            case FORTIFIED: {
                return this.getState() == UnitState.FORTIFYING;
            }
            case FORTIFYING: {
                return this.getMovesLeft() > 0;
            }
            case IMPROVING: {
                return this.getMovesLeft() > 0 && this.location instanceof Tile && this.getOwner().canAcquireForImprovement(this.location.getTile());
            }
            case IN_COLONY: {
                return !this.isNaval();
            }
            case SENTRY: {
                return true;
            }
            case SKIPPED: {
                return this.getState() == UnitState.ACTIVE;
            }
        }
        logger.warning("Invalid unit state: " + (Object)((Object)s));
        return false;
    }

    public void setState(UnitState s) {
        if (this.state == s) {
            return;
        }
        if (!this.checkSetState(s)) {
            throw new IllegalStateException("Illegal UnitState transition: " + (Object)((Object)this.state) + " -> " + (Object)((Object)s));
        }
        this.setStateUnchecked(s);
    }

    protected void setStateUnchecked(UnitState s) {
        switch (this.state) {
            case IMPROVING: {
                if (this.workImprovement == null || this.getWorkLeft() <= 0) break;
                if (!this.workImprovement.isComplete() && this.workImprovement.getTile() != null && this.workImprovement.getTile().getTileItemContainer() != null) {
                    this.workImprovement.getTile().getTileItemContainer().removeTileItem(this.workImprovement);
                }
                this.setWorkImprovement(null);
                break;
            }
        }
        switch (s) {
            case ACTIVE: {
                this.setWorkLeft(-1);
                break;
            }
            case SENTRY: {
                this.setWorkLeft(-1);
                break;
            }
            case FORTIFIED: {
                this.setWorkLeft(-1);
                this.movesLeft = 0;
                break;
            }
            case FORTIFYING: {
                this.setWorkLeft(1);
                break;
            }
            case IMPROVING: {
                if (this.workImprovement == null) {
                    this.setWorkLeft(-1);
                } else {
                    this.setWorkLeft(this.workImprovement.getTurnsToComplete() + (this.getMovesLeft() > 0 ? 0 : 1));
                }
                this.movesLeft = 0;
                break;
            }
            case SKIPPED: {
                break;
            }
            default: {
                this.setWorkLeft(-1);
            }
        }
        this.state = s;
    }

    public void setStateToAllChildren(UnitState state) {
        if (this.canCarryUnits()) {
            for (Unit u : this.getUnitList()) {
                u.setState(state);
            }
        }
    }

    public void changeOwner(Player owner) {
        Player oldOwner = this.owner;
        if (oldOwner == owner) {
            return;
        }
        if (oldOwner == null) {
            logger.warning("Unit " + this.getId() + " had no owner, when changing owner to " + owner.getId());
        }
        this.setOwner(owner);
        if (this.getTradeRoute() != null) {
            this.setTradeRoute(null);
        }
        if (this.getDestination() != null) {
            this.setDestination(null);
        }
        for (Unit u : this.getUnitList()) {
            u.changeOwner(owner);
        }
        if (this.getTeacher() != null && !this.canBeStudent(this.getTeacher())) {
            this.getTeacher().setStudent(null);
            this.setTeacher(null);
        }
        if (oldOwner != null) {
            oldOwner.removeUnit(this);
        }
        if (owner != null) {
            owner.addUnit(this);
        }
        this.getGame().notifyOwnerChanged(this, oldOwner, owner);
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public int getRoleCount() {
        return this.roleCount;
    }

    public void setRoleCount(int roleCount) {
        this.roleCount = roleCount;
    }

    public boolean hasDefaultRole() {
        return this.role.isDefaultRole();
    }

    public String getRoleSuffix() {
        return Role.getRoleSuffix(this.role.getId());
    }

    public void changeRole(Role role, int roleCount) {
        if (!role.isCompatibleWith(this.getRole())) {
            this.setExperience(0);
        }
        this.setRole(role);
        this.setRoleCount(role.isDefaultRole() ? 0 : roleCount);
    }

    public boolean changeRoleCount(int delta) {
        this.roleCount = Math.max(0, this.roleCount + delta);
        if (this.roleCount != 0) {
            return false;
        }
        this.role = this.getSpecification().getDefaultRole();
        return true;
    }

    public boolean roleIsAvailable(Role role) {
        return role.isAvailableTo(this);
    }

    public List<Role> getAvailableRoles(List<Role> roles) {
        if (roles == null) {
            roles = this.getSpecification().getRoles();
        }
        return roles.stream().filter(r -> this.roleIsAvailable((Role)r)).collect(Collectors.toList());
    }

    public Role getMilitaryRole() {
        List<Role> roles = this.getAvailableRoles(this.getSpecification().getMilitaryRoles());
        return roles.isEmpty() ? null : roles.get(0);
    }

    public List<AbstractGoods> getGoodsDifference(Role role, int roleCount) {
        return Role.getGoodsDifference(this.getRole(), this.getRoleCount(), role, roleCount);
    }

    public void setLocationNoUpdate(Location newLocation) {
        this.location = newLocation;
    }

    public boolean isOnCarrier() {
        return this.getLocation() instanceof Unit;
    }

    public Unit getCarrier() {
        return this.isOnCarrier() ? (Unit)this.getLocation() : null;
    }

    public boolean isAtSea() {
        return this.location instanceof Unit ? ((Unit)this.location).isAtSea() : this.location instanceof HighSeas;
    }

    public boolean isInMission() {
        return this.hasAbility("model.ability.establishMission") && (this.getLocation() instanceof IndianSettlement || this.getLocation() == null);
    }

    public boolean isInColony() {
        return this.getLocation() instanceof WorkLocation;
    }

    public boolean hasTile() {
        return this.getTile() != null;
    }

    public WorkLocation getWorkLocation() {
        return this.isInColony() ? (WorkLocation)this.getLocation() : null;
    }

    public Building getWorkBuilding() {
        if (this.getLocation() instanceof Building) {
            return (Building)this.getLocation();
        }
        return null;
    }

    public ColonyTile getWorkTile() {
        if (this.getLocation() instanceof ColonyTile) {
            return (ColonyTile)this.getLocation();
        }
        return null;
    }

    public Location getEntryLocation() {
        if (this.entryLocation == null) {
            this.entryLocation = this.owner.getEntryLocation();
        }
        return this.entryLocation;
    }

    public void setEntryLocation(Location entryLocation) {
        this.entryLocation = entryLocation;
        if (entryLocation != null) {
            this.owner.setEntryLocation(entryLocation);
        }
    }

    public Tile getFullEntryLocation() {
        return this.entryLocation != null ? (Tile)this.entryLocation : (this.owner.getEntryLocation() == null ? null : this.owner.getEntryLocation().getTile());
    }

    @Override
    public int getMovesLeft() {
        return this.movesLeft;
    }

    public void setMovesLeft(int moves) {
        this.movesLeft = moves < 0 ? 0 : moves;
    }

    public GoodsType getWorkType() {
        return this.workType;
    }

    public void setWorkType(GoodsType type) {
        this.workType = type;
    }

    public void changeWorkType(GoodsType type) {
        WorkLocation wl;
        this.setWorkType(type);
        if (type != null) {
            this.experienceType = type;
        }
        if ((wl = this.getWorkLocation()) != null) {
            wl.updateProductionType();
        }
    }

    public GoodsType getExperienceType() {
        return this.experienceType;
    }

    public int getExperience() {
        return this.experience;
    }

    public void setExperience(int experience) {
        this.experience = Math.min(experience, this.getType().getMaximumExperience());
    }

    public void modifyExperience(int value) {
        this.experience += value;
    }

    public int getWorkLeft() {
        return this.workLeft;
    }

    public void setWorkLeft(int workLeft) {
        this.workLeft = workLeft;
    }

    public int getWorkTurnsLeft() {
        return this.state == UnitState.IMPROVING && this.unitType.hasAbility("model.ability.expertPioneer") ? (this.getWorkLeft() + 1) / 2 : this.getWorkLeft();
    }

    public TileImprovement getWorkImprovement() {
        return this.workImprovement;
    }

    public void setWorkImprovement(TileImprovement imp) {
        this.workImprovement = imp;
    }

    public final Unit getStudent() {
        return this.student;
    }

    public final void setStudent(Unit newStudent) {
        Unit oldStudent = this.student;
        if (oldStudent == newStudent) {
            return;
        }
        if (newStudent == null) {
            this.student = null;
            if (oldStudent != null && oldStudent.getTeacher() == this) {
                oldStudent.setTeacher(null);
            }
        } else if (newStudent.getColony() != null && newStudent.getColony() == this.getColony() && newStudent.canBeStudent(this)) {
            if (oldStudent != null && oldStudent.getTeacher() == this) {
                oldStudent.setTeacher(null);
            }
            this.student = newStudent;
            newStudent.setTeacher(this);
        } else {
            throw new IllegalStateException("Unit can not be student: " + newStudent);
        }
    }

    public final Unit getTeacher() {
        return this.teacher;
    }

    public final void setTeacher(Unit newTeacher) {
        Unit oldTeacher = this.teacher;
        if (newTeacher == oldTeacher) {
            return;
        }
        if (newTeacher == null) {
            this.teacher = null;
            if (oldTeacher != null && oldTeacher.getStudent() == this) {
                oldTeacher.setStudent(null);
            }
        } else {
            UnitType skillTaught = newTeacher.getType().getSkillTaught();
            if (newTeacher.getColony() != null && newTeacher.getColony() == this.getColony() && this.getColony().canTrain(skillTaught)) {
                if (oldTeacher != null && oldTeacher.getStudent() == this) {
                    oldTeacher.setStudent(null);
                }
                this.teacher = newTeacher;
                this.teacher.setStudent(this);
            } else {
                throw new IllegalStateException("Unit can not be teacher: " + newTeacher);
            }
        }
    }

    public int getTurnsOfTraining() {
        return this.turnsOfTraining;
    }

    public void setTurnsOfTraining(int turnsOfTraining) {
        this.turnsOfTraining = turnsOfTraining;
    }

    public int getNeededTurnsOfTraining() {
        int result = 0;
        if (this.student != null) {
            result = this.getNeededTurnsOfTraining(this.unitType, this.student.unitType);
            if (this.getColony() != null) {
                result -= this.getColony().getProductionBonus();
            }
        }
        return result;
    }

    public int getNeededTurnsOfTraining(UnitType typeTeacher, UnitType typeStudent) {
        UnitType teaching = Unit.getUnitTypeTeaching(typeTeacher, typeStudent);
        if (teaching != null) {
            return typeStudent.getEducationTurns(teaching);
        }
        throw new IllegalStateException("typeTeacher=" + typeTeacher + " typeStudent=" + typeStudent);
    }

    public static UnitType getUnitTypeTeaching(UnitType typeTeacher, UnitType typeStudent) {
        UnitType skillTaught = typeTeacher.getSkillTaught();
        if (typeStudent.canBeUpgraded(skillTaught, UnitTypeChange.ChangeType.EDUCATION)) {
            return skillTaught;
        }
        return typeStudent.getEducationUnit(0);
    }

    public boolean canBeStudent(Unit teacher) {
        return teacher != this && this.canBeStudent(this.unitType, teacher.unitType);
    }

    public boolean canBeStudent(UnitType typeStudent, UnitType typeTeacher) {
        return Unit.getUnitTypeTeaching(typeTeacher, typeStudent) != null;
    }

    public String getNationality() {
        return this.nationality;
    }

    public void setNationality(String newNationality) {
        if (!this.isPerson()) {
            throw new UnsupportedOperationException("Can not set the nationality of a Unit which is not a person!");
        }
        this.nationality = newNationality;
    }

    public String getEthnicity() {
        return this.ethnicity;
    }

    public void setEthnicity(String newEthnicity) {
        this.ethnicity = newEthnicity;
    }

    public boolean hasNativeEthnicity() {
        try {
            return this.getGame().getSpecification().getNation(this.ethnicity).getType().isIndian();
        }
        catch (Exception e) {
            return false;
        }
    }

    public IndianSettlement getHomeIndianSettlement() {
        return this.indianSettlement;
    }

    public void setHomeIndianSettlement(IndianSettlement indianSettlement) {
        if (this.indianSettlement != null) {
            this.indianSettlement.removeOwnedUnit(this);
        }
        this.indianSettlement = indianSettlement;
        if (indianSettlement != null) {
            indianSettlement.addOwnedUnit(this);
        }
    }

    public int getHitPoints() {
        return this.hitPoints;
    }

    public void setHitPoints(int hitPoints) {
        this.hitPoints = hitPoints;
    }

    public boolean isDamaged() {
        return this.hitPoints < this.unitType.getHitPoints();
    }

    public int getTurnsForRepair() {
        return this.unitType.getHitPoints() - this.getHitPoints();
    }

    public Location getDestination() {
        return this.destination;
    }

    public void setDestination(Location newDestination) {
        this.destination = newDestination;
    }

    public final TradeRoute getTradeRoute() {
        return this.tradeRoute;
    }

    public final void setTradeRoute(TradeRoute newTradeRoute) {
        this.tradeRoute = newTradeRoute;
    }

    public TradeRouteStop getStop() {
        return this.validateCurrentStop() < 0 ? null : this.getTradeRoute().getStops().get(this.currentStop);
    }

    public List<TradeRouteStop> getCurrentStops() {
        if (this.validateCurrentStop() < 0) {
            return null;
        }
        ArrayList<TradeRouteStop> stops = new ArrayList<TradeRouteStop>(this.getTradeRoute().getStops());
        CollectionUtils.rotate(stops, this.currentStop);
        return stops;
    }

    public int getCurrentStop() {
        return this.currentStop;
    }

    public void setCurrentStop(int currentStop) {
        this.currentStop = currentStop;
    }

    public int validateCurrentStop() {
        if (this.tradeRoute == null) {
            this.currentStop = -1;
        } else {
            List<TradeRouteStop> stops = this.tradeRoute.getStops();
            if (stops == null || stops.isEmpty()) {
                this.currentStop = -1;
            } else if (this.currentStop < 0 || this.currentStop >= stops.size()) {
                this.currentStop = 0;
            }
        }
        return this.currentStop;
    }

    public boolean atStop(TradeRouteStop stop) {
        return Map.isSameLocation(this.getLocation(), stop.getLocation());
    }

    public TradeLocation getTradeLocation() {
        IndianSettlement is;
        Colony colony = this.getColony();
        return colony != null ? colony : ((is = this.getIndianSettlement()) != null ? is : (this.isInEurope() ? this.getOwner().getEurope() : null));
    }

    public int getTreasureAmount() {
        if (!this.canCarryTreasure()) {
            throw new IllegalStateException("Unit can not carry treasure");
        }
        return this.treasureAmount;
    }

    public void setTreasureAmount(int amount) {
        if (!this.canCarryTreasure()) {
            throw new IllegalStateException("Unit can not carry treasure");
        }
        this.treasureAmount = amount;
    }

    public int getAttrition() {
        return this.attrition;
    }

    public void setAttrition(int attrition) {
        this.attrition = attrition;
    }

    public int getVisibleGoodsCount() {
        return this.visibleGoodsCount >= 0 ? this.visibleGoodsCount : this.getGoodsSpaceTaken();
    }

    public Role getAutomaticRole() {
        Colony settlement;
        if (!this.hasDefaultRole()) {
            return null;
        }
        Set<Ability> autoDefence = this.getAbilities("model.ability.automaticEquipment");
        if (autoDefence.isEmpty()) {
            return null;
        }
        Settlement settlement2 = this.isInColony() ? this.getColony() : (settlement = this.getLocation() instanceof IndianSettlement ? (Settlement)this.getLocation() : null);
        if (settlement == null) {
            return null;
        }
        Specification spec = this.getSpecification();
        for (Ability ability : autoDefence) {
            for (Scope scope : ability.getScopes()) {
                Role role = spec.getRole(scope.getType());
                if (role == null || !settlement.containsGoods(this.getGoodsDifference(role, 1))) continue;
                return role;
            }
        }
        return null;
    }

    public Role canCaptureEquipment(Role role) {
        if (!this.hasAbility("model.ability.captureEquipment")) {
            return null;
        }
        Specification spec = this.getSpecification();
        Role oldRole = this.getRole();
        for (Role r : this.getAvailableRoles(spec.getMilitaryRoles())) {
            for (Role.RoleChange rc : r.getRoleChanges()) {
                if (rc.getFrom(spec) != oldRole || rc.getCapture(spec) != role) continue;
                return r;
            }
        }
        return null;
    }

    public boolean losingEquipmentKillsUnit() {
        return this.hasAbility("model.ability.disposeOnAllEquipLost") && this.getRole().getDowngrade() == null;
    }

    public boolean losingEquipmentDemotesUnit() {
        return this.hasAbility("model.ability.demoteOnAllEquipLost") && this.getRole().getDowngrade() == null;
    }

    public boolean isArmed() {
        return this.hasAbility("model.ability.armed");
    }

    public boolean isMounted() {
        return this.hasAbility("model.ability.mounted");
    }

    public boolean isBeached() {
        return this.isBeached(this.getTile());
    }

    public boolean isBeached(Tile tile) {
        return this.isNaval() && tile != null && tile.isLand() && !tile.hasSettlement();
    }

    public boolean isDefensiveUnit() {
        return (this.unitType.isDefensive() || this.getRole().isDefensive()) && !this.isCarrier();
    }

    public boolean isOffensiveUnit() {
        return this.unitType.isOffensive() || this.getRole().isOffensive();
    }

    public static boolean betterDefender(Unit defender, double defenderPower, Unit other, double otherPower) {
        if (defender == null) {
            return true;
        }
        if (defender.isPerson() && other.isPerson() && !defender.isArmed() && other.isArmed()) {
            return true;
        }
        if (defender.isPerson() && other.isPerson() && defender.isArmed() && !other.isArmed()) {
            return false;
        }
        if (!defender.isDefensiveUnit() && other.isDefensiveUnit()) {
            return true;
        }
        if (defender.isDefensiveUnit() && !other.isDefensiveUnit()) {
            return false;
        }
        return defenderPower < otherPower;
    }

    public Location getRepairLocation() {
        Player player = this.getOwner();
        Colony notHere = this.getTile().getColony();
        Colony best = this.getClosestColony(player.getColonies().stream().filter(c -> c != notHere && c.hasAbility("model.ability.repairUnits")));
        return best != null ? best : player.getEurope();
    }

    public int getMoveCost(Tile target) {
        return this.getMoveCost(this.getTile(), target, this.getMovesLeft());
    }

    public int getMoveCost(Tile from, Tile target, int ml) {
        TileItemContainer container;
        int cost = target.getType().getBasicMoveCost();
        if (target.isLand() && !this.isNaval() && (container = target.getTileItemContainer()) != null) {
            cost = container.getMoveCost(from, target, cost);
        }
        if (this.isBeached(from)) {
            cost = ml;
        } else if (cost > ml && (ml + 2 >= this.getInitialMovesLeft() || cost <= ml + 2 || target.hasSettlement()) && ml != 0) {
            cost = ml;
        }
        return cost;
    }

    public MoveType getMoveType(Direction direction) {
        Tile target;
        return !this.hasTile() ? MoveType.MOVE_NO_TILE : ((target = this.getTile().getNeighbourOrNull(direction)) == null ? MoveType.MOVE_ILLEGAL : this.getMoveType(target));
    }

    public MoveType getMoveType(Tile target) {
        return !this.hasTile() ? MoveType.MOVE_NO_TILE : this.getMoveType(this.getTile(), target, this.getMovesLeft());
    }

    public MoveType getMoveType(Tile from, Tile target, int ml) {
        MoveType move = this.getSimpleMoveType(from, target);
        if (move.isLegal()) {
            switch (move) {
                case ATTACK_UNIT: 
                case ATTACK_SETTLEMENT: {
                    if (ml > 0) break;
                    move = MoveType.MOVE_NO_MOVES;
                    break;
                }
                default: {
                    if (ml > 0 && (from == null || this.getMoveCost(from, target, ml) <= ml)) break;
                    move = MoveType.MOVE_NO_MOVES;
                }
            }
        }
        return move;
    }

    public MoveType getSimpleMoveType(Tile from, Tile target) {
        return this.isNaval() ? this.getNavalMoveType(from, target) : this.getLandMoveType(from, target);
    }

    public MoveType getSimpleMoveType(Tile target) {
        return !this.hasTile() ? MoveType.MOVE_NO_TILE : this.getSimpleMoveType(this.getTile(), target);
    }

    public MoveType getSimpleMoveType(Direction direction) {
        Tile target;
        return !this.hasTile() ? MoveType.MOVE_NO_TILE : ((target = this.getTile().getNeighbourOrNull(direction)) == null ? MoveType.MOVE_ILLEGAL : this.getSimpleMoveType(this.getTile(), target));
    }

    private MoveType getNavalMoveType(Tile from, Tile target) {
        if (target == null) {
            return this.getOwner().canMoveToEurope() ? MoveType.MOVE_HIGH_SEAS : MoveType.MOVE_NO_EUROPE;
        }
        if (this.isDamaged()) {
            return MoveType.MOVE_NO_REPAIR;
        }
        if (target.isLand()) {
            Settlement settlement = target.getSettlement();
            if (settlement == null) {
                return MoveType.MOVE_NO_ACCESS_LAND;
            }
            if (settlement.getOwner() == this.getOwner()) {
                return MoveType.MOVE;
            }
            if (this.isTradingUnit()) {
                return this.getTradeMoveType(settlement);
            }
            return MoveType.MOVE_NO_ACCESS_SETTLEMENT;
        }
        Unit defender = target.getFirstUnit();
        if (defender != null && !this.getOwner().owns(defender)) {
            return this.isOffensiveUnit() ? MoveType.ATTACK_UNIT : MoveType.MOVE_NO_ATTACK_CIVILIAN;
        }
        return target.isDirectlyHighSeasConnected() ? MoveType.MOVE_HIGH_SEAS : MoveType.MOVE;
    }

    private MoveType getLandMoveType(Tile from, Tile target) {
        if (target == null) {
            return MoveType.MOVE_ILLEGAL;
        }
        Player owner = this.getOwner();
        Unit defender = target.getFirstUnit();
        if (target.isLand()) {
            Settlement settlement = target.getSettlement();
            if (settlement == null) {
                if (defender != null && owner != defender.getOwner()) {
                    if (defender.isNaval()) {
                        return MoveType.ATTACK_UNIT;
                    }
                    if (!this.isOffensiveUnit()) {
                        return MoveType.MOVE_NO_ATTACK_CIVILIAN;
                    }
                    return this.allowMoveFrom(from) ? MoveType.ATTACK_UNIT : MoveType.MOVE_NO_ATTACK_MARINE;
                }
                if (target.hasLostCityRumour() && owner.isEuropean()) {
                    return MoveType.EXPLORE_LOST_CITY_RUMOUR;
                }
                return MoveType.MOVE;
            }
            if (owner == settlement.getOwner()) {
                return MoveType.MOVE;
            }
            if (this.isTradingUnit()) {
                return this.getTradeMoveType(settlement);
            }
            if (this.isColonist()) {
                if (settlement instanceof Colony && this.hasAbility("model.ability.negotiate")) {
                    return this.allowMoveFrom(from) ? MoveType.ENTER_FOREIGN_COLONY_WITH_SCOUT : MoveType.MOVE_NO_ACCESS_WATER;
                }
                if (settlement instanceof IndianSettlement && this.hasAbility("model.ability.speakWithChief")) {
                    return this.allowMoveFrom(from) ? MoveType.ENTER_INDIAN_SETTLEMENT_WITH_SCOUT : MoveType.MOVE_NO_ACCESS_WATER;
                }
                if (this.isOffensiveUnit()) {
                    return this.allowMoveFrom(from) ? MoveType.ATTACK_SETTLEMENT : MoveType.MOVE_NO_ATTACK_MARINE;
                }
                if (this.hasAbility("model.ability.establishMission")) {
                    return this.getMissionaryMoveType(from, settlement);
                }
                return this.getLearnMoveType(from, settlement);
            }
            if (this.isOffensiveUnit()) {
                return this.allowMoveFrom(from) ? MoveType.ATTACK_SETTLEMENT : MoveType.MOVE_NO_ATTACK_MARINE;
            }
            return MoveType.MOVE_NO_ACCESS_SETTLEMENT;
        }
        return defender == null || !this.getOwner().owns(defender) ? MoveType.MOVE_NO_ACCESS_EMBARK : (CollectionUtils.any(target.getUnitList(), u -> u.canAdd(this)) ? MoveType.EMBARK : MoveType.MOVE_NO_ACCESS_FULL);
    }

    private MoveType getTradeMoveType(Settlement settlement) {
        if (settlement instanceof Colony) {
            return this.getOwner().atWarWith(settlement.getOwner()) ? MoveType.MOVE_NO_ACCESS_WAR : (!this.hasAbility("model.ability.tradeWithForeignColonies") ? MoveType.MOVE_NO_ACCESS_TRADE : MoveType.ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS);
        }
        if (settlement instanceof IndianSettlement) {
            return !this.allowContact(settlement) ? MoveType.MOVE_NO_ACCESS_CONTACT : (this.hasGoodsCargo() || this.getSpecification().getBoolean("model.option.emptyTraders") ? MoveType.ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS : MoveType.MOVE_NO_ACCESS_GOODS);
        }
        return MoveType.MOVE_ILLEGAL;
    }

    private MoveType getLearnMoveType(Tile from, Settlement settlement) {
        if (settlement instanceof Colony) {
            return MoveType.MOVE_NO_ACCESS_SETTLEMENT;
        }
        if (settlement instanceof IndianSettlement) {
            return !this.allowContact(settlement) ? MoveType.MOVE_NO_ACCESS_CONTACT : (!this.allowMoveFrom(from) ? MoveType.MOVE_NO_ACCESS_WATER : (!this.getType().canBeUpgraded(null, UnitTypeChange.ChangeType.NATIVES) ? MoveType.MOVE_NO_ACCESS_SKILL : MoveType.ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST));
        }
        return MoveType.MOVE_ILLEGAL;
    }

    private MoveType getMissionaryMoveType(Tile from, Settlement settlement) {
        if (settlement instanceof Colony) {
            return MoveType.MOVE_NO_ACCESS_SETTLEMENT;
        }
        if (settlement instanceof IndianSettlement) {
            return !this.allowContact(settlement) ? MoveType.MOVE_NO_ACCESS_CONTACT : (!this.allowMoveFrom(from) ? MoveType.MOVE_NO_ACCESS_WATER : (settlement.getOwner().missionsBanned(this.getOwner()) ? MoveType.MOVE_NO_ACCESS_MISSION_BAN : MoveType.ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY));
        }
        return MoveType.MOVE_ILLEGAL;
    }

    private boolean allowMoveFrom(Tile from) {
        return from.isLand() || !this.getOwner().isREF() && this.getSpecification().getBoolean("model.option.amphibiousMoves");
    }

    private boolean allowContact(Settlement settlement) {
        return this.getOwner().hasContacted(settlement.getOwner());
    }

    public boolean isTileAccessible(Tile tile) {
        return this.isNaval() ? !tile.isLand() || tile.hasSettlement() && this.getOwner().owns(tile.getSettlement()) : tile.isLand();
    }

    @Override
    public int getInitialMovesLeft() {
        Turn turn = this.getGame().getTurn();
        return (int)this.applyModifiers(this.unitType.getMovement(), turn, "model.modifier.movementBonus", this.unitType);
    }

    public String getMovesAsString() {
        StringBuilder sb = new StringBuilder(16);
        int quotient = this.getMovesLeft() / 3;
        int remainder = this.getMovesLeft() % 3;
        if (quotient > 0 || remainder == 0) {
            sb.append(quotient);
        }
        if (remainder > 0) {
            sb.append("(").append(remainder).append("/3) ");
        }
        sb.append("/").append(this.getInitialMovesLeft() / 3);
        return sb.toString();
    }

    public int getSailTurns() {
        float base = this.getSpecification().getInteger("model.option.turnsToSail");
        return (int)this.getOwner().applyModifiers(base, this.getGame().getTurn(), "model.modifier.sailHighSeas", this.unitType);
    }

    public boolean canMoveToHighSeas() {
        if (this.isInEurope() || this.isAtSea()) {
            return true;
        }
        if (!this.getOwner().canMoveToEurope() || !this.getType().canMoveToHighSeas()) {
            return false;
        }
        return this.getTile().isDirectlyHighSeasConnected();
    }

    public boolean hasHighSeasMove() {
        return this.canMoveToHighSeas() ? true : (this.hasTile() && this.getMovesLeft() > 0 ? CollectionUtils.any(this.getTile().getSurroundingTiles(1, 1), Tile::isDirectlyHighSeasConnected) : false);
    }

    public boolean canBuildColony() {
        Specification spec = this.getSpecification();
        return this.hasTile() && this.unitType.canBuildColony() && this.getMovesLeft() > 0 && (!this.getOwner().isRebel() || spec.getBoolean("model.option.foundColonyDuringRebellion"));
    }

    public boolean isAtLocation(Location loc) {
        Location otherLoc;
        Location ourLoc = this.getLocation();
        Location location = otherLoc = loc instanceof Unit ? ((Unit)loc).getLocation() : loc;
        if (ourLoc instanceof Unit) {
            ourLoc = ((Unit)ourLoc).getLocation();
        }
        return Map.isSameLocation(ourLoc, otherLoc);
    }

    public Tile getBestEntryTile(Tile tile) {
        return this.getGame().getMap().getBestEntryTile(this, tile, null, null);
    }

    public Location resolveDestination() {
        Tile best;
        Location dst;
        if (!this.isAtSea()) {
            throw new IllegalArgumentException("Not at sea.");
        }
        TradeRouteStop stop = this.getStop();
        Location location = dst = TradeRoute.isStopValid(this, stop) ? stop.getLocation() : this.getDestination();
        return dst == null ? this.getFullEntryLocation() : (dst instanceof Europe ? dst : (dst.getTile() != null && (best = this.getBestEntryTile(dst.getTile())) != null ? best : this.getFullEntryLocation()));
    }

    private void spendAllMoves() {
        if (this.getColony() != null && this.getMovesLeft() < this.getInitialMovesLeft()) {
            this.setMovesLeft(0);
        }
    }

    public boolean couldMove() {
        return !this.isDisposed() && this.getState() == UnitState.ACTIVE && this.getMovesLeft() > 0 && this.destination == null && this.tradeRoute == null && !this.isDamaged() && !this.isAtSea() && !this.isOnCarrier() && !this.isInColony();
    }

    public Location getPathStartLocation() {
        Tile entry;
        Unit carrier = this.getCarrier();
        Location ret = this.getTile();
        if (this.isOnCarrier()) {
            if (ret == null) {
                ret = carrier.getDestination() == null ? null : (carrier.getDestination() instanceof Map ? carrier.getFullEntryLocation() : (carrier.getDestination() instanceof Settlement ? carrier.getDestination() : null));
            }
        } else if (this.isNaval() && ret == null) {
            ret = this.getDestination() == null || this.getDestination() instanceof Map ? this.getFullEntryLocation() : (this.getDestination() instanceof Settlement ? this.getDestination() : this.getFullEntryLocation());
        }
        if (ret != null) {
            return ret;
        }
        Player owner = this.getOwner();
        int bestValue = Integer.MAX_VALUE;
        for (Settlement s : owner.getSettlements()) {
            if (s.getTile().isHighSeasConnected()) {
                int value = s.getTile().getHighSeasCount();
                if (bestValue <= value) continue;
                bestValue = value;
                ret = s;
                continue;
            }
            if (bestValue != Integer.MAX_VALUE) continue;
            ret = s;
        }
        if (ret != null) {
            return ret;
        }
        if (owner.isREF()) {
            bestValue = Integer.MAX_VALUE;
            for (Player p : owner.getRebels()) {
                for (Settlement s : p.getSettlements()) {
                    if (s.getTile().isHighSeasConnected()) {
                        int value = s.getTile().getHighSeasCount();
                        if (bestValue <= value) continue;
                        bestValue = value;
                        ret = s;
                        continue;
                    }
                    if (bestValue != Integer.MAX_VALUE) continue;
                    ret = s;
                }
            }
            if (ret != null) {
                return ret;
            }
        }
        if ((entry = this.getFullEntryLocation()) != null && entry.getTile() != null) {
            for (Tile t : entry.getTile().getSurroundingTiles(Integer.MAX_VALUE)) {
                if (!t.isLand()) continue;
                return t;
            }
        }
        return null;
    }

    public boolean shouldTakeTransportTo(Location loc) {
        PathNode path;
        return loc != null && !this.isNaval() && !this.isAtLocation(loc) && ((path = this.findPath(this.getLocation(), loc, this.getCarrier(), null)) == null || path.usesCarrier());
    }

    public PathNode getTrivialPath() {
        Tile tile;
        if (this.isDisposed() || this.getLocation() == null) {
            return null;
        }
        if (!this.isNaval()) {
            return this.findOurNearestSettlement();
        }
        PathNode path = this.findOurNearestPort();
        if (path == null && (tile = this.getTile()) != null && tile.isOnRiver() && tile.isHighSeasConnected() && (path = this.search(this.getLocation(), GoalDeciders.getCornerGoalDecider(), CostDeciders.avoidSettlementsAndBlockingUnits(), Integer.MAX_VALUE, null)) == null && tile.isRiverCorner()) {
            return new PathNode(tile, 0, 0, false, null, null);
        }
        return path;
    }

    public PathNode findPath(Location end) {
        return this.findPath(this.getLocation(), end, null, null);
    }

    public PathNode findPath(Location start, Location end, Unit carrier, CostDecider costDecider) {
        return this.getGame().getMap().findPath(this, start, end, carrier, costDecider, null);
    }

    public PathNode findPathToNeighbour(Location start, Tile end, Unit carrier, CostDecider costDecider) {
        Player owner = this.getOwner();
        int bestValue = Integer.MAX_VALUE;
        PathNode best = null;
        for (Tile t : end.getSurroundingTiles(1)) {
            PathNode p;
            if (!this.isTileAccessible(t) || t.getFirstUnit() != null && !owner.owns(t.getFirstUnit()) || (p = this.findPath(start, t, carrier, costDecider)) == null || bestValue <= p.getTotalTurns()) continue;
            bestValue = p.getTotalTurns();
            best = p;
        }
        return best;
    }

    public int getTurnsToReach(Location end) {
        return this.getTurnsToReach(this.getLocation(), end);
    }

    public int getTurnsToReach(Location start, Location end) {
        return this.getTurnsToReach(start, end, this.getCarrier(), CostDeciders.avoidSettlementsAndBlockingUnits());
    }

    public int getTurnsToReach(Location start, Location end, Unit carrier, CostDecider costDecider) {
        PathNode path = this.findPath(start, end, carrier, costDecider);
        return path == null ? 10000 : path.getTotalTurns();
    }

    public Colony getClosestColony(List<Colony> colonies) {
        return this.getClosestColony(colonies.stream());
    }

    public Colony getClosestColony(Stream<Colony> colonies) {
        ToIntFunction<Colony> closeness = c -> c == null ? 9999 : this.getTurnsToReach((Location)c);
        return Stream.concat(Stream.of((Colony)null), colonies).collect(Collectors.minBy(Comparator.comparingInt(closeness))).orElse(null);
    }

    public PathNode findOurNearestSettlement(boolean excludeStart, int range, boolean coastal) {
        Player player = this.getOwner();
        if (player.getNumberOfSettlements() <= 0 || !this.hasTile()) {
            return null;
        }
        return this.findOurNearestSettlement(this.getTile(), excludeStart, range, coastal);
    }

    public PathNode findOurNearestSettlement(final Tile startTile, final boolean excludeStart, int range, final boolean coastal) {
        final Player player = this.getOwner();
        if (startTile == null || player.getNumberOfSettlements() <= 0) {
            return null;
        }
        GoalDecider gd = new GoalDecider(){
            private int bestValue = Integer.MAX_VALUE;
            private PathNode best = null;

            @Override
            public PathNode getGoal() {
                return this.best;
            }

            @Override
            public boolean hasSubGoals() {
                return true;
            }

            @Override
            public boolean check(Unit u, PathNode path) {
                int value;
                Tile t = path.getTile();
                if (t == null || t == startTile && excludeStart) {
                    return false;
                }
                Settlement settlement = t.getSettlement();
                if (settlement != null && player.owns(settlement) && (!coastal || settlement.isConnectedPort()) && (value = path.getTotalTurns()) < this.bestValue) {
                    this.bestValue = value;
                    this.best = path;
                    return true;
                }
                return false;
            }
        };
        return this.search(startTile, gd, CostDeciders.avoidIllegal(), range, null);
    }

    public PathNode findOurNearestSettlement() {
        return this.findOurNearestSettlement(false, Integer.MAX_VALUE, false);
    }

    public PathNode findOurNearestPort() {
        PathNode sPath;
        int sTurns;
        PathNode ePath = null;
        int eTurns = -1;
        Europe europe = this.getOwner().getEurope();
        if (this.getType().canMoveToHighSeas()) {
            ePath = europe == null ? null : this.findPath(europe);
            eTurns = ePath == null ? -1 : ePath.getTotalTurns();
        }
        int n = sTurns = (sPath = this.findOurNearestSettlement(false, Integer.MAX_VALUE, true)) == null ? -1 : sPath.getTotalTurns();
        return ePath == null ? sPath : (sPath == null ? ePath : (sTurns <= eTurns ? sPath : ePath));
    }

    public PathNode findIntermediatePort(Location dst) {
        Settlement ignoreSrc = this.getSettlement();
        Settlement ignoreDst = dst.getSettlement();
        Tile srcTile = this.getTile();
        Tile dstTile = dst.getTile();
        int dstCont = dstTile == null ? -1 : dstTile.getContiguity();
        PathNode best = null;
        int bestValue = Integer.MAX_VALUE;
        int type = this.isNaval() ? (!srcTile.isHighSeasConnected() ? 0 : (dstTile == null ? 1 : (dstTile.isHighSeasConnected() ? (this.getTile().isOnRiver() ? 1 : 2) : 2))) : (dstTile == null || this.getTile().getContiguity() != dstCont ? (srcTile.isHighSeasConnected() ? 1 : 2) : 3);
        switch (type) {
            case 0: {
                break;
            }
            case 1: {
                best = this.search(this.getLocation(), GoalDeciders.getReduceHighSeasCountGoalDecider(this), null, Integer.MAX_VALUE, null);
                break;
            }
            case 2: {
                for (Settlement s : this.getOwner().getSettlements()) {
                    int value;
                    PathNode path;
                    if (s == ignoreSrc || s == ignoreDst || !s.isConnectedPort() || (path = this.findPath(s)) == null || bestValue <= (value = path.getTotalTurns() + dstTile.getDistanceTo(s.getTile()))) continue;
                    bestValue = value;
                    best = path;
                }
                break;
            }
            case 3: {
                for (Settlement s : this.getOwner().getSettlements()) {
                    int value;
                    PathNode path;
                    if (s == ignoreSrc || s == ignoreDst || s.getTile().getContiguity() != dstCont || (path = this.findPath(s)) == null || bestValue <= (value = path.getTotalTurns() + dstTile.getDistanceTo(s.getTile()))) continue;
                    bestValue = value;
                    best = path;
                }
                break;
            }
        }
        return best != null ? best : this.findOurNearestSettlement(false, Integer.MAX_VALUE, false);
    }

    public PathNode findOurNearestOtherSettlement() {
        return this.findOurNearestSettlement(true, Integer.MAX_VALUE, false);
    }

    public PathNode search(Location start, GoalDecider gd, CostDecider cd, int maxTurns, Unit carrier) {
        return start == null ? null : this.getGame().getMap().search(this, start, gd, cd, maxTurns, carrier, null);
    }

    public boolean canAttack(Unit defender) {
        if (!this.isOffensiveUnit() || defender == null || !defender.hasTile()) {
            return false;
        }
        Tile tile = defender.getTile();
        return this.isNaval() ? !tile.hasSettlement() && defender.isNaval() : !defender.isNaval() || defender.isBeached();
    }

    public PathNode searchForDanger(final int range, final float threat) {
        final CombatModel cm = this.getGame().getCombatModel();
        final Tile start = this.getTile();
        GoalDecider threatDecider = new GoalDecider(){
            private PathNode found = null;

            @Override
            public PathNode getGoal() {
                return this.found;
            }

            @Override
            public boolean hasSubGoals() {
                return false;
            }

            @Override
            public boolean check(Unit unit, PathNode path) {
                Tile tile = path.getTile();
                if (tile == null) {
                    return false;
                }
                Unit first = tile.getFirstUnit();
                if (first == null || !Unit.this.getOwner().atWarWith(first.getOwner())) {
                    return false;
                }
                for (Unit u : tile.getUnitList()) {
                    PathNode reverse;
                    if (!u.canAttack(unit) || !(cm.calculateCombatOdds((FreeColGameObject)u, (FreeColGameObject)unit).win >= (double)threat) || (reverse = u.findPath(start)) == null || reverse.getTotalTurns() >= range) continue;
                    this.found = path;
                    return true;
                }
                return false;
            }
        };
        int reverseRange = range * (this.isNaval() ? this.getSpecification().getFastestNavalUnitType() : this.getSpecification().getFastestLandUnitType()).getMovement() / this.getType().getMovement();
        return start == null ? null : this.search(start, threatDecider, CostDeciders.avoidIllegal(), reverseRange, this.getCarrier());
    }

    public boolean isInDanger(int range, float threat) {
        return this.searchForDanger(range, threat) != null;
    }

    public int getLineOfSight() {
        Turn turn = this.getGame().getTurn();
        HashSet<Modifier> result = new HashSet<Modifier>();
        result.addAll(this.getModifiers("model.modifier.lineOfSightBonus", this.unitType, turn));
        if (this.hasTile() && this.getTile().isExplored()) {
            result.addAll(this.getTile().getType().getModifiers("model.modifier.lineOfSightBonus", this.unitType, turn));
        }
        float base = this.unitType.getLineOfSight();
        return (int)Unit.applyModifiers(base, turn, result);
    }

    public List<Goods> getGoodsList() {
        return this.getGoodsContainer() == null ? Collections.emptyList() : this.getGoodsContainer().getGoods();
    }

    public List<Goods> getCompactGoodsList() {
        return this.getGoodsContainer() == null ? Collections.emptyList() : this.getGoodsContainer().getCompactGoods();
    }

    public boolean canCarryUnits() {
        return this.hasAbility("model.ability.carryUnits");
    }

    public boolean couldCarry(Unit u) {
        return this.canCarryUnits() && this.getCargoCapacity() >= u.getSpaceTaken();
    }

    public boolean canCarryGoods() {
        return this.hasAbility("model.ability.carryGoods");
    }

    public boolean couldCarry(Goods g) {
        return this.canCarryGoods() && this.getCargoCapacity() >= g.getSpaceTaken();
    }

    public int getSpaceLeft() {
        return this.getCargoCapacity() - this.getCargoSpaceTaken();
    }

    public boolean hasSpaceLeft() {
        return this.getSpaceLeft() > 0;
    }

    public int getCargoCapacity() {
        return this.unitType.getSpace();
    }

    public int getGoodsSpaceTaken() {
        if (!this.canCarryGoods()) {
            return 0;
        }
        GoodsContainer gc = this.getGoodsContainer();
        return gc == null ? 0 : gc.getSpaceTaken();
    }

    public int getUnitSpaceTaken() {
        return this.canCarryUnits() ? this.getUnitList().stream().mapToInt(u -> u.getSpaceTaken()).sum() : 0;
    }

    public int getCargoSpaceTaken() {
        return this.getGoodsSpaceTaken() + this.getUnitSpaceTaken();
    }

    public boolean hasGoodsCargo() {
        return this.getGoodsSpaceTaken() > 0;
    }

    public boolean hasCargo() {
        return this.getCargoSpaceTaken() > 0;
    }

    public int getLoadableAmount(GoodsType type) {
        if (!this.canCarryGoods()) {
            return 0;
        }
        int result = this.getSpaceLeft() * 100;
        int count = this.getGoodsCount(type) % 100;
        if (count != 0) {
            result += 100 - count;
        }
        return result;
    }

    public StringTemplate getOccupationLabel(Player player, boolean full) {
        TradeRoute tradeRoute = this.getTradeRoute();
        StringTemplate ret = player != null && player.owns(this) ? (this.isDamaged() ? (full ? StringTemplate.label(":").add("model.unit.occupation.underRepair").addName(String.valueOf(this.getTurnsForRepair())) : StringTemplate.key("model.unit.occupation.underRepair")) : (tradeRoute != null ? (full ? StringTemplate.label(":").add("model.unit.occupation.inTradeRoute").addName(tradeRoute.getName()) : StringTemplate.key("model.unit.occupation.inTradeRoute")) : (this.getState() == UnitState.ACTIVE && this.getMovesLeft() == 0 ? StringTemplate.key("model.unit.occupation.activeNoMovesLeft") : (this.getState() == UnitState.IMPROVING && this.getWorkImprovement() != null ? (full ? StringTemplate.label(":").add(this.getWorkImprovement().getType() + ".occupationString").addName(String.valueOf(this.getWorkTurnsLeft())) : StringTemplate.key(this.getWorkImprovement().getType() + ".occupationString")) : (this.getDestination() != null ? StringTemplate.key("model.unit.occupation.goingSomewhere") : StringTemplate.key("model.unit." + this.getState().getKey())))))) : (this.isNaval() ? StringTemplate.name(String.valueOf(this.getVisibleGoodsCount())) : StringTemplate.key("model.unit.occupation.activeNoMovesLeft"));
        return ret;
    }

    public float getConvertProbability() {
        Specification spec = this.getSpecification();
        int opt = spec.getInteger("model.option.nativeConvertProbability");
        return 0.01f * this.applyModifiers(opt, this.getGame().getTurn(), "model.modifier.nativeConvertBonus");
    }

    public float getBurnProbability() {
        Specification spec = this.getSpecification();
        return 0.01f * (float)spec.getInteger("model.option.burnProbability");
    }

    public UnitType getTypeChange(UnitTypeChange.ChangeType change, Player owner) {
        return this.getType().getTargetType(change, owner);
    }

    public boolean canCashInTreasureTrain() {
        return this.canCashInTreasureTrain(this.getLocation());
    }

    public boolean canCashInTreasureTrain(Location loc) {
        if (!this.canCarryTreasure()) {
            throw new IllegalStateException("Can't carry treasure");
        }
        if (loc == null) {
            return false;
        }
        if (this.getOwner().getEurope() == null) {
            return loc.getColony() != null;
        }
        if (loc.getColony() != null) {
            return loc.getColony().isConnectedPort() && (this.getOwner().getCarriersForUnit(this).isEmpty() || this.getTransportFee() == 0);
        }
        return loc instanceof Europe || loc instanceof Unit && ((Unit)loc).isInEurope();
    }

    public int getTransportFee() {
        if (!this.isInEurope() && this.getOwner().getEurope() != null) {
            float fee = (float)(this.getSpecification().getInteger("model.option.treasureTransportFee") * this.getTreasureAmount()) / 100.0f;
            return (int)this.getOwner().applyModifiers(fee, this.getGame().getTurn(), "model.modifier.treasureTransportFee", this.unitType);
        }
        return 0;
    }

    public int getSkillLevel() {
        return Unit.getSkillLevel(this.unitType);
    }

    public static int getSkillLevel(UnitType unitType) {
        return unitType.hasSkill() ? unitType.getSkill() : 0;
    }

    public Set<Modifier> getMissionaryTradeModifiers(boolean sense) {
        HashSet<Modifier> result = new HashSet<Modifier>();
        for (Modifier m : this.getModifiers("model.modifier.missionaryTradeBonus")) {
            Modifier modifier = new Modifier(m);
            if (!sense) {
                modifier.setValue(-m.getValue());
            }
            result.add(modifier);
        }
        return result;
    }

    public void addFeature(Feature feature) {
        throw new UnsupportedOperationException("Can not add Feature to Unit directly!");
    }

    public ProductionInfo getProductionInfo(List<AbstractGoods> input) {
        ProductionInfo result = new ProductionInfo();
        result.setConsumption(this.getType().getConsumedGoods());
        result.setMaximumConsumption(this.getType().getConsumedGoods());
        return result;
    }

    public int getPioneerScore() {
        int ht;
        int n = ht = this.hasTile() ? 100 : 0;
        return this.getLocation() == null || !this.isColonist() ? -1000 : (this.hasAbility("model.ability.improveTerrain") ? 900 + ht : (this.hasAbility("model.ability.expertPioneer") ? 700 : (!this.hasDefaultRole() ? 0 : (this.getSkillLevel() > 0 ? 0 : 200 + this.getSkillLevel() * 50))));
    }

    public int getScoutScore() {
        int ht;
        int n = ht = this.hasTile() ? 100 : 0;
        return this.getLocation() == null || !this.isColonist() ? -1000 : (this.hasAbility("model.ability.speakWithChief") ? 900 + ht : (this.hasAbility("model.ability.expertScout") ? 700 : (!this.hasDefaultRole() ? 0 : (this.getSkillLevel() <= 0 ? -200 * this.getSkillLevel() : 0))));
    }

    public int evaluateFor(Player player) {
        Europe europe = player.getEurope();
        if (player.isAI() && player.getUnits().size() < 10) {
            return Integer.MIN_VALUE;
        }
        return europe == null ? 500 : europe.getUnitPrice(this.getType());
    }

    public Set<Modifier> getCombatModifiers(String id, FreeColGameObjectType fcgot, Turn turn) {
        Player owner = this.getOwner();
        UnitType unitType = this.getType();
        HashSet<Modifier> result = new HashSet<Modifier>();
        for (Modifier m : unitType.getModifiers(id, fcgot, turn)) {
            switch (m.getType()) {
                case ADDITIVE: {
                    m.setModifierIndex(20);
                    break;
                }
                default: {
                    m.setModifierIndex(40);
                }
            }
            result.add(m);
        }
        for (Modifier m : owner.getModifiers(id, fcgot, turn)) {
            m.setModifierIndex(50);
            result.add(m);
        }
        for (Modifier m : this.role.getModifiers(id, fcgot, turn)) {
            m.setModifierIndex(30);
            result.add(m);
        }
        return result;
    }

    public Tile getNeighbourTile(String directionString) {
        if (!this.hasTile()) {
            throw new IllegalStateException("Unit is not on the map: " + this.getId());
        }
        Direction direction = Enum.valueOf(Direction.class, directionString);
        Tile tile = this.getTile().getNeighbourOrNull(direction);
        if (tile == null) {
            throw new IllegalStateException("Could not find tile in direction: " + direction + " from unit: " + this.getId());
        }
        return tile;
    }

    public Settlement getAdjacentSettlementSafely(String settlementId) throws IllegalStateException {
        Game game = this.getOwner().getGame();
        Settlement settlement = game.getFreeColGameObject(settlementId, Settlement.class);
        if (settlement == null) {
            throw new IllegalStateException("Not a settlement: " + settlementId);
        }
        if (settlement.getTile() == null) {
            throw new IllegalStateException("Settlement is not on the map: " + settlementId);
        }
        if (!this.hasTile()) {
            throw new IllegalStateException("Unit is not on the map: " + this.getId());
        }
        if (this.getTile().getDistanceTo(settlement.getTile()) > 1) {
            throw new IllegalStateException("Unit " + this.getId() + " is not adjacent to settlement: " + settlementId);
        }
        if (this.getOwner() == settlement.getOwner()) {
            throw new IllegalStateException("Unit: " + this.getId() + " and settlement: " + settlementId + " are both owned by player: " + this.getOwner().getId());
        }
        return settlement;
    }

    public IndianSettlement getAdjacentIndianSettlementSafely(String id) throws IllegalStateException {
        Settlement settlement = this.getAdjacentSettlementSafely(id);
        if (!(settlement instanceof IndianSettlement)) {
            throw new IllegalStateException("Not an indianSettlement: " + id);
        }
        if (!this.getOwner().hasContacted(settlement.getOwner())) {
            throw new IllegalStateException("Player has not contacted the " + settlement.getOwner().getNation());
        }
        return (IndianSettlement)settlement;
    }

    @Override
    public List<AbstractGoods> getConsumedGoods() {
        return this.unitType.getConsumedGoods();
    }

    @Override
    public int getPriority() {
        return this.unitType.getPriority();
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Player player) {
        this.owner = player;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public boolean setLocation(Location newLocation) {
        boolean preserveEducation;
        if (newLocation instanceof Colony) {
            return ((Colony)newLocation).joinColony(this);
        }
        if (newLocation == this.location) {
            return true;
        }
        if (newLocation != null && !newLocation.canAdd(this)) {
            logger.warning("Can not add " + this + " to " + newLocation.getId());
            return false;
        }
        Colony oldColony = this.isInColony() ? this.location.getColony() : null;
        Colony newColony = newLocation instanceof WorkLocation ? newLocation.getColony() : null;
        boolean withinColony = newColony != null && newColony == oldColony;
        boolean bl = preserveEducation = withinColony && ((WorkLocation)this.location).canTeach() == ((WorkLocation)newLocation).canTeach();
        if (oldColony != null && !preserveEducation) {
            oldColony.updateEducation(this, false);
        }
        if (this.location != null && !this.location.remove(this)) {
            throw new RuntimeException("Failed to remove " + this + " from " + this.location.getId());
        }
        if (newLocation == null) {
            this.setLocationNoUpdate(null);
        } else if (!newLocation.add(this)) {
            throw new RuntimeException("Failed to add " + this + " to " + newLocation.getId());
        }
        if (newColony != null && !preserveEducation) {
            newColony.updateEducation(this, true);
        }
        if (!withinColony) {
            if (oldColony != null) {
                oldColony.updatePopulation();
            }
            if (newColony != null) {
                newColony.updatePopulation();
            }
        }
        return true;
    }

    @Override
    public boolean isInEurope() {
        return this.location instanceof Unit ? ((Unit)this.location).isInEurope() : this.getLocation() instanceof Europe;
    }

    @Override
    public Tile getTile() {
        return this.location != null ? this.location.getTile() : null;
    }

    @Override
    public StringTemplate getLocationLabel() {
        return StringTemplate.template("model.unit.onBoard").addStringTemplate("%unit%", this.getLabel());
    }

    @Override
    public boolean add(Locatable locatable) {
        if (!this.canAdd(locatable)) {
            return false;
        }
        if (locatable instanceof Unit) {
            Unit unit = (Unit)locatable;
            if (super.add(locatable)) {
                this.spendAllMoves();
                unit.setState(UnitState.SENTRY);
                return true;
            }
        } else if (locatable instanceof Goods) {
            Goods goods = (Goods)locatable;
            if (super.addGoods(goods)) {
                this.spendAllMoves();
                return true;
            }
        } else {
            throw new IllegalStateException("Can not be added to unit: " + locatable);
        }
        return false;
    }

    @Override
    public boolean remove(Locatable locatable) {
        if (locatable == null) {
            throw new IllegalArgumentException("Locatable must not be 'null'.");
        }
        if (locatable instanceof Unit && this.canCarryUnits()) {
            if (super.remove(locatable)) {
                this.spendAllMoves();
                return true;
            }
        } else if (locatable instanceof Goods && this.canCarryGoods()) {
            if (super.removeGoods((Goods)locatable) != null) {
                this.spendAllMoves();
                return true;
            }
        } else {
            logger.warning("Tried to remove from unit: " + locatable);
        }
        return false;
    }

    @Override
    public Settlement getSettlement() {
        Location location = this.getLocation();
        return location != null ? location.getSettlement() : null;
    }

    @Override
    public Location up() {
        return this.isInEurope() ? this.getLocation().up() : (this.isInColony() ? this.getColony() : (this.hasTile() ? this.getTile().up() : this));
    }

    @Override
    public int getRank() {
        return Location.getRank(this.getLocation());
    }

    @Override
    public String toShortString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.getId()).append("-").append(this.getType().getSuffix());
        if (!this.hasDefaultRole()) {
            sb.append("-").append(this.getRoleSuffix());
            int count = this.getRoleCount();
            if (count > 1) {
                sb.append(".").append(count);
            }
        }
        return sb.toString();
    }

    @Override
    public int getSpaceTaken() {
        return this.unitType.getSpaceTaken();
    }

    @Override
    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        if (locatable == this) {
            return UnitLocation.NoAddReason.ALREADY_PRESENT;
        }
        if (locatable instanceof Unit) {
            return !this.canCarryUnits() ? UnitLocation.NoAddReason.WRONG_TYPE : (locatable.getSpaceTaken() > this.getSpaceLeft() ? UnitLocation.NoAddReason.CAPACITY_EXCEEDED : super.getNoAddReason(locatable));
        }
        if (locatable instanceof Goods) {
            Goods goods = (Goods)locatable;
            return !this.canCarryGoods() ? UnitLocation.NoAddReason.WRONG_TYPE : (goods.getAmount() > this.getLoadableAmount(goods.getType()) ? UnitLocation.NoAddReason.CAPACITY_EXCEEDED : UnitLocation.NoAddReason.NONE);
        }
        return super.getNoAddReason(locatable);
    }

    @Override
    public int getGoodsCapacity() {
        return this.getCargoCapacity();
    }

    @Override
    public void disposeResources() {
        if (this.location != null) {
            this.location.remove(this);
        }
        if (this.teacher != null) {
            this.teacher.setStudent(null);
            this.teacher = null;
        }
        if (this.student != null) {
            this.student.setTeacher(null);
            this.student = null;
        }
        this.setHomeIndianSettlement(null);
        this.getOwner().removeUnit(this);
        super.disposeResources();
    }

    @Override
    public FreeColGameObject getLinkTarget(Player player) {
        return this.hasTile() ? (FreeColGameObject)((Object)this.getTile().up()) : player.getEurope();
    }

    @Override
    public int checkIntegrity(boolean fix) {
        int result = super.checkIntegrity(fix);
        if (this.role == null) {
            if (fix) {
                this.role = this.getSpecification().getDefaultRole();
                logger.warning("Fixed missing role for: " + this.getId());
                result = 0;
            } else {
                logger.warning("Missing role for: " + this.getId());
                result = -1;
            }
        }
        if (this.destination != null && ((FreeColGameObject)((Object)this.destination)).isUninitialized()) {
            if (fix) {
                this.destination = null;
                logger.warning("Cleared uninitialized destination for: " + this.getId());
                result = Math.min(result, 0);
            } else {
                logger.warning("Uninitialized destination for: " + this.getId());
                result = -1;
            }
        }
        return result;
    }

    @Override
    public Set<Ability> getAbilities(String id, FreeColGameObjectType fcgot, Turn turn) {
        Player owner = this.getOwner();
        UnitType unitType = this.getType();
        HashSet<Ability> result = new HashSet<Ability>();
        result.addAll(unitType.getAbilities(id));
        result.addAll(this.role.getAbilities(id, fcgot, turn));
        result.addAll(owner.getAbilities(id, fcgot, turn));
        if (this.getSettlement() != null) {
            result.addAll(this.getSettlement().getAbilities(id, unitType, turn));
        } else if (this.isInEurope()) {
            Location loc = this.getLocation();
            Europe europe = loc instanceof Europe ? (Europe)loc : (loc instanceof Unit ? (Europe)((Unit)loc).getLocation() : null);
            result.addAll(europe.getAbilities(id, unitType, turn));
        }
        return result;
    }

    @Override
    public Set<Modifier> getModifiers(String id, FreeColGameObjectType fcgot, Turn turn) {
        Player owner = this.getOwner();
        UnitType unitType = this.getType();
        HashSet<Modifier> result = new HashSet<Modifier>();
        result.addAll(unitType.getModifiers(id, fcgot, turn));
        result.addAll(owner.getModifiers(id, fcgot, turn));
        result.addAll(this.role.getModifiers(id, fcgot, turn));
        return result;
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        boolean full = xw.validFor(this.getOwner());
        if (this.name != null) {
            xw.writeAttribute(NAME_TAG, this.name);
        }
        xw.writeAttribute(UNIT_TYPE_TAG, this.unitType);
        xw.writeAttribute(MOVES_LEFT_TAG, this.movesLeft);
        xw.writeAttribute(STATE_TAG, this.state);
        xw.writeAttribute(ROLE_TAG, this.role);
        xw.writeAttribute(ROLE_COUNT_TAG, this.roleCount);
        if (!full && this.hasAbility("model.ability.piracy")) {
            xw.writeAttribute(OWNER_TAG, this.getGame().getUnknownEnemy());
        } else {
            xw.writeAttribute(OWNER_TAG, this.getOwner());
            if (this.isPerson()) {
                xw.writeAttribute(NATIONALITY_TAG, this.nationality != null ? this.nationality : this.getOwner().getNationId());
                xw.writeAttribute(ETHNICITY_TAG, this.ethnicity != null ? this.ethnicity : this.getOwner().getNationId());
            }
        }
        if (this.location != null) {
            if (!full && this.isInColony()) {
                xw.writeLocationAttribute(LOCATION_TAG, this.getColony());
            } else {
                xw.writeLocationAttribute(LOCATION_TAG, this.location);
            }
        }
        xw.writeAttribute(TREASURE_AMOUNT_TAG, this.treasureAmount);
        if (full) {
            if (this.entryLocation != null) {
                xw.writeLocationAttribute(ENTRY_LOCATION_TAG, this.entryLocation);
            }
            xw.writeAttribute(TURNS_OF_TRAINING_TAG, this.turnsOfTraining);
            if (this.workType != null) {
                xw.writeAttribute(WORK_TYPE_TAG, this.workType);
            }
            if (this.experienceType != null) {
                xw.writeAttribute(EXPERIENCE_TYPE_TAG, this.experienceType);
            }
            xw.writeAttribute(EXPERIENCE_TAG, this.experience);
            xw.writeAttribute(INDIAN_SETTLEMENT_TAG, this.indianSettlement);
            xw.writeAttribute(WORK_LEFT_TAG, this.workLeft);
            xw.writeAttribute(HIT_POINTS_TAG, this.hitPoints);
            xw.writeAttribute(ATTRITION_TAG, this.attrition);
            if (this.student != null) {
                xw.writeAttribute(STUDENT_TAG, this.student);
            }
            if (this.teacher != null) {
                xw.writeAttribute(TEACHER_TAG, this.teacher);
            }
            if (this.destination != null) {
                xw.writeLocationAttribute(DESTINATION_TAG, this.destination);
            }
            if (this.tradeRoute != null) {
                xw.writeAttribute(TRADE_ROUTE_TAG, this.tradeRoute);
                xw.writeAttribute(CURRENT_STOP_TAG, this.currentStop);
            }
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        if (xw.validFor(this.getOwner())) {
            super.writeChildren(xw);
            if (this.workImprovement != null) {
                this.workImprovement.toXML(xw);
            }
        } else if (this.getType().canCarryGoods()) {
            xw.writeAttribute(VISIBLE_GOODS_COUNT_TAG, this.getVisibleGoodsCount());
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        Game game = this.getGame();
        this.name = xr.getAttribute(NAME_TAG, null);
        Player oldOwner = this.owner;
        this.owner = xr.findFreeColGameObject(game, OWNER_TAG, Player.class, null, true);
        if (xr.shouldIntern()) {
            game.checkOwners(this, oldOwner);
        }
        UnitType oldUnitType = this.unitType;
        this.unitType = xr.getType(spec, UNIT_TYPE_TAG, UnitType.class, null);
        this.state = xr.getAttribute(STATE_TAG, UnitState.class, UnitState.ACTIVE);
        this.role = xr.getRole(spec, ROLE_TAG, Role.class, spec.getDefaultRole());
        if (this.owner.isIndian()) {
            if ("model.role.scout".equals(this.role.getId())) {
                this.role = spec.getRole("model.role.mountedBrave");
            } else if ("model.role.soldier".equals(this.role.getId())) {
                this.role = spec.getRole("model.role.armedBrave");
            } else if ("model.role.dragoon".equals(this.role.getId())) {
                this.role = spec.getRole("model.role.nativeDragoon");
            }
        } else if (this.owner.isREF()) {
            if ("model.role.soldier".equals(this.role.getId()) && this.unitType.hasAbility("model.ability.refUnit")) {
                this.role = spec.getRole("model.role.infantry");
            } else if ("model.role.dragoon".equals(this.role.getId()) && this.unitType.hasAbility("model.ability.refUnit")) {
                this.role = spec.getRole("model.role.cavalry");
            } else if ("model.role.infantry".equals(this.role.getId()) && !this.unitType.hasAbility("model.ability.refUnit")) {
                this.role = spec.getRole("model.role.soldier");
            } else if ("model.role.cavalry".equals(this.role.getId()) && !this.unitType.hasAbility("model.ability.refUnit")) {
                this.role = spec.getRole("model.role.dragoon");
            }
        } else if ("model.role.infantry".equals(this.role.getId())) {
            this.role = spec.getRole("model.role.soldier");
        } else if ("model.role.cavalry".equals(this.role.getId())) {
            this.role = spec.getRole("model.role.dragoon");
        }
        this.roleCount = xr.getAttribute(ROLE_COUNT_TAG, -1);
        this.location = xr.getLocationAttribute(game, LOCATION_TAG, true);
        this.entryLocation = xr.getLocationAttribute(game, ENTRY_LOCATION_TAG, true);
        this.movesLeft = xr.getAttribute(MOVES_LEFT_TAG, 0);
        this.workLeft = xr.getAttribute(WORK_LEFT_TAG, 0);
        this.attrition = xr.getAttribute(ATTRITION_TAG, 0);
        this.nationality = xr.getAttribute(NATIONALITY_TAG, null);
        this.ethnicity = xr.getAttribute(ETHNICITY_TAG, null);
        this.turnsOfTraining = xr.getAttribute(TURNS_OF_TRAINING_TAG, 0);
        this.hitPoints = xr.getAttribute(HIT_POINTS_TAG, -1);
        if (this.hitPoints < 0) {
            this.hitPoints = xr.getAttribute(OLD_HIT_POINTS_TAG, -1);
        }
        this.teacher = xr.makeFreeColGameObject(game, TEACHER_TAG, Unit.class, false);
        this.student = xr.makeFreeColGameObject(game, STUDENT_TAG, Unit.class, false);
        this.setHomeIndianSettlement(xr.makeFreeColGameObject(game, INDIAN_SETTLEMENT_TAG, IndianSettlement.class, false));
        this.treasureAmount = xr.getAttribute(TREASURE_AMOUNT_TAG, 0);
        this.destination = xr.getLocationAttribute(game, DESTINATION_TAG, true);
        this.tradeRoute = xr.findFreeColGameObject(game, TRADE_ROUTE_TAG, TradeRoute.class, null, false);
        this.currentStop = this.tradeRoute == null ? -1 : xr.getAttribute(CURRENT_STOP_TAG, 0);
        this.experienceType = xr.getType(spec, EXPERIENCE_TYPE_TAG, GoodsType.class, null);
        if (this.experienceType == null && this.workType != null) {
            this.experienceType = this.workType;
        }
        this.experience = xr.getAttribute(EXPERIENCE_TAG, 0);
        this.visibleGoodsCount = xr.getAttribute(VISIBLE_GOODS_COUNT_TAG, -1);
        this.changeWorkType(xr.getType(spec, WORK_TYPE_TAG, GoodsType.class, null));
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (this.getGoodsContainer() != null) {
            this.getGoodsContainer().removeAll();
        }
        this.equipment.clear();
        this.workImprovement = null;
        super.readChildren(xr);
        if (this.roleCount < 0) {
            Specification spec = this.getSpecification();
            Role role = spec.getDefaultRole();
            boolean horses = false;
            boolean muskets = false;
            int count = 1;
            for (EquipmentType type : this.equipment.keySet()) {
                if ("model.equipment.horses".equals(type.getId()) || "model.equipment.indian.horses".equals(type.getId())) {
                    horses = true;
                    continue;
                }
                if ("model.equipment.muskets".equals(type.getId()) || "model.equipment.indian.muskets".equals(type.getId())) {
                    muskets = true;
                    continue;
                }
                role = type.getRole();
                if (!"model.equipment.tools".equals(type.getId())) continue;
                count = this.equipment.getCount(type);
            }
            if (horses && muskets) {
                role = this.owner.isIndian() ? spec.getRole("model.role.nativeDragoon") : (this.owner.isREF() && this.hasAbility("model.ability.refUnit") ? spec.getRole("model.role.cavalry") : spec.getRole("model.role.dragoon"));
            } else if (horses) {
                if (this.owner.isIndian()) {
                    role = spec.getRole("model.role.mountedBrave");
                } else if (this.owner.isREF() && this.hasAbility("model.ability.refUnit")) {
                    logger.warning("Undefined role: REF Scout");
                } else {
                    role = spec.getRole("model.role.scout");
                }
            } else if (muskets) {
                role = this.owner.isIndian() ? spec.getRole("model.role.armedBrave") : (this.owner.isREF() && this.hasAbility("model.ability.refUnit") ? spec.getRole("model.role.infantry") : spec.getRole("model.role.soldier"));
            }
            this.setRoleCount(Math.min(role.getMaximumCount(), count));
        } else {
            this.equipment.clear();
        }
        if (this.workImprovement != null && this.workImprovement.getTile() == null) {
            this.workImprovement = null;
        }
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if (EQUIPMENT_TAG.equals(tag)) {
            this.equipment.incrementCount(spec.getEquipmentType(xr.readId()), xr.getAttribute(COUNT_TAG, 0));
            xr.closeTag(EQUIPMENT_TAG);
        } else if (OLD_UNITS_TAG.equals(tag)) {
            while (xr.nextTag() != 2) {
                super.readChild(xr);
            }
        } else if (TileImprovement.getXMLElementTagName().equals(tag) || OLD_TILE_IMPROVEMENT_TAG.equals(tag)) {
            this.workImprovement = xr.readFreeColGameObject(game, TileImprovement.class);
        } else {
            super.readChild(xr);
        }
    }

    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder(64);
        sb.append("[").append(prefix).append(this.getId());
        if (this.isUninitialized()) {
            sb.append(" uninitialized");
        } else if (this.isDisposed()) {
            sb.append(" disposed");
        } else {
            sb.append(" ").append(StringUtils.lastPart(this.owner.getNationId(), ".")).append(" ").append(this.getType().getSuffix());
            if (!this.hasDefaultRole()) {
                sb.append("-").append(this.getRoleSuffix());
                int count = this.getRoleCount();
                if (count > 1) {
                    sb.append(".").append(count);
                }
            }
            sb.append(" ").append(this.getMovesAsString());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public String getXMLTagName() {
        return Unit.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "unit";
    }

    public static enum MoveType {
        MOVE(null, true),
        MOVE_HIGH_SEAS(null, true),
        EXPLORE_LOST_CITY_RUMOUR(null, true),
        ATTACK_UNIT(null, false),
        ATTACK_SETTLEMENT(null, false),
        EMBARK(null, false),
        ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST(null, false),
        ENTER_INDIAN_SETTLEMENT_WITH_SCOUT(null, false),
        ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY(null, false),
        ENTER_FOREIGN_COLONY_WITH_SCOUT(null, false),
        ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS(null, false),
        MOVE_NO_MOVES("Attempt to move without moves left"),
        MOVE_NO_ACCESS_LAND("Attempt to move a naval unit onto land"),
        MOVE_NO_ACCESS_BEACHED("Attempt to move onto foreign beached ship"),
        MOVE_NO_ACCESS_EMBARK("Attempt to embark onto absent or foreign carrier"),
        MOVE_NO_ACCESS_FULL("Attempt to embark onto full carrier"),
        MOVE_NO_ACCESS_GOODS("Attempt to trade without goods"),
        MOVE_NO_ACCESS_CONTACT("Attempt to interact with natives before contact"),
        MOVE_NO_ACCESS_MISSION_BAN("Attempt to use missionary at banned settlement"),
        MOVE_NO_ACCESS_SETTLEMENT("Attempt to move into foreign settlement"),
        MOVE_NO_ACCESS_SKILL("Attempt to learn skill with incapable unit"),
        MOVE_NO_ACCESS_TRADE("Attempt to trade without authority"),
        MOVE_NO_ACCESS_WAR("Attempt to trade while at war"),
        MOVE_NO_ACCESS_WATER("Attempt to move into a settlement by water"),
        MOVE_NO_ATTACK_CIVILIAN("Attempt to attack with civilian unit"),
        MOVE_NO_ATTACK_MARINE("Attempt to attack from on board ship"),
        MOVE_NO_EUROPE("Attempt to move to Europe by incapable unit"),
        MOVE_NO_REPAIR("Attempt to move a unit that is under repair"),
        MOVE_NO_TILE("Attempt to move when not on a tile"),
        MOVE_ILLEGAL("Unspecified illegal move");

        private final String reason;
        private final boolean progress;

        private MoveType(String reason) {
            this.reason = reason;
            this.progress = false;
        }

        private MoveType(String reason, boolean progress) {
            this.reason = reason;
            this.progress = progress;
        }

        public boolean isLegal() {
            return this.reason == null;
        }

        public String whyIllegal() {
            return this.reason == null ? "(none)" : this.reason;
        }

        public boolean isProgress() {
            return this.progress;
        }

        public boolean isAttack() {
            return this == ATTACK_UNIT || this == ATTACK_SETTLEMENT;
        }
    }

    public static enum UnitLabelType {
        PLAIN,
        NATIONAL,
        FULL;

    }

    public static enum UnitState {
        ACTIVE,
        FORTIFIED,
        SENTRY,
        IN_COLONY,
        IMPROVING,
        TO_EUROPE,
        TO_AMERICA,
        FORTIFYING,
        SKIPPED;


        public String getKey() {
            return "unitState." + StringUtils.getEnumKey(this);
        }
    }
}

