/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.settings;

import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFileChooser;
import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;

public class SaveConfig
extends GenericFunction {
    public SaveConfig(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.saveconfig";
    }

    @Override
    public void begin() {
        File file = Config.getConfigFile();
        if (file == null) {
            file = Config.HOME_CONFIG_FILE;
        }
        JFileChooser jFileChooser = new JFileChooser(file.getAbsoluteFile().getParent());
        jFileChooser.setSelectedFile(file);
        int n = jFileChooser.showSaveDialog(this._parentFrame);
        if (n == 0) {
            File file2 = jFileChooser.getSelectedFile();
            this.saveConfig(file2);
        }
    }

    public void silentSave() {
        this.saveConfig(Config.getConfigFile());
    }

    public void autosaveSwitched(boolean bl) {
        File file = Config.getConfigFile();
        if (bl && file == null) {
            this.begin();
        } else if (!bl && file != null) {
            this.silentSave();
        }
    }

    private void saveConfig(File file) {
        block14: {
            Rectangle rectangle = this._app.getFrame().getBounds();
            String string = rectangle.x + "x" + rectangle.y + "x" + rectangle.width + "x" + rectangle.height;
            Config.setConfigString("prune.windowbounds", string);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(file);
                Config.getAllConfig().store(fileOutputStream, "GpsPrune config file");
            }
            catch (IOException iOException) {
                this._app.showErrorMessageNoLookup(this.getNameKey(), String.valueOf(I18nManager.getText("error.save.failed")) + " : " + iOException.getMessage());
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
                break block14;
            }
            catch (NullPointerException nullPointerException) {
                try {}
                catch (Throwable throwable) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
                break block14;
            }
            try {
                fileOutputStream.close();
            }
            catch (Exception exception) {}
        }
        Config.setConfigFile(file);
    }
}

