/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.runtime.memoize;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.ThreadSafe;
import org.codehaus.groovy.runtime.memoize.CommonCache;
import org.codehaus.groovy.runtime.memoize.EvictableCache;
import org.codehaus.groovy.runtime.memoize.MemoizeCache;
import org.codehaus.groovy.runtime.memoize.ValueConvertable;

@ThreadSafe
public class ConcurrentCommonCache<K, V>
implements EvictableCache<K, V>,
ValueConvertable<V, Object>,
Serializable {
    private static final long serialVersionUID = -7352338549333024936L;
    private final ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock.ReadLock readLock = this.rwl.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.rwl.writeLock();
    private final CommonCache<K, V> commonCache;

    public ConcurrentCommonCache() {
        this.commonCache = new CommonCache();
    }

    public ConcurrentCommonCache(int initialCapacity, int maxSize, EvictableCache.EvictionStrategy evictionStrategy) {
        this.commonCache = new CommonCache(initialCapacity, maxSize, evictionStrategy);
    }

    public ConcurrentCommonCache(int initialCapacity, int maxSize) {
        this.commonCache = new CommonCache(initialCapacity, maxSize);
    }

    public ConcurrentCommonCache(int maxSize) {
        this.commonCache = new CommonCache(maxSize);
    }

    public ConcurrentCommonCache(Map<K, V> map) {
        this.commonCache = new CommonCache<K, V>(map);
    }

    @Override
    public V get(Object key) {
        this.readLock.lock();
        try {
            V v = this.commonCache.get(key);
            return v;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        this.writeLock.lock();
        try {
            V v = this.commonCache.put(key, value);
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public V getAndPut(K key, MemoizeCache.ValueProvider<? super K, ? extends V> valueProvider) {
        return this.getAndPut(key, valueProvider, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getAndPut(K key, MemoizeCache.ValueProvider<? super K, ? extends V> valueProvider, boolean shouldCache) {
        V value;
        this.readLock.lock();
        try {
            value = this.commonCache.get((Object)key);
            if (null != this.convertValue(value)) {
                V v = value;
                return v;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.writeLock.lock();
        try {
            value = this.commonCache.get((Object)key);
            if (null != this.convertValue(value)) {
                V v = value;
                return v;
            }
            value = null == valueProvider ? null : valueProvider.provide((K)key);
            Object v0 = value;
            if (shouldCache && null != this.convertValue(value)) {
                this.commonCache.put(key, value);
            }
        }
        finally {
            this.writeLock.unlock();
        }
        return value;
    }

    @Override
    public Collection<V> values() {
        this.readLock.lock();
        try {
            Collection<V> collection = this.commonCache.values();
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.readLock.lock();
        try {
            Set<Map.Entry<K, V>> set = this.commonCache.entrySet();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Set<K> keys() {
        this.readLock.lock();
        try {
            Set<K> set = this.commonCache.keys();
            return set;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean containsKey(Object key) {
        this.readLock.lock();
        try {
            boolean bl = this.commonCache.containsKey(key);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean containsValue(Object value) {
        this.readLock.lock();
        try {
            boolean bl = this.commonCache.containsValue(value);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public int size() {
        this.readLock.lock();
        try {
            int n = this.commonCache.size();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public V remove(Object key) {
        this.writeLock.lock();
        try {
            V v = this.commonCache.remove(key);
            return v;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.writeLock.lock();
        try {
            this.commonCache.putAll(m);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Set<K> keySet() {
        return this.keys();
    }

    @Override
    public Map<K, V> clearAll() {
        this.writeLock.lock();
        try {
            Map<K, V> map = this.commonCache.clearAll();
            return map;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void clear() {
        this.clearAll();
    }

    @Override
    public void cleanUpNullReferences() {
        this.writeLock.lock();
        try {
            this.commonCache.cleanUpNullReferences();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Object convertValue(V value) {
        return value;
    }

    private <R> R doWithWriteLock(Action<K, V, R> action) {
        this.writeLock.lock();
        try {
            R r = action.doWith(this.commonCache);
            return r;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private <R> R doWithReadLock(Action<K, V, R> action) {
        this.readLock.lock();
        try {
            R r = action.doWith(this.commonCache);
            return r;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public static interface Action<K, V, R> {
        public R doWith(CommonCache<K, V> var1);
    }
}

