/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context.env;

import io.micronaut.context.exceptions.ConfigurationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public interface PropertySourceReader {
    public Map<String, Object> read(String var1, InputStream var2) throws IOException;

    default public Set<String> getExtensions() {
        return Collections.emptySet();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    default public Map<String, Object> read(String name, byte[] bytes) {
        try (ByteArrayInputStream input = new ByteArrayInputStream(bytes);){
            Map<String, Object> map = this.read(name, input);
            return map;
        }
        catch (Throwable e) {
            throw new ConfigurationException("Error reading property source [" + name + "]: " + e.getMessage(), e);
        }
    }
}

