/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.testng.TestNGException;
import org.testng.internal.reflect.Parameter;
import org.testng.internal.reflect.ReflectionRecipes;

public class MethodMatcherException
extends TestNGException {
    public MethodMatcherException(String string, Method method, Object[] objectArray) {
        this(MethodMatcherException.generateMessage(string, method, objectArray));
    }

    public MethodMatcherException(String string) {
        super(string);
    }

    public MethodMatcherException(String string, Throwable throwable) {
        super(string, throwable);
    }

    public MethodMatcherException(Throwable throwable) {
        super(throwable);
    }

    static String generateMessage(String string, Constructor constructor, Object[] objectArray) {
        Parameter[] parameterArray = null;
        String string2 = null;
        if (constructor != null) {
            parameterArray = ReflectionRecipes.getConstructorParameters(constructor);
            string2 = constructor.getName();
        }
        return MethodMatcherException.generateMessage(string, string2, "Constructor", parameterArray, objectArray);
    }

    public static String generateMessage(String string, Method method, Object[] objectArray) {
        Parameter[] parameterArray = null;
        String string2 = null;
        if (method != null) {
            parameterArray = ReflectionRecipes.getMethodParameters(method);
            string2 = method.getName();
        }
        return MethodMatcherException.generateMessage(string, string2, "Method", parameterArray, objectArray);
    }

    private static String generateMessage(String string, String string2, String string3, Parameter[] parameterArray, Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string).append("\n").append(string3).append(": ");
        if (string2 != null) {
            stringBuilder.append(string2).append("(").append(Arrays.toString(parameterArray)).append(")");
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append("\n").append("Arguments: ");
        if (objectArray != null) {
            stringBuilder.append("[");
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object != null) {
                    stringBuilder.append("(").append(object.getClass().getName()).append(") ").append(MethodMatcherException.stringify(object));
                } else {
                    stringBuilder.append("null");
                }
                if (i >= objectArray.length - 1) continue;
                stringBuilder.append(",");
            }
            stringBuilder.append("]");
        } else {
            stringBuilder.append("Arguments: null");
        }
        return stringBuilder.toString();
    }

    private static String stringify(Object object) {
        if (object.getClass().isArray()) {
            return Arrays.toString((Object[])object);
        }
        return object.toString();
    }
}

