/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.janocchio;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import org.openscience.jmol.app.janocchio.Measure;

class NMRTableCellRenderer
extends DefaultTableCellRenderer {
    Color red = new Color(255, 200, 200);
    Color yellow = new Color(255, 255, 200);
    Color green = new Color(200, 255, 200);
    Color white = new Color(255, 255, 255);
    double redLevel;
    double yellowLevel;

    public void setRedLevel(double d) {
        this.redLevel = d;
    }

    public void setYellowLevel(double d) {
        this.yellowLevel = d;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setBackground(this.white);
            if (value != null && ((Measure)value).getExpValue() != null) {
                try {
                    double myValue = ((Measure)value).getDiff();
                    if (myValue >= this.redLevel) {
                        this.setBackground(this.red);
                    } else if (myValue >= this.yellowLevel && myValue < this.redLevel) {
                        this.setBackground(this.yellow);
                    } else {
                        this.setBackground(this.green);
                    }
                }
                catch (Exception e) {
                    this.setBackground(this.white);
                }
            }
        }
        this.setFont(table.getFont());
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                super.setForeground(UIManager.getColor("Table.focusCellForeground"));
                super.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(noFocusBorder);
        }
        this.setText(((Measure)value).round());
        return this;
    }
}

