/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.jpeg;

import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class JpegSegmentData {
    @NotNull
    private final HashMap<Byte, List<byte[]>> _segmentDataMap = new HashMap(10);

    public void addSegment(byte segmentType, @NotNull byte[] segmentBytes) {
        this.getOrCreateSegmentList(segmentType).add(segmentBytes);
    }

    public Iterable<JpegSegmentType> getSegmentTypes() {
        HashSet<JpegSegmentType> segmentTypes = new HashSet<JpegSegmentType>();
        for (Byte segmentTypeByte : this._segmentDataMap.keySet()) {
            JpegSegmentType segmentType = JpegSegmentType.fromByte(segmentTypeByte);
            if (segmentType == null) {
                throw new IllegalStateException("Should not have a segmentTypeByte that is not in the enum: " + Integer.toHexString(segmentTypeByte.byteValue()));
            }
            segmentTypes.add(segmentType);
        }
        return segmentTypes;
    }

    @Nullable
    public byte[] getSegment(byte segmentType) {
        return this.getSegment(segmentType, 0);
    }

    @Nullable
    public byte[] getSegment(@NotNull JpegSegmentType segmentType) {
        return this.getSegment(segmentType.byteValue, 0);
    }

    @Nullable
    public byte[] getSegment(@NotNull JpegSegmentType segmentType, int occurrence) {
        return this.getSegment(segmentType.byteValue, occurrence);
    }

    @Nullable
    public byte[] getSegment(byte segmentType, int occurrence) {
        List<byte[]> segmentList = this.getSegmentList(segmentType);
        return segmentList != null && segmentList.size() > occurrence ? segmentList.get(occurrence) : null;
    }

    @NotNull
    public Iterable<byte[]> getSegments(@NotNull JpegSegmentType segmentType) {
        return this.getSegments(segmentType.byteValue);
    }

    @NotNull
    public Iterable<byte[]> getSegments(byte segmentType) {
        ArrayList segmentList = this.getSegmentList(segmentType);
        return segmentList == null ? new ArrayList() : segmentList;
    }

    @Nullable
    private List<byte[]> getSegmentList(byte segmentType) {
        return this._segmentDataMap.get(segmentType);
    }

    @NotNull
    private List<byte[]> getOrCreateSegmentList(byte segmentType) {
        ArrayList<byte[]> segmentList;
        if (this._segmentDataMap.containsKey(segmentType)) {
            segmentList = this._segmentDataMap.get(segmentType);
        } else {
            segmentList = new ArrayList();
            this._segmentDataMap.put(segmentType, segmentList);
        }
        return segmentList;
    }

    public int getSegmentCount(@NotNull JpegSegmentType segmentType) {
        return this.getSegmentCount(segmentType.byteValue);
    }

    public int getSegmentCount(byte segmentType) {
        List<byte[]> segmentList = this.getSegmentList(segmentType);
        return segmentList == null ? 0 : segmentList.size();
    }

    public void removeSegmentOccurrence(@NotNull JpegSegmentType segmentType, int occurrence) {
        this.removeSegmentOccurrence(segmentType.byteValue, occurrence);
    }

    public void removeSegmentOccurrence(byte segmentType, int occurrence) {
        List<byte[]> segmentList = this._segmentDataMap.get(segmentType);
        segmentList.remove(occurrence);
    }

    public void removeSegment(@NotNull JpegSegmentType segmentType) {
        this.removeSegment(segmentType.byteValue);
    }

    public void removeSegment(byte segmentType) {
        this._segmentDataMap.remove(segmentType);
    }

    public boolean containsSegment(@NotNull JpegSegmentType segmentType) {
        return this.containsSegment(segmentType.byteValue);
    }

    public boolean containsSegment(byte segmentType) {
        return this._segmentDataMap.containsKey(segmentType);
    }
}

