/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import javax.swing.JCheckBoxMenuItem;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.spi.preferences.PreferenceChangeEvent;
import org.openstreetmap.josm.spi.preferences.PreferenceChangedListener;

public class PreferenceToggleAction
extends JosmAction
implements PreferenceChangedListener {
    private final JCheckBoxMenuItem checkbox;
    private final BooleanProperty pref;

    public PreferenceToggleAction(String name, String tooltip, BooleanProperty pref) {
        super(name, null, tooltip, null, false);
        this.setToolbarId("toggle-" + pref.getKey());
        this.pref = pref;
        this.checkbox = new JCheckBoxMenuItem(this);
        this.checkbox.setSelected(pref.get());
        Preferences.main().addWeakKeyPreferenceChangeListener(pref.getKey(), this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.pref.put(this.checkbox.isSelected());
    }

    public JCheckBoxMenuItem getCheckbox() {
        return this.checkbox;
    }

    @Override
    public void preferenceChanged(PreferenceChangeEvent e) {
        this.checkbox.setSelected(this.pref.get());
    }
}

