/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jnr.posix.util.Platform;
import junit.framework.TestCase;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public class PySystemStateTest
extends TestCase {
    private static List<JarExample> jarExamples = Arrays.asList(new JarExample("/some_dir/some.jar", "a/package/with/A.class", "/some_dir/some.jar"), new JarExample("/some%20dir/some.jar", "a/package/with/A.class", "/some dir/some.jar"), new JarExample("/some+dir/some.jar", "a/package/with/A.class", "/some+dir/some.jar"), new JarExample("/n%c3%a5gon/katalog/r%c3%a4tt.jar", "en/f%c3%b6rpackning/med/En.class", "/n\u00e5gon/katalog/r\u00e4tt.jar"));

    public void testGetJarFileNameFromURL() throws Exception {
        PySystemStateTest.assertNull((Object)Py.getJarFileNameFromURL(null));
        for (JarExample ex : jarExamples) {
            URL url = new URL("jar:file:" + ex.urlJarPath + "!/" + ex.urlClassPath);
            PySystemStateTest.assertEquals((String)ex.filePath, (String)Py.getJarFileNameFromURL(url));
        }
    }

    public void testGetJarFileNameFromURL_jboss() throws Exception {
        String protocol = "vfszip";
        String host = "";
        int port = -1;
        TestJBossURLStreamHandler handler = new TestJBossURLStreamHandler();
        String classPart = "/org/python/core/PySystemState.class";
        if (Platform.IS_WINDOWS) {
            String file = "/C:/some_dir/some.jar/org/python/core/PySystemState.class";
            URL url = new URL("vfszip", "", -1, file, handler);
            PySystemStateTest.assertEquals((String)"vfszip:/C:/some_dir/some.jar/org/python/core/PySystemState.class", (String)url.toString());
            String result = Py.getJarFileNameFromURL(url);
            PySystemStateTest.assertEquals((String)"C:\\some_dir\\some.jar", (String)result);
            file = "/C:/some%20dir/some.jar/org/python/core/PySystemState.class";
            url = new URL("vfszip", "", -1, file, handler);
            PySystemStateTest.assertEquals((String)"vfszip:/C:/some%20dir/some.jar/org/python/core/PySystemState.class", (String)url.toString());
            result = Py.getJarFileNameFromURL(url);
            PySystemStateTest.assertEquals((String)"C:\\some dir\\some.jar", (String)result);
            file = "/C:/some+dir/some.jar/org/python/core/PySystemState.class";
            url = new URL("vfszip", "", -1, file, handler);
            PySystemStateTest.assertEquals((String)"vfszip:/C:/some+dir/some.jar/org/python/core/PySystemState.class", (String)url.toString());
            result = Py.getJarFileNameFromURL(url);
            PySystemStateTest.assertEquals((String)"C:\\some+dir\\some.jar", (String)result);
            file = "/C:/n%c3%a5gon/katalog/r%c3%a4tt.jar/org/python/core/PySystemState.class";
            url = new URL("vfszip", "", -1, file, handler);
            PySystemStateTest.assertEquals((String)"vfszip:/C:/n%c3%a5gon/katalog/r%c3%a4tt.jar/org/python/core/PySystemState.class", (String)url.toString());
            result = Py.getJarFileNameFromURL(url);
            PySystemStateTest.assertEquals((String)"C:\\n\u00e5gon\\katalog\\r\u00e4tt.jar", (String)result);
        } else {
            String file = "/some_dir/some.jar/org/python/core/PySystemState.class";
            URL url = new URL("vfszip", "", -1, file, handler);
            PySystemStateTest.assertEquals((String)"vfszip:/some_dir/some.jar/org/python/core/PySystemState.class", (String)url.toString());
            String result = Py.getJarFileNameFromURL(url);
            PySystemStateTest.assertEquals((String)"/some_dir/some.jar", (String)result);
            file = "/some dir/some.jar/org/python/core/PySystemState.class";
            url = new URL("vfszip", "", -1, file, handler);
            PySystemStateTest.assertEquals((String)"vfszip:/some%20dir/some.jar/org/python/core/PySystemState.class", (String)url.toString());
            result = Py.getJarFileNameFromURL(url);
            PySystemStateTest.assertEquals((String)"/some dir/some.jar", (String)result);
            file = "/some+dir/some.jar/org/python/core/PySystemState.class";
            url = new URL("vfszip", "", -1, file, handler);
            PySystemStateTest.assertEquals((String)"vfszip:/some+dir/some.jar/org/python/core/PySystemState.class", (String)url.toString());
            result = Py.getJarFileNameFromURL(url);
            PySystemStateTest.assertEquals((String)"/some+dir/some.jar", (String)result);
            file = "/n%c3%a5gon/katalog/r%c3%a4tt.jar/org/python/core/PySystemState.class";
            url = new URL("vfszip", "", -1, file, handler);
            PySystemStateTest.assertEquals((String)"vfszip:/n%c3%a5gon/katalog/r%c3%a4tt.jar/org/python/core/PySystemState.class", (String)url.toString());
            result = Py.getJarFileNameFromURL(url);
            PySystemStateTest.assertEquals((String)"/n\u00e5gon/katalog/r\u00e4tt.jar", (String)result);
        }
    }

    public void testImport() throws Exception {
        Options.importSite = false;
        try {
            PySystemState pySystemState = new PySystemState();
            PySystemState.initialize();
            PythonInterpreter interpreter = new PythonInterpreter(null, pySystemState);
            interpreter.exec("import os");
            PySystemStateTest.assertTrue((boolean)interpreter.getSystemState().modules.__contains__(new PyString("os")));
        }
        finally {
            Options.importSite = true;
        }
    }

    static {
        if (Platform.IS_WINDOWS) {
            jarExamples = new ArrayList<JarExample>(jarExamples);
            jarExamples.add(new JarExample("/C:/some_dir/some.jar", "a/package/with/A.class", "C:\\some_dir\\some.jar", true));
            jarExamples.add(new JarExample("/E:/n%c3%a5gon/katalog/r%c3%a4tt.jar", "med/En.class", "E:\\n\u00e5gon\\katalog\\r\u00e4tt.jar", true));
            String p = "/org/python/version.properies";
            String r = "\\\\localhost\\shared\\jython-dev.jar";
            jarExamples.add(new JarExample("////localhost/shared/jython-dev.jar", p, r, true));
            jarExamples.add(new JarExample("//localhost/shared/jython-dev.jar", p, r, true));
            r = "\\\\localhost\\shared\\jy thon%dev.jar";
            jarExamples.add(new JarExample("////localhost/shared/jy%20thon%25dev.jar", p, r, true));
            jarExamples.add(new JarExample("//localhost/shared/jy%20thon%25dev.jar", p, r, true));
        }
    }

    protected static class TestJBossURLStreamHandler
    extends URLStreamHandler {
        protected TestJBossURLStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            throw new RuntimeException("unexpected call to openConnection " + u.toString());
        }
    }

    private static class JarExample {
        final String urlJarPath;
        final String urlClassPath;
        final String filePath;

        JarExample(String urlJarPath, String urlClassPath, String unixPath) {
            this(urlJarPath, urlClassPath, Platform.IS_WINDOWS ? new File(unixPath).toString() : unixPath, true);
        }

        JarExample(String urlJarPath, String urlClassPath, String filePath, boolean ignored) {
            this.urlJarPath = urlJarPath;
            this.urlClassPath = urlClassPath;
            this.filePath = filePath;
        }
    }
}

