/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.inline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.CommonCoroutineCodegenUtilKt;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.ir.Symbols;
import org.jetbrains.kotlin.backend.common.lower.CoroutineIntrinsicLambdaOrigin;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.inline.DeepCopyIrTreeWithSymbolsForInliner;
import org.jetbrains.kotlin.backend.common.lower.inline.InlinerExpressionLocationHint;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrReturnableBlock;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallWithIndexedArgumentsBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnableBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTerminalDeclarationReferenceBase;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrVarargImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.IrReturnableBlockSymbolImpl;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u00020\b*\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/inline/FunctionInlining;", "Lorg/jetbrains/kotlin/backend/common/IrElementTransformerVoidWithContext;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "needsInlining", "", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getNeedsInlining", "(Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)Z", "getFunctionDeclaration", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "inline", "Lorg/jetbrains/kotlin/ir/IrElement;", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "visitFunctionAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "Inliner", "IrGetValueWithoutLocation", "ir.backend.common"})
public final class FunctionInlining
extends IrElementTransformerVoidWithContext {
    @NotNull
    private final CommonBackendContext context;

    @NotNull
    public final IrElement inline(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkParameterIsNotNull(irModule, "irModule");
        return (IrElement)irModule.accept(this, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrExpression visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$mapTo$iv$iv;
        IrFunction irFunction;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
        IrFunctionAccessExpression irFunctionAccessExpression = expression2;
        if (irFunctionAccessExpression instanceof IrCall) {
            irFunction = expression2.getSymbol().getOwner();
        } else if (irFunctionAccessExpression instanceof IrConstructorCall) {
            irFunction = ((IrConstructorCall)expression2).getSymbol().getOwner();
        } else {
            return expression2;
        }
        IrFunction callee = irFunction;
        if (!this.getNeedsInlining(callee)) {
            return expression2;
        }
        if (Symbols.Companion.isLateinitIsInitializedPropertyGetter(callee.getSymbol())) {
            return expression2;
        }
        if (Symbols.Companion.isTypeOfIntrinsic(callee.getSymbol())) {
            return expression2;
        }
        IrFunction actualCallee = this.getFunctionDeclaration(callee.getSymbol());
        Iterable $this$map$iv = this.getAllScopes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ScopeWithIr scopeWithIr = (ScopeWithIr)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrElement irElement = it.getIrElement();
            collection.add(irElement);
        }
        Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filterIsInstance = false;
        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrDeclarationParent)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        IrDeclarationParent parent2 = (IrDeclarationParent)CollectionsKt.lastOrNull((List)destination$iv$iv);
        ScopeWithIr scopeWithIr = this.getCurrentScope();
        if (scopeWithIr == null) {
            Intrinsics.throwNpe();
        }
        Inliner inliner = new Inliner(expression2, actualCallee, scopeWithIr, parent2, this.context);
        return inliner.inline();
    }

    private final IrFunction getFunctionDeclaration(IrFunctionSymbol symbol2) {
        Object object;
        FunctionDescriptor functionDescriptor = symbol2.getDescriptor().getOriginal();
        Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "symbol.descriptor.original");
        FunctionDescriptor descriptor2 = functionDescriptor;
        LanguageVersionSettings languageVersionSettings = CommonConfigurationKeysKt.getLanguageVersionSettings(this.context.getConfiguration());
        if (CommonCoroutineCodegenUtilKt.isBuiltInIntercepted(descriptor2, languageVersionSettings)) {
            String string2 = "Continuation.intercepted is not available with release coroutines";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        if (CommonCoroutineCodegenUtilKt.isBuiltInSuspendCoroutineUninterceptedOrReturn(descriptor2, languageVersionSettings)) {
            object = this.context.getIr().getSymbols().getSuspendCoroutineUninterceptedOrReturn().getOwner();
        } else if (Intrinsics.areEqual(symbol2, this.context.getIr().getSymbols().getCoroutineContextGetter())) {
            object = this.context.getIr().getSymbols().getCoroutineGetContext().getOwner();
        } else {
            IrSimpleFunction irSimpleFunction;
            IrFunction irFunction = symbol2.getOwner();
            if (!(irFunction instanceof IrSimpleFunction)) {
                irFunction = null;
            }
            object = (irSimpleFunction = (IrSimpleFunction)irFunction) != null && (irSimpleFunction = IrUtilsKt.resolveFakeOverride(irSimpleFunction)) != null ? (IrFunction)irSimpleFunction : symbol2.getOwner();
        }
        return object;
    }

    private final boolean getNeedsInlining(@NotNull IrFunction $this$needsInlining) {
        return $this$needsInlining.isInline() && !$this$needsInlining.isExternal();
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    public FunctionInlining(@NotNull CommonBackendContext context2) {
        Intrinsics.checkParameterIsNotNull(context2, "context");
        this.context = context2;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0002<=B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ&\u0010!\u001a\u0010\u0012\f\u0012\n0#R\u00060\u0000R\u00020$0\"2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\"2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\"2\u0006\u0010'\u001a\u00020(H\u0002J\u0006\u0010)\u001a\u00020*J \u0010+\u001a\u00020*2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-H\u0002J\u0010\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u000200H\u0002J\u0014\u00101\u001a\u00020\u001e*\u00020\u001e2\u0006\u00102\u001a\u000203H\u0002J\f\u00104\u001a\u00020-*\u00020\u001dH\u0002J3\u00105\u001a\u000206\"\n\b\u0000\u00107\u0018\u0001*\u000208*\b\u0012\u0004\u0012\u0002H7092\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u0002H7\u0012\u0004\u0012\u0002080;H\u0082\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001d\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/inline/FunctionInlining$Inliner;", "", "callSite", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "callee", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "currentScope", "Lorg/jetbrains/kotlin/backend/common/ScopeWithIr;", "parent", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/lower/inline/FunctionInlining;Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/backend/common/ScopeWithIr;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "getCallSite", "()Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "getCallee", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "copyIrElement", "Lorg/jetbrains/kotlin/backend/common/lower/inline/DeepCopyIrTreeWithSymbolsForInliner;", "getCopyIrElement", "()Lorg/jetbrains/kotlin/backend/common/lower/inline/DeepCopyIrTreeWithSymbolsForInliner;", "getCurrentScope", "()Lorg/jetbrains/kotlin/backend/common/ScopeWithIr;", "getParent", "()Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "substituteMap", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "getSubstituteMap", "()Ljava/util/Map;", "buildParameterToArgument", "", "Lorg/jetbrains/kotlin/backend/common/lower/inline/FunctionInlining$Inliner$ParameterToArgument;", "Lorg/jetbrains/kotlin/backend/common/lower/inline/FunctionInlining;", "evaluateArguments", "Lorg/jetbrains/kotlin/ir/IrStatement;", "functionReference", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "inline", "Lorg/jetbrains/kotlin/ir/expressions/IrReturnableBlock;", "inlineFunction", "performRecursiveInline", "", "isLambdaCall", "irCall", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "implicitCastIfNeededTo", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isInlineParameter", "transform", "", "T", "Lorg/jetbrains/kotlin/ir/IrElement;", "", "transformation", "Lkotlin/Function1;", "ParameterSubstitutor", "ParameterToArgument", "ir.backend.common"})
    private final class Inliner {
        @NotNull
        private final DeepCopyIrTreeWithSymbolsForInliner copyIrElement;
        @NotNull
        private final Map<IrValueParameter, IrExpression> substituteMap;
        @NotNull
        private final IrFunctionAccessExpression callSite;
        @NotNull
        private final IrFunction callee;
        @NotNull
        private final ScopeWithIr currentScope;
        @Nullable
        private final IrDeclarationParent parent;
        @NotNull
        private final CommonBackendContext context;

        @NotNull
        public final DeepCopyIrTreeWithSymbolsForInliner getCopyIrElement() {
            return this.copyIrElement;
        }

        @NotNull
        public final Map<IrValueParameter, IrExpression> getSubstituteMap() {
            return this.substituteMap;
        }

        @NotNull
        public final IrReturnableBlock inline() {
            return this.inlineFunction(this.callSite, this.callee, true);
        }

        /*
         * WARNING - void declaration
         */
        private final IrReturnableBlock inlineFunction(IrFunctionAccessExpression callSite, IrFunction callee, boolean performRecursiveInline) {
            void $this$transform$iv;
            IrFunction irFunction;
            if (performRecursiveInline) {
                IrElement irElement = FunctionInlining.this.visitElement(this.copyIrElement.copy(callee));
                if (irElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
                }
                irFunction = (IrFunction)irElement;
            } else {
                IrElement irElement = this.copyIrElement.copy(callee);
                if (irElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrFunction");
                }
                irFunction = (IrFunction)irElement;
            }
            IrFunction copiedCallee = irFunction;
            List<IrStatement> evaluationStatements = this.evaluateArguments(callSite, copiedCallee);
            IrBody irBody = copiedCallee.getBody();
            if (irBody == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrBlockBody");
            }
            List<IrStatement> statements = ((IrBlockBody)irBody).getStatements();
            FunctionDescriptor functionDescriptor = copiedCallee.getDescriptor().getOriginal();
            Intrinsics.checkExpressionValueIsNotNull(functionDescriptor, "copiedCallee.descriptor.original");
            IrReturnableBlockSymbolImpl irReturnableBlockSymbol = new IrReturnableBlockSymbolImpl(functionDescriptor);
            int endOffset = callee.getEndOffset();
            DeclarationIrBuilder irBuilder = LowerUtilsKt.createIrBuilder(this.context, irReturnableBlockSymbol, endOffset, endOffset);
            ParameterSubstitutor transformer2 = new ParameterSubstitutor();
            Object object = statements;
            Inliner this_$iv = this;
            boolean $i$f$transform = false;
            Iterable $this$forEachIndexed$iv$iv = (Iterable)$this$transform$iv;
            boolean $i$f$forEachIndexed = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$forEachIndexed$iv$iv) {
                void it;
                IrElement irElement;
                void item$iv;
                int n = index$iv$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                IrElement irElement2 = (IrElement)item$iv$iv;
                int i$iv = n2;
                boolean bl2 = false;
                IrStatement irStatement = (IrStatement)item$iv;
                int n3 = i$iv;
                void var27_30 = $this$transform$iv;
                boolean bl3 = false;
                IrElement irElement3 = irElement = (IrElement)it.transform(transformer2, null);
                if (irElement3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.IrStatement");
                }
                var27_30.set(n3, (IrElement)((IrStatement)irElement3));
            }
            statements.addAll(0, (Collection<IrStatement>)evaluationStatements);
            boolean isCoroutineIntrinsicCall = CommonCoroutineCodegenUtilKt.isBuiltInSuspendCoroutineUninterceptedOrReturn(callSite.getSymbol().getDescriptor(), CommonConfigurationKeysKt.getLanguageVersionSettings(this.context.getConfiguration()));
            object = new IrReturnableBlockImpl(callSite.getStartOffset(), callSite.getEndOffset(), callSite.getType(), irReturnableBlockSymbol, isCoroutineIntrinsicCall ? CoroutineIntrinsicLambdaOrigin.INSTANCE : null, statements, callee.getSymbol());
            boolean bl = false;
            boolean bl4 = false;
            Object $this$apply = object;
            boolean bl5 = false;
            IrElementTransformerVoidKt.transformChildrenVoid((IrElement)$this$apply, new IrElementTransformerVoid(this, copiedCallee, irBuilder){
                final /* synthetic */ Inliner this$0;
                final /* synthetic */ IrFunction $copiedCallee$inlined;
                final /* synthetic */ DeclarationIrBuilder $irBuilder$inlined;
                {
                    this.this$0 = inliner;
                    this.$copiedCallee$inlined = irFunction;
                    this.$irBuilder$inlined = declarationIrBuilder;
                }

                @NotNull
                public IrExpression visitReturn(@NotNull IrReturn expression2) {
                    Intrinsics.checkParameterIsNotNull(expression2, "expression");
                    IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
                    if (Intrinsics.areEqual(expression2.getReturnTargetSymbol(), this.$copiedCallee$inlined.getSymbol())) {
                        return ExpressionHelpersKt.irReturn(this.$irBuilder$inlined, expression2.getValue());
                    }
                    return expression2;
                }
            });
            PatchDeclarationParentsKt.patchDeclarationParents((IrElement)$this$apply, this.parent);
            return (IrReturnableBlock)object;
        }

        private final IrExpression implicitCastIfNeededTo(@NotNull IrExpression $this$implicitCastIfNeededTo, IrType type2) {
            return Intrinsics.areEqual(type2, $this$implicitCastIfNeededTo.getType()) ? $this$implicitCastIfNeededTo : (IrExpression)new IrTypeOperatorCallImpl($this$implicitCastIfNeededTo.getStartOffset(), $this$implicitCastIfNeededTo.getEndOffset(), type2, IrTypeOperator.IMPLICIT_CAST, type2, $this$implicitCastIfNeededTo);
        }

        private final boolean isLambdaCall(IrCall irCall) {
            IrFunction callee = irCall.getSymbol().getOwner();
            IrValueParameter irValueParameter = callee.getDispatchReceiverParameter();
            if (irValueParameter == null) {
                return false;
            }
            IrValueParameter dispatchReceiver = irValueParameter;
            boolean bl = !IrTypeUtilsKt.isKFunction(dispatchReceiver.getType());
            boolean bl2 = false;
            boolean bl3 = false;
            if (_Assertions.ENABLED && !bl) {
                boolean bl4 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            return (IrTypeUtilsKt.isFunction(dispatchReceiver.getType()) || IrTypeUtilsKt.isSuspendFunction(dispatchReceiver.getType())) && Intrinsics.areEqual(callee.getName(), OperatorNameConventions.INVOKE) && irCall.getDispatchReceiver() instanceof IrGetValue;
        }

        private final boolean isInlineParameter(@NotNull IrValueParameter $this$isInlineParameter) {
            return !$this$isInlineParameter.isNoinline() && !org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.isNullable($this$isInlineParameter.getType()) && (IrTypeUtilsKt.isFunction($this$isInlineParameter.getType()) || IrTypeUtilsKt.isSuspendFunction($this$isInlineParameter.getType()));
        }

        /*
         * WARNING - void declaration
         */
        private final List<ParameterToArgument> buildParameterToArgument(IrFunctionAccessExpression callSite, IrFunction callee) {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            List parameterToArgument = new ArrayList();
            if (callSite.getDispatchReceiver() != null && callee.getDispatchReceiverParameter() != null) {
                Collection collection = parameterToArgument;
                IrValueParameter irValueParameter = callee.getDispatchReceiverParameter();
                if (irValueParameter == null) {
                    Intrinsics.throwNpe();
                }
                IrExpression irExpression = callSite.getDispatchReceiver();
                if (irExpression == null) {
                    Intrinsics.throwNpe();
                }
                ParameterToArgument parameterToArgument2 = new ParameterToArgument(irValueParameter, irExpression);
                boolean bl2 = false;
                collection.add(parameterToArgument2);
            }
            Iterable $this$map$iv = callSite.getSymbol().getOwner().getValueParameters();
            boolean $i$f$map2 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                IrExpression irExpression = callSite.getValueArgument(it.getIndex());
                collection.add(irExpression);
            }
            List valueArguments = CollectionsKt.toMutableList((List)destination$iv$iv);
            if (callee.getExtensionReceiverParameter() != null) {
                IrExpression irExpression;
                $this$map$iv = parameterToArgument;
                IrValueParameter irValueParameter = callee.getExtensionReceiverParameter();
                if (irValueParameter == null) {
                    Intrinsics.throwNpe();
                }
                if (callSite.getExtensionReceiver() != null) {
                    irExpression = callSite.getExtensionReceiver();
                    if (irExpression == null) {
                        Intrinsics.throwNpe();
                    }
                } else {
                    Object t = valueArguments.remove(0);
                    if (t == null) {
                        Intrinsics.throwNpe();
                    }
                    irExpression = (IrExpression)t;
                }
                ParameterToArgument $i$f$map2 = new ParameterToArgument(irValueParameter, irExpression);
                boolean bl4 = false;
                $this$map$iv.add($i$f$map2);
            } else if (callSite.getExtensionReceiver() != null) {
                IrExpression irExpression = callSite.getExtensionReceiver();
                if (irExpression == null) {
                    Intrinsics.throwNpe();
                }
                valueArguments.add(0, irExpression);
            }
            boolean $i$f$map2 = false;
            List parametersWithDefaultToArgument = new ArrayList();
            for (IrValueParameter parameter : callee.getValueParameters()) {
                Object object;
                Collection $i$f$mapTo2;
                IrExpression argument = (IrExpression)valueArguments.get(parameter.getIndex());
                if (argument != null) {
                    $i$f$mapTo2 = parameterToArgument;
                    object = new ParameterToArgument(parameter, argument);
                    boolean bl5 = false;
                    $i$f$mapTo2.add(object);
                    continue;
                }
                if (parameter.getDefaultValue() != null) {
                    $i$f$mapTo2 = parametersWithDefaultToArgument;
                    IrExpressionBody irExpressionBody = parameter.getDefaultValue();
                    if (irExpressionBody == null) {
                        Intrinsics.throwNpe();
                    }
                    object = new ParameterToArgument(parameter, irExpressionBody.getExpression());
                    boolean bl6 = false;
                    $i$f$mapTo2.add(object);
                    continue;
                }
                if (parameter.getVarargElementType() != null) {
                    int n = callSite.getStartOffset();
                    int n2 = callSite.getEndOffset();
                    IrType irType = parameter.getType();
                    IrType irType2 = parameter.getVarargElementType();
                    if (irType2 == null) {
                        Intrinsics.throwNpe();
                    }
                    IrVarargImpl emptyArray = new IrVarargImpl(n, n2, irType, irType2);
                    object = parameterToArgument;
                    ParameterToArgument parameterToArgument3 = new ParameterToArgument(parameter, emptyArray);
                    boolean bl7 = false;
                    object.add(parameterToArgument3);
                    continue;
                }
                String message2 = "Incomplete expression: call to " + callee.getDescriptor() + ' ' + "has no argument at index " + parameter.getIndex();
                throw (Throwable)new Error(message2);
            }
            return CollectionsKt.plus((Collection)parameterToArgument, (Iterable)parametersWithDefaultToArgument);
        }

        /*
         * WARNING - void declaration
         */
        private final List<IrStatement> evaluateArguments(IrFunctionReference functionReference2) {
            ParameterToArgument it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = IrUtilsKt.getArgumentsWithIr(functionReference2);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ParameterToArgument parameterToArgument = new ParameterToArgument((IrValueParameter)((Pair)((Object)it)).getFirst(), (IrExpression)((Pair)((Object)it)).getSecond());
                collection.add(parameterToArgument);
            }
            List arguments2 = (List)destination$iv$iv;
            $i$f$map = false;
            List evaluationStatements = new ArrayList();
            ParameterSubstitutor substitutor2 = new ParameterSubstitutor();
            IrFunction referenced = functionReference2.getSymbol().getOwner();
            Iterable $this$forEach$iv = arguments2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                IrExpression irExpression;
                it = (ParameterToArgument)element$iv;
                boolean bl = false;
                if (it.isImmutableVariableLoad()) {
                    irExpression = it.getArgumentExpression().transform(substitutor2, null);
                } else {
                    IrVariable newVariable = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createTemporaryVariableWithWrappedDescriptor$default(this.currentScope.getScope(), it.getArgumentExpression().transform(substitutor2, null), this.callee.getSymbol().getOwner().getName().toString(), false, null, 8, null);
                    evaluationStatements.add(newVariable);
                    irExpression = new IrGetValueWithoutLocation((IrValueSymbol)newVariable.getSymbol(), null, 2, null);
                }
                IrExpression newArgument = irExpression;
                IrValueParameter irValueParameter = it.getParameter();
                if (Intrinsics.areEqual(irValueParameter, referenced.getDispatchReceiverParameter())) {
                    functionReference2.setDispatchReceiver(newArgument);
                    continue;
                }
                if (Intrinsics.areEqual(irValueParameter, referenced.getExtensionReceiverParameter())) {
                    functionReference2.setExtensionReceiver(newArgument);
                    continue;
                }
                functionReference2.putValueArgument(it.getParameter().getIndex(), newArgument);
            }
            return evaluationStatements;
        }

        private final List<IrStatement> evaluateArguments(IrFunctionAccessExpression callSite, IrFunction callee) {
            List<ParameterToArgument> arguments2 = this.buildParameterToArgument(callSite, callee);
            boolean bl = false;
            List evaluationStatements = new ArrayList();
            ParameterSubstitutor substitutor2 = new ParameterSubstitutor();
            Iterable $this$forEach$iv = arguments2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ParameterToArgument it = (ParameterToArgument)element$iv;
                boolean bl2 = false;
                if (it.isInlinableLambdaArgument()) {
                    this.substituteMap.put(it.getParameter(), it.getArgumentExpression());
                    IrExpression irExpression = it.getArgumentExpression();
                    if (!(irExpression instanceof IrFunctionReference)) {
                        irExpression = null;
                    }
                    if ((IrFunctionReference)irExpression != null) {
                        IrFunctionReference irFunctionReference;
                        boolean bl3 = false;
                        boolean bl4 = false;
                        IrFunctionReference it2 = irFunctionReference;
                        boolean bl5 = false;
                        Collection collection = evaluationStatements;
                        Iterable iterable = this.evaluateArguments(it2);
                        boolean bl6 = false;
                        CollectionsKt.addAll(collection, iterable);
                    }
                    continue;
                }
                if (it.isImmutableVariableLoad()) {
                    this.substituteMap.put(it.getParameter(), it.getArgumentExpression().transform(substitutor2, null));
                    continue;
                }
                IrExpression variableInitializer = it.getArgumentExpression().transform(substitutor2, null);
                IrElement irElement = this.currentScope.getIrElement();
                if (irElement == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrSymbolOwner");
                }
                IrBlockImpl irBlockImpl = new IrBlockImpl(variableInitializer.getStartOffset(), variableInitializer.getEndOffset(), variableInitializer.getType(), new InlinerExpressionLocationHint(((IrSymbolOwner)irElement).getSymbol()));
                Scope scope2 = this.currentScope.getScope();
                boolean bl7 = false;
                boolean bl8 = false;
                IrBlockImpl $this$apply = irBlockImpl;
                boolean bl9 = false;
                $this$apply.getStatements().add(variableInitializer);
                IrBlockImpl irBlockImpl2 = irBlockImpl;
                IrVariable newVariable = org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createTemporaryVariableWithWrappedDescriptor$default(scope2, irBlockImpl2, callee.getSymbol().getOwner().getName().toString(), false, null, 8, null);
                evaluationStatements.add(newVariable);
                this.substituteMap.put(it.getParameter(), new IrGetValueWithoutLocation((IrValueSymbol)newVariable.getSymbol(), null, 2, null));
            }
            return evaluationStatements;
        }

        @NotNull
        public final IrFunctionAccessExpression getCallSite() {
            return this.callSite;
        }

        @NotNull
        public final IrFunction getCallee() {
            return this.callee;
        }

        @NotNull
        public final ScopeWithIr getCurrentScope() {
            return this.currentScope;
        }

        @Nullable
        public final IrDeclarationParent getParent() {
            return this.parent;
        }

        @NotNull
        public final CommonBackendContext getContext() {
            return this.context;
        }

        /*
         * WARNING - void declaration
         */
        public Inliner(@NotNull IrFunctionAccessExpression callSite, @NotNull IrFunction callee, @Nullable ScopeWithIr currentScope2, @NotNull IrDeclarationParent parent2, CommonBackendContext context2) {
            void $this$associateTo$iv$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull(callSite, "callSite");
            Intrinsics.checkParameterIsNotNull(callee, "callee");
            Intrinsics.checkParameterIsNotNull(currentScope2, "currentScope");
            Intrinsics.checkParameterIsNotNull(context2, "context");
            this.callSite = callSite;
            this.callee = callee;
            this.currentScope = currentScope2;
            this.parent = parent2;
            this.context = context2;
            Inliner inliner = this;
            Inliner inliner2 = this;
            boolean bl = false;
            boolean bl2 = false;
            Inliner $this$run = inliner;
            boolean bl3 = false;
            List<IrTypeParameter> typeParameters2 = $this$run.callee instanceof IrConstructor ? IrUtilsKt.getParentAsClass($this$run.callee).getTypeParameters() : $this$run.callee.getTypeParameters();
            Iterable $this$map$iv = RangesKt.until(0, $this$run.callSite.getTypeArgumentsCount());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                Pair pair = TuplesKt.to(typeParameters2.get((int)it).getSymbol(), $this$run.callSite.getTypeArgument((int)it));
                collection.add(pair);
            }
            Iterable $this$associate$iv = (List)destination$iv$iv;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            destination$iv$iv = $this$associate$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv2;
                Pair it = (Pair)element$iv$iv;
                boolean bl5 = false;
                Pair pair = it;
                boolean bl6 = false;
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map typeArguments2 = destination$iv$iv2;
            Object object = new DeepCopyIrTreeWithSymbolsForInliner($this$run.context, typeArguments2, $this$run.parent);
            inliner2.copyIrElement = object;
            inliner2 = this;
            boolean bl7 = false;
            inliner2.substituteMap = object = (Map)new LinkedHashMap();
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/inline/FunctionInlining$Inliner$ParameterSubstitutor;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "(Lorg/jetbrains/kotlin/backend/common/lower/inline/FunctionInlining$Inliner;)V", "visitCall", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "visitElement", "Lorg/jetbrains/kotlin/ir/IrElement;", "element", "visitGetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "ir.backend.common"})
        private final class ParameterSubstitutor
        extends IrElementTransformerVoid {
            @Override
            @NotNull
            public IrExpression visitGetValue(@NotNull IrGetValue expression2) {
                IrExpression irExpression;
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                IrExpression irExpression2 = super.visitGetValue(expression2);
                if (irExpression2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrGetValue");
                }
                IrGetValue newExpression = (IrGetValue)irExpression2;
                Map<IrValueParameter, IrExpression> map2 = Inliner.this.getSubstituteMap();
                IrValueDeclaration irValueDeclaration = newExpression.getSymbol().getOwner();
                boolean bl = false;
                IrExpression irExpression3 = map2.get(irValueDeclaration);
                if (irExpression3 == null) {
                    return newExpression;
                }
                IrExpression argument = irExpression3;
                IrElementTransformerVoidKt.transformChildrenVoid(argument, this);
                if (argument instanceof IrGetValueWithoutLocation) {
                    irExpression = ((IrGetValueWithoutLocation)argument).withLocation(newExpression.getStartOffset(), newExpression.getEndOffset());
                } else {
                    IrElement irElement = Inliner.this.getCopyIrElement().copy(argument);
                    if (irElement == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                    }
                    irExpression = (IrExpression)irElement;
                }
                return irExpression;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public IrExpression visitCall(@NotNull IrCall expression2) {
                Intrinsics.checkParameterIsNotNull(expression2, "expression");
                if (!Inliner.this.isLambdaCall(expression2)) {
                    return super.visitCall(expression2);
                }
                IrExpression irExpression = expression2.getDispatchReceiver();
                if (irExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrGetValue");
                }
                IrGetValue dispatchReceiver = (IrGetValue)irExpression;
                Map<IrValueParameter, IrExpression> map2 = Inliner.this.getSubstituteMap();
                IrValueDeclaration irValueDeclaration = dispatchReceiver.getSymbol().getOwner();
                boolean bl = false;
                IrExpression irExpression2 = map2.get(irValueDeclaration);
                if (irExpression2 == null) {
                    return super.visitCall(expression2);
                }
                IrExpression functionArgument = irExpression2;
                IrValueDeclaration irValueDeclaration2 = dispatchReceiver.getSymbol().getOwner();
                if (!(irValueDeclaration2 instanceof IrValueParameter)) {
                    irValueDeclaration2 = null;
                }
                IrValueParameter irValueParameter = (IrValueParameter)irValueDeclaration2;
                if (irValueParameter != null) {
                    if (irValueParameter.isNoinline()) {
                        return super.visitCall(expression2);
                    }
                }
                if (functionArgument instanceof IrFunctionReference) {
                    IrMemberAccessExpression irMemberAccessExpression;
                    void $this$associateTo$iv$iv;
                    Object object;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    IrElementTransformerVoidKt.transformChildrenVoid(functionArgument, this);
                    IrFunction function2 = ((IrFunctionReference)functionArgument).getSymbol().getOwner();
                    List<IrValueParameter> functionParameters = IrUtilsKt.getExplicitParameters(function2);
                    List<Pair<IrValueParameter, IrExpression>> boundFunctionParameters = IrUtilsKt.getArgumentsWithIr((IrMemberAccessExpression)functionArgument);
                    Iterable iterable = boundFunctionParameters;
                    Object object2 = functionParameters;
                    boolean $i$f$map = false;
                    void var10_13 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo22 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        Iterator it;
                        Pair pair = (Pair)item$iv$iv;
                        object = destination$iv$iv;
                        boolean bl2 = false;
                        IrValueParameter irValueParameter2 = (IrValueParameter)((Pair)((Object)it)).getFirst();
                        object.add(irValueParameter2);
                    }
                    object = (List)destination$iv$iv;
                    List unboundFunctionParameters = CollectionsKt.minus(object2, (Iterable)object);
                    Iterable $this$associate$iv = boundFunctionParameters;
                    boolean $i$f$associate = false;
                    int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
                    Iterable $i$f$mapTo22 = $this$associate$iv;
                    Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                    boolean $i$f$associateTo = false;
                    for (Object element$iv$iv : $this$associateTo$iv$iv) {
                        Map map3 = destination$iv$iv2;
                        Pair it = (Pair)element$iv$iv;
                        boolean bl3 = false;
                        it = TuplesKt.to(it.getFirst(), it.getSecond());
                        bl3 = false;
                        map3.put(it.getFirst(), it.getSecond());
                    }
                    Map boundFunctionParametersMap = destination$iv$iv2;
                    int unboundIndex = 0;
                    Set unboundArgsSet = CollectionsKt.toSet(unboundFunctionParameters);
                    List valueParameters2 = CollectionsKt.drop((Iterable)IrUtilsKt.getArgumentsWithIr(expression2), 1);
                    object2 = Inliner.this;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    IrCall $this$with = expression2;
                    boolean bl6 = false;
                    if (function2 instanceof IrConstructor) {
                        int classTypeParametersCount = IrUtilsKt.getParentAsClass(function2).getTypeParameters().size();
                        irMemberAccessExpression = IrConstructorCallImpl.Companion.fromSymbolOwner$default(IrConstructorCallImpl.Companion, $this$with.getStartOffset(), $this$with.getEndOffset(), function2.getReturnType(), (IrConstructorSymbol)((IrConstructor)function2).getSymbol(), classTypeParametersCount, null, 32, null);
                    } else {
                        irMemberAccessExpression = new IrCallImpl($this$with.getStartOffset(), $this$with.getEndOffset(), function2.getReturnType(), ((IrFunctionReference)functionArgument).getSymbol(), null, null, 48, null);
                    }
                    Object object3 = object = irMemberAccessExpression;
                    bl5 = false;
                    boolean bl7 = false;
                    Object $this$apply = object3;
                    boolean bl8 = false;
                    Iterable $this$forEach$iv22 = functionParameters;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv22) {
                        IrExpression irExpression3;
                        IrValueParameter it = (IrValueParameter)element$iv;
                        boolean bl9 = false;
                        if (unboundArgsSet.contains(it)) {
                            int n = unboundIndex < valueParameters2.size() ? 1 : 0;
                            boolean bl10 = false;
                            if (_Assertions.ENABLED && n == 0) {
                                boolean bl11 = false;
                                String string2 = "Attempt to use unbound parameter outside of the callee's value parameters";
                                throw (Throwable)((Object)new AssertionError((Object)string2));
                            }
                            n = unboundIndex;
                            unboundIndex = n + 1;
                            irExpression3 = (IrExpression)((Pair)valueParameters2.get(n)).getSecond();
                        } else {
                            IrExpression arg;
                            Object v = boundFunctionParametersMap.get(it);
                            if (v == null) {
                                Intrinsics.throwNpe();
                            }
                            irExpression3 = (arg = (IrExpression)v) instanceof IrGetValueWithoutLocation ? (IrExpression)((IrGetValueWithoutLocation)arg).withLocation(expression2.getStartOffset(), expression2.getEndOffset()) : arg;
                        }
                        IrExpression argument = irExpression3;
                        IrValueParameter irValueParameter3 = it;
                        if (Intrinsics.areEqual(irValueParameter3, function2.getDispatchReceiverParameter())) {
                            IrCallWithIndexedArgumentsBase irCallWithIndexedArgumentsBase = (IrCallWithIndexedArgumentsBase)$this$apply;
                            IrValueParameter irValueParameter4 = function2.getDispatchReceiverParameter();
                            if (irValueParameter4 == null) {
                                Intrinsics.throwNpe();
                            }
                            irCallWithIndexedArgumentsBase.setDispatchReceiver(Inliner.this.implicitCastIfNeededTo(argument, irValueParameter4.getType()));
                            continue;
                        }
                        if (Intrinsics.areEqual(irValueParameter3, function2.getExtensionReceiverParameter())) {
                            IrCallWithIndexedArgumentsBase irCallWithIndexedArgumentsBase = (IrCallWithIndexedArgumentsBase)$this$apply;
                            IrValueParameter irValueParameter5 = function2.getExtensionReceiverParameter();
                            if (irValueParameter5 == null) {
                                Intrinsics.throwNpe();
                            }
                            irCallWithIndexedArgumentsBase.setExtensionReceiver(Inliner.this.implicitCastIfNeededTo(argument, irValueParameter5.getType()));
                            continue;
                        }
                        ((IrCallWithIndexedArgumentsBase)$this$apply).putValueArgument(it.getIndex(), Inliner.this.implicitCastIfNeededTo(argument, function2.getValueParameters().get(it.getIndex()).getType()));
                    }
                    int $this$forEach$iv22 = unboundIndex == valueParameters2.size() ? 1 : 0;
                    int n = 0;
                    if (_Assertions.ENABLED && $this$forEach$iv22 == 0) {
                        boolean bl12 = false;
                        String string3 = "Not all arguments of the callee are used";
                        throw (Throwable)((Object)new AssertionError((Object)string3));
                    }
                    $this$forEach$iv22 = 0;
                    n = ((IrFunctionReference)functionArgument).getTypeArgumentsCount();
                    while ($this$forEach$iv22 < n) {
                        void index2;
                        ((IrCallWithIndexedArgumentsBase)$this$apply).putTypeArgument((int)index2, ((IrFunctionReference)functionArgument).getTypeArgument((int)index2));
                        ++index2;
                    }
                    object = object3;
                    IrExpression immediateCall = ((Inliner)object2).implicitCastIfNeededTo((IrExpression)object, expression2.getType());
                    return FunctionInlining.this.visitExpression(super.visitExpression(immediateCall));
                }
                if (!(functionArgument instanceof IrFunctionExpression)) {
                    return super.visitCall(expression2);
                }
                IrReturnableBlock newExpression = Inliner.this.inlineFunction(expression2, ((IrFunctionExpression)functionArgument).getFunction(), false);
                return newExpression.transform(this, null);
            }

            @Override
            @NotNull
            public IrElement visitElement(@NotNull IrElement element) {
                Intrinsics.checkParameterIsNotNull(element, "element");
                return (IrElement)element.accept(this, null);
            }
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0011\u0010\f\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/inline/FunctionInlining$Inliner$ParameterToArgument;", "", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "argumentExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "(Lorg/jetbrains/kotlin/backend/common/lower/inline/FunctionInlining$Inliner;Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)V", "getArgumentExpression", "()Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "isImmutableVariableLoad", "", "()Z", "isInlinableLambdaArgument", "getParameter", "()Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "ir.backend.common"})
        private final class ParameterToArgument {
            @NotNull
            private final IrValueParameter parameter;
            @NotNull
            private final IrExpression argumentExpression;

            public final boolean isInlinableLambdaArgument() {
                return Inliner.this.isInlineParameter(this.parameter) && (this.argumentExpression instanceof IrFunctionReference || this.argumentExpression instanceof IrFunctionExpression);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isImmutableVariableLoad() {
                IrExpression irExpression = this.argumentExpression;
                boolean bl = false;
                boolean bl2 = false;
                IrExpression it = irExpression;
                boolean bl3 = false;
                if (!(it instanceof IrGetValue)) return false;
                IrValueDeclaration irValueDeclaration = ((IrGetValue)it).getSymbol().getOwner();
                boolean bl4 = false;
                boolean bl5 = false;
                IrValueDeclaration it2 = irValueDeclaration;
                boolean bl6 = false;
                if (!(it2 instanceof IrVariable)) return true;
                if (!((IrVariable)it2).isVar()) return true;
                return false;
            }

            @NotNull
            public final IrValueParameter getParameter() {
                return this.parameter;
            }

            @NotNull
            public final IrExpression getArgumentExpression() {
                return this.argumentExpression;
            }

            public ParameterToArgument(@NotNull IrValueParameter parameter, IrExpression argumentExpression) {
                Intrinsics.checkParameterIsNotNull(parameter, "parameter");
                Intrinsics.checkParameterIsNotNull(argumentExpression, "argumentExpression");
                this.parameter = parameter;
                this.argumentExpression = argumentExpression;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J5\u0010\n\u001a\u0002H\u000b\"\u0004\b\u0000\u0010\u000b\"\u0004\b\u0001\u0010\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u0002H\f0\u000e2\u0006\u0010\u000f\u001a\u0002H\fH\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/inline/FunctionInlining$IrGetValueWithoutLocation;", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrTerminalDeclarationReferenceBase;", "Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "symbol", "origin", "Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "(Lorg/jetbrains/kotlin/ir/symbols/IrValueSymbol;Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;)V", "getOrigin", "()Lorg/jetbrains/kotlin/ir/expressions/IrStatementOrigin;", "accept", "R", "D", "visitor", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitor;", "data", "(Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitor;Ljava/lang/Object;)Ljava/lang/Object;", "copy", "withLocation", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetValueImpl;", "startOffset", "", "endOffset", "ir.backend.common"})
    private static final class IrGetValueWithoutLocation
    extends IrTerminalDeclarationReferenceBase<IrValueSymbol>
    implements IrGetValue {
        @Nullable
        private final IrStatementOrigin origin;

        @Override
        public <R, D> R accept(@NotNull IrElementVisitor<? extends R, ? super D> visitor2, D data) {
            Intrinsics.checkParameterIsNotNull(visitor2, "visitor");
            return visitor2.visitGetValue(this, data);
        }

        @Override
        @NotNull
        public IrGetValue copy() {
            String string2 = "not implemented";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string2);
        }

        @NotNull
        public final IrGetValueImpl withLocation(int startOffset, int endOffset) {
            return new IrGetValueImpl(startOffset, endOffset, this.getType(), (IrValueSymbol)this.getSymbol(), this.getOrigin());
        }

        @Override
        @Nullable
        public IrStatementOrigin getOrigin() {
            return this.origin;
        }

        public IrGetValueWithoutLocation(@NotNull IrValueSymbol symbol2, @Nullable IrStatementOrigin origin) {
            Intrinsics.checkParameterIsNotNull(symbol2, "symbol");
            super(-1, -1, symbol2.getOwner().getType(), (IrSymbol)symbol2);
            this.origin = origin;
        }

        public /* synthetic */ IrGetValueWithoutLocation(IrValueSymbol irValueSymbol, IrStatementOrigin irStatementOrigin, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                irStatementOrigin = null;
            }
            this(irValueSymbol, irStatementOrigin);
        }
    }
}

