/*
 * Decompiled with CFR 0.152.
 */
package org.bridj;

import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import org.bridj.FlagSet;
import org.bridj.NativeObject;
import org.bridj.Pointer;
import org.bridj.PointerIO;
import org.bridj.TypedPointer;
import org.bridj.dyncall.DyncallLibrary;

interface CallIO {
    public Object newInstance(long var1);

    public long getDCStruct();

    public long getPeer(Object var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class GenericPointerHandler
    implements CallIO {
        private final Type targetType;
        private final PointerIO pointerIO;

        public GenericPointerHandler(Type targetType) {
            this.targetType = targetType;
            this.pointerIO = PointerIO.getInstance(targetType);
        }

        @Override
        public Pointer<?> newInstance(long address) {
            return Pointer.pointerToAddress(address, this.pointerIO);
        }

        @Override
        public long getDCStruct() {
            return 0L;
        }

        @Override
        public long getPeer(Object o) {
            return Pointer.getPeer((Pointer)o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NativeObjectHandler
    implements CallIO {
        final Class<? extends NativeObject> nativeClass;
        final Type nativeType;
        final Pointer<DyncallLibrary.DCstruct> pStruct;

        public NativeObjectHandler(Class<? extends NativeObject> type, Type t, Pointer<DyncallLibrary.DCstruct> pStruct) {
            this.nativeClass = type;
            this.nativeType = t;
            this.pStruct = pStruct;
        }

        @Override
        public NativeObject newInstance(long address) {
            return Pointer.pointerToAddress(address).getNativeObject(this.nativeClass);
        }

        @Override
        public long getDCStruct() {
            return Pointer.getPeer(this.pStruct);
        }

        @Override
        public long getPeer(Object o) {
            return Pointer.getAddress((NativeObject)o, this.nativeClass);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypedPointerIO
    implements CallIO {
        Class<? extends TypedPointer> type;
        Constructor<?> constructor;

        public TypedPointerIO(Class<? extends TypedPointer> type) {
            this.type = type;
            try {
                this.constructor = type.getConstructor(Long.TYPE);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to create " + CallIO.class.getName() + " for type " + type.getName(), ex);
            }
        }

        @Override
        public Pointer<?> newInstance(long address) {
            try {
                return address == 0L ? null : (Pointer)this.constructor.newInstance(address);
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to instantiate pointer of type " + this.type.getName(), ex);
            }
        }

        @Override
        public long getDCStruct() {
            return 0L;
        }

        @Override
        public long getPeer(Object o) {
            return Pointer.getPeer((Pointer)o);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Utils {
        public static CallIO createPointerCallIOToTargetType(Type targetType) {
            return new GenericPointerHandler(targetType);
        }

        public static <EE extends Enum<EE>> CallIO createValuedEnumCallIO(final Class<EE> enumClass) {
            return new CallIO(){

                public Object newInstance(long value) {
                    return FlagSet.fromValue((long)value, (Class)enumClass, (Enum[])new Enum[0]);
                }

                public long getDCStruct() {
                    return 0L;
                }

                public long getPeer(Object o) {
                    return 0L;
                }
            };
        }

        public static CallIO createPointerCallIO(Type type) {
            return Utils.createPointerCallIO(org.bridj.util.Utils.getClass(type), type);
        }

        public static CallIO createPointerCallIO(Class<?> cl, Type type) {
            if (cl == Pointer.class) {
                return Utils.createPointerCallIOToTargetType(org.bridj.util.Utils.getUniqueParameterizedTypeParameter(type));
            }
            assert (TypedPointer.class.isAssignableFrom(cl));
            return new TypedPointerIO(cl);
        }
    }
}

