/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.WireFormat;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.TransportRoute;
import net.osmand.data.TransportStop;
import net.osmand.util.MapUtils;
import net.sf.junidecode.Junidecode;

public class BinaryMapTransportReaderAdapter {
    private CodedInputStream codedIS;
    private final BinaryMapIndexReader map;

    protected BinaryMapTransportReaderAdapter(BinaryMapIndexReader map) {
        this.codedIS = map.codedIS;
        this.map = map;
    }

    private void skipUnknownField(int t) throws IOException {
        this.map.skipUnknownField(t);
    }

    private int readInt() throws IOException {
        return this.map.readInt();
    }

    protected void readTransportIndex(TransportIndex ind) throws IOException {
        block7: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 3: {
                    this.skipUnknownField(t);
                    continue block7;
                }
                case 1: {
                    ind.setName(this.codedIS.readString());
                    continue block7;
                }
                case 6: {
                    ind.stopsFileLength = this.readInt();
                    ind.stopsFileOffset = this.codedIS.getTotalBytesRead();
                    int old = this.codedIS.pushLimit(ind.stopsFileLength);
                    this.readTransportBounds(ind);
                    this.codedIS.popLimit(old);
                    continue block7;
                }
                case 9: {
                    IndexStringTable st = new IndexStringTable();
                    st.length = this.codedIS.readRawVarint32();
                    st.fileOffset = this.codedIS.getTotalBytesRead();
                    ind.stringTable = st;
                    this.codedIS.seek(st.length + st.fileOffset);
                    continue block7;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private void readTransportBounds(TransportIndex ind) throws IOException {
        block7: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return;
                }
                case 1: {
                    ind.left = this.codedIS.readSInt32();
                    continue block7;
                }
                case 2: {
                    ind.right = this.codedIS.readSInt32();
                    continue block7;
                }
                case 3: {
                    ind.top = this.codedIS.readSInt32();
                    continue block7;
                }
                case 4: {
                    ind.bottom = this.codedIS.readSInt32();
                    continue block7;
                }
            }
            this.skipUnknownField(t);
        }
    }

    protected void searchTransportTreeBounds(int pleft, int pright, int ptop, int pbottom, BinaryMapIndexReader.SearchRequest<TransportStop> req) throws IOException {
        int init = 0;
        int lastIndexResult = -1;
        int cright = 0;
        int cleft = 0;
        int ctop = 0;
        int cbottom = 0;
        ++req.numberOfReadSubtrees;
        block10: while (!req.isCancelled()) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            if (init == 15) {
                init = 0;
                if (cright < req.left || cleft > req.right || ctop > req.bottom || cbottom < req.top) {
                    return;
                }
                ++req.numberOfAcceptedSubtrees;
            }
            switch (tag) {
                case 0: {
                    return;
                }
                case 4: {
                    cbottom = this.codedIS.readSInt32() + pbottom;
                    init |= 1;
                    break;
                }
                case 1: {
                    cleft = this.codedIS.readSInt32() + pleft;
                    init |= 2;
                    break;
                }
                case 2: {
                    cright = this.codedIS.readSInt32() + pright;
                    init |= 4;
                    break;
                }
                case 3: {
                    ctop = this.codedIS.readSInt32() + ptop;
                    init |= 8;
                    break;
                }
                case 8: {
                    int stopOffset = this.codedIS.getTotalBytesRead();
                    int length = this.codedIS.readRawVarint32();
                    int oldLimit = this.codedIS.pushLimit(length);
                    if (lastIndexResult == -1) {
                        lastIndexResult = req.getSearchResults().size();
                    }
                    ++req.numberOfVisitedObjects;
                    TransportStop transportStop = this.readTransportStop(stopOffset, cleft, cright, ctop, cbottom, req);
                    if (transportStop != null) {
                        req.publish(transportStop);
                    }
                    this.codedIS.popLimit(oldLimit);
                    break;
                }
                case 7: {
                    int oldLimit;
                    int length = this.readInt();
                    int filePointer = this.codedIS.getTotalBytesRead();
                    if (req.limit == -1 || req.limit >= req.getSearchResults().size()) {
                        oldLimit = this.codedIS.pushLimit(length);
                        this.searchTransportTreeBounds(cleft, cright, ctop, cbottom, req);
                        this.codedIS.popLimit(oldLimit);
                    }
                    this.codedIS.seek(filePointer + length);
                    if (lastIndexResult < 0) continue block10;
                    throw new IllegalStateException();
                }
                case 16: {
                    long baseId = this.codedIS.readUInt64();
                    if (lastIndexResult == -1) continue block10;
                    int i = lastIndexResult;
                    while (true) {
                        if (i >= req.getSearchResults().size()) continue block10;
                        TransportStop rs = req.getSearchResults().get(i);
                        rs.setId(rs.getId() + baseId);
                        ++i;
                    }
                }
                default: {
                    this.skipUnknownField(t);
                }
            }
        }
        return;
    }

    private String regStr(TIntObjectHashMap<String> stringTable) throws IOException {
        int i = this.codedIS.readUInt32();
        stringTable.putIfAbsent(i, (Object)"");
        return (char)i + "";
    }

    public TransportRoute getTransportRoute(int filePointer, TIntObjectHashMap<String> stringTable, boolean onlyDescription) throws IOException {
        this.codedIS.seek(filePointer);
        int routeLength = this.codedIS.readRawVarint32();
        int old = this.codedIS.pushLimit(routeLength);
        TransportRoute dataObject = new TransportRoute();
        boolean end = false;
        long rid = 0L;
        int rx = 0;
        int ry = 0;
        long did = 0L;
        int dx = 0;
        int dy = 0;
        block12: while (!end) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    end = true;
                    continue block12;
                }
                case 8: {
                    dataObject.setDistance(this.codedIS.readUInt32());
                    continue block12;
                }
                case 1: {
                    dataObject.setId(this.codedIS.readUInt64());
                    continue block12;
                }
                case 5: {
                    dataObject.setRef(this.codedIS.readString());
                    continue block12;
                }
                case 3: {
                    dataObject.setType(this.regStr(stringTable));
                    continue block12;
                }
                case 7: {
                    dataObject.setEnName(this.regStr(stringTable));
                    continue block12;
                }
                case 6: {
                    dataObject.setName(this.regStr(stringTable));
                    continue block12;
                }
                case 4: {
                    dataObject.setOperator(this.regStr(stringTable));
                    continue block12;
                }
                case 16: {
                    if (onlyDescription) {
                        end = true;
                        this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                        continue block12;
                    }
                    int length = this.codedIS.readRawVarint32();
                    int olds = this.codedIS.pushLimit(length);
                    TransportStop stop = this.readTransportRouteStop(dx, dy, did, stringTable);
                    dataObject.getBackwardStops().add(stop);
                    did = stop.getId();
                    dx = (int)MapUtils.getTileNumberX(24.0f, stop.getLocation().getLongitude());
                    dy = (int)MapUtils.getTileNumberY(24.0f, stop.getLocation().getLatitude());
                    this.codedIS.popLimit(olds);
                    continue block12;
                }
                case 15: {
                    if (onlyDescription) {
                        end = true;
                        this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                        continue block12;
                    }
                    int length = this.codedIS.readRawVarint32();
                    int olds = this.codedIS.pushLimit(length);
                    TransportStop stop = this.readTransportRouteStop(rx, ry, rid, stringTable);
                    dataObject.getForwardStops().add(stop);
                    rid = stop.getId();
                    rx = (int)MapUtils.getTileNumberX(24.0f, stop.getLocation().getLongitude());
                    ry = (int)MapUtils.getTileNumberY(24.0f, stop.getLocation().getLatitude());
                    this.codedIS.popLimit(olds);
                    continue block12;
                }
            }
            this.skipUnknownField(t);
        }
        this.codedIS.popLimit(old);
        return dataObject;
    }

    protected void initializeStringTable(TransportIndex ind, TIntObjectHashMap<String> stringTable) throws IOException {
        int[] values = stringTable.keys();
        Arrays.sort(values);
        this.codedIS.seek(ind.stringTable.fileOffset);
        int oldLimit = this.codedIS.pushLimit(ind.stringTable.length);
        int current = 0;
        int i = 0;
        block4: while (i < values.length) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    continue block4;
                }
                case 1: {
                    if (current == values[i]) {
                        String value = this.codedIS.readString();
                        stringTable.put(values[i], (Object)value);
                        ++i;
                    } else {
                        this.skipUnknownField(t);
                    }
                    ++current;
                    continue block4;
                }
            }
            this.skipUnknownField(t);
        }
        this.codedIS.popLimit(oldLimit);
    }

    protected void initializeNames(boolean onlyDescription, TransportRoute dataObject, TIntObjectHashMap<String> stringTable) throws IOException {
        if (dataObject.getName().length() > 0) {
            dataObject.setName((String)stringTable.get((int)dataObject.getName().charAt(0)));
        }
        if (dataObject.getEnName(false).length() > 0) {
            dataObject.setEnName((String)stringTable.get((int)dataObject.getEnName(false).charAt(0)));
        }
        if (dataObject.getName().length() > 0 && dataObject.getName("en").length() == 0) {
            dataObject.setEnName(Junidecode.unidecode((String)dataObject.getName()));
        }
        if (dataObject.getOperator().length() > 0) {
            dataObject.setOperator((String)stringTable.get((int)dataObject.getOperator().charAt(0)));
        }
        if (dataObject.getType().length() > 0) {
            dataObject.setType((String)stringTable.get((int)dataObject.getType().charAt(0)));
        }
        for (int i = 0; i < 2 && !onlyDescription; ++i) {
            List<TransportStop> stops = i == 0 ? dataObject.getForwardStops() : dataObject.getBackwardStops();
            for (TransportStop s : stops) {
                this.initializeNames(stringTable, s);
            }
        }
    }

    protected void initializeNames(TIntObjectHashMap<String> stringTable, TransportStop s) {
        if (s.getName().length() > 0) {
            s.setName((String)stringTable.get((int)s.getName().charAt(0)));
        }
        if (s.getEnName(false).length() > 0) {
            s.setEnName((String)stringTable.get((int)s.getEnName(false).charAt(0)));
        }
    }

    private TransportStop readTransportRouteStop(int dx, int dy, long did, TIntObjectHashMap<String> stringTable) throws IOException {
        TransportStop dataObject = new TransportStop();
        boolean end = false;
        block8: while (!end) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    end = true;
                    continue block8;
                }
                case 7: {
                    dataObject.setEnName(this.regStr(stringTable));
                    continue block8;
                }
                case 6: {
                    dataObject.setName(this.regStr(stringTable));
                    continue block8;
                }
                case 1: {
                    did += this.codedIS.readSInt64();
                    continue block8;
                }
                case 2: {
                    dx += this.codedIS.readSInt32();
                    continue block8;
                }
                case 3: {
                    dy += this.codedIS.readSInt32();
                    continue block8;
                }
            }
            this.skipUnknownField(t);
        }
        dataObject.setId(did);
        dataObject.setLocation(MapUtils.getLatitudeFromTile(24.0f, dy), MapUtils.getLongitudeFromTile(24.0, dx));
        return dataObject;
    }

    private TransportStop readTransportStop(int shift, int cleft, int cright, int ctop, int cbottom, BinaryMapIndexReader.SearchRequest<TransportStop> req) throws IOException {
        int tag = WireFormat.getTagFieldNumber(this.codedIS.readTag());
        if (1 != tag) {
            throw new IllegalArgumentException();
        }
        int x = this.codedIS.readSInt32() + cleft;
        tag = WireFormat.getTagFieldNumber(this.codedIS.readTag());
        if (2 != tag) {
            throw new IllegalArgumentException();
        }
        int y = this.codedIS.readSInt32() + ctop;
        if (req.right < x || req.left > x || req.top > y || req.bottom < y) {
            this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
            return null;
        }
        ++req.numberOfAcceptedObjects;
        req.cacheTypes.clear();
        TransportStop dataObject = new TransportStop();
        dataObject.setLocation(MapUtils.getLatitudeFromTile(24.0f, y), MapUtils.getLongitudeFromTile(24.0, x));
        dataObject.setFileOffset(shift);
        block7: while (true) {
            int t = this.codedIS.readTag();
            tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    dataObject.setReferencesToRoutes(req.cacheTypes.toArray());
                    if (dataObject.getName("en").length() == 0) {
                        dataObject.setEnName(Junidecode.unidecode((String)dataObject.getName()));
                    }
                    return dataObject;
                }
                case 16: {
                    req.cacheTypes.add(shift - this.codedIS.readUInt32());
                    continue block7;
                }
                case 7: {
                    if (req.stringTable != null) {
                        dataObject.setEnName(this.regStr(req.stringTable));
                        continue block7;
                    }
                    this.skipUnknownField(t);
                    continue block7;
                }
                case 6: {
                    if (req.stringTable != null) {
                        dataObject.setName(this.regStr(req.stringTable));
                        continue block7;
                    }
                    this.skipUnknownField(t);
                    continue block7;
                }
                case 5: {
                    dataObject.setId(this.codedIS.readSInt64());
                    continue block7;
                }
            }
            this.skipUnknownField(t);
        }
    }

    protected static class IndexStringTable {
        int fileOffset = 0;
        int length = 0;
        TIntArrayList offsets = new TIntArrayList();

        protected IndexStringTable() {
        }
    }

    public static class TransportIndex
    extends BinaryIndexPart {
        int left = 0;
        int right = 0;
        int top = 0;
        int bottom = 0;
        int stopsFileOffset = 0;
        int stopsFileLength = 0;
        IndexStringTable stringTable = null;

        public int getLeft() {
            return this.left;
        }

        public int getRight() {
            return this.right;
        }

        public int getTop() {
            return this.top;
        }

        public int getBottom() {
            return this.bottom;
        }
    }
}

