/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandNope;
import net.sourceforge.plantuml.command.CommandScale;
import net.sourceforge.plantuml.command.UmlDiagramFactory;
import net.sourceforge.plantuml.core.DiagramType;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.command.CommandColorTask;
import net.sourceforge.plantuml.project.command.CommandGanttArrow;
import net.sourceforge.plantuml.project.command.CommandGanttArrow2;
import net.sourceforge.plantuml.project.command.CommandPage;
import net.sourceforge.plantuml.project.command.CommandPrintBetween;
import net.sourceforge.plantuml.project.command.CommandPrintScale;
import net.sourceforge.plantuml.project.command.CommandSeparator;
import net.sourceforge.plantuml.project.command.NaturalCommand;
import net.sourceforge.plantuml.project.command.NaturalCommandAnd;
import net.sourceforge.plantuml.project.command.NaturalCommandAndAnd;
import net.sourceforge.plantuml.project.lang.ComplementPattern;
import net.sourceforge.plantuml.project.lang.SubjectDayAsDate;
import net.sourceforge.plantuml.project.lang.SubjectDayOfWeek;
import net.sourceforge.plantuml.project.lang.SubjectDaysAsDates;
import net.sourceforge.plantuml.project.lang.SubjectPattern;
import net.sourceforge.plantuml.project.lang.SubjectProject;
import net.sourceforge.plantuml.project.lang.SubjectResource;
import net.sourceforge.plantuml.project.lang.SubjectTask;
import net.sourceforge.plantuml.project.lang.SubjectToday;
import net.sourceforge.plantuml.project.lang.VerbPattern;

public class GanttDiagramFactory
extends UmlDiagramFactory {
    private static final Collection<Command> cache = new ArrayList<Command>();

    private static final List<SubjectPattern> subjects() {
        return Arrays.asList(new SubjectTask(), new SubjectProject(), new SubjectDayOfWeek(), new SubjectDayAsDate(), new SubjectDaysAsDates(), new SubjectResource(), new SubjectToday());
    }

    public GanttDiagramFactory(DiagramType type) {
        super(type);
    }

    @Override
    protected List<Command> createCommands() {
        ArrayList<Command> cmds = new ArrayList<Command>();
        this.addTitleCommands(cmds);
        cmds.add(new CommandNope());
        cmds.addAll(GanttDiagramFactory.getLanguageCommands());
        cmds.add(new CommandGanttArrow());
        cmds.add(new CommandGanttArrow2());
        cmds.add(new CommandColorTask());
        cmds.add(new CommandSeparator());
        cmds.add(new CommandPrintScale());
        cmds.add(new CommandPrintBetween());
        cmds.add(new CommandScale());
        cmds.add(new CommandPage());
        return cmds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<Command> getLanguageCommands() {
        Collection<Command> collection = cache;
        synchronized (collection) {
            if (cache.size() == 0) {
                Collection<VerbPattern> verbs;
                for (SubjectPattern subject : GanttDiagramFactory.subjects()) {
                    for (VerbPattern verb : subject.getVerbs()) {
                        for (ComplementPattern complement : verb.getComplements()) {
                            cache.add(NaturalCommand.create(subject, verb, complement));
                        }
                    }
                }
                for (SubjectPattern subject : GanttDiagramFactory.subjects()) {
                    verbs = subject.getVerbs();
                    for (VerbPattern verb1 : verbs) {
                        for (VerbPattern verb2 : verbs) {
                            if (verb1 == verb2) continue;
                            for (ComplementPattern complement1 : verb1.getComplements()) {
                                for (ComplementPattern complement2 : verb2.getComplements()) {
                                    cache.add(NaturalCommandAnd.create(subject, verb1, complement1, verb2, complement2));
                                }
                            }
                        }
                    }
                }
                for (SubjectPattern subject : GanttDiagramFactory.subjects()) {
                    verbs = subject.getVerbs();
                    for (VerbPattern verb1 : verbs) {
                        for (VerbPattern verb2 : verbs) {
                            for (VerbPattern verb3 : verbs) {
                                if (verb1 == verb2 || verb1 == verb3 || verb2 == verb3) continue;
                                for (ComplementPattern complement1 : verb1.getComplements()) {
                                    for (ComplementPattern complement2 : verb2.getComplements()) {
                                        for (ComplementPattern complement3 : verb3.getComplements()) {
                                            cache.add(NaturalCommandAndAnd.create(subject, verb1, complement1, verb2, complement2, verb3, complement3));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return cache;
    }

    @Override
    public GanttDiagram createEmptyDiagram() {
        return new GanttDiagram();
    }
}

