/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.GanttDiagram;
import net.sourceforge.plantuml.project.lang.Complement;
import net.sourceforge.plantuml.project.lang.ComplementPattern;
import net.sourceforge.plantuml.project.lang.Subject;
import net.sourceforge.plantuml.project.lang.SubjectPattern;
import net.sourceforge.plantuml.project.lang.Verb;
import net.sourceforge.plantuml.project.lang.VerbPattern;

public class NaturalCommandAnd
extends SingleLineCommand2<GanttDiagram> {
    private final SubjectPattern subjectPattern;
    private final VerbPattern verbPattern1;
    private final ComplementPattern complementPattern1;
    private final VerbPattern verbPattern2;
    private final ComplementPattern complementPattern2;

    private NaturalCommandAnd(RegexConcat pattern, SubjectPattern subject, VerbPattern verb1, ComplementPattern complement1, VerbPattern verb2, ComplementPattern complement2) {
        super(pattern);
        this.subjectPattern = subject;
        this.verbPattern1 = verb1;
        this.complementPattern1 = complement1;
        this.verbPattern2 = verb2;
        this.complementPattern2 = complement2;
    }

    public String toString() {
        return this.subjectPattern.toString() + " " + this.verbPattern1.toString() + " " + this.complementPattern1.toString() + " and " + this.verbPattern2.toString() + " " + this.complementPattern2.toString();
    }

    @Override
    protected CommandExecutionResult executeArg(GanttDiagram system, LineLocation location, RegexResult arg) {
        Subject subject = this.subjectPattern.getSubject(system, arg);
        Verb verb1 = this.verbPattern1.getVerb(system, arg);
        Failable<Complement> complement1 = this.complementPattern1.getComplement(system, arg, "1");
        if (complement1.isFail()) {
            return CommandExecutionResult.error(complement1.getError());
        }
        CommandExecutionResult result1 = verb1.execute(subject, complement1.get());
        if (!result1.isOk()) {
            return result1;
        }
        Verb verb2 = this.verbPattern2.getVerb(system, arg);
        Failable<Complement> complement2 = this.complementPattern2.getComplement(system, arg, "2");
        if (complement2.isFail()) {
            return CommandExecutionResult.error(complement2.getError());
        }
        return verb2.execute(subject, complement2.get());
    }

    public static Command create(SubjectPattern subject, VerbPattern verb1, ComplementPattern complement1, VerbPattern verb2, ComplementPattern complement2) {
        RegexConcat pattern = new RegexConcat(RegexLeaf.start(), subject.toRegex(), RegexLeaf.spaceOneOrMore(), verb1.toRegex(), RegexLeaf.spaceOneOrMore(), complement1.toRegex("1"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("and"), RegexLeaf.spaceOneOrMore(), verb2.toRegex(), RegexLeaf.spaceOneOrMore(), complement2.toRegex("2"), RegexLeaf.end());
        return new NaturalCommandAnd(pattern, subject, verb1, complement1, verb2, complement2);
    }
}

