/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.AlignmentParam;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.Guillemet;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ClusterDecoration;
import net.sourceforge.plantuml.svek.GeneralImageBuilder;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class EntityImageEmptyPackage
extends AbstractEntityImage {
    private final TextBlock desc;
    private static final int MARGIN = 10;
    private final HColor specificBackColor;
    private final ISkinParam skinParam;
    private final Stereotype stereotype;
    private final TextBlock stereoBlock;
    private final Url url;
    private final SName styleName;

    public EntityImageEmptyPackage(ILeaf entity, ISkinParam skinParam, PortionShower portionShower, SName styleName) {
        super(entity, skinParam);
        this.styleName = styleName;
        this.skinParam = skinParam;
        this.specificBackColor = entity.getColors(skinParam).getColor(ColorType.BACK);
        this.stereotype = entity.getStereotype();
        this.desc = entity.getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.PACKAGE, this.stereotype), HorizontalAlignment.CENTER, skinParam);
        this.url = entity.getUrl99();
        this.stereoBlock = this.stereotype == null || this.stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) == null || !portionShower.showPortion(EntityPortion.STEREOTYPE, entity) ? TextBlockUtils.empty(0.0, 0.0) : TextBlockUtils.withMargin(Display.create(this.stereotype.getLabels(skinParam.guillemet())).create(new FontConfiguration(this.getSkinParam(), FontParam.PACKAGE_STEREOTYPE, this.stereotype), HorizontalAlignment.CENTER, skinParam), 1.0, 0.0);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimDesc = this.desc.calculateDimension(stringBounder);
        Dimension2D dim = TextBlockUtils.mergeTB(this.desc, this.stereoBlock, HorizontalAlignment.LEFT).calculateDimension(stringBounder);
        dim = Dimension2DDouble.atLeast(dim, 0.0, 2.0 * dimDesc.getHeight());
        return Dimension2DDouble.delta(dim, 20.0, 20.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimTotal = this.calculateDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        HColor back = Cluster.getBackColor(this.specificBackColor, this.skinParam, this.stereotype, this.styleName);
        double roundCorner = 0.0;
        UStroke stroke = GeneralImageBuilder.getForcedStroke(this.getEntity().getStereotype(), this.getSkinParam());
        ClusterDecoration decoration = new ClusterDecoration(this.getSkinParam().packageStyle(), null, this.desc, this.stereoBlock, 0.0, 0.0, widthTotal, heightTotal, stroke);
        double shadowing = this.getSkinParam().shadowing(this.getEntity().getStereotype()) ? 3.0 : 0.0;
        decoration.drawU(ug, back, SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.packageBorder), shadowing, 0.0, this.getSkinParam().getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false), this.getSkinParam().getStereotypeAlignment());
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }
}

