/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ugraphic.AbstractShadowable;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.Scalable;
import net.sourceforge.plantuml.ugraphic.Shadowable;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UEmpty;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UShapeIgnorableForCompression;
import net.sourceforge.plantuml.ugraphic.UShapeSized;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.comp.CompressionMode;

public class URectangle
extends AbstractShadowable
implements Scalable,
UShapeSized,
UShapeIgnorableForCompression {
    private final double width;
    private final double height;
    private final double rx;
    private final double ry;
    private final String comment;
    private final boolean ignoreForCompressionOnX;
    private final boolean ignoreForCompressionOnY;

    public URectangle withHeight(double newHeight) {
        URectangle result = new URectangle(this.width, newHeight, this.rx, this.ry, this.comment, this.ignoreForCompressionOnX, this.ignoreForCompressionOnY);
        result.setDeltaShadow(this.getDeltaShadow());
        return result;
    }

    public URectangle withWidth(double newWidth) {
        URectangle result = new URectangle(newWidth, this.height, this.rx, this.ry, this.comment, this.ignoreForCompressionOnX, this.ignoreForCompressionOnY);
        result.setDeltaShadow(this.getDeltaShadow());
        return result;
    }

    public URectangle withComment(String comment) {
        return new URectangle(this.width, this.height, this.rx, this.ry, comment, this.ignoreForCompressionOnX, this.ignoreForCompressionOnY);
    }

    public URectangle rounded(double round) {
        return new URectangle(this.width, this.height, round, round, this.comment, this.ignoreForCompressionOnX, this.ignoreForCompressionOnY);
    }

    public Shadowable diagonalCorner(double diagonalCorner) {
        if (this.ignoreForCompressionOnX || this.ignoreForCompressionOnY) {
            throw new IllegalStateException();
        }
        if (diagonalCorner == 0.0) {
            return this;
        }
        UPath result = new UPath();
        result.moveTo(diagonalCorner, 0.0);
        result.lineTo(this.width - diagonalCorner, 0.0);
        result.lineTo(this.width, diagonalCorner);
        result.lineTo(this.width, this.height - diagonalCorner);
        result.lineTo(this.width - diagonalCorner, this.height);
        result.lineTo(diagonalCorner, this.height);
        result.lineTo(0.0, this.height - diagonalCorner);
        result.lineTo(0.0, diagonalCorner);
        result.lineTo(diagonalCorner, 0.0);
        return result;
    }

    public final URectangle ignoreForCompressionOnX() {
        return new URectangle(this.width, this.height, this.rx, this.ry, this.comment, true, this.ignoreForCompressionOnY);
    }

    public final URectangle ignoreForCompressionOnY() {
        return new URectangle(this.width, this.height, this.rx, this.ry, this.comment, this.ignoreForCompressionOnX, true);
    }

    @Override
    public UShape getScaled(double scale) {
        if (scale == 1.0) {
            return this;
        }
        URectangle result = new URectangle(this.width * scale, this.height * scale, this.rx * scale, this.ry * scale, this.comment, this.ignoreForCompressionOnX, this.ignoreForCompressionOnY);
        ((AbstractShadowable)result).setDeltaShadow(this.getDeltaShadow());
        return result;
    }

    public URectangle(double width, double height) {
        this(width, height, 0.0, 0.0, null, false, false);
    }

    public URectangle(Dimension2D dim) {
        this(dim.getWidth(), dim.getHeight());
    }

    private URectangle(double width, double height, double rx, double ry, String comment, boolean ignoreForCompressionOnX, boolean ignoreForCompressionOnY) {
        if (height == 0.0) {
            throw new IllegalArgumentException("height=" + height);
        }
        if (width == 0.0) {
            throw new IllegalArgumentException("width=" + width);
        }
        this.ignoreForCompressionOnX = ignoreForCompressionOnX;
        this.ignoreForCompressionOnY = ignoreForCompressionOnY;
        this.comment = comment;
        this.width = width;
        this.height = height;
        this.rx = rx;
        this.ry = ry;
    }

    public String toString() {
        return "width=" + this.width + " height=" + this.height;
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public double getHeight() {
        return this.height;
    }

    public double getRx() {
        return this.rx;
    }

    public double getRy() {
        return this.ry;
    }

    public URectangle clip(UClip clip) {
        return this;
    }

    public MinMax getMinMax() {
        return MinMax.fromMax(this.width, this.height);
    }

    public final String getComment() {
        return this.comment;
    }

    @Override
    public void drawWhenCompressed(UGraphic ug, CompressionMode mode) {
        if (mode == CompressionMode.ON_X) {
            ug.draw(new UEmpty(2.0, this.getHeight()));
            ug.apply(UTranslate.dx(this.getWidth() - 2.0)).draw(new UEmpty(2.0, this.getHeight()));
        }
        if (mode == CompressionMode.ON_Y) {
            ug.draw(new UEmpty(this.getWidth(), 2.0));
            ug.apply(UTranslate.dy(this.getHeight() - 2.0)).draw(new UEmpty(this.getWidth(), 2.0));
        }
    }

    @Override
    public boolean isIgnoreForCompressionOn(CompressionMode mode) {
        if (mode == CompressionMode.ON_X) {
            return this.ignoreForCompressionOnX;
        }
        if (mode == CompressionMode.ON_Y) {
            return this.ignoreForCompressionOnY;
        }
        throw new IllegalArgumentException();
    }
}

