# -*- coding: utf-8 -*-
info = {
    "name": "ast",
    "date_order": "DMY",
    "january": [
        "xineru",
        "xin",
        "de xineru"
    ],
    "february": [
        "febreru",
        "feb",
        "de febreru"
    ],
    "march": [
        "marzu",
        "mar",
        "de marzu"
    ],
    "april": [
        "abril",
        "abr",
        "d'abril"
    ],
    "may": [
        "mayu",
        "may",
        "de mayu"
    ],
    "june": [
        "xunu",
        "xun",
        "de xunu"
    ],
    "july": [
        "xunetu",
        "xnt",
        "de xunetu"
    ],
    "august": [
        "agostu",
        "ago",
        "d'agostu"
    ],
    "september": [
        "setiembre",
        "set",
        "de setiembre"
    ],
    "october": [
        "ochobre",
        "och",
        "d'ochobre"
    ],
    "november": [
        "payares",
        "pay",
        "de payares"
    ],
    "december": [
        "avientu",
        "avi",
        "d'avientu"
    ],
    "monday": [
        "llunes",
        "llu"
    ],
    "tuesday": [
        "martes",
        "mar"
    ],
    "wednesday": [
        "miércoles",
        "mié"
    ],
    "thursday": [
        "xueves",
        "xue"
    ],
    "friday": [
        "vienres",
        "vie"
    ],
    "saturday": [
        "sábadu",
        "sáb"
    ],
    "sunday": [
        "domingu",
        "dom"
    ],
    "am": [
        "mañana",
        "am",
        "de la mañana"
    ],
    "pm": [
        "tarde",
        "pm",
        "de la tarde"
    ],
    "year": [
        "añu"
    ],
    "month": [
        "mes"
    ],
    "week": [
        "selmana",
        "sel"
    ],
    "day": [
        "día"
    ],
    "hour": [
        "hora",
        "h"
    ],
    "minute": [
        "minutu",
        "min",
        "m"
    ],
    "second": [
        "segundu",
        "s"
    ],
    "relative-type": {
        "1 year ago": [
            "l'añu pasáu",
            "l'añu pas",
            "añu pas"
        ],
        "0 year ago": [
            "esti añu"
        ],
        "in 1 year": [
            "l'añu viniente",
            "l'añu vin",
            "añu vin"
        ],
        "1 month ago": [
            "el mes pasáu",
            "mes pas"
        ],
        "0 month ago": [
            "esti mes"
        ],
        "in 1 month": [
            "el mes viniente",
            "mes vin"
        ],
        "1 week ago": [
            "la selmana pasada",
            "selm pasada",
            "selm pas"
        ],
        "0 week ago": [
            "esta selmana",
            "esta selm"
        ],
        "in 1 week": [
            "la selmana viniente",
            "selm viniente",
            "selm vin"
        ],
        "1 day ago": [
            "ayeri"
        ],
        "0 day ago": [
            "güei"
        ],
        "in 1 day": [
            "mañana",
            "mañ"
        ],
        "0 hour ago": [
            "esta hora",
            "esta h"
        ],
        "0 minute ago": [
            "esti minutu",
            "esti min"
        ],
        "0 second ago": [
            "agora"
        ]
    },
    "relative-type-regex": {
        "in \\1 year": [
            "en (\\d+) añu",
            "en (\\d+) años",
            "en (\\d+) a"
        ],
        "\\1 year ago": [
            "hai (\\d+) añu",
            "hai (\\d+) años",
            "hai (\\d+) a"
        ],
        "in \\1 month": [
            "en (\\d+) mes",
            "en (\\d+) meses",
            "en (\\d+) m"
        ],
        "\\1 month ago": [
            "hai (\\d+) mes",
            "hai (\\d+) meses",
            "hai (\\d+) m"
        ],
        "in \\1 week": [
            "en (\\d+) selmana",
            "en (\\d+) selmanes",
            "en (\\d+) selm",
            "en (\\d+) se"
        ],
        "\\1 week ago": [
            "hai (\\d+) selmana",
            "hai (\\d+) selmanes",
            "hai (\\d+) selm",
            "hai (\\d+) se"
        ],
        "in \\1 day": [
            "en (\\d+) día",
            "en (\\d+) díes",
            "en (\\d+) d"
        ],
        "\\1 day ago": [
            "hai (\\d+) día",
            "hai (\\d+) díes",
            "hai (\\d+) d"
        ],
        "in \\1 hour": [
            "en (\\d+) hora",
            "en (\\d+) hores",
            "en (\\d+) h"
        ],
        "\\1 hour ago": [
            "hai (\\d+) hora",
            "hai (\\d+) hores",
            "hai (\\d+) h"
        ],
        "in \\1 minute": [
            "en (\\d+) minutu",
            "en (\\d+) minutos",
            "en (\\d+) min"
        ],
        "\\1 minute ago": [
            "hai (\\d+) minutu",
            "hai (\\d+) minutos",
            "hai (\\d+) min"
        ],
        "in \\1 second": [
            "en (\\d+) segundu",
            "en (\\d+) segundos",
            "en (\\d+) seg",
            "en (\\d+) s"
        ],
        "\\1 second ago": [
            "hai (\\d+) segundu",
            "hai (\\d+) segundos",
            "hai (\\d+) seg",
            "hai (\\d+) s"
        ]
    },
    "locale_specific": {},
    "skip": [
        " ",
        ".",
        ",",
        ";",
        "-",
        "/",
        "'",
        "|",
        "@",
        "[",
        "]",
        "，"
    ]
}
