/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.HierarchyBoundsListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import javax.swing.BorderFactory;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;

final class ProfilerTableHovers {
    private static final int MAX_RENDERER_WIDTH = 5000;
    private static final int POPUP_LEFT = 0;
    private static final int POPUP_RIGHT = 1;
    private final ProfilerTable table;
    private Opener opener;
    private Closer closer;
    private CellRendererPane crp;
    private int currentRow = -1;
    private int currentColumn = -1;
    private Point currentScreenPoint;
    private final JWindow[] windows = new JWindow[2];

    static void install(ProfilerTable profilerTable) {
        new ProfilerTableHovers(profilerTable).install();
    }

    private ProfilerTableHovers(ProfilerTable profilerTable) {
        this.table = profilerTable;
    }

    private void install() {
        this.opener = new Opener();
        this.opener.install();
    }

    private void updatePopups(Point point, boolean bl) {
        if (this.currentScreenPoint == null) {
            this.hidePopups();
        } else {
            if (point == null) {
                point = new Point(this.currentScreenPoint);
                SwingUtilities.convertPointFromScreen(point, this.table);
            }
            this.checkPopup(this.table.rowAtPoint(point), this.table.columnAtPoint(point), point, bl);
        }
    }

    private void checkPopup(int n, int n2, Point point, boolean bl) {
        if (!this.table.isShowing()) {
            this.hidePopups();
            this.currentScreenPoint = null;
            return;
        }
        if (n < 0 || n2 < 0 || n >= this.table.getRowCount() || n2 >= this.table.getColumnCount()) {
            this.hidePopups();
            return;
        }
        Component component = this.getRenderer(n, n2);
        Rectangle[] rectangleArray = this.computePopups(n, n2, point, component);
        if (rectangleArray == null) {
            this.hidePopups();
        } else if (bl || this.currentRow != n || this.currentColumn != n2) {
            if (!ProfilerTableHovers.isInFocusedWindow(this.table) || ProfilerTableHovers.isPopupOpen()) {
                this.hidePopups();
            } else {
                this.currentRow = n;
                this.currentColumn = n2;
                this.showPopups(component, rectangleArray);
            }
        }
    }

    private static boolean isInFocusedWindow(Component component) {
        Window window = SwingUtilities.getWindowAncestor(component);
        return window != null && window.isFocused();
    }

    private static boolean isPopupOpen() {
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        return menuElementArray != null && menuElementArray.length > 0;
    }

    private void showPopups(Component component, Rectangle[] rectangleArray) {
        Image image = this.createPopupImage(component);
        Color color = this.table.getGridColor();
        if (rectangleArray[0] != null) {
            this.openWindow(rectangleArray[0], image, 0, color);
        } else if (this.windows[0] != null) {
            this.closeWindow(0);
        }
        if (rectangleArray[1] != null) {
            this.openWindow(rectangleArray[1], image, 1, color);
        } else if (this.windows[1] != null) {
            this.closeWindow(1);
        }
        if (this.closer == null) {
            this.closer = new Closer();
            this.closer.install();
        }
    }

    private void hidePopups() {
        if (this.windows[0] == null && this.windows[1] == null) {
            return;
        }
        this.currentRow = -1;
        this.currentColumn = -1;
        if (this.windows[0] != null) {
            this.closeWindow(0);
        }
        if (this.windows[1] != null) {
            this.closeWindow(1);
        }
        if (this.closer != null) {
            this.closer.deinstall();
            this.closer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image createPopupImage(Component component) {
        int n = component.getWidth();
        int n2 = component.getHeight();
        Image image = !Platform.isMac() ? this.table.createVolatileImage(n, n2) : new BufferedImage(n, n2, 2);
        Graphics graphics = image.getGraphics();
        try {
            graphics.setColor(this.table.getBackground());
            graphics.fillRect(0, 0, n, n2);
            component.move(0, 0);
            if (this.crp == null) {
                this.crp = new CellRendererPane(){

                    @Override
                    public void paintComponent(Graphics graphics, Component component, Container container, int n, int n2, int n3, int n4, boolean bl) {
                        super.paintComponent(graphics, component, container, n, n2, n3, n4, bl);
                        this.remove(component);
                    }
                };
            }
            this.crp.paintComponent(graphics, component, null, 0, 0, n, n2, false);
        }
        finally {
            graphics.dispose();
        }
        return image;
    }

    private void openWindow(Rectangle rectangle, final Image image, int n, Color color) {
        final boolean bl = n == 0;
        final int n2 = rectangle.width;
        final int n3 = rectangle.height;
        final int n4 = image.getWidth(null);
        final int n5 = image.getHeight(null);
        JPanel jPanel = new JPanel(null){

            @Override
            protected void paintComponent(Graphics graphics) {
                if (bl) {
                    graphics.drawImage(image, 1, 1, 1 + n2, 1 + n3, 0, 0, n2, n3, null);
                } else {
                    graphics.drawImage(image, 0, 1, 0 + n2, 1 + n3, n4 - n2, 0, n4, n5, null);
                }
            }
        };
        if (bl) {
            jPanel.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 0, color));
        } else {
            jPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 1, color));
        }
        jPanel.setSize(n2 + 1, n3 + 2);
        JWindow jWindow = this.windows[n];
        if (jWindow == null) {
            jWindow = new JWindow(SwingUtilities.getWindowAncestor(this.table));
            jWindow.setType(Window.Type.POPUP);
            jWindow.setFocusable(false);
            jWindow.setAutoRequestFocus(false);
            jWindow.setFocusableWindowState(false);
            jWindow.getContentPane().add(jPanel);
            ProfilerTableHovers.safeSetBackground(jWindow, new Color(255, 255, 255, 0));
            jWindow.getRootPane().putClientProperty("Window.shadow", Boolean.FALSE.toString());
            jWindow.setVisible(true);
        } else {
            jWindow.getContentPane().removeAll();
            jWindow.getContentPane().add(jPanel);
            if (jWindow.isVisible()) {
                jWindow.repaint();
            } else {
                jWindow.setVisible(true);
            }
        }
        Point point = this.table.getLocationOnScreen();
        jWindow.setBounds(rectangle.x + point.x - (bl ? 1 : 0), rectangle.y + point.y - 1, n2 + 1, n3 + 2);
        this.windows[n] = jWindow;
    }

    private void closeWindow(int n) {
        this.windows[n].setVisible(false);
        this.windows[n].dispose();
        this.windows[n] = null;
    }

    private static void safeSetBackground(JWindow jWindow, Color color) {
        GraphicsConfiguration graphicsConfiguration = jWindow.getGraphicsConfiguration();
        if (!graphicsConfiguration.isTranslucencyCapable()) {
            return;
        }
        if (graphicsConfiguration.getDevice().getFullScreenWindow() == jWindow) {
            return;
        }
        jWindow.setBackground(color);
    }

    private Rectangle[] computePopups(int n, int n2, Point point, Component component) {
        Rectangle rectangle;
        Rectangle rectangle2 = this.getRendererRect(n2, component);
        if (rectangle2 == null) {
            return null;
        }
        Rectangle rectangle3 = this.table.getCellRect(n, n2, true);
        rectangle2.translate(rectangle3.x, rectangle3.y);
        --rectangle3.width;
        if (rectangle3.contains(rectangle2)) {
            return null;
        }
        Rectangle rectangle4 = rectangle3.intersection(rectangle2);
        if (!rectangle4.contains(point)) {
            return null;
        }
        Rectangle[] rectangleArray = new Rectangle[2];
        if (rectangle2.x < rectangle4.x) {
            rectangle = new Rectangle(rectangle2);
            rectangle.width = rectangle4.x - rectangle.x;
            rectangleArray[0] = rectangle;
        }
        if (rectangle2.x + rectangle2.width - 1 > rectangle4.x + rectangle4.width) {
            rectangle = new Rectangle(rectangle2);
            rectangle.x = rectangle4.x + rectangle4.width;
            rectangle.width = rectangle2.x + rectangle2.width - rectangle.x;
            rectangleArray[1] = rectangle;
        }
        return rectangleArray;
    }

    private Rectangle getRendererRect(int n, Component component) {
        int n2 = this.table.convertColumnIndexToModel(n);
        if (!(component instanceof ProfilerRenderer) && !this.table.isScrollableColumn(n2)) {
            return null;
        }
        if (component instanceof JComponent && ((JComponent)component).getClientProperty("ProfilerTableHover_NoHover") != null) {
            return null;
        }
        Rectangle rectangle = component.getBounds();
        rectangle.x -= this.table.getColumnOffset(n2);
        return rectangle;
    }

    private Component getRenderer(int n, int n2) {
        TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n, n2);
        Component component = this.table.getRenderer(tableCellRenderer, n, n2, true);
        component.setSize(Math.min(component.getWidth(), 5000), component.getHeight());
        return component;
    }

    private class Closer
    extends MouseAdapter
    implements KeyListener,
    ComponentListener,
    HierarchyListener,
    HierarchyBoundsListener,
    FocusListener,
    ListSelectionListener {
        private Closer() {
        }

        void install() {
            ProfilerTableHovers.this.table.addMouseListener(this);
            ProfilerTableHovers.this.table.addMouseMotionListener(this);
            ProfilerTableHovers.this.table.getSelectionModel().addListSelectionListener(this);
            ProfilerTableHovers.this.table.addComponentListener(this);
            ProfilerTableHovers.this.table.addHierarchyListener(this);
            ProfilerTableHovers.this.table.addHierarchyBoundsListener(this);
        }

        void deinstall() {
            ProfilerTableHovers.this.table.removeMouseListener(this);
            ProfilerTableHovers.this.table.removeMouseMotionListener(this);
            ProfilerTableHovers.this.table.getSelectionModel().removeListSelectionListener(this);
            ProfilerTableHovers.this.table.removeComponentListener(this);
            ProfilerTableHovers.this.table.removeHierarchyListener(this);
            ProfilerTableHovers.this.table.removeHierarchyBoundsListener(this);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ProfilerTableHovers.this.updatePopups(mouseEvent.getPoint(), true);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ProfilerTableHovers.this.updatePopups(mouseEvent.getPoint(), true);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ProfilerTableHovers.this.updatePopups(null, true);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            ProfilerTableHovers.this.hidePopups();
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            ProfilerTableHovers.this.hidePopups();
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            ProfilerTableHovers.this.hidePopups();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            ProfilerTableHovers.this.hidePopups();
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            ProfilerTableHovers.this.hidePopups();
            ProfilerTableHovers.this.currentScreenPoint = null;
        }

        @Override
        public void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            ProfilerTableHovers.this.hidePopups();
        }

        @Override
        public void ancestorMoved(HierarchyEvent hierarchyEvent) {
            ProfilerTableHovers.this.hidePopups();
        }

        @Override
        public void ancestorResized(HierarchyEvent hierarchyEvent) {
            ProfilerTableHovers.this.hidePopups();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            ProfilerTableHovers.this.hidePopups();
            ProfilerTableHovers.this.currentScreenPoint = null;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ProfilerTableHovers.this.hidePopups();
        }
    }

    private class Opener
    extends MouseAdapter
    implements ComponentListener,
    TableModelListener {
        private Opener() {
        }

        void install() {
            ProfilerTableHovers.this.table.addMouseListener(this);
            ProfilerTableHovers.this.table.addMouseMotionListener(this);
            ProfilerTableHovers.this.table.addComponentListener(this);
            ProfilerTableHovers.this.table.getModel().addTableModelListener(this);
        }

        void deinstall() {
            ProfilerTableHovers.this.hidePopups();
            ProfilerTableHovers.this.table.removeMouseListener(this);
            ProfilerTableHovers.this.table.removeMouseMotionListener(this);
            ProfilerTableHovers.this.table.removeComponentListener(this);
            ProfilerTableHovers.this.table.getModel().removeTableModelListener(this);
            ProfilerTableHovers.this.currentScreenPoint = null;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            ProfilerTableHovers.this.currentScreenPoint = mouseEvent.getLocationOnScreen();
            ProfilerTableHovers.this.updatePopups(mouseEvent.getPoint(), false);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            ProfilerTableHovers.this.currentScreenPoint = mouseEvent.getLocationOnScreen();
            ProfilerTableHovers.this.updatePopups(mouseEvent.getPoint(), false);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            ProfilerTableHovers.this.hidePopups();
            ProfilerTableHovers.this.currentScreenPoint = null;
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            ProfilerTableHovers.this.updatePopups(null, false);
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void tableChanged(TableModelEvent tableModelEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProfilerTableHovers.this.updatePopups(null, true);
                }
            });
        }
    }
}

