/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.swing;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.plaf.ButtonUI;
import javax.swing.plaf.basic.BasicButtonUI;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.modules.profiler.snaptracer.impl.swing.HeaderPanel;

public class HeaderButton
extends HeaderPanel {
    private static final HeaderButtonUI UI = new HeaderButtonUI();
    private final JButton button;

    public HeaderButton(String string, Icon icon) {
        JPanel jPanel = super.getClientContainer();
        jPanel.setLayout(new BorderLayout());
        this.button = new JButton(string, icon){

            @Override
            protected void processMouseEvent(MouseEvent mouseEvent) {
                super.processMouseEvent(mouseEvent);
                if (!this.isEnabled()) {
                    return;
                }
                HeaderButton.this.processMouseEvent(mouseEvent);
            }

            @Override
            protected void fireActionPerformed(ActionEvent actionEvent) {
                HeaderButton.this.performAction(actionEvent);
            }
        };
        jPanel.add((Component)this.button, "Center");
        this.button.setOpaque(false);
        this.button.setBorderPainted(false);
        this.button.setMargin(new Insets(0, 0, 0, 0));
        this.button.setUI(UI);
    }

    @Override
    public void setToolTipText(String string) {
        this.button.setToolTipText(string);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.button.setEnabled(bl);
        super.setEnabled(bl);
    }

    public void reset() {
        this.processMouseEvent(new MouseEvent(this, 505, System.currentTimeMillis(), 0, -1, -1, 0, false));
    }

    @Override
    protected boolean processMouseEvents() {
        return true;
    }

    protected void performAction(ActionEvent actionEvent) {
    }

    public void setUI(ButtonUI buttonUI) {
        if (buttonUI == UI) {
            super.setUI(buttonUI);
        }
    }

    private static class HeaderButtonUI
    extends BasicButtonUI {
        private static final Color FOCUS_COLOR = Color.BLACK;
        private static final Stroke FOCUS_STROKE = new BasicStroke(1.0f, 2, 2, 0.0f, new float[]{0.0f, 2.0f}, 0.0f);
        private static final Color PRESSED_FOREGROUND = Utils.checkedColor((Color)new Color(100, 100, 100, 70));

        private HeaderButtonUI() {
        }

        @Override
        protected void paintFocus(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(FOCUS_STROKE);
            graphics2D.setColor(FOCUS_COLOR);
            graphics2D.drawRect(2, 2, abstractButton.getWidth() - 5, abstractButton.getHeight() - 5);
        }

        @Override
        protected void paintButtonPressed(Graphics graphics, AbstractButton abstractButton) {
            graphics.setColor(PRESSED_FOREGROUND);
            graphics.fillRect(0, 0, abstractButton.getWidth(), abstractButton.getHeight());
        }
    }
}

