/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.bytes.AbstractBytesReference;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.transport.netty4.ByteBufStreamInput;

final class ByteBufBytesReference
extends AbstractBytesReference {
    private final ByteBuf buffer;
    private final int length;
    private final int offset;

    ByteBufBytesReference(ByteBuf buffer, int length) {
        this.buffer = buffer;
        this.length = length;
        this.offset = buffer.readerIndex();
        assert (length <= buffer.readableBytes()) : "length[" + length + "] > " + buffer.readableBytes();
    }

    public byte get(int index) {
        return this.buffer.getByte(this.offset + index);
    }

    public int getInt(int index) {
        return this.buffer.getInt(this.offset + index);
    }

    public int indexOf(byte marker, int from) {
        int start = this.offset + from;
        return this.buffer.forEachByte(start, this.length - start, value -> value != marker);
    }

    public int length() {
        return this.length;
    }

    public BytesReference slice(int from, int length) {
        return new ByteBufBytesReference(this.buffer.slice(this.offset + from, length), length);
    }

    public StreamInput streamInput() {
        return new ByteBufStreamInput(this.buffer.duplicate(), this.length);
    }

    public void writeTo(OutputStream os) throws IOException {
        this.buffer.getBytes(this.offset, os, this.length);
    }

    ByteBuf toByteBuf() {
        return this.buffer.duplicate();
    }

    public String utf8ToString() {
        return this.buffer.toString(this.offset, this.length, StandardCharsets.UTF_8);
    }

    public BytesRef toBytesRef() {
        if (this.buffer.hasArray()) {
            return new BytesRef(this.buffer.array(), this.buffer.arrayOffset() + this.offset, this.length);
        }
        byte[] copy = new byte[this.length];
        this.buffer.getBytes(this.offset, copy);
        return new BytesRef(copy);
    }

    public long ramBytesUsed() {
        return this.buffer.capacity();
    }
}

