/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.Closeable;
import java.io.FilterOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntPredicate;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.SerialMergeScheduler;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.ReleasableBytesStreamOutput;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.NodeMetaData;
import org.elasticsearch.index.Index;

public class PersistedClusterStateService {
    private static final Logger logger = LogManager.getLogger(PersistedClusterStateService.class);
    private static final String CURRENT_TERM_KEY = "current_term";
    private static final String LAST_ACCEPTED_VERSION_KEY = "last_accepted_version";
    private static final String NODE_ID_KEY = "node_id";
    private static final String NODE_VERSION_KEY = "node_version";
    private static final String TYPE_FIELD_NAME = "type";
    private static final String DATA_FIELD_NAME = "data";
    private static final String GLOBAL_TYPE_NAME = "global";
    private static final String INDEX_TYPE_NAME = "index";
    private static final String INDEX_UUID_FIELD_NAME = "index_uuid";
    private static final int COMMIT_DATA_SIZE = 4;
    public static final String METADATA_DIRECTORY_NAME = "_state";
    public static final Setting<TimeValue> SLOW_WRITE_LOGGING_THRESHOLD = Setting.timeSetting("gateway.slow_write_logging_threshold", TimeValue.timeValueSeconds((long)10L), TimeValue.ZERO, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private final Path[] dataPaths;
    private final String nodeId;
    private final NamedXContentRegistry namedXContentRegistry;
    private final BigArrays bigArrays;
    private final LongSupplier relativeTimeMillisSupplier;
    private volatile TimeValue slowWriteLoggingThreshold;
    private static final ToXContent.Params FORMAT_PARAMS;

    public PersistedClusterStateService(NodeEnvironment nodeEnvironment, NamedXContentRegistry namedXContentRegistry, BigArrays bigArrays, ClusterSettings clusterSettings, LongSupplier relativeTimeMillisSupplier) {
        this(nodeEnvironment.nodeDataPaths(), nodeEnvironment.nodeId(), namedXContentRegistry, bigArrays, clusterSettings, relativeTimeMillisSupplier);
    }

    public PersistedClusterStateService(Path[] dataPaths, String nodeId, NamedXContentRegistry namedXContentRegistry, BigArrays bigArrays, ClusterSettings clusterSettings, LongSupplier relativeTimeMillisSupplier) {
        this.dataPaths = dataPaths;
        this.nodeId = nodeId;
        this.namedXContentRegistry = namedXContentRegistry;
        this.bigArrays = bigArrays;
        this.relativeTimeMillisSupplier = relativeTimeMillisSupplier;
        this.slowWriteLoggingThreshold = clusterSettings.get(SLOW_WRITE_LOGGING_THRESHOLD);
        clusterSettings.addSettingsUpdateConsumer(SLOW_WRITE_LOGGING_THRESHOLD, this::setSlowWriteLoggingThreshold);
    }

    private void setSlowWriteLoggingThreshold(TimeValue slowWriteLoggingThreshold) {
        this.slowWriteLoggingThreshold = slowWriteLoggingThreshold;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Writer createWriter() throws IOException {
        ArrayList<MetaDataIndexWriter> metaDataIndexWriters = new ArrayList<MetaDataIndexWriter>();
        ArrayList<Object> closeables = new ArrayList<Object>();
        boolean success = false;
        try {
            for (Path path : this.dataPaths) {
                Directory directory = this.createDirectory(path.resolve(METADATA_DIRECTORY_NAME));
                closeables.add(directory);
                IndexWriter indexWriter = PersistedClusterStateService.createIndexWriter(directory, false);
                closeables.add(indexWriter);
                metaDataIndexWriters.add(new MetaDataIndexWriter(directory, indexWriter));
            }
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException(closeables);
            }
        }
        return new Writer(metaDataIndexWriters, this.nodeId, this.bigArrays, this.relativeTimeMillisSupplier, () -> this.slowWriteLoggingThreshold);
    }

    private static IndexWriter createIndexWriter(Directory directory, boolean openExisting) throws IOException {
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig((Analyzer)new KeywordAnalyzer());
        indexWriterConfig.setOpenMode(openExisting ? IndexWriterConfig.OpenMode.APPEND : IndexWriterConfig.OpenMode.CREATE);
        indexWriterConfig.setCommitOnClose(false);
        indexWriterConfig.setRAMBufferSizeMB(1.0);
        indexWriterConfig.setMergeScheduler((MergeScheduler)new SerialMergeScheduler());
        return new IndexWriter(directory, indexWriterConfig);
    }

    public static void deleteAll(Path[] dataPaths) throws IOException {
        for (Path dataPath : dataPaths) {
            Lucene.cleanLuceneIndex((Directory)new SimpleFSDirectory(dataPath.resolve(METADATA_DIRECTORY_NAME)));
        }
    }

    Directory createDirectory(Path path) throws IOException {
        return new SimpleFSDirectory(path);
    }

    public Path[] getDataPaths() {
        return this.dataPaths;
    }

    @Nullable
    public static NodeMetaData nodeMetaData(Path ... dataPaths) throws IOException {
        String nodeId = null;
        Version version = null;
        for (Path dataPath : dataPaths) {
            Path indexPath = dataPath.resolve(METADATA_DIRECTORY_NAME);
            if (!Files.exists(indexPath, new LinkOption[0])) continue;
            try (DirectoryReader reader = DirectoryReader.open((Directory)new SimpleFSDirectory(dataPath.resolve(METADATA_DIRECTORY_NAME)));){
                Map userData = reader.getIndexCommit().getUserData();
                assert (userData.get(NODE_VERSION_KEY) != null);
                String thisNodeId = (String)userData.get(NODE_ID_KEY);
                assert (thisNodeId != null);
                if (nodeId != null && !nodeId.equals(thisNodeId)) {
                    throw new IllegalStateException("unexpected node ID in metadata, found [" + thisNodeId + "] in [" + dataPath + "] but expected [" + nodeId + "]");
                }
                if (nodeId != null) continue;
                nodeId = thisNodeId;
                version = Version.fromId(Integer.parseInt((String)userData.get(NODE_VERSION_KEY)));
            }
            catch (IndexNotFoundException e) {
                logger.debug((Message)new ParameterizedMessage("no on-disk state at {}", (Object)indexPath), (Throwable)e);
            }
        }
        if (nodeId == null) {
            return null;
        }
        return new NodeMetaData(nodeId, version);
    }

    public static void overrideVersion(Version newVersion, Path ... dataPaths) throws IOException {
        for (Path dataPath : dataPaths) {
            Path indexPath = dataPath.resolve(METADATA_DIRECTORY_NAME);
            if (!Files.exists(indexPath, new LinkOption[0])) continue;
            try (DirectoryReader reader = DirectoryReader.open((Directory)new SimpleFSDirectory(dataPath.resolve(METADATA_DIRECTORY_NAME)));){
                Map userData = reader.getIndexCommit().getUserData();
                assert (userData.get(NODE_VERSION_KEY) != null);
                try (IndexWriter indexWriter = PersistedClusterStateService.createIndexWriter((Directory)new SimpleFSDirectory(dataPath.resolve(METADATA_DIRECTORY_NAME)), true);){
                    HashMap<String, String> commitData = new HashMap<String, String>(userData);
                    commitData.put(NODE_VERSION_KEY, Integer.toString(newVersion.id));
                    indexWriter.setLiveCommitData(commitData.entrySet());
                    indexWriter.commit();
                }
            }
            catch (IndexNotFoundException e) {
                logger.debug((Message)new ParameterizedMessage("no on-disk state at {}", (Object)indexPath), (Throwable)e);
            }
        }
    }

    public OnDiskState loadBestOnDiskState() throws IOException {
        OnDiskState bestOnDiskState;
        String committedClusterUuid = null;
        Path committedClusterUuidPath = null;
        OnDiskState maxCurrentTermOnDiskState = bestOnDiskState = OnDiskState.NO_ON_DISK_STATE;
        for (Path dataPath : this.dataPaths) {
            Path indexPath = dataPath.resolve(METADATA_DIRECTORY_NAME);
            if (!Files.exists(indexPath, new LinkOption[0])) continue;
            try (Directory directory = this.createDirectory(indexPath);
                 DirectoryReader directoryReader = DirectoryReader.open((Directory)directory);){
                OnDiskState onDiskState = this.loadOnDiskState(dataPath, directoryReader);
                if (!this.nodeId.equals(onDiskState.nodeId)) {
                    throw new IllegalStateException("unexpected node ID in metadata, found [" + onDiskState.nodeId + "] in [" + dataPath + "] but expected [" + this.nodeId + "]");
                }
                if (onDiskState.metaData.clusterUUIDCommitted()) {
                    if (committedClusterUuid == null) {
                        committedClusterUuid = onDiskState.metaData.clusterUUID();
                        committedClusterUuidPath = dataPath;
                    } else if (!committedClusterUuid.equals(onDiskState.metaData.clusterUUID())) {
                        throw new IllegalStateException("mismatched cluster UUIDs in metadata, found [" + committedClusterUuid + "] in [" + committedClusterUuidPath + "] and [" + onDiskState.metaData.clusterUUID() + "] in [" + dataPath + "]");
                    }
                }
                if (maxCurrentTermOnDiskState.empty() || maxCurrentTermOnDiskState.currentTerm < onDiskState.currentTerm) {
                    maxCurrentTermOnDiskState = onDiskState;
                }
                long acceptedTerm = onDiskState.metaData.coordinationMetaData().term();
                long maxAcceptedTerm = bestOnDiskState.metaData.coordinationMetaData().term();
                if (!bestOnDiskState.empty() && acceptedTerm <= maxAcceptedTerm && (acceptedTerm != maxAcceptedTerm || onDiskState.lastAcceptedVersion <= bestOnDiskState.lastAcceptedVersion && (onDiskState.lastAcceptedVersion != bestOnDiskState.lastAcceptedVersion || onDiskState.currentTerm <= bestOnDiskState.currentTerm))) continue;
                bestOnDiskState = onDiskState;
            }
            catch (IndexNotFoundException e) {
                logger.debug((Message)new ParameterizedMessage("no on-disk state at {}", (Object)indexPath), (Throwable)e);
            }
        }
        if (bestOnDiskState.currentTerm != maxCurrentTermOnDiskState.currentTerm) {
            throw new IllegalStateException("inconsistent terms found: best state is from [" + bestOnDiskState.dataPath + "] in term [" + bestOnDiskState.currentTerm + "] but there is a stale state in [" + maxCurrentTermOnDiskState.dataPath + "] with greater term [" + maxCurrentTermOnDiskState.currentTerm + "]");
        }
        return bestOnDiskState;
    }

    private OnDiskState loadOnDiskState(Path dataPath, DirectoryReader reader) throws IOException {
        IndexSearcher searcher = new IndexSearcher((IndexReader)reader);
        searcher.setQueryCache(null);
        SetOnce builderReference = new SetOnce();
        PersistedClusterStateService.consumeFromType(searcher, GLOBAL_TYPE_NAME, bytes -> {
            MetaData metaData = MetaData.Builder.fromXContent(XContentFactory.xContent((XContentType)XContentType.SMILE).createParser(this.namedXContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, bytes.bytes, bytes.offset, bytes.length));
            logger.trace("found global metadata with last-accepted term [{}]", (Object)metaData.coordinationMetaData().term());
            if (builderReference.get() != null) {
                throw new IllegalStateException("duplicate global metadata found in [" + dataPath + "]");
            }
            builderReference.set((Object)MetaData.builder(metaData));
        });
        MetaData.Builder builder = (MetaData.Builder)builderReference.get();
        if (builder == null) {
            throw new IllegalStateException("no global metadata found in [" + dataPath + "]");
        }
        logger.trace("got global metadata, now reading index metadata");
        HashSet indexUUIDs = new HashSet();
        PersistedClusterStateService.consumeFromType(searcher, INDEX_TYPE_NAME, bytes -> {
            IndexMetaData indexMetaData = IndexMetaData.fromXContent(XContentFactory.xContent((XContentType)XContentType.SMILE).createParser(this.namedXContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, bytes.bytes, bytes.offset, bytes.length));
            logger.trace("found index metadata for {}", (Object)indexMetaData.getIndex());
            if (!indexUUIDs.add(indexMetaData.getIndexUUID())) {
                throw new IllegalStateException("duplicate metadata found for " + indexMetaData.getIndex() + " in [" + dataPath + "]");
            }
            builder.put(indexMetaData, false);
        });
        Map userData = reader.getIndexCommit().getUserData();
        logger.trace("loaded metadata [{}] from [{}]", (Object)userData, (Object)reader.directory());
        assert (userData.size() == 4) : userData;
        assert (userData.get(CURRENT_TERM_KEY) != null);
        assert (userData.get(LAST_ACCEPTED_VERSION_KEY) != null);
        assert (userData.get(NODE_ID_KEY) != null);
        assert (userData.get(NODE_VERSION_KEY) != null);
        return new OnDiskState((String)userData.get(NODE_ID_KEY), dataPath, Long.parseLong((String)userData.get(CURRENT_TERM_KEY)), Long.parseLong((String)userData.get(LAST_ACCEPTED_VERSION_KEY)), builder.build());
    }

    private static void consumeFromType(IndexSearcher indexSearcher, String type, CheckedConsumer<BytesRef, IOException> bytesRefConsumer) throws IOException {
        TermQuery query = new TermQuery(new Term(TYPE_FIELD_NAME, type));
        Weight weight = indexSearcher.createWeight((Query)query, ScoreMode.COMPLETE_NO_SCORES, 0.0f);
        logger.trace("running query [{}]", (Object)query);
        for (LeafReaderContext leafReaderContext : indexSearcher.getIndexReader().leaves()) {
            logger.trace("new leafReaderContext: {}", (Object)leafReaderContext);
            Scorer scorer = weight.scorer(leafReaderContext);
            if (scorer == null) continue;
            Bits liveDocs = leafReaderContext.reader().getLiveDocs();
            IntPredicate isLiveDoc = liveDocs == null ? i -> true : arg_0 -> ((Bits)liveDocs).get(arg_0);
            DocIdSetIterator docIdSetIterator = scorer.iterator();
            while (docIdSetIterator.nextDoc() != Integer.MAX_VALUE) {
                if (!isLiveDoc.test(docIdSetIterator.docID())) continue;
                logger.trace("processing doc {}", (Object)docIdSetIterator.docID());
                bytesRefConsumer.accept(leafReaderContext.reader().document(docIdSetIterator.docID()).getBinaryValue(DATA_FIELD_NAME));
            }
        }
    }

    static {
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("binary", "true");
        params.put("context_mode", MetaData.CONTEXT_MODE_GATEWAY);
        FORMAT_PARAMS = new ToXContent.MapParams(params);
    }

    private static class MetaDataIndexWriter
    implements Closeable {
        private final Logger logger;
        private final Directory directory;
        private final IndexWriter indexWriter;

        MetaDataIndexWriter(Directory directory, IndexWriter indexWriter) {
            this.directory = directory;
            this.indexWriter = indexWriter;
            this.logger = Loggers.getLogger(MetaDataIndexWriter.class, directory.toString());
        }

        void deleteAll() throws IOException {
            this.logger.trace("clearing existing metadata");
            this.indexWriter.deleteAll();
        }

        void updateIndexMetaDataDocument(Document indexMetaDataDocument, Index index) throws IOException {
            this.logger.trace("updating metadata for [{}]", (Object)index);
            this.indexWriter.updateDocument(new Term(PersistedClusterStateService.INDEX_UUID_FIELD_NAME, index.getUUID()), (Iterable)indexMetaDataDocument);
        }

        void updateGlobalMetaData(Document globalMetaDataDocument) throws IOException {
            this.logger.trace("updating global metadata doc");
            this.indexWriter.updateDocument(new Term(PersistedClusterStateService.TYPE_FIELD_NAME, PersistedClusterStateService.GLOBAL_TYPE_NAME), (Iterable)globalMetaDataDocument);
        }

        void deleteIndexMetaData(String indexUUID) throws IOException {
            this.logger.trace("removing metadata for [{}]", (Object)indexUUID);
            this.indexWriter.deleteDocuments(new Term[]{new Term(PersistedClusterStateService.INDEX_UUID_FIELD_NAME, indexUUID)});
        }

        void flush() throws IOException {
            this.logger.trace("flushing");
            this.indexWriter.flush();
        }

        void prepareCommit(String nodeId, long currentTerm, long lastAcceptedVersion) throws IOException {
            HashMap<String, String> commitData = new HashMap<String, String>(4);
            commitData.put(PersistedClusterStateService.CURRENT_TERM_KEY, Long.toString(currentTerm));
            commitData.put(PersistedClusterStateService.LAST_ACCEPTED_VERSION_KEY, Long.toString(lastAcceptedVersion));
            commitData.put(PersistedClusterStateService.NODE_VERSION_KEY, Integer.toString(Version.CURRENT.id));
            commitData.put(PersistedClusterStateService.NODE_ID_KEY, nodeId);
            this.indexWriter.setLiveCommitData(commitData.entrySet());
            this.indexWriter.prepareCommit();
        }

        void commit() throws IOException {
            this.indexWriter.commit();
        }

        @Override
        public void close() throws IOException {
            IOUtils.close((Closeable[])new Closeable[]{this.indexWriter, this.directory});
        }
    }

    public static class Writer
    implements Closeable {
        private final List<MetaDataIndexWriter> metaDataIndexWriters;
        private final String nodeId;
        private final BigArrays bigArrays;
        private final LongSupplier relativeTimeMillisSupplier;
        private final Supplier<TimeValue> slowWriteLoggingThresholdSupplier;
        boolean fullStateWritten = false;
        private final AtomicBoolean closed = new AtomicBoolean();

        private Writer(List<MetaDataIndexWriter> metaDataIndexWriters, String nodeId, BigArrays bigArrays, LongSupplier relativeTimeMillisSupplier, Supplier<TimeValue> slowWriteLoggingThresholdSupplier) {
            this.metaDataIndexWriters = metaDataIndexWriters;
            this.nodeId = nodeId;
            this.bigArrays = bigArrays;
            this.relativeTimeMillisSupplier = relativeTimeMillisSupplier;
            this.slowWriteLoggingThresholdSupplier = slowWriteLoggingThresholdSupplier;
        }

        private void ensureOpen() {
            if (this.closed.get()) {
                throw new AlreadyClosedException("cluster state writer is closed already");
            }
        }

        public boolean isOpen() {
            return !this.closed.get();
        }

        private void closeIfAnyIndexWriterHasTragedyOrIsClosed() {
            if (this.metaDataIndexWriters.stream().map(writer -> ((MetaDataIndexWriter)writer).indexWriter).anyMatch(iw -> iw.getTragicException() != null || !iw.isOpen())) {
                try {
                    this.close();
                }
                catch (Exception e) {
                    logger.warn("failed on closing cluster state writer", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeFullStateAndCommit(long currentTerm, ClusterState clusterState) throws IOException {
            this.ensureOpen();
            try {
                long startTimeMillis = this.relativeTimeMillisSupplier.getAsLong();
                WriterStats stats = this.overwriteMetaData(clusterState.metaData());
                this.commit(currentTerm, clusterState.version());
                this.fullStateWritten = true;
                long durationMillis = this.relativeTimeMillisSupplier.getAsLong() - startTimeMillis;
                TimeValue finalSlowWriteLoggingThreshold = this.slowWriteLoggingThresholdSupplier.get();
                if (durationMillis >= finalSlowWriteLoggingThreshold.getMillis()) {
                    logger.warn("writing cluster state took [{}ms] which is above the warn threshold of [{}]; wrote full state with [{}] indices", (Object)durationMillis, (Object)finalSlowWriteLoggingThreshold, (Object)stats.numIndicesUpdated);
                } else {
                    logger.debug("writing cluster state took [{}ms]; wrote full state with [{}] indices", (Object)durationMillis, (Object)stats.numIndicesUpdated);
                }
            }
            finally {
                this.closeIfAnyIndexWriterHasTragedyOrIsClosed();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void writeIncrementalStateAndCommit(long currentTerm, ClusterState previousClusterState, ClusterState clusterState) throws IOException {
            this.ensureOpen();
            assert (this.fullStateWritten) : "Need to write full state first before doing incremental writes";
            try {
                long startTimeMillis = this.relativeTimeMillisSupplier.getAsLong();
                WriterStats stats = this.updateMetaData(previousClusterState.metaData(), clusterState.metaData());
                this.commit(currentTerm, clusterState.version());
                long durationMillis = this.relativeTimeMillisSupplier.getAsLong() - startTimeMillis;
                TimeValue finalSlowWriteLoggingThreshold = this.slowWriteLoggingThresholdSupplier.get();
                if (durationMillis >= finalSlowWriteLoggingThreshold.getMillis()) {
                    logger.warn("writing cluster state took [{}ms] which is above the warn threshold of [{}]; wrote global metadata [{}] and metadata for [{}] indices and skipped [{}] unchanged indices", (Object)durationMillis, (Object)finalSlowWriteLoggingThreshold, (Object)stats.globalMetaUpdated, (Object)stats.numIndicesUpdated, (Object)stats.numIndicesUnchanged);
                } else {
                    logger.debug("writing cluster state took [{}ms]; wrote global metadata [{}] and metadata for [{}] indices and skipped [{}] unchanged indices", (Object)durationMillis, (Object)stats.globalMetaUpdated, (Object)stats.numIndicesUpdated, (Object)stats.numIndicesUnchanged);
                }
            }
            finally {
                this.closeIfAnyIndexWriterHasTragedyOrIsClosed();
            }
        }

        private WriterStats updateMetaData(MetaData previouslyWrittenMetaData, MetaData metaData) throws IOException {
            boolean updateGlobalMeta;
            assert (previouslyWrittenMetaData.coordinationMetaData().term() == metaData.coordinationMetaData().term());
            logger.trace("currentTerm [{}] matches previous currentTerm, writing changes only", (Object)metaData.coordinationMetaData().term());
            boolean bl = updateGlobalMeta = !MetaData.isGlobalStateEquals(previouslyWrittenMetaData, metaData);
            if (updateGlobalMeta) {
                try (ReleasableDocument globalMetaDataDocument = this.makeGlobalMetaDataDocument(metaData);){
                    for (MetaDataIndexWriter metaDataIndexWriter : this.metaDataIndexWriters) {
                        metaDataIndexWriter.updateGlobalMetaData(globalMetaDataDocument.getDocument());
                    }
                }
            }
            HashMap<String, Long> indexMetaDataVersionByUUID = new HashMap<String, Long>(previouslyWrittenMetaData.indices().size());
            for (ObjectCursor cursor : previouslyWrittenMetaData.indices().values()) {
                IndexMetaData indexMetaData = (IndexMetaData)cursor.value;
                Long previousValue = indexMetaDataVersionByUUID.putIfAbsent(indexMetaData.getIndexUUID(), indexMetaData.getVersion());
                assert (previousValue == null) : indexMetaData.getIndexUUID() + " already mapped to " + previousValue;
            }
            int numIndicesUpdated = 0;
            int numIndicesUnchanged = 0;
            for (ObjectCursor cursor : metaData.indices().values()) {
                IndexMetaData indexMetaData = (IndexMetaData)cursor.value;
                Long previousVersion = (Long)indexMetaDataVersionByUUID.get(indexMetaData.getIndexUUID());
                if (previousVersion == null || indexMetaData.getVersion() != previousVersion.longValue()) {
                    logger.trace("updating metadata for [{}], changing version from [{}] to [{}]", (Object)indexMetaData.getIndex(), (Object)previousVersion, (Object)indexMetaData.getVersion());
                    ++numIndicesUpdated;
                    try (ReleasableDocument indexMetaDataDocument = this.makeIndexMetaDataDocument(indexMetaData);){
                        for (MetaDataIndexWriter metaDataIndexWriter : this.metaDataIndexWriters) {
                            metaDataIndexWriter.updateIndexMetaDataDocument(indexMetaDataDocument.getDocument(), indexMetaData.getIndex());
                        }
                    }
                } else {
                    ++numIndicesUnchanged;
                    logger.trace("no action required for [{}]", (Object)indexMetaData.getIndex());
                }
                indexMetaDataVersionByUUID.remove(indexMetaData.getIndexUUID());
            }
            for (String removedIndexUUID : indexMetaDataVersionByUUID.keySet()) {
                for (MetaDataIndexWriter metaDataIndexWriter : this.metaDataIndexWriters) {
                    metaDataIndexWriter.deleteIndexMetaData(removedIndexUUID);
                }
            }
            for (MetaDataIndexWriter metaDataIndexWriter : this.metaDataIndexWriters) {
                metaDataIndexWriter.flush();
            }
            return new WriterStats(updateGlobalMeta, numIndicesUpdated, numIndicesUnchanged);
        }

        private WriterStats overwriteMetaData(MetaData metaData) throws IOException {
            for (MetaDataIndexWriter metaDataIndexWriter : this.metaDataIndexWriters) {
                metaDataIndexWriter.deleteAll();
            }
            return this.addMetaData(metaData);
        }

        private WriterStats addMetaData(MetaData metaData) throws IOException {
            try (ReleasableDocument globalMetaDataDocument = this.makeGlobalMetaDataDocument(metaData);){
                for (MetaDataIndexWriter metaDataIndexWriter : this.metaDataIndexWriters) {
                    metaDataIndexWriter.updateGlobalMetaData(globalMetaDataDocument.getDocument());
                }
            }
            for (ObjectCursor cursor : metaData.indices().values()) {
                IndexMetaData indexMetaData = (IndexMetaData)cursor.value;
                ReleasableDocument indexMetaDataDocument = this.makeIndexMetaDataDocument(indexMetaData);
                try {
                    for (MetaDataIndexWriter metaDataIndexWriter : this.metaDataIndexWriters) {
                        metaDataIndexWriter.updateIndexMetaDataDocument(indexMetaDataDocument.getDocument(), indexMetaData.getIndex());
                    }
                }
                finally {
                    if (indexMetaDataDocument == null) continue;
                    indexMetaDataDocument.close();
                }
            }
            for (MetaDataIndexWriter metaDataIndexWriter : this.metaDataIndexWriters) {
                metaDataIndexWriter.flush();
            }
            return new WriterStats(true, metaData.indices().size(), 0L);
        }

        public void commit(long currentTerm, long lastAcceptedVersion) throws IOException {
            this.ensureOpen();
            try {
                for (MetaDataIndexWriter metaDataIndexWriter : this.metaDataIndexWriters) {
                    metaDataIndexWriter.prepareCommit(this.nodeId, currentTerm, lastAcceptedVersion);
                }
            }
            catch (Exception e) {
                try {
                    this.close();
                }
                catch (Exception e2) {
                    logger.warn("failed on closing cluster state writer", (Throwable)e2);
                    e.addSuppressed(e2);
                }
                throw e;
            }
            finally {
                this.closeIfAnyIndexWriterHasTragedyOrIsClosed();
            }
            try {
                for (MetaDataIndexWriter metaDataIndexWriter : this.metaDataIndexWriters) {
                    metaDataIndexWriter.commit();
                }
            }
            catch (IOException e) {
                try {
                    this.close();
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
                throw new IOError(e);
            }
            finally {
                this.closeIfAnyIndexWriterHasTragedyOrIsClosed();
            }
        }

        @Override
        public void close() throws IOException {
            logger.trace("closing PersistedClusterStateService.Writer");
            if (this.closed.compareAndSet(false, true)) {
                IOUtils.close(this.metaDataIndexWriters);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ReleasableDocument makeIndexMetaDataDocument(IndexMetaData indexMetaData) throws IOException {
            ReleasableDocument releasableDocument;
            block4: {
                ReleasableDocument indexMetaDataDocument = this.makeDocument(PersistedClusterStateService.INDEX_TYPE_NAME, (ToXContent)indexMetaData);
                boolean success = false;
                try {
                    String indexUUID = indexMetaData.getIndexUUID();
                    assert (!indexUUID.equals("_na_"));
                    indexMetaDataDocument.getDocument().add((IndexableField)new StringField(PersistedClusterStateService.INDEX_UUID_FIELD_NAME, indexUUID, Field.Store.NO));
                    success = true;
                    releasableDocument = indexMetaDataDocument;
                    if (success) break block4;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{indexMetaDataDocument});
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{indexMetaDataDocument});
            }
            return releasableDocument;
        }

        private ReleasableDocument makeGlobalMetaDataDocument(MetaData metaData) throws IOException {
            return this.makeDocument(PersistedClusterStateService.GLOBAL_TYPE_NAME, (ToXContent)metaData);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ReleasableDocument makeDocument(String typeName, ToXContent metaData) throws IOException {
            ReleasableDocument releasableDocument;
            block10: {
                Document document = new Document();
                document.add((IndexableField)new StringField(PersistedClusterStateService.TYPE_FIELD_NAME, typeName, Field.Store.NO));
                boolean success = false;
                ReleasableBytesStreamOutput releasableBytesStreamOutput = new ReleasableBytesStreamOutput(this.bigArrays);
                try {
                    FilterOutputStream outputStream = new FilterOutputStream(releasableBytesStreamOutput){

                        @Override
                        public void close() {
                        }
                    };
                    try (XContentBuilder xContentBuilder = XContentFactory.contentBuilder((XContentType)XContentType.SMILE, (OutputStream)outputStream);){
                        xContentBuilder.startObject();
                        metaData.toXContent(xContentBuilder, FORMAT_PARAMS);
                        xContentBuilder.endObject();
                    }
                    document.add((IndexableField)new StoredField(PersistedClusterStateService.DATA_FIELD_NAME, releasableBytesStreamOutput.bytes().toBytesRef()));
                    ReleasableDocument releasableDocument2 = new ReleasableDocument(document, releasableBytesStreamOutput);
                    success = true;
                    releasableDocument = releasableDocument2;
                    if (success) break block10;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{releasableBytesStreamOutput});
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{releasableBytesStreamOutput});
            }
            return releasableDocument;
        }

        static class WriterStats {
            final boolean globalMetaUpdated;
            final long numIndicesUpdated;
            final long numIndicesUnchanged;

            WriterStats(boolean globalMetaUpdated, long numIndicesUpdated, long numIndicesUnchanged) {
                this.globalMetaUpdated = globalMetaUpdated;
                this.numIndicesUpdated = numIndicesUpdated;
                this.numIndicesUnchanged = numIndicesUnchanged;
            }
        }
    }

    public static class OnDiskState {
        private static final OnDiskState NO_ON_DISK_STATE = new OnDiskState(null, null, 0L, 0L, MetaData.EMPTY_META_DATA);
        private final String nodeId;
        private final Path dataPath;
        public final long currentTerm;
        public final long lastAcceptedVersion;
        public final MetaData metaData;

        private OnDiskState(String nodeId, Path dataPath, long currentTerm, long lastAcceptedVersion, MetaData metaData) {
            this.nodeId = nodeId;
            this.dataPath = dataPath;
            this.currentTerm = currentTerm;
            this.lastAcceptedVersion = lastAcceptedVersion;
            this.metaData = metaData;
        }

        public boolean empty() {
            return this == NO_ON_DISK_STATE;
        }
    }

    private static class ReleasableDocument
    implements Releasable {
        private final Document document;
        private final Releasable releasable;

        ReleasableDocument(Document document, Releasable releasable) {
            this.document = document;
            this.releasable = releasable;
        }

        Document getDocument() {
            return this.document;
        }

        @Override
        public void close() {
            this.releasable.close();
        }
    }
}

