/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.util.Set;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.AudioClip;
import tim.prune.data.AudioList;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.FileInfo;
import tim.prune.data.Photo;
import tim.prune.data.PhotoList;
import tim.prune.data.Selection;
import tim.prune.data.Track;

public class TrackInfo {
    private Track _track = null;
    private Selection _selection = null;
    private FileInfo _fileInfo = null;
    private PhotoList _photoList = null;
    private AudioList _audioList = null;

    public TrackInfo(Track track) {
        this._track = track;
        this._selection = new Selection(this._track);
        this._fileInfo = new FileInfo();
        this._photoList = new PhotoList();
        this._audioList = new AudioList();
    }

    public Track getTrack() {
        return this._track;
    }

    public Selection getSelection() {
        return this._selection;
    }

    public FileInfo getFileInfo() {
        return this._fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this._fileInfo = fileInfo;
    }

    public PhotoList getPhotoList() {
        return this._photoList;
    }

    public AudioList getAudioList() {
        return this._audioList;
    }

    public DataPoint getCurrentPoint() {
        return this._track.getPoint(this._selection.getCurrentPointIndex());
    }

    public Photo getCurrentPhoto() {
        return this._photoList.getPhoto(this._selection.getCurrentPhotoIndex());
    }

    public AudioClip getCurrentAudio() {
        return this._audioList.getAudio(this._selection.getCurrentAudioIndex());
    }

    public int[] addPhotos(Set<Photo> set) {
        int n = 0;
        int n2 = 0;
        if (set != null && !set.isEmpty()) {
            for (Photo object2 : set) {
                if (object2 == null || this._photoList.contains(object2)) continue;
                ++n;
                if (object2.getDataPoint() == null) continue;
                ++n2;
            }
        }
        if (n > 0) {
            DataPoint[] dataPointArray = new DataPoint[n2];
            int n3 = 0;
            boolean bl = false;
            for (Photo photo : set) {
                if (photo == null || this._photoList.contains(photo)) continue;
                this._photoList.addPhoto(photo);
                if (photo.getDataPoint() == null) continue;
                dataPointArray[n3] = photo.getDataPoint();
                bl |= photo.getDataPoint().getAltitude() != null;
                ++n3;
            }
            if (n2 > 0) {
                this._track.appendPoints(dataPointArray);
                this._track.getFieldList().extendList(Field.LATITUDE);
                this._track.getFieldList().extendList(Field.LONGITUDE);
                if (bl) {
                    this._track.getFieldList().extendList(Field.ALTITUDE);
                }
            }
        }
        int[] nArray = new int[]{n, n2};
        return nArray;
    }

    public int addAudios(Set<AudioClip> set) {
        int n = 0;
        if (set != null && !set.isEmpty()) {
            for (AudioClip audioClip : set) {
                if (audioClip == null || this._audioList.contains(audioClip)) continue;
                this._audioList.addAudio(audioClip);
                ++n;
            }
        }
        return n;
    }

    public boolean deletePoint() {
        if (this._track.deletePoint(this._selection.getCurrentPointIndex())) {
            this._selection.modifyPointDeleted();
            return true;
        }
        return false;
    }

    public boolean deleteCurrentPhoto(boolean bl) {
        int n = this._selection.getCurrentPhotoIndex();
        if (n >= 0) {
            Photo photo = this._photoList.getPhoto(n);
            this._photoList.deletePhoto(n);
            if (photo.getDataPoint() != null) {
                if (bl) {
                    int n2 = this._track.getPointIndex(photo.getDataPoint());
                    this._track.deletePoint(n2);
                } else {
                    photo.getDataPoint().setPhoto(null);
                    photo.setDataPoint(null);
                }
            }
            this._selection.modifyPointDeleted();
            UpdateMessageBroker.informSubscribers();
        }
        return true;
    }

    public boolean deleteCurrentAudio(boolean bl) {
        int n = this._selection.getCurrentAudioIndex();
        if (n >= 0) {
            AudioClip audioClip = this._audioList.getAudio(n);
            this._audioList.deleteAudio(n);
            if (audioClip.getDataPoint() != null) {
                if (bl) {
                    int n2 = this._track.getPointIndex(audioClip.getDataPoint());
                    this._track.deletePoint(n2);
                } else {
                    audioClip.getDataPoint().setAudio(null);
                    audioClip.setDataPoint(null);
                }
            }
            this._selection.modifyPointDeleted();
            UpdateMessageBroker.informSubscribers();
        }
        return true;
    }

    public int deleteMarkedPoints(boolean bl) {
        int n = this._track.deleteMarkedPoints(bl);
        if (n > 0) {
            this._selection.clearAll();
            UpdateMessageBroker.informSubscribers();
        }
        return n;
    }

    public DataPoint[] cloneSelectedRange() {
        return this._track.cloneRange(this._selection.getStart(), this._selection.getEnd());
    }

    public boolean mergeTrackSegments(int n, int n2) {
        boolean bl = true;
        int n3 = n;
        while (n3 <= n2) {
            DataPoint dataPoint = this._track.getPoint(n3);
            if (dataPoint != null && !dataPoint.isWaypoint()) {
                dataPoint.setSegmentStart(bl);
                bl = false;
            }
            ++n3;
        }
        DataPoint dataPoint = this._track.getNextTrackPoint(n2 + 1);
        if (dataPoint != null) {
            dataPoint.setSegmentStart(true);
        }
        this._selection.markInvalid();
        UpdateMessageBroker.informSubscribers();
        return true;
    }

    public boolean average() {
        boolean bl = this._track.average(this._selection.getStart(), this._selection.getEnd());
        if (bl) {
            this.selectPoint(this._selection.getEnd() + 1);
        }
        return bl;
    }

    public void selectPoint(DataPoint dataPoint) {
        this.selectPoint(this._track.getPointIndex(dataPoint));
    }

    public void incrementPointIndex(int n) {
        int n2 = this._selection.getCurrentPointIndex() + n;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this._track.getNumPoints()) {
            n2 = this._track.getNumPoints() - 1;
        }
        this.selectPoint(n2);
    }

    public void selectPoint(int n) {
        boolean bl;
        boolean bl2;
        if (this._selection.getCurrentPointIndex() == n || n >= this._track.getNumPoints()) {
            return;
        }
        DataPoint dataPoint = this._track.getPoint(n);
        int n2 = this._selection.getCurrentPhotoIndex();
        boolean bl3 = bl2 = n >= 0 && dataPoint.getPhoto() != null;
        if (bl2) {
            n2 = this._photoList.getPhotoIndex(dataPoint.getPhoto());
        } else if (n2 < 0 || this._photoList.getPhoto(n2).isConnected()) {
            n2 = -1;
        }
        int n3 = this._selection.getCurrentAudioIndex();
        boolean bl4 = bl = n >= 0 && dataPoint.getAudio() != null;
        if (bl) {
            n3 = this._audioList.getAudioIndex(dataPoint.getAudio());
        } else if (n3 < 0 || this._audioList.getAudio(n3).isConnected()) {
            n3 = -1;
        }
        this._selection.selectPointPhotoAudio(n, n2, n3);
    }

    public void selectPhoto(int n) {
        if (this._selection.getCurrentPhotoIndex() == n) {
            return;
        }
        Photo photo = this._photoList.getPhoto(n);
        int n2 = this._selection.getCurrentPointIndex();
        DataPoint dataPoint = this.getCurrentPoint();
        if (photo != null) {
            if (photo.isConnected()) {
                n2 = this._track.getPointIndex(photo.getDataPoint());
            } else if (n2 >= 0 && this._track.getPoint(n2).getPhoto() != null) {
                n2 = -1;
            }
        } else if (dataPoint != null && dataPoint.getPhoto() != null) {
            n2 = -1;
        }
        DataPoint dataPoint2 = this._track.getPoint(n2);
        int n3 = this._selection.getCurrentAudioIndex();
        if (dataPoint2 != null && dataPoint2.getAudio() != null) {
            n3 = this._audioList.getAudioIndex(dataPoint2.getAudio());
        } else if (dataPoint != null && dataPoint2 != dataPoint && dataPoint.getAudio() != null) {
            n3 = -1;
        }
        this._selection.selectPointPhotoAudio(n2, n, n3);
    }

    public void selectAudio(int n) {
        if (this._selection.getCurrentAudioIndex() == n) {
            return;
        }
        AudioClip audioClip = this._audioList.getAudio(n);
        int n2 = this._selection.getCurrentPointIndex();
        DataPoint dataPoint = this.getCurrentPoint();
        if (audioClip != null) {
            if (audioClip.isConnected()) {
                n2 = this._track.getPointIndex(audioClip.getDataPoint());
            } else if (n2 >= 0 && this._track.getPoint(n2).getAudio() != null) {
                n2 = -1;
            }
        } else if (dataPoint != null && dataPoint.getAudio() != null) {
            n2 = -1;
        }
        DataPoint dataPoint2 = this._track.getPoint(n2);
        int n3 = this._selection.getCurrentPhotoIndex();
        if (dataPoint2 != null && dataPoint2.getPhoto() != null) {
            n3 = this._photoList.getPhotoIndex(dataPoint2.getPhoto());
        } else if (dataPoint != null && dataPoint2 != dataPoint && dataPoint.getPhoto() != null) {
            n3 = -1;
        }
        this._selection.selectPointPhotoAudio(n2, n3, n);
    }

    public void extendSelection(int n) {
        int n2 = this._selection.getStart();
        if (n2 < 0 || this._selection.getCurrentPointIndex() != this._selection.getEnd()) {
            n2 = this._selection.getCurrentPointIndex();
        }
        this.selectPoint(n);
        if (n2 < n) {
            this._selection.selectRange(n2, n);
        }
    }
}

