/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;

public class MultiStateCheckBox
extends JCheckBox
implements ItemListener {
    private ImageIcon[] _icons = null;
    private int _currState = 0;
    private final int _numStates;

    public MultiStateCheckBox(int n) {
        this._numStates = n > 0 ? n : 1;
        this._icons = new ImageIcon[this._numStates];
        this.addItemListener(this);
    }

    public void setCurrentState(int n) {
        this._currState = n % this._numStates;
        this.setIcon(this._icons[this._currState]);
        this.setSelected(false);
        this.setSelectedIcon(this._icons[(this._currState + 1) % this._numStates]);
    }

    public int getCurrentState() {
        return this._currState;
    }

    public void setIcon(int n, ImageIcon imageIcon) {
        this._icons[n % this._numStates] = imageIcon;
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        super.addItemListener(new ProxyListener(itemListener));
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.setCurrentState(this._currState + 1);
    }

    private class ProxyListener
    implements ItemListener {
        private ItemListener _listener = null;

        ProxyListener(ItemListener itemListener) {
            this._listener = itemListener;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getStateChange() == 1) {
                this._listener.itemStateChanged(itemEvent);
            }
        }
    }
}

