/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.io.scan;

import io.micronaut.asm.AnnotationVisitor;
import io.micronaut.asm.ClassVisitor;
import io.micronaut.asm.Type;
import io.micronaut.core.annotation.AnnotatedTypeInfo;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.reflect.ClassUtils;
import java.util.HashSet;
import java.util.Set;

@Internal
class AnnotatedTypeInfoVisitor
extends ClassVisitor
implements AnnotatedTypeInfo {
    private Set<String> annotations = new HashSet<String>();
    private String className;
    private boolean isAbstract;

    public AnnotatedTypeInfoVisitor() {
        super(327680);
    }

    @Override
    public void visit(int version, int access, String name, String signature, String supername, String[] interfaces) {
        this.className = ClassUtils.pathToClassName(name);
        boolean isInterface = (access & 0x200) != 0;
        boolean isAnnotation = (access & 0x2000) != 0;
        this.isAbstract = isInterface || isAnnotation || (access & 0x400) != 0;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        String className = Type.getType(desc).getClassName();
        this.annotations.add(className);
        return super.visitAnnotation(desc, visible);
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public String getTypeName() {
        return this.className;
    }

    @Override
    public boolean hasAnnotation(String annotationName) {
        return this.annotations.contains(annotationName);
    }
}

