/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.io.CertificateAmendment;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Platform;
import org.openstreetmap.josm.tools.PlatformHook;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public class PlatformHookUnixoid
implements PlatformHook {
    private String osDescription;

    @Override
    public Platform getPlatform() {
        return Platform.UNIXOID;
    }

    @Override
    public void preStartupHook() {
        if (PlatformHookUnixoid.isDebianOrUbuntu() && Utils.getJavaVersion() < 9) {
            Utils.updateSystemProperty("javax.accessibility.assistive_technologies", "java.lang.Object");
        }
    }

    @Override
    public void openUrl(String url) throws IOException {
        for (String program : Config.getPref().getList("browser.unix", Arrays.asList("xdg-open", "#DESKTOP#", "$BROWSER", "gnome-open", "kfmclient openURL", "firefox"))) {
            try {
                if ("#DESKTOP#".equals(program)) {
                    Desktop.getDesktop().browse(Utils.urlToURI(url));
                } else if (program.startsWith("$")) {
                    program = System.getenv().get(program.substring(1));
                    Runtime.getRuntime().exec(new String[]{program, url});
                } else {
                    Runtime.getRuntime().exec(new String[]{program, url});
                }
                return;
            }
            catch (IOException | URISyntaxException e) {
                Logging.warn(e);
            }
        }
    }

    @Override
    public void initSystemShortcuts() {
        for (int i = 112; i <= 123; ++i) {
            Shortcut.registerSystemShortcut("screen:toogle" + i, I18n.tr("reserved", new Object[0]), i, 640).setAutomatic();
        }
        Shortcut.registerSystemShortcut("system:reset", I18n.tr("reserved", new Object[0]), 127, 640).setAutomatic();
        Shortcut.registerSystemShortcut("system:resetX", I18n.tr("reserved", new Object[0]), 8, 640).setAutomatic();
    }

    @Override
    public String getDefaultStyle() {
        return "javax.swing.plaf.metal.MetalLookAndFeel";
    }

    public static boolean isDebianOrUbuntu() {
        try {
            String dist = Utils.execOutput(Arrays.asList("lsb_release", "-i", "-s"));
            return "Debian".equalsIgnoreCase(dist) || "Ubuntu".equalsIgnoreCase(dist) || "Mint".equalsIgnoreCase(dist);
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            Logging.debug(e);
            return false;
        }
    }

    public static String getPackageDetails(String ... packageNames) {
        block5: {
            try {
                boolean dpkg = Paths.get("/usr/bin/dpkg-query", new String[0]).toFile().exists();
                boolean eque = Paths.get("/usr/bin/equery", new String[0]).toFile().exists();
                boolean rpm = Paths.get("/bin/rpm", new String[0]).toFile().exists();
                if (!dpkg && !rpm && !eque) break block5;
                for (String packageName : packageNames) {
                    String[] args = dpkg ? new String[]{"dpkg-query", "--show", "--showformat", "${Architecture}-${Version}", packageName} : (eque ? new String[]{"equery", "-q", "list", "-e", "--format=$fullversion", packageName} : new String[]{"rpm", "-q", "--qf", "%{arch}-%{version}", packageName});
                    try {
                        String version = Utils.execOutput(Arrays.asList(args));
                        if (version == null || version.isEmpty()) continue;
                        return packageName + ':' + version;
                    }
                    catch (ExecutionException e) {
                        Logging.trace(e);
                    }
                }
            }
            catch (IOException | InterruptedException e) {
                Logging.warn(e);
            }
        }
        return null;
    }

    public String getJavaPackageDetails() {
        String home = Utils.getSystemProperty("java.home");
        if (home.contains("java-8-openjdk") || home.contains("java-1.8.0-openjdk")) {
            return PlatformHookUnixoid.getPackageDetails("openjdk-8-jre", "java-1_8_0-openjdk", "java-1.8.0-openjdk");
        }
        if (home.contains("java-9-openjdk") || home.contains("java-1.9.0-openjdk")) {
            return PlatformHookUnixoid.getPackageDetails("openjdk-9-jre", "java-1_9_0-openjdk", "java-1.9.0-openjdk", "java-9-openjdk");
        }
        if (home.contains("java-10-openjdk")) {
            return PlatformHookUnixoid.getPackageDetails("openjdk-10-jre", "java-10-openjdk");
        }
        if (home.contains("java-11-openjdk")) {
            return PlatformHookUnixoid.getPackageDetails("openjdk-11-jre", "java-11-openjdk");
        }
        if (home.contains("java-openjdk")) {
            return PlatformHookUnixoid.getPackageDetails("java-openjdk");
        }
        if (home.contains("icedtea")) {
            return PlatformHookUnixoid.getPackageDetails("icedtea-bin");
        }
        if (home.contains("oracle")) {
            return PlatformHookUnixoid.getPackageDetails("oracle-jdk-bin", "oracle-jre-bin");
        }
        return null;
    }

    public String getWebStartPackageDetails() {
        if (this.isOpenJDK()) {
            return PlatformHookUnixoid.getPackageDetails("icedtea-netx", "icedtea-web");
        }
        return null;
    }

    public String getAtkWrapperPackageDetails() {
        if (this.isOpenJDK() && PlatformHookUnixoid.isDebianOrUbuntu()) {
            return PlatformHookUnixoid.getPackageDetails("libatk-wrapper-java");
        }
        return null;
    }

    private String buildOSDescription() {
        String osName = Utils.getSystemProperty("os.name");
        if ("Linux".equalsIgnoreCase(osName)) {
            try {
                String line = this.exec("lsb_release", "-ds");
                if (line != null && !line.isEmpty()) {
                    line = line.replaceAll("\"+", "");
                    if ((line = line.replace("NAME=", "")).startsWith("Linux ")) {
                        return line;
                    }
                    if (!line.isEmpty()) {
                        return "Linux " + line;
                    }
                }
            }
            catch (IOException e) {
                Logging.debug(e);
                for (LinuxReleaseInfo info : new LinuxReleaseInfo[]{new LinuxReleaseInfo("/etc/lsb-release", "DISTRIB_DESCRIPTION", "DISTRIB_ID", "DISTRIB_RELEASE"), new LinuxReleaseInfo("/etc/os-release", "PRETTY_NAME", "NAME", "VERSION"), new LinuxReleaseInfo("/etc/arch-release"), new LinuxReleaseInfo("/etc/debian_version", "Debian GNU/Linux "), new LinuxReleaseInfo("/etc/fedora-release"), new LinuxReleaseInfo("/etc/gentoo-release"), new LinuxReleaseInfo("/etc/redhat-release"), new LinuxReleaseInfo("/etc/SuSE-release")}) {
                    String description = info.extractDescription();
                    if (description == null || description.isEmpty()) continue;
                    return "Linux " + description;
                }
            }
        }
        return osName;
    }

    @Override
    public String getOSDescription() {
        if (this.osDescription == null) {
            this.osDescription = this.buildOSDescription();
        }
        return this.osDescription;
    }

    private static File getDotDirectory() {
        String dirName = "." + Preferences.getJOSMDirectoryBaseName().toLowerCase(Locale.ENGLISH);
        return new File(Utils.getSystemProperty("user.home"), dirName);
    }

    private static boolean useDotDirectory() {
        return PlatformHookUnixoid.getDotDirectory().exists();
    }

    @Override
    public File getDefaultCacheDirectory() {
        if (PlatformHookUnixoid.useDotDirectory()) {
            return new File(PlatformHookUnixoid.getDotDirectory(), "cache");
        }
        String xdgCacheDir = Utils.getSystemEnv("XDG_CACHE_HOME");
        if (xdgCacheDir != null && !xdgCacheDir.isEmpty()) {
            return new File(xdgCacheDir, Preferences.getJOSMDirectoryBaseName());
        }
        return new File(Utils.getSystemProperty("user.home") + File.separator + ".cache" + File.separator + Preferences.getJOSMDirectoryBaseName());
    }

    @Override
    public File getDefaultPrefDirectory() {
        if (PlatformHookUnixoid.useDotDirectory()) {
            return PlatformHookUnixoid.getDotDirectory();
        }
        String xdgConfigDir = Utils.getSystemEnv("XDG_CONFIG_HOME");
        if (xdgConfigDir != null && !xdgConfigDir.isEmpty()) {
            return new File(xdgConfigDir, Preferences.getJOSMDirectoryBaseName());
        }
        return new File(Utils.getSystemProperty("user.home") + File.separator + ".config" + File.separator + Preferences.getJOSMDirectoryBaseName());
    }

    @Override
    public File getDefaultUserDataDirectory() {
        if (PlatformHookUnixoid.useDotDirectory()) {
            return PlatformHookUnixoid.getDotDirectory();
        }
        String xdgDataDir = Utils.getSystemEnv("XDG_DATA_HOME");
        if (xdgDataDir != null && !xdgDataDir.isEmpty()) {
            return new File(xdgDataDir, Preferences.getJOSMDirectoryBaseName());
        }
        return new File(Utils.getSystemProperty("user.home") + File.separator + ".local" + File.separator + "share" + File.separator + Preferences.getJOSMDirectoryBaseName());
    }

    @Override
    public X509Certificate getX509Certificate(CertificateAmendment.NativeCertAmend certAmend) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        for (String dir : new String[]{"/etc/ssl/certs", "/usr/share/ca-certificates/mozilla"}) {
            File f = new File(dir, certAmend.getFilename());
            if (!f.exists()) continue;
            CertificateFactory fact = CertificateFactory.getInstance("X.509");
            try (InputStream is = Files.newInputStream(f.toPath(), new OpenOption[0]);){
                X509Certificate x509Certificate = (X509Certificate)fact.generateCertificate(is);
                return x509Certificate;
            }
        }
        return null;
    }

    @Override
    public Collection<String> getPossiblePreferenceDirs() {
        HashSet<String> locations = new HashSet<String>();
        locations.add("/usr/local/share/josm/");
        locations.add("/usr/local/lib/josm/");
        locations.add("/usr/share/josm/");
        locations.add("/usr/lib/josm/");
        return locations;
    }

    private static class LinuxReleaseInfo {
        private final String path;
        private final String descriptionField;
        private final String idField;
        private final String releaseField;
        private final boolean plainText;
        private final String prefix;

        LinuxReleaseInfo(String path, String descriptionField, String idField, String releaseField) {
            this(path, descriptionField, idField, releaseField, false, null);
        }

        LinuxReleaseInfo(String path) {
            this(path, null, null, null, true, null);
        }

        LinuxReleaseInfo(String path, String prefix) {
            this(path, null, null, null, true, prefix);
        }

        private LinuxReleaseInfo(String path, String descriptionField, String idField, String releaseField, boolean plainText, String prefix) {
            this.path = path;
            this.descriptionField = descriptionField;
            this.idField = idField;
            this.releaseField = releaseField;
            this.plainText = plainText;
            this.prefix = prefix;
        }

        public String toString() {
            return "ReleaseInfo [path=" + this.path + ", descriptionField=" + this.descriptionField + ", idField=" + this.idField + ", releaseField=" + this.releaseField + ']';
        }

        public String extractDescription() {
            Path p;
            String result = null;
            if (this.path != null && (p = Paths.get(this.path, new String[0])).toFile().exists()) {
                try (BufferedReader reader = Files.newBufferedReader(p, StandardCharsets.UTF_8);){
                    String line;
                    String id = null;
                    String release = null;
                    while (result == null && (line = reader.readLine()) != null) {
                        if (line.contains("=")) {
                            String[] tokens = line.split("=", -1);
                            if (tokens.length < 2) continue;
                            if (this.descriptionField != null && this.descriptionField.equalsIgnoreCase(tokens[0])) {
                                result = Utils.strip(tokens[1]);
                                continue;
                            }
                            if (this.idField != null && this.idField.equalsIgnoreCase(tokens[0])) {
                                id = Utils.strip(tokens[1]);
                                continue;
                            }
                            if (this.releaseField == null || !this.releaseField.equalsIgnoreCase(tokens[0])) continue;
                            release = Utils.strip(tokens[1]);
                            continue;
                        }
                        if (!this.plainText || line.isEmpty()) continue;
                        result = Utils.strip(line);
                    }
                    if (result == null && id != null && release != null) {
                        result = id + ' ' + release;
                    }
                }
                catch (IOException e) {
                    Logging.trace(e);
                }
            }
            if (result != null && !result.isEmpty() && this.prefix != null && !this.prefix.isEmpty()) {
                result = this.prefix + result;
            }
            if (result != null) {
                result = result.replaceAll("\"+", "");
            }
            return result;
        }
    }
}

