/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import writer2latex.api.ComplexOption;
import writer2latex.base.BooleanOption;
import writer2latex.base.ConfigBase;
import writer2latex.base.IntegerOption;
import writer2latex.base.Option;
import writer2latex.util.Misc;
import writer2latex.xhtml.XhtmlFormatOption;
import writer2latex.xhtml.XhtmlStyleMap;
import writer2latex.xhtml.XhtmlStyleMapItem;

public class XhtmlConfig
extends ConfigBase {
    public static final int IGNORE_ALL = 0;
    public static final int IGNORE_STYLES = 1;
    public static final int IGNORE_HARD = 2;
    public static final int CONVERT_ALL = 3;
    public static final int CSS1 = 0;
    public static final int CSS1_HACK = 1;
    public static final int HARD_LABELS = 2;
    public static final int NONE = 0;
    public static final int ABSOLUTE = 1;
    public static final int RELATIVE = 2;
    public static final int STARMATH = 0;
    public static final int LATEX = 1;
    public static final int IMAGE_STARMATH = 2;
    public static final int IMAGE_LATEX = 3;
    public static final int STYLES = 1;
    public static final int EXPLICIT = 2;
    public static final int ALL = 3;
    private static final int IGNORE_HARD_LINE_BREAKS = 0;
    private static final int IGNORE_EMPTY_PARAGRAPHS = 1;
    private static final int IGNORE_DOUBLE_SPACES = 2;
    private static final int IMAGE_SIZE = 3;
    private static final int NO_DOCTYPE = 4;
    private static final int ADD_BOM = 5;
    private static final int ENCODING = 6;
    private static final int USE_NAMED_ENTITIES = 7;
    private static final int HEXADECIMAL_ENTITIES = 8;
    private static final int PRETTY_PRINT = 9;
    private static final int MULTILINGUAL = 10;
    private static final int TEMPLATE_IDS = 11;
    private static final int SEPARATE_STYLESHEET = 12;
    private static final int CUSTOM_STYLESHEET = 13;
    private static final int FORMATTING = 14;
    private static final int FRAME_FORMATTING = 15;
    private static final int SECTION_FORMATTING = 16;
    private static final int TABLE_FORMATTING = 17;
    private static final int TABLE_SIZE = 18;
    private static final int LIST_FORMATTING = 19;
    private static final int MAX_WIDTH = 20;
    private static final int USE_DEFAULT_FONT = 21;
    private static final int DEFAULT_FONT_NAME = 22;
    private static final int USE_DUBLIN_CORE = 23;
    private static final int NOTES = 24;
    private static final int DISPLAY_HIDDEN_TEXT = 25;
    private static final int CONVERT_TO_PX = 26;
    private static final int SCALING = 27;
    private static final int COLUMN_SCALING = 28;
    private static final int RELATIVE_FONT_SIZE = 29;
    private static final int FONT_SCALING = 30;
    private static final int FLOAT_OBJECTS = 31;
    private static final int TABSTOP_STYLE = 32;
    private static final int FORMULAS = 33;
    private static final int ENDNOTES_HEADING = 34;
    private static final int FOOTNOTES_HEADING = 35;
    private static final int EXTERNAL_TOC_DEPTH = 36;
    private static final int INCLUDE_TOC = 37;
    private static final int INCLUDE_NCX = 38;
    private static final int SPLIT_LEVEL = 39;
    private static final int REPEAT_LEVELS = 40;
    private static final int PAGE_BREAK_SPLIT = 41;
    private static final int SPLIT_AFTER = 42;
    private static final int IMAGE_SPLIT = 43;
    private static final int COVER_IMAGE = 44;
    private static final int EMBED_SVG = 45;
    private static final int EMBED_IMG = 46;
    private static final int USE_MATHJAX = 47;
    private static final int CALC_SPLIT = 48;
    private static final int DISPLAY_HIDDEN_SHEETS = 49;
    private static final int DISPLAY_HIDDEN_ROWS_COLS = 50;
    private static final int DISPLAY_FILTERED_ROWS_COLS = 51;
    private static final int APPLY_PRINT_RANGES = 52;
    private static final int USE_TITLE_AS_HEADING = 53;
    private static final int USE_SHEET_NAMES_AS_HEADINGS = 54;
    private static final int SAVE_IMAGES_IN_SUBDIR = 55;
    private static final int UPLINK = 56;
    private static final int DIRECTORY_ICON = 57;
    private static final int DOCUMENT_ICON = 58;
    private static final int INDEX_LINKS = 59;
    private static final int EXTERNAL_TOC_DEPTH_MARKS = 60;
    private static final int AVOID_HTML5 = 61;
    protected ComplexOption xheading = this.addComplexOption("heading-map");
    protected ComplexOption xpar = this.addComplexOption("paragraph-map");
    protected ComplexOption xtext = this.addComplexOption("text-map");
    protected ComplexOption xframe = this.addComplexOption("frame-map");
    protected ComplexOption xlist = this.addComplexOption("list-map");
    protected ComplexOption xattr = this.addComplexOption("text-attribute-map");

    @Override
    protected int getOptionCount() {
        return 62;
    }

    @Override
    protected String getDefaultConfigPath() {
        return "/writer2latex/xhtml/config/";
    }

    @Override
    public void setOption(String sName, String sValue) {
        if (sName.startsWith("xhtml_")) {
            sName = sName.substring(6);
        }
        if (sName.equals("keep_image_size")) {
            sName = "original_image_size";
        }
        if (sName.equals("original_image_size")) {
            sName = "image_size";
            sValue = sValue.equals("true") ? "none" : "absolute";
        }
        if (sName.equals("use_list_hack")) {
            sName = "list_formatting";
            sValue = sValue.equals("true") ? "css1_hack" : "css1";
        }
        if (sName.equals("ignore_table_dimensions")) {
            sName = "table_size";
            sValue = sValue.equals("true") ? "none" : "absolute";
        }
        super.setOption(sName, sValue);
    }

    public XhtmlConfig() {
        this.options[0] = new BooleanOption("ignore_hard_line_breaks", "false");
        this.options[1] = new BooleanOption("ignore_empty_paragraphs", "false");
        this.options[2] = new BooleanOption("ignore_double_spaces", "false");
        this.options[3] = new IntegerOption("image_size", "auto"){

            @Override
            public void setString(String sValue) {
                super.setString(sValue);
                this.nValue = "relative".equals(sValue) ? 2 : ("none".equals(sValue) ? 0 : ("original_image_size".equals(sValue) ? 0 : 1));
            }
        };
        this.options[4] = new BooleanOption("no_doctype", "false");
        this.options[5] = new BooleanOption("add_bom", "false");
        this.options[6] = new Option("encoding", "UTF-8");
        this.options[7] = new BooleanOption("use_named_entities", "false");
        this.options[8] = new BooleanOption("hexadecimal_entities", "true");
        this.options[9] = new BooleanOption("pretty_print", "true");
        this.options[10] = new BooleanOption("multilingual", "true");
        this.options[11] = new Option("template_ids", "");
        this.options[12] = new BooleanOption("separate_stylesheet", "false");
        this.options[13] = new Option("custom_stylesheet", "");
        this.options[14] = new XhtmlFormatOption("formatting", "convert_all");
        this.options[15] = new XhtmlFormatOption("frame_formatting", "convert_all");
        this.options[16] = new XhtmlFormatOption("section_formatting", "convert_all");
        this.options[17] = new XhtmlFormatOption("table_formatting", "convert_all");
        this.options[18] = new IntegerOption("table_size", "auto"){

            @Override
            public void setString(String sValue) {
                super.setString(sValue);
                this.nValue = "relative".equals(sValue) ? 2 : ("none".equals(sValue) ? 0 : 1);
            }
        };
        this.options[19] = new IntegerOption("list_formatting", "css1"){

            @Override
            public void setString(String sValue) {
                super.setString(sValue);
                this.nValue = "css1_hack".equals(sValue) ? 1 : ("hard_labels".equals(sValue) ? 2 : 0);
            }
        };
        this.options[20] = new Option("max_width", "800px");
        this.options[21] = new BooleanOption("use_default_font", "false");
        this.options[22] = new BooleanOption("default_font_name", "");
        this.options[23] = new BooleanOption("use_dublin_core", "true");
        this.options[24] = new BooleanOption("notes", "true");
        this.options[25] = new BooleanOption("display_hidden_text", "false");
        this.options[26] = new BooleanOption("convert_to_px", "true");
        this.options[27] = new Option("scaling", "100%");
        this.options[28] = new Option("column_scaling", "100%");
        this.options[29] = new BooleanOption("relative_font_size", "false");
        this.options[30] = new Option("font_scaling", "100%");
        this.options[31] = new BooleanOption("float_objects", "true");
        this.options[32] = new Option("tabstop_style", "");
        this.options[34] = new Option("endnotes_heading", "");
        this.options[35] = new Option("footnotes_heading", "");
        this.options[33] = new IntegerOption("formulas", "image+starmath"){

            @Override
            public void setString(String sValue) {
                super.setString(sValue);
                this.nValue = "latex".equals(sValue) ? 1 : ("image+latex".equals(sValue) ? 3 : ("starmath".equals(sValue) ? 0 : 2));
            }
        };
        this.options[36] = new IntegerOption("external_toc_depth", "auto"){

            @Override
            public void setString(String sValue) {
                super.setString(sValue);
                this.nValue = "auto".equals(sValue) ? -1 : ("0".equals(sValue) ? 0 : Misc.getPosInteger(sValue, 1));
            }
        };
        this.options[37] = new BooleanOption("include_toc", "true");
        this.options[38] = new BooleanOption("include_ncx", "true");
        this.options[39] = new IntegerOption("split_level", "0"){

            @Override
            public void setString(String sValue) {
                super.setString(sValue);
                this.nValue = Misc.getPosInteger(sValue, 0);
            }
        };
        this.options[40] = new IntegerOption("repeat_levels", "5"){

            @Override
            public void setString(String sValue) {
                super.setString(sValue);
                this.nValue = Misc.getPosInteger(sValue, 0);
            }
        };
        this.options[41] = new IntegerOption("page_break_split", "none"){

            @Override
            public void setString(String sValue) {
                super.setString(sValue);
                this.nValue = "styles".equals(sValue) ? 1 : ("explicit".equals(sValue) ? 2 : ("all".equals(sValue) ? 3 : 0));
            }
        };
        this.options[42] = new IntegerOption("split_after", "0"){

            @Override
            public void setString(String sValue) {
                super.setString(sValue);
                this.nValue = Misc.getPosInteger(sValue, 0);
            }
        };
        this.options[43] = new Option("image_split", "none");
        this.options[44] = new BooleanOption("cover_image", "false");
        this.options[45] = new BooleanOption("embed_svg", "false");
        this.options[46] = new BooleanOption("embed_img", "false");
        this.options[47] = new BooleanOption("use_mathjax", "false");
        this.options[48] = new BooleanOption("calc_split", "false");
        this.options[49] = new BooleanOption("display_hidden_sheets", "false");
        this.options[50] = new BooleanOption("display_hidden_rows_cols", "false");
        this.options[51] = new BooleanOption("display_filtered_rows_cols", "false");
        this.options[52] = new BooleanOption("apply_print_ranges", "false");
        this.options[53] = new BooleanOption("use_title_as_heading", "true");
        this.options[54] = new BooleanOption("use_sheet_names_as_headings", "true");
        this.options[55] = new BooleanOption("save_images_in_subdir", "false");
        this.options[56] = new Option("uplink", "");
        this.options[57] = new Option("directory_icon", "");
        this.options[58] = new Option("document_icon", "");
        this.options[59] = new BooleanOption("index_links", "true");
        this.options[60] = new IntegerOption("external_toc_depth_marks", "0"){

            @Override
            public void setString(String sValue) {
                super.setString(sValue);
                this.nValue = "0".equals(sValue) ? 0 : Misc.getPosInteger(sValue, 1);
            }
        };
        this.options[61] = new BooleanOption("avoid_html5", "false");
    }

    @Override
    protected void readInner(Element elm) {
        if (elm.getTagName().equals("xhtml-style-map")) {
            String sName = elm.getAttribute("name");
            String sFamily = elm.getAttribute("family");
            if (sFamily.length() == 0) {
                sFamily = elm.getAttribute("class");
            }
            HashMap<String, String> attr = new HashMap<String, String>();
            String sElement = elm.getAttribute("element");
            String sCss = elm.getAttribute("css");
            if (sCss.length() == 0) {
                sCss = "(none)";
            }
            attr.put("element", sElement);
            attr.put("css", sCss);
            String sBlockElement = elm.getAttribute("block-element");
            String sBlockCss = elm.getAttribute("block-css");
            if (sBlockCss.length() == 0) {
                sBlockCss = "(none)";
            }
            String sBefore = elm.getAttribute("before");
            String sAfter = elm.getAttribute("after");
            if ("heading".equals(sFamily)) {
                attr.put("block-element", sBlockElement);
                attr.put("block-css", sBlockCss);
                attr.put("before", sBefore);
                attr.put("after", sAfter);
                this.xheading.put(sName, attr);
            }
            if ("paragraph".equals(sFamily)) {
                attr.put("block-element", sBlockElement);
                attr.put("block-css", sBlockCss);
                attr.put("before", sBefore);
                attr.put("after", sAfter);
                this.xpar.put(sName, attr);
            } else if ("text".equals(sFamily)) {
                attr.put("before", sBefore);
                attr.put("after", sAfter);
                this.xtext.put(sName, attr);
            } else if ("frame".equals(sFamily)) {
                this.xframe.put(sName, attr);
            } else if ("list".equals(sFamily)) {
                this.xlist.put(sName, attr);
            } else if ("attribute".equals(sFamily)) {
                this.xattr.put(sName, attr);
            }
        }
    }

    @Override
    protected void writeInner(Document dom) {
        this.writeXStyleMap(dom, this.xheading, "heading");
        this.writeXStyleMap(dom, this.xpar, "paragraph");
        this.writeXStyleMap(dom, this.xtext, "text");
        this.writeXStyleMap(dom, this.xlist, "list");
        this.writeXStyleMap(dom, this.xframe, "frame");
        this.writeXStyleMap(dom, this.xattr, "attribute");
    }

    private void writeXStyleMap(Document dom, ComplexOption option, String sFamily) {
        for (String sName : option.keySet()) {
            Element smNode = dom.createElement("xhtml-style-map");
            smNode.setAttribute("name", sName);
            smNode.setAttribute("family", sFamily);
            Map<String, String> attr = option.get(sName);
            smNode.setAttribute("element", attr.get("element"));
            smNode.setAttribute("css", attr.get("css"));
            if (attr.containsKey("block-element")) {
                smNode.setAttribute("block-element", attr.get("block-element"));
            }
            if (attr.containsKey("block-css")) {
                smNode.setAttribute("block-css", attr.get("block-css"));
            }
            if (attr.containsKey("before")) {
                smNode.setAttribute("before", attr.get("before"));
            }
            if (attr.containsKey("after")) {
                smNode.setAttribute("after", attr.get("after"));
            }
            dom.getDocumentElement().appendChild(smNode);
        }
    }

    public boolean ignoreHardLineBreaks() {
        return ((BooleanOption)this.options[0]).getValue();
    }

    public boolean ignoreEmptyParagraphs() {
        return ((BooleanOption)this.options[1]).getValue();
    }

    public boolean ignoreDoubleSpaces() {
        return ((BooleanOption)this.options[2]).getValue();
    }

    public int imageSize() {
        return ((IntegerOption)this.options[3]).getValue();
    }

    public boolean xhtmlNoDoctype() {
        return ((BooleanOption)this.options[4]).getValue();
    }

    public boolean xhtmlAddBOM() {
        return ((BooleanOption)this.options[5]).getValue();
    }

    public String xhtmlEncoding() {
        return this.options[6].getString();
    }

    public boolean useNamedEntities() {
        return ((BooleanOption)this.options[7]).getValue();
    }

    public boolean hexadecimalEntities() {
        return ((BooleanOption)this.options[8]).getValue();
    }

    public boolean prettyPrint() {
        return ((BooleanOption)this.options[9]).getValue();
    }

    public boolean multilingual() {
        return ((BooleanOption)this.options[10]).getValue();
    }

    public String templateIds() {
        return this.options[11].getString();
    }

    public boolean separateStylesheet() {
        return ((BooleanOption)this.options[12]).getValue();
    }

    public String xhtmlCustomStylesheet() {
        return this.options[13].getString();
    }

    public int xhtmlFormatting() {
        return ((XhtmlFormatOption)this.options[14]).getValue();
    }

    public int xhtmlFrameFormatting() {
        return ((XhtmlFormatOption)this.options[15]).getValue();
    }

    public int xhtmlSectionFormatting() {
        return ((XhtmlFormatOption)this.options[16]).getValue();
    }

    public int xhtmlTableFormatting() {
        return ((XhtmlFormatOption)this.options[17]).getValue();
    }

    public int tableSize() {
        return ((IntegerOption)this.options[18]).getValue();
    }

    public int listFormatting() {
        return ((IntegerOption)this.options[19]).getValue();
    }

    public String getMaxWidth() {
        return this.options[20].getString();
    }

    public boolean useDefaultFont() {
        return ((BooleanOption)this.options[21]).getValue();
    }

    public String defaultFontName() {
        return this.options[22].getString();
    }

    public boolean xhtmlUseDublinCore() {
        return ((BooleanOption)this.options[23]).getValue();
    }

    public boolean xhtmlNotes() {
        return ((BooleanOption)this.options[24]).getValue();
    }

    public boolean displayHiddenText() {
        return ((BooleanOption)this.options[25]).getValue();
    }

    public boolean xhtmlConvertToPx() {
        return ((BooleanOption)this.options[26]).getValue();
    }

    public String getXhtmlScaling() {
        return this.options[27].getString();
    }

    public String getXhtmlColumnScaling() {
        return this.options[28].getString();
    }

    public boolean relativeFontSize() {
        return ((BooleanOption)this.options[29]).getValue();
    }

    public String fontScaling() {
        return this.options[30].getString();
    }

    public boolean xhtmlFloatObjects() {
        return ((BooleanOption)this.options[31]).getValue();
    }

    public String getXhtmlTabstopStyle() {
        return this.options[32].getString();
    }

    public String getEndnotesHeading() {
        return this.options[34].getString();
    }

    public String getFootnotesHeading() {
        return this.options[35].getString();
    }

    public int formulas() {
        return ((IntegerOption)this.options[33]).getValue();
    }

    public int externalTocDepth() {
        return ((IntegerOption)this.options[36]).getValue();
    }

    public boolean includeToc() {
        return ((BooleanOption)this.options[37]).getValue();
    }

    public boolean includeNCX() {
        return ((BooleanOption)this.options[38]).getValue();
    }

    public int getXhtmlSplitLevel() {
        return ((IntegerOption)this.options[39]).getValue();
    }

    public int getXhtmlRepeatLevels() {
        return ((IntegerOption)this.options[40]).getValue();
    }

    public int pageBreakSplit() {
        return ((IntegerOption)this.options[41]).getValue();
    }

    public int splitAfter() {
        return ((IntegerOption)this.options[42]).getValue();
    }

    public String imageSplit() {
        return this.options[43].getString();
    }

    public boolean coverImage() {
        return ((BooleanOption)this.options[44]).getValue();
    }

    public boolean embedSVG() {
        return ((BooleanOption)this.options[45]).getValue();
    }

    public boolean embedImg() {
        return ((BooleanOption)this.options[46]).getValue();
    }

    public boolean useMathJax() {
        return ((BooleanOption)this.options[47]).getValue();
    }

    public boolean xhtmlCalcSplit() {
        return ((BooleanOption)this.options[48]).getValue();
    }

    public boolean xhtmlDisplayHiddenSheets() {
        return ((BooleanOption)this.options[49]).getValue();
    }

    public boolean displayHiddenRowsCols() {
        return ((BooleanOption)this.options[50]).getValue();
    }

    public boolean displayFilteredRowsCols() {
        return ((BooleanOption)this.options[51]).getValue();
    }

    public boolean applyPrintRanges() {
        return ((BooleanOption)this.options[52]).getValue();
    }

    public boolean xhtmlUseTitleAsHeading() {
        return ((BooleanOption)this.options[53]).getValue();
    }

    public boolean xhtmlUseSheetNamesAsHeadings() {
        return ((BooleanOption)this.options[54]).getValue();
    }

    public boolean saveImagesInSubdir() {
        return ((BooleanOption)this.options[55]).getValue();
    }

    public String getXhtmlUplink() {
        return this.options[56].getString();
    }

    public String getXhtmlDirectoryIcon() {
        return this.options[57].getString();
    }

    public String getXhtmlDocumentIcon() {
        return this.options[58].getString();
    }

    public boolean indexLinks() {
        return ((BooleanOption)this.options[59]).getValue();
    }

    public int externalTocDepthMarks() {
        return ((IntegerOption)this.options[60]).getValue();
    }

    public boolean avoidHtml5() {
        return ((BooleanOption)this.options[61]).getValue();
    }

    public XhtmlStyleMap getXParStyleMap() {
        return this.getStyleMap(this.xpar);
    }

    public XhtmlStyleMap getXHeadingStyleMap() {
        return this.getStyleMap(this.xheading);
    }

    public XhtmlStyleMap getXTextStyleMap() {
        return this.getStyleMap(this.xtext);
    }

    public XhtmlStyleMap getXFrameStyleMap() {
        return this.getStyleMap(this.xframe);
    }

    public XhtmlStyleMap getXListStyleMap() {
        return this.getStyleMap(this.xlist);
    }

    public XhtmlStyleMap getXAttrStyleMap() {
        return this.getStyleMap(this.xattr);
    }

    private XhtmlStyleMap getStyleMap(ComplexOption co) {
        XhtmlStyleMap map = new XhtmlStyleMap();
        for (String sName : co.keySet()) {
            Map<String, String> attr = co.get(sName);
            String sElement = attr.containsKey("element") ? attr.get("element") : "";
            String sCss = attr.containsKey("css") ? attr.get("css") : "";
            String sBlockElement = attr.containsKey("block-element") ? attr.get("block-element") : "";
            String sBlockCss = attr.containsKey("block-css") ? attr.get("block-css") : "";
            String sBefore = attr.containsKey("before") ? attr.get("before") : "";
            String sAfter = attr.containsKey("after") ? attr.get("after") : "";
            map.put(sName, new XhtmlStyleMapItem(sBlockElement, sBlockCss, sElement, sCss, sBefore, sAfter));
        }
        return map;
    }
}

