/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import mediathek.tool.MVFunctionSys;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Logfile {
    private static final Logger logger = LogManager.getLogger();

    public static boolean LogDateiSchreiben(String ziel, String progVersion, String settingsDir, ArrayList<String> progs, String[][] configs) {
        boolean ret;
        Path logFilePath = Paths.get(ziel, new String[0]);
        try (OutputStream os = Files.newOutputStream(logFilePath, new OpenOption[0]);
             OutputStreamWriter osw = new OutputStreamWriter(os);
             BufferedWriter bw = new BufferedWriter(osw);){
            bw.write("Erstellt: " + DateTimeFormatter.ofPattern("dd.MM.yyyy, HH:mm").format(LocalDateTime.ofInstant(Instant.now(), ZoneId.systemDefault())));
            bw.newLine();
            bw.write("#####################################################");
            bw.newLine();
            bw.write(progVersion);
            bw.newLine();
            bw.write("Betriebssystem: " + System.getProperty("os.name"));
            bw.newLine();
            bw.write("Bs-Version:     " + System.getProperty("os.version"));
            bw.newLine();
            bw.write("Bs-Architektur: " + System.getProperty("os.arch"));
            bw.newLine();
            bw.newLine();
            bw.write("=====================================================");
            bw.newLine();
            bw.write("Programmpfad: " + MVFunctionSys.getPathJar());
            bw.newLine();
            bw.write("Verzeichnis Einstellungen: " + settingsDir);
            bw.newLine();
            bw.write("=====================================================");
            bw.newLine();
            bw.write("#####################################################");
            bw.newLine();
            bw.write("## Programmeinstellungen ##########################");
            bw.newLine();
            bw.write("#####################################################");
            bw.newLine();
            bw.newLine();
            for (String[] s2 : configs) {
                if (s2[1].isEmpty()) continue;
                bw.write(s2[0] + "\t" + s2[1]);
                bw.newLine();
            }
            bw.newLine();
            bw.newLine();
            bw.newLine();
            bw.newLine();
            bw.write("#####################################################");
            bw.newLine();
            bw.write("## Programmsets ##################################");
            bw.newLine();
            bw.write("#####################################################");
            bw.newLine();
            bw.newLine();
            for (String s3 : progs) {
                bw.write(s3);
                bw.newLine();
            }
            bw.newLine();
            bw.newLine();
            ret = true;
        }
        catch (Exception ex) {
            logger.error("Error writing log file", (Throwable)ex);
            ret = false;
        }
        return ret;
    }
}

