/*
 * Decompiled with CFR 0.152.
 */
package org.coode.mdock;

import java.util.Arrays;
import java.util.List;
import org.coode.mdock.HorizontalSplitter;
import org.coode.mdock.Node;
import org.coode.mdock.NodeVisitor;
import org.coode.mdock.Splitter;
import org.coode.mdock.SplitterNode;
import org.coode.mdock.VerticalSplitterNode;

public class HorizontalSplitterNode
extends SplitterNode {
    public HorizontalSplitterNode(List<? extends Node> children, List<Double> splits) {
        super(children, splits);
    }

    @Override
    protected double getGloballyNormalisedHeight(Node child) {
        return this.getGloballyNormalisedHeight() * this.getNormalisedSplit(child);
    }

    @Override
    public double getGloballyNormalisedYLocation(Node child) {
        double yLoc = this.getGloballyNormalisedYLocation();
        for (Node curChild : this.getVisibleChildren()) {
            if (curChild == child) {
                return yLoc;
            }
            yLoc += this.getGloballyNormalisedHeight(curChild);
        }
        return 0.0;
    }

    @Override
    public boolean isSplitterDirection(int direction) {
        return direction == 0;
    }

    @Override
    public Splitter createSplitter(Node child0, Node child1) {
        return new HorizontalSplitter(this, child0, child1);
    }

    public SplitterNode pushDown(Node existingChild, List<Node> children) {
        VerticalSplitterNode vsn = new VerticalSplitterNode(children, Arrays.asList(0.5, 0.5));
        this.replaceChild(existingChild, vsn);
        return vsn;
    }

    @Override
    protected SplitterNode createPerpendicularSplitterNode(List<Node> children, List<Double> splits) {
        return new VerticalSplitterNode(children, splits);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }
}

